/*
 * This file is part of the Pablo Performance Analysis Environment
 *
 *                                           TM
 * The Pablo Performance Analysis Environment   software is *not* in
 * the public domain.  However, it is freely available without fee for
 * education, research, and non-profit purposes.  By obtaining copies
 * of this and other files that comprise the Pablo Performance Analysis
 * Environment, you, the Licensee, agree to abide by the following
 * conditions and understandings with respect to the copyrighted software:
 * 
 * 1.  The software is copyrighted in the name of the Board of Trustees
 *     of the University of Illinois (UI), and ownership of the software
 *     remains with the UI. 
 *
 * 2.  Permission to use, copy, and modify this software and its documentation
 *     for education, research, and non-profit purposes is hereby granted
 *     to Licensee, provided that the copyright notice, the original author's
 *     names and unit identification, and this permission notice appear on
 *     all such copies, and that no charge be made for such copies.  Any
 *     entity desiring permission to incorporate this software into commercial
 *     products should contact:
 *
 *          Professor Daniel A. Reed                 reed@cs.uiuc.edu
 *          University of Illinois
 *          Department of Computer Science
 *          2413 Digital Computer Laboratory
 *          1304 West Springfield Avenue
 *          Urbana, Illinois  61801
 *          USA
 *
 * 3.  Licensee may not use the name, logo, or any other symbol of the UI
 *     nor the names of any of its employees nor any adaptation thereof in
 *     advertizing or publicity pertaining to the software without specific
 *     prior written approval of the UI.
 *
 * 4.  THE UI MAKES NO REPRESENTATIONS ABOUT THE SUITABILITY OF THE
 *     SOFTWARE FOR ANY PURPOSE.  IT IS PROVIDED "AS IS" WITHOUT EXPRESS
 *     OR IMPLIED WARRANTY.
 *
 * 5.  The UI shall not be liable for any damages suffered by Licensee from
 *     the use of this software.
 *
 * 6.  The software was developed under agreements between the UI and the
 *     Federal Government which entitle the Government to certain rights.
 *
 **************************************************************************
 *
 * Developed by: The TAPESTRY Parallel Computing Laboratory
 *		 University of Illinois at Urbana-Champaign
 *		 Department of Computer Science
 *		 1304 W. Springfield Avenue
 *		 Urbana, IL	61801
 *
 * Copyright (c) 1987, 1988, 1989, 1990, 1991, 1992
 * The University of Illinois Board of Trustees.
 *	All Rights Reserved.
 *
 * Author: Tara Madhyastha (tara@cs.uiuc.edu)
 * Project Manager and Principal Investigator:
 *	Daniel A. Reed (reed@cs.uiuc.edu)
 *
 * Funded by: National Science Foundation grants NSF CCR86-57696,
 * NSF CCR87-06653 and NSF CDA87-22836 (Tapestry), NASA ICLASS Contract
 * No. NAG-1-613, DARPA Contract No. DABT63-91-K-0004, and by a grant
 * from the Digital Equipment Corporation External Research Program.
 *
 */


#include "Step.h"

Step::Step()
{
  strcpy(Mapfilename, "/dev/null");
  mapping = new Mapfile(Mapfilename);
}  

void Step::setValue(char *args, char *v) {
  if (strcmp(args, "mapfile") == 0) {
    if (strlen(v) > 0) {
      delete mapping;
      strcpy(Mapfilename, v);
      mapping = new Mapfile(v);
    }
    return;
  }
  setValue(args, atof(v));
}

void Step::setValue(char *args, double v) {
  if (strcmp(args, "offset") == 0) {
    Offset = v;
    return;
  }
  if (strcmp(args, "width") == 0) {
    StepWidth = v;
    return;
  }
  cerr << "Warning: Step::setValue: ignoring unrecognized argument: " << args << NL;
}

Bool_ Step::readConfiguration(istream &is)
{
  char token[256];
  if (parser.getTok(is, token) != FIXED) {
    return ( False_ );
  } else {
    setValue("mapfile", token);
  }

  if (parser.getTok(is, token) != FIXED) {
    return ( False_ );
  } else {
    setValue("offset", token);
  }

  if (parser.getTok(is, token) != FIXED) {
    return ( False_ );
  } else {
    setValue("width", token);
  }
  return( True_ );
}
  
char* Step::printConfiguration(char *header) 
{
  char *tmp = form("%s %d %s %3.2f %3.2f", header, Step_, Mapfilename, 
		   Offset, StepWidth);
  char *s = new char[strlen(tmp) + 1];
  strcpy(s, tmp);
  return s;
}
  
  

void Step::calculateValue(void *variable, void *result)
{ 
  int tmp;
  if (mapping->mapInt(*((double *) variable), tmp)) {
    ((Val *)result)->SetValueFromDouble((double)(StepWidth*tmp + Offset));
  } else {
    ((Val *)result)->SetValueFromDouble(-1.0);
  }
}



void Step::printOn(ostream &os)
{
	os << form("Step, Mapfile = %s, Offset = %3.2f, StepWidth = %3.2f", 
		   Mapfilename, Offset, StepWidth);
}

  
