/*
 * This file is part of the Pablo Performance Analysis Environment
 *
 *                                           TM
 * The Pablo Performance Analysis Environment   software is *not* in
 * the public domain.  However, it is freely available without fee for
 * education, research, and non-profit purposes.  By obtaining copies
 * of this and other files that comprise the Pablo Performance Analysis
 * Environment, you, the Licensee, agree to abide by the following
 * conditions and understandings with respect to the copyrighted software:
 * 
 * 1.  The software is copyrighted in the name of the Board of Trustees
 *     of the University of Illinois (UI), and ownership of the software
 *     remains with the UI. 
 *
 * 2.  Permission to use, copy, and modify this software and its documentation
 *     for education, research, and non-profit purposes is hereby granted
 *     to Licensee, provided that the copyright notice, the original author's
 *     names and unit identification, and this permission notice appear on
 *     all such copies, and that no charge be made for such copies.  Any
 *     entity desiring permission to incorporate this software into commercial
 *     products should contact:
 *
 *          Professor Daniel A. Reed                 reed@cs.uiuc.edu
 *          University of Illinois
 *          Department of Computer Science
 *          2413 Digital Computer Laboratory
 *          1304 West Springfield Avenue
 *          Urbana, Illinois  61801
 *          USA
 *
 * 3.  Licensee may not use the name, logo, or any other symbol of the UI
 *     nor the names of any of its employees nor any adaptation thereof in
 *     advertizing or publicity pertaining to the software without specific
 *     prior written approval of the UI.
 *
 * 4.  THE UI MAKES NO REPRESENTATIONS ABOUT THE SUITABILITY OF THE
 *     SOFTWARE FOR ANY PURPOSE.  IT IS PROVIDED "AS IS" WITHOUT EXPRESS
 *     OR IMPLIED WARRANTY.
 *
 * 5.  The UI shall not be liable for any damages suffered by Licensee from
 *     the use of this software.
 *
 * 6.  The software was developed under agreements between the UI and the
 *     Federal Government which entitle the Government to certain rights.
 *
 **************************************************************************
 *
 * Developed by: The TAPESTRY Parallel Computing Laboratory
 *		 University of Illinois at Urbana-Champaign
 *		 Department of Computer Science
 *		 1304 W. Springfield Avenue
 *		 Urbana, IL	61801
 *
 * Copyright (c) 1987, 1988, 1989, 1990, 1991, 1992
 * The University of Illinois Board of Trustees.
 *	All Rights Reserved.
 *
 * Author: Tara Madhyastha (tara@cs.uiuc.edu)
 * Project Manager and Principal Investigator:
 *	Daniel A. Reed (reed@cs.uiuc.edu)
 *
 * Funded by: National Science Foundation grants NSF CCR86-57696,
 * NSF CCR87-06653 and NSF CDA87-22836 (Tapestry), NASA ICLASS Contract
 * No. NAG-1-613, DARPA Contract No. DABT63-91-K-0004, and by a grant
 * from the Digital Equipment Corporation External Research Program.
 *
 */
/*
 * MIDISoundDevice.h: The base interface class for MIDI instruments. 
 *
 */

#pragma once
#ifndef MIDISoundDevice_h
#define MIDISoundDevice_h

#include "SoundObj.h"
#include "ValList.h"


extern "C"
{
void InitMIDI();
void SelectProgram(char number);
void SelectChannel(char channel);
char GetCurrentChannel();
void NoteOn(char note, char velocity);
void NoteOff(char note, char velocity);
void KeyPressure(char pitch, char pressure);
void ChannelPressure(char pressure);
void Parameter(char paramnumber, char setting);
void PitchWheel(char lsb, char msb);
void SetPortamento(char number);
void SetBalance(char balance);
void SetVolume(char volume);
void SetSustain(char sustain);
void SetVibrato(char number);
void SysEx(char *buf, int bufsz);
void AllNotesOff();
void MIDIcloseDevice();
}


class MIDISoundDevice : public SoundObj {
/*
 * MIDISoundDevice is the base class for any MIDI sound devices. It supports
 * the basic MIDI commands. This implementation supports a serial to MIDI
 * interface; commands are sent by writing bytes to the serial port. 
 * Therefore, timing is inexact.
 */



public:
  /* Method MIDISoundDevice: The MIDISoundDevice constructor */
  MIDISoundDevice();

  /* Method ~MIDISoundDevice: The MIDISoundDevice destructor */
  ~MIDISoundDevice();

  /* Method reinitialize: Reinitialize the MIDI device */
  virtual void  reinitialize();
  
  /* Method pause: Cause device daemon to sleep before executing again */
  virtual void  pause(ValList &);

  /* Method playNote: Play a note */
  virtual void  playNote(ValList &);

  /* Method noteOn:  Execute a note on command */
  virtual void noteOn(ValList &);

  /* Method noteOff: Execute a note off command */
  virtual void noteOff(ValList &);

  /* Method closeDevice: Close the MIDI device */
  virtual void closeDevice();

  /* Method selectInstrument: Choose an instrument */
  virtual void selectInstrument(ValList &);

  /* Method selectChannel: Choose a channel */
  virtual void selectChannel(ValList &);
  
  /* Method setPitchBend: Set pitch bend */
  virtual void setPitchBend(ValList &);

  /* Method setKeyPressure: Set key pressure */
  virtual void setKeyPressure(ValList &);

  /* Method setChannelPressure: Set Channel pressure */
  virtual void setChannelPressure(ValList &);

  /* Method setPortamento: Set Portamento */ 
  virtual void setPortamento(ValList &);

  /* Method setSustain: Set sustain */
  virtual void setSustain(ValList &);

  /* Method setVibrato: Set vibrato */
  virtual void setVibrato(ValList &);

  /* Method setVolume: Set global volume */
  virtual void setVolume(ValList &);

  /* Method setBalance: Set Balance */
  virtual void setBalance(ValList &);

  /* Method allNotesOff: Turn all notes off */
  virtual void allNotesOff();
  
  /* Method printOn: Stream output function */
  virtual void printOn(ostream &os = cout);
};

inline ostream &operator<<(ostream &os, MIDISoundDevice &obj)
{
	obj.printOn(os);
	return os;
}

#endif
