/*
 * This file is part of the Pablo Performance Analysis Environment
 *
 *                                           TM
 * The Pablo Performance Analysis Environment   software is *not* in
 * the public domain.  However, it is freely available without fee for
 * education, research, and non-profit purposes.  By obtaining copies
 * of this and other files that comprise the Pablo Performance Analysis
 * Environment, you, the Licensee, agree to abide by the following
 * conditions and understandings with respect to the copyrighted software:
 * 
 * 1.  The software is copyrighted in the name of the Board of Trustees
 *     of the University of Illinois (UI), and ownership of the software
 *     remains with the UI. 
 *
 * 2.  Permission to use, copy, and modify this software and its documentation
 *     for education, research, and non-profit purposes is hereby granted
 *     to Licensee, provided that the copyright notice, the original author's
 *     names and unit identification, and this permission notice appear on
 *     all such copies, and that no charge be made for such copies.  Any
 *     entity desiring permission to incorporate this software into commercial
 *     products should contact:
 *
 *          Professor Daniel A. Reed                 reed@cs.uiuc.edu
 *          University of Illinois
 *          Department of Computer Science
 *          2413 Digital Computer Laboratory
 *          1304 West Springfield Avenue
 *          Urbana, Illinois  61801
 *          USA
 *
 * 3.  Licensee may not use the name, logo, or any other symbol of the UI
 *     nor the names of any of its employees nor any adaptation thereof in
 *     advertizing or publicity pertaining to the software without specific
 *     prior written approval of the UI.
 *
 * 4.  THE UI MAKES NO REPRESENTATIONS ABOUT THE SUITABILITY OF THE
 *     SOFTWARE FOR ANY PURPOSE.  IT IS PROVIDED "AS IS" WITHOUT EXPRESS
 *     OR IMPLIED WARRANTY.
 *
 * 5.  The UI shall not be liable for any damages suffered by Licensee from
 *     the use of this software.
 *
 * 6.  The software was developed under agreements between the UI and the
 *     Federal Government which entitle the Government to certain rights.
 *
 **************************************************************************
 *
 * Developed by: The TAPESTRY Parallel Computing Laboratory
 *		 University of Illinois at Urbana-Champaign
 *		 Department of Computer Science
 *		 1304 W. Springfield Avenue
 *		 Urbana, IL	61801
 *
 * Copyright (c) 1987, 1988, 1989, 1990, 1991, 1992
 * The University of Illinois Board of Trustees.
 *	All Rights Reserved.
 *
 * Author: Tara Madhyastha (tara@m.cs.uiuc.edu)
 * Project Manager and Principal Investigator:
 *	Daniel A. Reed (reed@cs.uiuc.edu)
 *
 * Funded by: National Science Foundation grants NSF CCR86-57696,
 * NSF CCR87-06653 and NSF CDA87-22836 (Tapestry), NASA ICLASS Contract
 * No. NAG-1-613, DARPA Contract No. DABT63-91-K-0004, and by a grant
 * from the Digital Equipment Corporation External Research Program.
 *
 */
#include <stdio.h>
#include <sys/time.h>
#include <fcntl.h>
#include <sys/termios.h>
#include "SoundDefines.h"


int MIDIfd;
char CurrentChannel=0;

void InitMIDI()
{
	struct termios params,test;

	MIDIfd = open("/dev/ttyb",O_WRONLY | O_SYNC);
	if (ioctl(MIDIfd,TCGETS,&params) < 0 ) {
	  fprintf(stderr, "Error: InitMIDI(): fd=%d, %s\n", MIDIfd, 
		  sys_errlist[errno]);
	}
	params.c_oflag = 0;
	params.c_cflag = B38400 | CS8;
	if (ioctl(MIDIfd,TCSETSW,&params) < 0) {
	  fprintf(stderr, "Error: InitMIDI(): fd=%d, %s\n", MIDIfd, 
		  sys_errlist[errno]);
	}
}

/* SysEx accepts a random buffer and writes it to the device */
void SysEx(buf, bufsz)
     char *buf;
     int bufsz;
{
  if (write(MIDIfd,buf,bufsz) < 0) {
    fprintf(stderr, "Error: SysEx: fd=%d, %s\n", MIDIfd,
	    sys_errlist[errno]); 
  }   
}
     


/* Program selects the Instrument to be associated with a channel */
void SelectProgram(number)
     char number;
{
  char data[2];
  data[0] = 0xc0 | CurrentChannel;
  data[1] = number;
  if (write(MIDIfd,data,2) < 0) {
    fprintf(stderr, "Error: SelectProgram: fd=%d, %s\n", MIDIfd,
	    sys_errlist[errno]);
  }
}


void SelectChannel(channel)
     char channel;
{
  if (channel >= 0 && channel < 16) {
    CurrentChannel=channel;
  } else {
    fprintf(stderr, 
	    "Error: SelectChannel: channel must be in range 0-15 (got %c)\n",
	    channel);
  }
}

char GetCurrentChannel()
{  
  return(CurrentChannel); 
}


void NoteOn(note, velocity)
     char note, velocity;
{
  char data[3];
  data[0] = 0x90 | CurrentChannel;
  data[1] = note;
  data[2] = velocity;
  if (write(MIDIfd,data,3) < 0) {
    fprintf(stderr, "Error: NoteOn: fd=%d, %s\n", MIDIfd,
	    sys_errlist[errno]);
  }
}

void NoteOff(note, velocity)
     char note, velocity;
{
  char data[3];
  data[0] = 0x80 | CurrentChannel;
  data[1] = note;
  data[2] = velocity;
  if (write(MIDIfd,data,3) < 0) {
    fprintf(stderr, "Error: NoteOff: fd=%d, %s\n", MIDIfd,
	    sys_errlist[errno]);
  }
}

void KeyPressure(pitch, pressure)
     char pitch, pressure;
{
  char data[3];
  data[0] = 0xa0 | CurrentChannel;
  data[1] = pitch;
  data[2] = pressure;
  if (write(MIDIfd,data,3) < 0) {
    fprintf(stderr, "Error: KeyPressure: fd=%d, %s\n", MIDIfd,
	    sys_errlist[errno]);
  }
}

void Parameter(paramnumber, setting)
     char paramnumber, setting;
{
  char data[3];
  data[0] = 0xb0 | CurrentChannel;
  data[1] = paramnumber;
  data[2] = setting;

  if (write(MIDIfd,data,3) < 0) {
    fprintf(stderr, "Error: Parameter: fd=%d, %s\n", MIDIfd,
	    sys_errlist[errno]);
  }  
}  
void ChannelPressure(pressure)
     char pressure;
{
  char data[2];
  data[0] = 0xd0 | CurrentChannel;
  data[1] = pressure;
  if (write(MIDIfd,data,2) < 0) {
    fprintf(stderr, "Error: AfterTouch: fd=%d, %s\n", MIDIfd,
	    sys_errlist[errno]);
  }
}

void PitchWheel(lsb, msb)
     char lsb, msb;
{
  char data[3];
  data[0] = 0xe0 | CurrentChannel;
  data[1] = msb;
  data[2] = lsb;

  if (write(MIDIfd,data,3) < 0) {
    fprintf(stderr, "Error: PitchWheel: fd=%d, %s\n", MIDIfd,
	    sys_errlist[errno]);
  }  
}

void SetPortamento(number)
     char number;
{
  Parameter((char) 65, number);
}

void SetBalance(balance)
     char balance;
{
  Parameter((char) 8, balance);
}

void SetVolume(volume)
     int volume;
{
  Parameter((char) 7, volume);
}

void AllNotesOff()
{
  Parameter((char) 123, 0);
}

void MIDIcloseDevice()
{
  AllNotesOff();
  close(MIDIfd);
}

void SetSustain(sustain)
     char sustain;
{
  Parameter((char) 64, sustain);
}

void SetVibrato(vibrato)
     char vibrato;
{
  Parameter((char) 1, vibrato);
}

