/*
 * This file is part of the Pablo Performance Analysis Environment
 *
 *                                           TM
 * The Pablo Performance Analysis Environment   software is *not* in
 * the public domain.  However, it is freely available without fee for
 * education, research, and non-profit purposes.  By obtaining copies
 * of this and other files that comprise the Pablo Performance Analysis
 * Environment, you, the Licensee, agree to abide by the following
 * conditions and understandings with respect to the copyrighted software:
 * 
 * 1.  The software is copyrighted in the name of the Board of Trustees
 *     of the University of Illinois (UI), and ownership of the software
 *     remains with the UI. 
 *
 * 2.  Permission to use, copy, and modify this software and its documentation
 *     for education, research, and non-profit purposes is hereby granted
 *     to Licensee, provided that the copyright notice, the original author's
 *     names and unit identification, and this permission notice appear on
 *     all such copies, and that no charge be made for such copies.  Any
 *     entity desiring permission to incorporate this software into commercial
 *     products should contact:
 *
 *          Professor Daniel A. Reed                 reed@cs.uiuc.edu
 *          University of Illinois
 *          Department of Computer Science
 *          2413 Digital Computer Laboratory
 *          1304 West Springfield Avenue
 *          Urbana, Illinois  61801
 *          USA
 *
 * 3.  Licensee may not use the name, logo, or any other symbol of the UI
 *     nor the names of any of its employees nor any adaptation thereof in
 *     advertizing or publicity pertaining to the software without specific
 *     prior written approval of the UI.
 *
 * 4.  THE UI MAKES NO REPRESENTATIONS ABOUT THE SUITABILITY OF THE
 *     SOFTWARE FOR ANY PURPOSE.  IT IS PROVIDED "AS IS" WITHOUT EXPRESS
 *     OR IMPLIED WARRANTY.
 *
 * 5.  The UI shall not be liable for any damages suffered by Licensee from
 *     the use of this software.
 *
 * 6.  The software was developed under agreements between the UI and the
 *     Federal Government which entitle the Government to certain rights.
 *
 **************************************************************************
 *
 * Developed by: The TAPESTRY Parallel Computing Laboratory
 *		 University of Illinois at Urbana-Champaign
 *		 Department of Computer Science
 *		 1304 W. Springfield Avenue
 *		 Urbana, IL	61801
 *
 * Copyright (c) 1987, 1988, 1989, 1990, 1991, 1992
 * The University of Illinois Board of Trustees.
 *	All Rights Reserved.
 *
 * Project Manager and Principal Investigator:
 *      Daniel A. Reed (reed@cs.uiuc.edu)
 *
 * Funded by: National Science Foundation grants NSF CCR86-57696,
 * NSF CCR87-06653 and NSF CDA87-22836 (Tapestry), NASA ICLASS Contract
 * No. NAG-1-613, DARPA Contract No. DABT63-91-K-0004, and by a grant
 * from the Digital Equipment Corporation External Research Program.
 *
 */

#include "TCPSocket.h"
#include "MessageList.h"

#include <stream.h>
#include <sys/types.h>
#include <time.h>

DEVICETYPE _mySoundDevice;

extern MessageList& InitMessageList();

/* This server is the interface between the class representing the 
   hardware and the network commands. The same code works for any new
   server you write. 
*/

main(int argc, char *argv[])
{
  TCPSocket sock;
  TCPSocket *csock;
  int fd;
  filebuf fb;
  char command, ack;
  FILE *fp;
  long tloc;
  Bool_ Acknowledge;
  char tmp[256];

  if (argc > 1) { // cerr to log file
    if (fb.open(argv[1], output) == 0) {
      cerr << form("Error opening log file %s: %s\n", argv[1],
		   sys_errlist[errno]);
    } else {
      cerr = *new ostream(&fb);
    }
  }
  time(&tloc);
  cerr << "Local Server: starting at " << ctime(&tloc);

  /* InitMessageList() is a function defined in InitMessageList.cc,
  a file generated by the ConfigureDeviceServer script. 
  */

  MessageList &myMessageTable = InitMessageList();

  if (sock.bindToNamedPort(MY_PORT) < 0) {
    cerr << form("Cannot bind to port %s; exiting...\n", MY_PORT);
    exit(1);
  }


  sprintf(tmp, "%s%s", ROOT, DEVICEDEFAULTS);

  if ((fp = fopen(tmp, "r")) == NULL) {
    cerr << form("Error: Cannot open device defaults file %s%s : %s\n",
		 ROOT, DEVICEDEFAULTS, sys_errlist[errno]);
    exit(1);
  }
  ValList myDefaults(fp);
//  cout << myDefaults << NL;

  sprintf(tmp, "%s%s", ROOT, DEVICEPARAMS);
  if ((fp = fopen(tmp, "r")) == NULL) {
    cerr << form("Error: Cannot open device parameters file %s%s : %s\n",
		 ROOT, DEVICEPARAMS, sys_errlist[errno]);
    exit(1);
  }
  ValList mySystemParameters(fp);
//  cout << mySystemParameters << NL;

  char foo;
  for(;;) {
    sock.listen(5);
    csock = sock.accept();

    time(&tloc);
    cerr << "Local Server: accepting connection at " << ctime(&tloc);
    fd = csock->getFd();
    
    csock->send(myDefaults);
//    cout << "sent defaults\n";
    csock->receive(foo);
    csock->send(mySystemParameters);
//    cout << "sent system parameters\n";
    csock->receive(foo);
    csock->send(myMessageTable);
//    cout << "sent message table\n";
    csock->receive(foo);
    
    csock->send(foo);

    char numberInBatch;
    int i;

    while(csock->receive(numberInBatch) > 0) {
      if (csock->receive(ack) < 0 ) {
	cerr << "Error: Local Server expected acknowledgement status, \
recieved nothing\n";
	break;
      }
      for(i=0; i < numberInBatch; i++) {
	
	if (csock->receive(command) < 0) {
	  cerr << "Error: Local Server expected command, recieved nothing\n";
	  break;
	}

	//      cout << "Local server: Ack is " << (int) ack << NL;
	Message& m = myMessageTable.getArg((int) command);
	m.binReceive(fd);
	//      cerr << "Executing message: " << m << NL;
	m.execute();
      }
      if ((int) ack > 0) {
	//	csock->send(ack);
	write(fd, &ack, 1);
	//	cout << "Sent ack\n";
      }
    }
    close(fd);
    time(&tloc);
    cerr << "Local Server: closing up shop at " << ctime(&tloc);

    _mySoundDevice.reinitialize();

  }
}


