; Orchestra File Skeleton for makegamme

sr=8192 
kr=512 
ksmps=16 

instr 1

        ; p3 = duration
        ; p4 = slur information
        ; p5 = pitch
        ; p6 = amplitude

        p5      = p5 - 1
        icpsp   = cpspch(p5)

        if (p4 == int(p4/2) * 2) goto initslurs
                ihold
initslurs:
        iatttm  = 0.075
        idectm  = 0.1
        isustm  = p3 - iatttm - idectm
        idec    = p6
        ireinit = -1

        if (p4 > 1) goto checkafterslur
        ilast   = 0

checkafterslur:
        if (p4 == 1 || p4 == 3) goto doneslurs
        idec = 0
        ireinit = 0

doneslurs:
        if (isustm <= 0) goto simpleenv
        kamp    linseg ilast,iatttm,p6,isustm,p6,idectm,idec,0,idec
        goto doneenv

simpleenv:
        kamp    linseg ilast,p3 / 2,p6,p3 / 2,idec,0,idec

doneenv:
        ilast = p6

;;; Some randomness for fun.
        krnd    randi .1,10
        krnd    = krnd + 1
        kamp    = kamp * krnd

;;; Some vibrato.
        ivamp   = icpsp * 0.025
        ivfreq  = 5
        kvbra   oscil ivamp,ivfreq,1,ireinit
        kfreq   = icpsp + kvbra

;;; The note.
        a1      oscili kamp,kfreq,2,ireinit

;;; Some resonance cavities.
        a2      tone a1,3500,ireinit
        a3      comb a2,.15,.01,ireinit
        a4      comb a3,.15,.02,ireinit

                out a1

        endin
