/*
 * This file is part of the Pablo Performance Analysis Environment
 *
 *                                           TM
 * The Pablo Performance Analysis Environment   software is *not* in
 * the public domain.  However, it is freely available without fee for
 * education, research, and non-profit purposes.  By obtaining copies
 * of this and other files that comprise the Pablo Performance Analysis
 * Environment, you, the Licensee, agree to abide by the following
 * conditions and understandings with respect to the copyrighted software:
 * 
 * 1.  The software is copyrighted in the name of the Board of Trustees
 *     of the University of Illinois (UI), and ownership of the software
 *     remains with the UI. 
 *
 * 2.  Permission to use, copy, and modify this software and its documentation
 *     for education, research, and non-profit purposes is hereby granted
 *     to Licensee, provided that the copyright notice, the original author's
 *     names and unit identification, and this permission notice appear on
 *     all such copies, and that no charge be made for such copies.  Any
 *     entity desiring permission to incorporate this software into commercial
 *     products should contact:
 *
 *          Professor Daniel A. Reed                 reed@cs.uiuc.edu
 *          University of Illinois
 *          Department of Computer Science
 *          2413 Digital Computer Laboratory
 *          1304 West Springfield Avenue
 *          Urbana, Illinois  61801
 *          USA
 *
 * 3.  Licensee may not use the name, logo, or any other symbol of the UI
 *     nor the names of any of its employees nor any adaptation thereof in
 *     advertizing or publicity pertaining to the software without specific
 *     prior written approval of the UI.
 *
 * 4.  THE UI MAKES NO REPRESENTATIONS ABOUT THE SUITABILITY OF THE
 *     SOFTWARE FOR ANY PURPOSE.  IT IS PROVIDED "AS IS" WITHOUT EXPRESS
 *     OR IMPLIED WARRANTY.
 *
 * 5.  The UI shall not be liable for any damages suffered by Licensee from
 *     the use of this software.
 *
 * 6.  The software was developed under agreements between the UI and the
 *     Federal Government which entitle the Government to certain rights.
 *
 **************************************************************************
 *
 * Developed by: The TAPESTRY Parallel Computing Laboratory
 *		 University of Illinois at Urbana-Champaign
 *		 Department of Computer Science
 *		 1304 W. Springfield Avenue
 *		 Urbana, IL	61801
 *
 * Copyright (c) 1987, 1988, 1989, 1990, 1991, 1992
 * The University of Illinois Board of Trustees.
 *	All Rights Reserved.
 *
 * Author: Tara Madhyastha (tara@cs.uiuc.edu)
 * Project Manager and Principal Investigator:
 *	Daniel A. Reed (reed@cs.uiuc.edu)
 *
 * Funded by: National Science Foundation grants NSF CCR86-57696,
 * NSF CCR87-06653 and NSF CDA87-22836 (Tapestry), NASA ICLASS Contract
 * No. NAG-1-613, DARPA Contract No. DABT63-91-K-0004, and by a grant
 * from the Digital Equipment Corporation External Research Program.
 *
 */
#include <stream.h>
#include <math.h>
#include <fcntl.h>
#include "WaveTable.h"
extern "C"
{
unsigned int cvt(int ch);
double cvt_ulaw_to_double(int ch);
}

WaveTable::WaveTable(double samplerate, int tabsize)
{
  int i=0;

  fs = samplerate;
  N = tabsize;
  wavetable = new double[N];

  /* fill the wavetable */
  angle = 0;
  inc = (2 * M_PI ) / N;
  for (i=0; i < N; i++, angle+=inc)
    {
      wavetable[i]=(double)sin(angle);
    }
}

WaveTable::WaveTable(double samplerate, char *samplefile, int tabsize)
{
  int i=0, fd;
  fs = samplerate;
  N = tabsize;
  /* put some code to determine the format of samplefile here */
  /* for now assume ulaw format */
  /* there has got to be a better way to do this */
  
  unsigned char tmptable[N];
  wavetable = new double[N];

  if ((fd = open(samplefile, O_RDONLY)) == -1) {
    cout << "can't open file: " << samplefile << "\n";
    exit(1);
  }
  /* it would make sense to wraparound here */
  if ((i = read(fd, tmptable, N)) < N) {
    cout << "error: the wavetable isn't full\n";
  }
  for (i=0; i < N; i++) {
    wavetable[i] = cvt_ulaw_to_double(tmptable[i]);
    
  }
}
  

WaveTable::WaveTable(double samplerate, Samples *mySamples)
{
  int i=0, fd;
  fs = samplerate;
  N = mySamples->size();

  wavetable = new double[N];

  for (i=0; i < N; i++) {
    wavetable[i] = mySamples->get(i);
  }
}
