/*
 * This file is part of the Pablo Performance Analysis Environment
 *
 *                                           TM
 * The Pablo Performance Analysis Environment   software is *not* in
 * the public domain.  However, it is freely available without fee for
 * education, research, and non-profit purposes.  By obtaining copies
 * of this and other files that comprise the Pablo Performance Analysis
 * Environment, you, the Licensee, agree to abide by the following
 * conditions and understandings with respect to the copyrighted software:
 * 
 * 1.  The software is copyrighted in the name of the Board of Trustees
 *     of the University of Illinois (UI), and ownership of the software
 *     remains with the UI. 
 *
 * 2.  Permission to use, copy, and modify this software and its documentation
 *     for education, research, and non-profit purposes is hereby granted
 *     to Licensee, provided that the copyright notice, the original author's
 *     names and unit identification, and this permission notice appear on
 *     all such copies, and that no charge be made for such copies.  Any
 *     entity desiring permission to incorporate this software into commercial
 *     products should contact:
 *
 *          Professor Daniel A. Reed                 reed@cs.uiuc.edu
 *          University of Illinois
 *          Department of Computer Science
 *          2413 Digital Computer Laboratory
 *          1304 West Springfield Avenue
 *          Urbana, Illinois  61801
 *          USA
 *
 * 3.  Licensee may not use the name, logo, or any other symbol of the UI
 *     nor the names of any of its employees nor any adaptation thereof in
 *     advertizing or publicity pertaining to the software without specific
 *     prior written approval of the UI.
 *
 * 4.  THE UI MAKES NO REPRESENTATIONS ABOUT THE SUITABILITY OF THE
 *     SOFTWARE FOR ANY PURPOSE.  IT IS PROVIDED "AS IS" WITHOUT EXPRESS
 *     OR IMPLIED WARRANTY.
 *
 * 5.  The UI shall not be liable for any damages suffered by Licensee from
 *     the use of this software.
 *
 * 6.  The software was developed under agreements between the UI and the
 *     Federal Government which entitle the Government to certain rights.
 *
 **************************************************************************
 *
 * Developed by: The TAPESTRY Parallel Computing Laboratory
 *		 University of Illinois at Urbana-Champaign
 *		 Department of Computer Science
 *		 1304 W. Springfield Avenue
 *		 Urbana, IL	61801
 *
 * Copyright (c) 1987, 1988, 1989, 1990, 1991, 1992
 * The University of Illinois Board of Trustees.
 *	All Rights Reserved.
 *
 * Author: Tara Madhyastha (tara@cs.uiuc.edu)
 * Project Manager and Principal Investigator:
 *	Daniel A. Reed (reed@cs.uiuc.edu)
 *
 * Funded by: National Science Foundation grants NSF CCR86-57696,
 * NSF CCR87-06653 and NSF CDA87-22836 (Tapestry), NASA ICLASS Contract
 * No. NAG-1-613, DARPA Contract No. DABT63-91-K-0004, and by a grant
 * from the Digital Equipment Corporation External Research Program.
 *
 */
/*
 * WclInterface.h: Implements the X interface for the sdinterface 
 * application.
 *
 */


#pragma once
#ifndef WclInterface_h
#define WclInterface_h

#include "SoundObj.h"
#include "SoundDevice.h"

#include <Xm/Xm.h>
#include <ctype.h>



class WclInterface : public SoundObj {
/*
*  WclInterface is the X interface for the sdinterface application.
*/
       
       
       
private:
  Widget appShell;
  XtAppContext app;
  SoundDevice& SD;
  int LabelNumber=0;
  char *appClass;
  char foreground[64], background[64], highlight[64];
  static char _resourcefile[256];

  /* Method dumpWclResources: Write out WCL resource file */
  void dumpWclResources(char *appClass, ostream &os);
  
  /* Method dumpMessageListResources: Write out resources for msg list */
  char* dumpMessageListResources(ostream &os);
  
  /* Method dumpDefaultResources: Write out resources for defaults */
  char* dumpDefaultResources(ostream &os);
  
  /* Method genName: Make up a temporary name */
  char* genName(char *s);
  
  /* Method doButton: Do the resources for a button */
  char* doButton(Val& v, ostream &os);
  
  /* Method doText: Do the resources for a text widget */
  char* doText(Val& v, ostream &os);
  
  /* Method doEnumList: Do the resources for a scrolled list */
  char* doEnumList(Val& v, ostream &os);
  
  /* Method doSlider: Do the resources for a slider */
  char* doSlider(Val& v, ostream &os);
  
  /* Method onSignal: Clean up temp files on terminating signals */
  static void onSignal();

  
public:
  int CurrentDefault;
  int CurrentMessage;
  
  /* Method WclInterface: The WclInterface constructor. */
  WclInterface(char *appName, SoundDevice &sd, int argc, char **argv);
  
  /* Method ~WclInterface: The WclInterface destructor. */
  ~WclInterface();
  
  /* Method run: Run the X interface */
  void run();
  
  
  /* Method getDefault: Return numbered default */
  Val& getDefault(int defaultnum);
  
  /* Method getMessage: Return numbered message */
  Message& getMessage(int messagenum);

  /* Method SendMessage: Send numbered message */
  void SendMessage(int msgnum = -1);
  
  /* Method HighlightMessageArgs: Highlight the defaults that are message  */
  /*                              parameters                               */
  void HighlightMessageArgs();
  
  /* Method printOn: Stream output function */
  void printOn(ostream &os = cout);

};

inline ostream &operator<<(ostream &os, WclInterface &obj)
{
	obj.printOn(os);
	return os;
}

#endif
