/*
 * This file is part of the Pablo Performance Analysis Environment
 *
 *                                           TM
 * The Pablo Performance Analysis Environment   software is *not* in
 * the public domain.  However, it is freely available without fee for
 * education, research, and non-profit purposes.  By obtaining copies
 * of this and other files that comprise the Pablo Performance Analysis
 * Environment, you, the Licensee, agree to abide by the following
 * conditions and understandings with respect to the copyrighted software:
 * 
 * 1.  The software is copyrighted in the name of the Board of Trustees
 *     of the University of Illinois (UI), and ownership of the software
 *     remains with the UI. 
 *
 * 2.  Permission to use, copy, and modify this software and its documentation
 *     for education, research, and non-profit purposes is hereby granted
 *     to Licensee, provided that the copyright notice, the original author's
 *     names and unit identification, and this permission notice appear on
 *     all such copies, and that no charge be made for such copies.  Any
 *     entity desiring permission to incorporate this software into commercial
 *     products should contact:
 *
 *          Professor Daniel A. Reed                 reed@cs.uiuc.edu
 *          University of Illinois
 *          Department of Computer Science
 *          2413 Digital Computer Laboratory
 *          1304 West Springfield Avenue
 *          Urbana, Illinois  61801
 *          USA
 *
 * 3.  Licensee may not use the name, logo, or any other symbol of the UI
 *     nor the names of any of its employees nor any adaptation thereof in
 *     advertizing or publicity pertaining to the software without specific
 *     prior written approval of the UI.
 *
 * 4.  THE UI MAKES NO REPRESENTATIONS ABOUT THE SUITABILITY OF THE
 *     SOFTWARE FOR ANY PURPOSE.  IT IS PROVIDED "AS IS" WITHOUT EXPRESS
 *     OR IMPLIED WARRANTY.
 *
 * 5.  The UI shall not be liable for any damages suffered by Licensee from
 *     the use of this software.
 *
 * 6.  The software was developed under agreements between the UI and the
 *     Federal Government which entitle the Government to certain rights.
 *
 **************************************************************************
 *
 * Developed by: The TAPESTRY Parallel Computing Laboratory
 *		 University of Illinois at Urbana-Champaign
 *		 Department of Computer Science
 *		 1304 W. Springfield Avenue
 *		 Urbana, IL	61801
 *
 * Copyright (c) 1987, 1988, 1989, 1990, 1991, 1992
 * The University of Illinois Board of Trustees.
 *	All Rights Reserved.
 *
 * Author: Tara Madhyastha (tara@cs.uiuc.edu)
 * Project Manager and Principal Investigator:
 *	Daniel A. Reed (reed@cs.uiuc.edu)
 *
 * Funded by: National Science Foundation grants NSF CCR86-57696,
 * NSF CCR87-06653 and NSF CDA87-22836 (Tapestry), NASA ICLASS Contract
 * No. NAG-1-613, DARPA Contract No. DABT63-91-K-0004, and by a grant
 * from the Digital Equipment Corporation External Research Program.
 *
 */
/*
 * Step.h: Implements the step transformation function.
 *
 */


#pragma once
#ifndef Step_h
#define Step_h

#include "DataTransform.h"
#include "Mapfile.h"
#include "Val.h"

class Step : public DataTransform {
/*
 * The Step transform function is a combination of Linear and DataRange;
 * a file specifying ranges is used with a user--configured step and 
 * offset to calculate the value from the input data.
 */

private:

  double Offset = 0.0;
  double StepWidth = 0.0;

  Mapfile *mapping;
  char Mapfilename[256];


public:

  /* Method Step:  The Step constructor */
  Step();

  /* Method calculateValue:  Sets value of Val result according to variable */
  void calculateValue(void *variable, void *result);


  /* Method idNumber:   Return the id number of this transform */
  virtual int idNumber() { return 3; } ;



  /* Method setValue:  Set value of internal parameters */
  void setValue(char *args, double v);
  void setValue(char *args, char *v);


  /* Method readConfiguration: Get params from input stream */
  Bool_ readConfiguration(istream &is);

  /* Method printConfiguration: Return a string starting with header that 
   *                             describes configuration                  */
  char* printConfiguration(char *header);


  /* Method printOn: Stream output function */
  void printOn(ostream &os = cout);
};

inline ostream &operator<<(ostream &os, Step &obj)
{
	obj.printOn(os);
	return os;
}

#endif
