/*
 * This file is part of the Pablo Performance Analysis Environment
 *
 *                                           TM
 * The Pablo Performance Analysis Environment   software is *not* in
 * the public domain.  However, it is freely available without fee for
 * education, research, and non-profit purposes.  By obtaining copies
 * of this and other files that comprise the Pablo Performance Analysis
 * Environment, you, the Licensee, agree to abide by the following
 * conditions and understandings with respect to the copyrighted software:
 * 
 * 1.  The software is copyrighted in the name of the Board of Trustees
 *     of the University of Illinois (UI), and ownership of the software
 *     remains with the UI. 
 *
 * 2.  Permission to use, copy, and modify this software and its documentation
 *     for education, research, and non-profit purposes is hereby granted
 *     to Licensee, provided that the copyright notice, the original author's
 *     names and unit identification, and this permission notice appear on
 *     all such copies, and that no charge be made for such copies.  Any
 *     entity desiring permission to incorporate this software into commercial
 *     products should contact:
 *
 *          Professor Daniel A. Reed                 reed@cs.uiuc.edu
 *          University of Illinois
 *          Department of Computer Science
 *          2413 Digital Computer Laboratory
 *          1304 West Springfield Avenue
 *          Urbana, Illinois  61801
 *          USA
 *
 * 3.  Licensee may not use the name, logo, or any other symbol of the UI
 *     nor the names of any of its employees nor any adaptation thereof in
 *     advertizing or publicity pertaining to the software without specific
 *     prior written approval of the UI.
 *
 * 4.  THE UI MAKES NO REPRESENTATIONS ABOUT THE SUITABILITY OF THE
 *     SOFTWARE FOR ANY PURPOSE.  IT IS PROVIDED "AS IS" WITHOUT EXPRESS
 *     OR IMPLIED WARRANTY.
 *
 * 5.  The UI shall not be liable for any damages suffered by Licensee from
 *     the use of this software.
 *
 * 6.  The software was developed under agreements between the UI and the
 *     Federal Government which entitle the Government to certain rights.
 *
 **************************************************************************
 *
 * Developed by: The TAPESTRY Parallel Computing Laboratory
 *		 University of Illinois at Urbana-Champaign
 *		 Department of Computer Science
 *		 1304 W. Springfield Avenue
 *		 Urbana, IL	61801
 *
 * Copyright (c) 1987, 1988, 1989, 1990, 1991, 1992
 * The University of Illinois Board of Trustees.
 *	All Rights Reserved.
 *
 * Author: Tom Birkett (birkett@cs.uiuc.edu)
 * Author: Tara Madhyastha (tara@cs.uiuc.edu)
 * Project Manager and Principal Investigator:
 *      Daniel A. Reed (reed@cs.uiuc.edu)
 *
 * Funded by: National Science Foundation grants NSF CCR86-57696,
 * NSF CCR87-06653 and NSF CDA87-22836 (Tapestry), NASA ICLASS Contract
 * No. NAG-1-613, DARPA Contract No. DABT63-91-K-0004, and by a grant
 * from the Digital Equipment Corporation External Research Program.
 *
 */
/*
 * SparcAudioHardware.h: Implements the interface to the SPARC audio chip.
 *
 */
                               
#ifndef SparcAudioHardware_h
#define SparcAudioHardware_h

#include "SoundObj.h"
#include "Oscil.h"
#include <fcntl.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/poll.h>
#include <sys/errno.h>
#include <sun/audioio.h>
#include <multimedia/libaudio.h>
#include <multimedia/audio_device.h>



#define		BUFLEN		256	

typedef unsigned char waveBuffer[BUFLEN];

#define MAX_GAIN                (100)           /* maximum gain */
/*
 * This defines the tolerable sample rate error as a ratio between the
 * sample rates of the audio data and the audio device.
 */
#define SAMPLE_RATE_THRESHOLD   (.01)
#define AUDBUFSIZE              (65536) /* size should depend on sample rate */

#define MAX_SPOKEN_NUMBER       (100000) /* largest number to speak */


class SparcAudioHardware : public SoundObj {
/*
*
* A SparcAudioHardware defines the interface to the SPARC audio chip.
*	
*/

protected:

  unsigned        Volume = 0;            /* output volume */
  unsigned        Record_volume = 0;     /* recording volume */
  int             Audio_fd = -1;         /* file descriptor for audio device */
  char Audio_dev[14];
  Audio_hdr       Dev_hdr;                /* audio header for device */
  Audio_hdr       File_hdr;               /* audio header for file */

  unsigned       Play_port = AUDIO_SPEAKER;

  int InstrumentNumber=0;         


public:

        /* Method SparcAudioHardWare:	The SparcAudioHardware		
	*				constructor.			*/
        SparcAudioHardware();

        /* Method ~SparcAudioHardware:	The SparcAudioHardware		*
	*				destructor.			*/
        ~SparcAudioHardware();

        /* Method setVolume:    Set the volume (attenuation) of the     *
	*   			hardware.				*/
        Bool_ setVolume(unsigned volumeRequested);

        /* Method setRecordVolume:    Set the record volume (attenuation) */
        /*                            of the  hardware                    */
        Bool_ setRecordVolume(unsigned volumeRequested);

        /* Method reconfigDevice:    Reconfigure device to match file header */
        Bool_ reconfigDevice();

	/* Method selectInstrument:  Select one of the available instruments */
	Bool_ selectInstrument(int number);

        /* Method playSamples:      Play samples from sparc sample file */
        Bool_  playSamples(char *filename, double duration = -1.);
      
        Bool_ playSamples(char *abuf, int buflen, int samplerate = 8192, 
			    double duration = -1);

        /* Method stopPlayingSamples:     Flush queues and stop */
        Bool_ stopPlayingSamples();

        /* Method setOutputPort:   Set the play port */
        Bool_ setOutputPort(unsigned port);

        /* Method recordSamples:     Record samples  */
        Bool_ recordSamples(char *filename, double duration);
	

        Bool_ recordSamples(char *buf, int numsamples);

        /* Method pausePlay:      Pause play */
        Bool_ pausePlay();

        /* Method resumePlay:    Resume play */
        Bool_ resumePlay();

        /* Method reset:     Reset parameters to their initial values */
        Bool_ reset();
  
       /* Method playNote:	At the next opportunity, play the 	*
	*			requested note for the requested	*
	*			duration.				*/
        Bool_ playNote( char note, double duration );
	
       /* Method playNumber:    ``Say'' the given number                  */

        Bool_ playNumber( int num, int voice);
        Bool_ playNumber( double num, int voice);

       /* Method playFraction:  ``Say'' the fractional part of some number */
        Bool_ playFraction( char *fraction, int voice );

};	

#endif SparcAudioHardware_h
