/*
 * This file is part of the Pablo Performance Analysis Environment
 *
 *                                           TM
 * The Pablo Performance Analysis Environment   software is *not* in
 * the public domain.  However, it is freely available without fee for
 * education, research, and non-profit purposes.  By obtaining copies
 * of this and other files that comprise the Pablo Performance Analysis
 * Environment, you, the Licensee, agree to abide by the following
 * conditions and understandings with respect to the copyrighted software:
 * 
 * 1.  The software is copyrighted in the name of the Board of Trustees
 *     of the University of Illinois (UI), and ownership of the software
 *     remains with the UI. 
 *
 * 2.  Permission to use, copy, and modify this software and its documentation
 *     for education, research, and non-profit purposes is hereby granted
 *     to Licensee, provided that the copyright notice, the original author's
 *     names and unit identification, and this permission notice appear on
 *     all such copies, and that no charge be made for such copies.  Any
 *     entity desiring permission to incorporate this software into commercial
 *     products should contact:
 *
 *          Professor Daniel A. Reed                 reed@cs.uiuc.edu
 *          University of Illinois
 *          Department of Computer Science
 *          2413 Digital Computer Laboratory
 *          1304 West Springfield Avenue
 *          Urbana, Illinois  61801
 *          USA
 *
 * 3.  Licensee may not use the name, logo, or any other symbol of the UI
 *     nor the names of any of its employees nor any adaptation thereof in
 *     advertizing or publicity pertaining to the software without specific
 *     prior written approval of the UI.
 *
 * 4.  THE UI MAKES NO REPRESENTATIONS ABOUT THE SUITABILITY OF THE
 *     SOFTWARE FOR ANY PURPOSE.  IT IS PROVIDED "AS IS" WITHOUT EXPRESS
 *     OR IMPLIED WARRANTY.
 *
 * 5.  The UI shall not be liable for any damages suffered by Licensee from
 *     the use of this software.
 *
 * 6.  The software was developed under agreements between the UI and the
 *     Federal Government which entitle the Government to certain rights.
 *
 **************************************************************************
 *
 * Developed by: The TAPESTRY Parallel Computing Laboratory
 *		 University of Illinois at Urbana-Champaign
 *		 Department of Computer Science
 *		 1304 W. Springfield Avenue
 *		 Urbana, IL	61801
 *
 * Copyright (c) 1987, 1988, 1989, 1990, 1991, 1992
 * The University of Illinois Board of Trustees.
 *	All Rights Reserved.
 *
 * Author: Tara Madhyastha (tara@cs.uiuc.edu)
 * Project Manager and Principal Investigator:
 *	Daniel A. Reed (reed@cs.uiuc.edu)
 *
 * Funded by: National Science Foundation grants NSF CCR86-57696,
 * NSF CCR87-06653 and NSF CDA87-22836 (Tapestry), NASA ICLASS Contract
 * No. NAG-1-613, DARPA Contract No. DABT63-91-K-0004, and by a grant
 * from the Digital Equipment Corporation External Research Program.
 *
 */
/*
 * SWMultiParams.h: The X Window System interface for sonic widget 
 * configuration parameters.
 *
 */

#pragma once
#ifndef SWMultiParams_h
#define SWMultiParams_h

#include "BaseSonicWidget.h"
#include "SmallWCLWidget.h"
#include "TransformFunctions.h"

#include <Xm/Xm.h>


extern "C" {
#include <X11/Wc/WcCreate.h>
#include <X11/StringDefs.h>
#include <X11/Xmp/Table.h>
#include <X11/IntrinsicP.h>
#include <X11/CoreP.h>
char *XmTextGetString();
}


class SWMultiParams : public SmallWCLWidget {
/*
 *  SWMultiParams implements an X interface to configure a sonic widget.
 *  The sonic widget should be at most two levels deep.
 */

private:
  BaseSonicWidget *SW;

  Widget transformMenu;

  DataTransform  *newTF, *oldTF, *TF;
  TransformFunctions TFuncs;
  

  Bool_ doneRunning = False_;
  Bool_ dismissed = False_;
  Bool_ standaloneMode = False_;
  Bool_ usingOldTF = False_;

  PtrList WclWidgetList, ResFileList, TFWidgetList;

  int childID = 0;
  int CurrentlyUp = -1;

  /* Method centerWidget: Center the widget with respect to a reference  * 
   *                      widget                                         */
  void centerWidget(Widget reference, Widget center);

  /* Method resetAllToggles: Reset toggles on transform function menu */
  void resetAllToggles();

  /* Method registerCallbacks: Register all the X callbacks */
  void registerCallbacks();


  /* Method writeResourceFiles: Write the WCL resource files to a temporary
    directory. */
  void writeResourceFiles();


  int currentMessage=0, currentVal=0;

public:
  /* Method SWMultiParams: The SWMultiParams constructor. */
  SWMultiParams(Widget parent, const char *name, const char *AppName,
		  BaseSonicWidget *SW);

  /* Method ~SWMultiParams: The SWMultiParams destructor. */
  ~SWMultiParams();


  /* Method create: Create the WCL widget */
  void create();
  
  /* Method fixupSize:   Make sure the popup has the correct size */
  void fixupSize(Widget it, int i);

  /* Method getCallbackArgs: Get the callback args from a resource in the *
   *                         widget                                       */
  Bool_ getCallbackArgs(char *arglist);
  
  /* Method promptTransformFunctionMenu: Pop up the transform function menu */
  void promptTransformFunctionMenu();

  /* Method getTransformFunction: Return the selected transform function */
  DataTransform* getTransformFunction() { return TF; } ;

  /* Method run: Run the WCL widget */
  void run();


  /* Method PutLineResourceCB: Put a line in the resource database */
  static void PutLineResourceCB(Widget w, char *line, void *unused);

  /* Method updateRevertLabel: Update the revert label in the TF menu */
  void updateRevertLabel(DataTransform *transform);

  /* Method doneRunningCallback: Callback called when finished running */
  void doneRunningCallback(Widget w, SWMultiParams *obj, 
					 XtPointer);


  /* Method revertTransformFunctionCallback: Called to revert to old TF */
          void revertTransformFunctionCallback(Widget w, SWMultiParams *obj, 
					 XtPointer);

  /* Method dismissedCallback: Called when window is dismissed */
          void dismissedCallback(Widget w, SWMultiParams *obj, 
					 XtPointer);


  /* Method cancelledCallback: Called when TF menu is cancelled */
          void cancelledCallback(Widget w, SWMultiParams *obj, 
					 XtPointer);

  /* Method configureTransformCallback: Configure the TF menu */
  void configureTransformCallback(Widget w, SWMultiParams *obj, 
				  XtPointer);

  /* Method selectTransformFunctionCallback: Select a new TF */
  void selectTransformFunctionCallback(Widget w, SWMultiParams *obj, 
				       XmToggleButtonCallbackStruct *state);

  /* Method updateTransformDefaultCallback: update TF defaults */
  void updateTransformDefaultCallback(Widget w, SWMultiParams *obj, 
				      XtPointer);

  /* Method updateDefaultFromSliderCallback: Update default from scale widget */
  void updateDefaultFromSliderCallback(Widget w, SWMultiParams *obj, 
				       XtPointer);

  /* Method updateDefaultFromListCallback: Update default from list widget */
  void updateDefaultFromListCallback(Widget w, SWMultiParams *obj, 
				     XtPointer);

  /* Method updateDefaultFromTextCallback: Update default from text widget */
  void updateDefaultFromTextCallback(Widget w, SWMultiParams *obj,
					   XtPointer);

  /* Method updateDefaultFromToggleCallback: Update default from toggle button */
  void updateDefaultFromToggleCallback(Widget w, SWMultiParams *obj, 
				       XtPointer);


  /* Method updateDefaultCallback: Update default from any widget */
  void updateDefaultCallback(Widget w, SWMultiParams *,
					   XtPointer);

  /* Method generalSWParamsCallback: The basic callback -- all callbacks are * 
   *                                 routed through here                     */
  static void generalSWParamsCallback(Widget w, void *rec, 
				      XtPointer);


  /* Method registerMemberCallback: Register a member function callback */
  void registerMemberCallback(char *name, void *proc, 
			      SWMultiParams *data);

  /* Method printOn: Stream output function */
  void printOn(ostream &os = cout);

};

inline ostream &operator<<(ostream &os, SWMultiParams &obj)
{
	obj.printOn(os);
	return os;
}

#endif
