/*
 * This file is part of the Pablo Performance Analysis Environment
 *
 *                                           TM
 * The Pablo Performance Analysis Environment   software is *not* in
 * the public domain.  However, it is freely available without fee for
 * education, research, and non-profit purposes.  By obtaining copies
 * of this and other files that comprise the Pablo Performance Analysis
 * Environment, you, the Licensee, agree to abide by the following
 * conditions and understandings with respect to the copyrighted software:
 * 
 * 1.  The software is copyrighted in the name of the Board of Trustees
 *     of the University of Illinois (UI), and ownership of the software
 *     remains with the UI. 
 *
 * 2.  Permission to use, copy, and modify this software and its documentation
 *     for education, research, and non-profit purposes is hereby granted
 *     to Licensee, provided that the copyright notice, the original author's
 *     names and unit identification, and this permission notice appear on
 *     all such copies, and that no charge be made for such copies.  Any
 *     entity desiring permission to incorporate this software into commercial
 *     products should contact:
 *
 *          Professor Daniel A. Reed                 reed@cs.uiuc.edu
 *          University of Illinois
 *          Department of Computer Science
 *          2413 Digital Computer Laboratory
 *          1304 West Springfield Avenue
 *          Urbana, Illinois  61801
 *          USA
 *
 * 3.  Licensee may not use the name, logo, or any other symbol of the UI
 *     nor the names of any of its employees nor any adaptation thereof in
 *     advertizing or publicity pertaining to the software without specific
 *     prior written approval of the UI.
 *
 * 4.  THE UI MAKES NO REPRESENTATIONS ABOUT THE SUITABILITY OF THE
 *     SOFTWARE FOR ANY PURPOSE.  IT IS PROVIDED "AS IS" WITHOUT EXPRESS
 *     OR IMPLIED WARRANTY.
 *
 * 5.  The UI shall not be liable for any damages suffered by Licensee from
 *     the use of this software.
 *
 * 6.  The software was developed under agreements between the UI and the
 *     Federal Government which entitle the Government to certain rights.
 *
 **************************************************************************
 *
 * Developed by: The TAPESTRY Parallel Computing Laboratory
 *		 University of Illinois at Urbana-Champaign
 *		 Department of Computer Science
 *		 1304 W. Springfield Avenue
 *		 Urbana, IL	61801
 *
 * Copyright (c) 1987, 1988, 1989, 1990, 1991, 1992
 * The University of Illinois Board of Trustees.
 *	All Rights Reserved.
 *
 * Project Manager and Principal Investigator:
 *      Daniel A. Reed (reed@cs.uiuc.edu)
 *
 * Funded by: National Science Foundation grants NSF CCR86-57696,
 * NSF CCR87-06653 and NSF CDA87-22836 (Tapestry), NASA ICLASS Contract
 * No. NAG-1-613, DARPA Contract No. DABT63-91-K-0004, and by a grant
 * from the Digital Equipment Corporation External Research Program.
 *
 */

#include "TCPSocket.h"

TCPSocket::TCPSocket(int f) 
{
	int addrlen = sizeof(addr);

	fd = f;

	getsockname(fd, (struct sockaddr *) &addr, &addrlen);
	port = addr.sin_port;
//	cerr << form("TCPSocket::const fd=%d port=%d\n", fd, port);
}

TCPSocket::TCPSocket()
{
	fd =  socket(AF_INET, SOCK_STREAM, 0);
	port = 0;
	if (fd < 0)
	{
		cerr << "TCPSocket: socket error: " << sys_errlist[errno];
		cerr << NL;
	}
}

TCPSocket::~TCPSocket()
{
	if (fd >= 0)
		close(fd);
}

int TCPSocket::bindToPort(u_short p)
{
	int addrlen, rc;
	
	addr.sin_family = AF_INET;
	addr.sin_addr.s_addr = INADDR_ANY;
	addr.sin_port = htons(p);

	addrlen = sizeof(addr);
	
	rc = bind(fd, (struct sockaddr *) &addr, addrlen);
	if (rc < 0)
	{
		cerr << "TCPSocket::bindToPort error: " << sys_errlist[errno];
		cerr << NL;
	}
	port = p;
	return(rc);
}

int TCPSocket::bindToNamedPort(char *service)
{
	int addrlen, rc;
	struct servent *serv;

	serv = getservbyname(service, "tcp");
	if (serv == NULL)
	{
		cerr << "TCPSocket::bindToNamedPort: getservybyname error: " << sys_errlist[errno] << NL;
		return -1;
	}
	
	addr.sin_family = AF_INET;
	addr.sin_addr.s_addr = INADDR_ANY;
	addr.sin_port = serv->s_port;

	addrlen = sizeof(addr);
	
	rc = bind(fd, (struct sockaddr *) &addr, addrlen);
	if (rc < 0)
	{
		cerr << "TCPSocket::bindToPort error: " << sys_errlist[errno];
		cerr << NL;
		port = 0;
	}
	else
		port = serv->s_port;
	return(rc);
}

u_short TCPSocket::bindToAnonymousPort()
{
	int addrlen, rc;
	
	addr.sin_family = AF_INET;
	addr.sin_addr.s_addr = INADDR_ANY;
	addr.sin_port = htons(0);

	addrlen = sizeof(addr);
	
	rc = bind(fd, (struct sockaddr *) &addr, addrlen);
	if (rc < 0)
	{
		cerr << "TCPSocket::bindToPort error: " << sys_errlist[errno];
		cerr << NL;
	}
	getsockname(fd, (struct sockaddr *)&addr, &addrlen);
	port = addr.sin_port;
	return getPort();
}

void TCPSocket::listen(int backlog)
{
	int rc;

	rc = ::listen(fd, backlog);

	if (rc < 0)
	{
		cerr << form("TCPSocket::listen: %s\n", sys_errlist[errno]);
	}
}

		
TCPSocket* TCPSocket::accept()
{
	TCPSocket *sock;
	int cfd;
	struct sockaddr_in from;
	int fromlen;

	fromlen = sizeof(from);

      restart:
	cfd = ::accept(fd, (struct sockaddr *) &from, &fromlen);
	if (cfd < 0)
	{
	  if (errno == EINTR) {
	    goto restart;
	  } else {
	    cerr << form("TCPSocket::accept: %s\n", sys_errlist[errno]);
	    return NULL;
	  }
	}
	// here we probably want to restart accept if it was interrupted.

	return new TCPSocket(cfd);
}

int TCPSocket::connectToPort(char *hostname, u_short p)
{
	int rc;
	struct hostent *hp;
	struct sockaddr_in list;

	hp = gethostbyname(hostname);
	if (hp == NULL)
	{
		cerr << "TCPSocket gethostybyname: " << sys_errlist[errno] << NL;
		return (-1);
	}

	bzero((void *) &list, sizeof(list));
	bcopy((void *) hp->h_addr, (void *) &list.sin_addr, hp->h_length);
	list.sin_family = hp->h_addrtype;
	list.sin_port = htons(p);

	rc = connect(fd, (struct sockaddr *) &list, sizeof(list));
	if (rc < 0)
	{
		cerr << "TCPSocket::connect: " << sys_errlist[errno] <<  NL;
	}
	return(rc);
}

int TCPSocket::connectToService(char *hostname, char *service)
{
	int rc;
	struct hostent *hp;
	struct servent *serv;
	struct sockaddr_in list;

	hp = gethostbyname(hostname);
	if (hp == NULL)
	{
		cerr << "TCPSocket gethostybyname: " << sys_errlist[errno] << NL;
		return (-1);
	}

	serv = getservbyname(service, "tcp");
	if (serv == NULL)
	{
		cerr << "TCPSocket getservybyname: " << sys_errlist[errno] << NL;
		return (-1);
	}

	bzero((void *) &list, sizeof(list));
	bcopy((void *) hp->h_addr, (void *) &list.sin_addr, hp->h_length);
	list.sin_family = hp->h_addrtype;
	list.sin_port = serv->s_port;

	rc = connect(fd, (struct sockaddr *) &list, sizeof(list));
	if (rc < 0)
	{
		cerr << "TCPSocket::connect: " << sys_errlist[errno] <<  NL;
	}
	return(rc);
}


void TCPSocket::printOn(ostream &os)
{
	os << form("TCPSocket: fd=%d port=%d\n", fd, getPort());
}
