/*
 * This file is part of the Pablo Performance Analysis Environment
 *
 *                                           TM
 * The Pablo Performance Analysis Environment   software is *not* in
 * the public domain.  However, it is freely available without fee for
 * education, research, and non-profit purposes.  By obtaining copies
 * of this and other files that comprise the Pablo Performance Analysis
 * Environment, you, the Licensee, agree to abide by the following
 * conditions and understandings with respect to the copyrighted software:
 * 
 * 1.  The software is copyrighted in the name of the Board of Trustees
 *     of the University of Illinois (UI), and ownership of the software
 *     remains with the UI. 
 *
 * 2.  Permission to use, copy, and modify this software and its documentation
 *     for education, research, and non-profit purposes is hereby granted
 *     to Licensee, provided that the copyright notice, the original author's
 *     names and unit identification, and this permission notice appear on
 *     all such copies, and that no charge be made for such copies.  Any
 *     entity desiring permission to incorporate this software into commercial
 *     products should contact:
 *
 *          Professor Daniel A. Reed                 reed@cs.uiuc.edu
 *          University of Illinois
 *          Department of Computer Science
 *          2413 Digital Computer Laboratory
 *          1304 West Springfield Avenue
 *          Urbana, Illinois  61801
 *          USA
 *
 * 3.  Licensee may not use the name, logo, or any other symbol of the UI
 *     nor the names of any of its employees nor any adaptation thereof in
 *     advertizing or publicity pertaining to the software without specific
 *     prior written approval of the UI.
 *
 * 4.  THE UI MAKES NO REPRESENTATIONS ABOUT THE SUITABILITY OF THE
 *     SOFTWARE FOR ANY PURPOSE.  IT IS PROVIDED "AS IS" WITHOUT EXPRESS
 *     OR IMPLIED WARRANTY.
 *
 * 5.  The UI shall not be liable for any damages suffered by Licensee from
 *     the use of this software.
 *
 * 6.  The software was developed under agreements between the UI and the
 *     Federal Government which entitle the Government to certain rights.
 *
 **************************************************************************
 *
 * Developed by: The TAPESTRY Parallel Computing Laboratory
 *		 University of Illinois at Urbana-Champaign
 *		 Department of Computer Science
 *		 1304 W. Springfield Avenue
 *		 Urbana, IL	61801
 *
 * Copyright (c) 1987, 1988, 1989, 1990, 1991, 1992
 * The University of Illinois Board of Trustees.
 *	All Rights Reserved.
 *
 * Author: Tara Madhyastha (tara@cs.uiuc.edu)
 * Project Manager and Principal Investigator:
 *	Daniel A. Reed (reed@cs.uiuc.edu)
 *
 * Funded by: National Science Foundation grants NSF CCR86-57696,
 * NSF CCR87-06653 and NSF CDA87-22836 (Tapestry), NASA ICLASS Contract
 * No. NAG-1-613, DARPA Contract No. DABT63-91-K-0004, and by a grant
 * from the Digital Equipment Corporation External Research Program.
 *
 */
/* 
 * PtrList.h: Implements a list of pointers to things.
 *
 */

#pragma once
#ifndef PtrList_h
#define PtrList_h

#include "SoundObj.h"
#include "Data.h"

class PtrList : public Data {
/*
 * Implements a list of void pointers to things. It is the base class
 * for other typed lists.
 */

protected:
  int nItems = 0;
  int nItemsAllocated = 0;

  void **PtrArray;

  /* Method computeNewSize: Determine new size for list resizing */
  int computeNewSize(int requestedIndex);

  /* Method growList: Enlarge list, based on index n */
  void growList(int n);

  /* Method resizeListTo: Resize list to given size */
  Bool_ resizeListTo(int n);

public:
  /* Method PtrList: The PtrList constructor. */
  PtrList(int initialSize = 10);
  
  /* Method ~PtrList: The PtrList destructor. */
  ~PtrList();
  
  /* Method addElement: Add pointer to end of list */
  virtual int addElement(void *arg);
  
  /* Method setElement: Assign to a specific element of the list */
  virtual int setElement(int n, void *arg);
  
  /* Method getElement: Return element from list */
  virtual void* getElement(int n) const;

  /* Method deleteElement: Delete element from list, returning it */
  /*                   and resizing the list */
  
  virtual void* deleteElement(int n);
  
  
  /* Method numberArgs: Return the number of items in the list */
  int numberArgs() const { return nItems; }
  
  /* Method numberItemsAllocated: Return  allocated size of list */
  int numberItemsAllocated() const { return nItemsAllocated; };
  
  /* Method operator[]: Array access */
  virtual void* operator[](int n) const;
  
  /* Method printOn: Stream output function */
  virtual void printOn(ostream &os = cout);
};

inline ostream &operator<<(ostream &os, PtrList &obj)
{
	obj.printOn(os);
	return os;
}

#endif
