/*
 * This file is part of the Pablo Performance Analysis Environment
 *
 *                                           TM
 * The Pablo Performance Analysis Environment   software is *not* in
 * the public domain.  However, it is freely available without fee for
 * education, research, and non-profit purposes.  By obtaining copies
 * of this and other files that comprise the Pablo Performance Analysis
 * Environment, you, the Licensee, agree to abide by the following
 * conditions and understandings with respect to the copyrighted software:
 * 
 * 1.  The software is copyrighted in the name of the Board of Trustees
 *     of the University of Illinois (UI), and ownership of the software
 *     remains with the UI. 
 *
 * 2.  Permission to use, copy, and modify this software and its documentation
 *     for education, research, and non-profit purposes is hereby granted
 *     to Licensee, provided that the copyright notice, the original author's
 *     names and unit identification, and this permission notice appear on
 *     all such copies, and that no charge be made for such copies.  Any
 *     entity desiring permission to incorporate this software into commercial
 *     products should contact:
 *
 *          Professor Daniel A. Reed                 reed@cs.uiuc.edu
 *          University of Illinois
 *          Department of Computer Science
 *          2413 Digital Computer Laboratory
 *          1304 West Springfield Avenue
 *          Urbana, Illinois  61801
 *          USA
 *
 * 3.  Licensee may not use the name, logo, or any other symbol of the UI
 *     nor the names of any of its employees nor any adaptation thereof in
 *     advertizing or publicity pertaining to the software without specific
 *     prior written approval of the UI.
 *
 * 4.  THE UI MAKES NO REPRESENTATIONS ABOUT THE SUITABILITY OF THE
 *     SOFTWARE FOR ANY PURPOSE.  IT IS PROVIDED "AS IS" WITHOUT EXPRESS
 *     OR IMPLIED WARRANTY.
 *
 * 5.  The UI shall not be liable for any damages suffered by Licensee from
 *     the use of this software.
 *
 * 6.  The software was developed under agreements between the UI and the
 *     Federal Government which entitle the Government to certain rights.
 *
 **************************************************************************
 *
 * Developed by: The TAPESTRY Parallel Computing Laboratory
 *		 University of Illinois at Urbana-Champaign
 *		 Department of Computer Science
 *		 1304 W. Springfield Avenue
 *		 Urbana, IL	61801
 *
 * Copyright (c) 1987, 1988, 1989, 1990, 1991, 1992
 * The University of Illinois Board of Trustees.
 *	All Rights Reserved.
 *
 * Author: Tara Madhyastha (tara@cs.uiuc.edu)
 * Project Manager and Principal Investigator:
 *	Daniel A. Reed (reed@cs.uiuc.edu)
 *
 * Funded by: National Science Foundation grants NSF CCR86-57696,
 * NSF CCR87-06653 and NSF CDA87-22836 (Tapestry), NASA ICLASS Contract
 * No. NAG-1-613, DARPA Contract No. DABT63-91-K-0004, and by a grant
 * from the Digital Equipment Corporation External Research Program.
 *
 */

#include "PtrList.h"

PtrList::PtrList(int initialSize)
{
  PtrArray = new void*[initialSize];
  nItems = 0;
  nItemsAllocated = initialSize;
}

PtrList::~PtrList()
{
  delete PtrArray;
}

int PtrList::addElement(void* arg)
{
  if (nItems == nItemsAllocated) {
    growList(nItems);
  }
  
  PtrArray[nItems++] = arg;
  return(nItems);
}

int PtrList::setElement(int n, void *arg)
{
  if (n < 0)  {
    cerr << form("Error: PtrList::setElement: index %d out of bounds!\n", n);
    return -1;
  }
  if (n >= nItemsAllocated)
    growList(n);

  if (n >= nItems)
    nItems = n+1;

  PtrArray[n] = arg;
  return(n);
}

/* virtual */
void* PtrList::getElement(int n)  const
{
  if (n < 0 || n >= nItems) {
    cerr << form("Error: PtrList::getElement: index %d out of bounds!\n", n);
    return NULL;
  }
  return(PtrArray[n]);
}

void* PtrList::operator[](int n) const
{
  if (n < 0) {
    cerr << form("Error: PtrList::getElement: index %d out of bounds!\n", n);
    return NULL;
  }

  if (n >= nItems) {
    cerr << form("Error: PtrList::getElement: index %d greater than max!\n", n);
    return NULL;
  }

  return PtrArray[n];
}

void* PtrList::deleteElement(int n)
{
  void *arg;
  int i;
  
  if (n < 0 || n >= nItems) {
    cerr << form("Error: PtrList::deleteElement(n = %d): n must be between 0 and %d inclusive \n", n, nItems-1);
    return NULL;
  }
  arg = PtrArray[n];
  for(i=n; i < nItems - 1 ; i++) {
    PtrArray[i] = PtrArray[i+1];
  }
  nItems--;
  return(arg);
}
  

int PtrList::computeNewSize(int requestedIndex)
{
  if (requestedIndex < nItemsAllocated) {
    return (nItemsAllocated * 2);
  }  else {
    return (requestedIndex * 2);
  }
}

void PtrList::growList(int n)
{
  resizeListTo(computeNewSize(n));
}

Bool_ PtrList::resizeListTo(int n)
{
  void **oldPtrArray;
  int i;

  if (nItemsAllocated > n)
    return True_;

  oldPtrArray = PtrArray;
  PtrArray = new void*[n];

  for (i = 0; i < nItemsAllocated; i++)
    PtrArray[i] = oldPtrArray[i];

  delete oldPtrArray;
  nItemsAllocated = n;
  return True_;
}



void PtrList::printOn(ostream &os)
{
	os << "PtrList\n";
}


