/*
 * This file is part of the Pablo Performance Analysis Environment
 *
 *                                           TM
 * The Pablo Performance Analysis Environment   software is *not* in
 * the public domain.  However, it is freely available without fee for
 * education, research, and non-profit purposes.  By obtaining copies
 * of this and other files that comprise the Pablo Performance Analysis
 * Environment, you, the Licensee, agree to abide by the following
 * conditions and understandings with respect to the copyrighted software:
 * 
 * 1.  The software is copyrighted in the name of the Board of Trustees
 *     of the University of Illinois (UI), and ownership of the software
 *     remains with the UI. 
 *
 * 2.  Permission to use, copy, and modify this software and its documentation
 *     for education, research, and non-profit purposes is hereby granted
 *     to Licensee, provided that the copyright notice, the original author's
 *     names and unit identification, and this permission notice appear on
 *     all such copies, and that no charge be made for such copies.  Any
 *     entity desiring permission to incorporate this software into commercial
 *     products should contact:
 *
 *          Professor Daniel A. Reed                 reed@cs.uiuc.edu
 *          University of Illinois
 *          Department of Computer Science
 *          2413 Digital Computer Laboratory
 *          1304 West Springfield Avenue
 *          Urbana, Illinois  61801
 *          USA
 *
 * 3.  Licensee may not use the name, logo, or any other symbol of the UI
 *     nor the names of any of its employees nor any adaptation thereof in
 *     advertizing or publicity pertaining to the software without specific
 *     prior written approval of the UI.
 *
 * 4.  THE UI MAKES NO REPRESENTATIONS ABOUT THE SUITABILITY OF THE
 *     SOFTWARE FOR ANY PURPOSE.  IT IS PROVIDED "AS IS" WITHOUT EXPRESS
 *     OR IMPLIED WARRANTY.
 *
 * 5.  The UI shall not be liable for any damages suffered by Licensee from
 *     the use of this software.
 *
 * 6.  The software was developed under agreements between the UI and the
 *     Federal Government which entitle the Government to certain rights.
 *
 **************************************************************************
 *
 * Developed by: The TAPESTRY Parallel Computing Laboratory
 *		 University of Illinois at Urbana-Champaign
 *		 Department of Computer Science
 *		 1304 W. Springfield Avenue
 *		 Urbana, IL	61801
 *
 * Copyright (c) 1987, 1988, 1989, 1990, 1991, 1992
 * The University of Illinois Board of Trustees.
 *	All Rights Reserved.
 *
 * Author: Tara Madhyastha (tara@cs.uiuc.edu)
 *
 * Project Manager and Principal Investigator:
 *	Daniel A. Reed (reed@cs.uiuc.edu)
 *
 * Funded by: National Science Foundation grants NSF CCR86-57696,
 * NSF CCR87-06653 and NSF CDA87-22836 (Tapestry), NASA ICLASS Contract
 * No. NAG-1-613, DARPA Contract No. DABT63-91-K-0004, and by a grant
 * from the Digital Equipment Corporation External Research Program.
 *
 */
/*
 * DataType.h: Implements the default (unknown) data type.
 *
 */

#pragma once
#ifndef DataType_h
#define DataType_h

#include "Data.h"

class DataType : public Data {
/*
 * DataType is the default (unknown) data type, which can potentially be
 * part of class Val.
 */

protected:
  char lowerBound=0, upperBound=0;
  Bool_ bounded = False_;

public:

  /* Method DataType: The DataType constructor. */
  /* Method ~DataType: The DataType destructor. */
  DataType() { } ;
  ~DataType() { } ;

  virtual DataType& operator= ( const DataType& dt ) {
    lowerBound = dt.lowerBound;
    upperBound = dt.upperBound;
    bounded = dt.bounded;
    return *this;
  } ;

  /* Method enumAsString: Return a particular enumerate as a string */
  virtual char* enumAsString(const int i) { 
    cerr << "Error DataType::enumAsString: not an enumerate...\n";
    return NULL; 
  } ;

  /* Method setValueFromString: Set data type value from string */
  virtual void setValueFromString( const char *string ) { } ;

  /* Method setBounds:      Set upper and lower bounds */
  virtual Bool_ setBounds( const char l, const char u );

  /* Method isBounded:  Must this type be in a specific range? */
  virtual Bool_ isBounded() { return bounded; } ;

  /* Method getLowerBound: Returns the lower bound, if bounded */
  virtual char getLowerBound() { return lowerBound; } ;
  
  /* Method getUpperBound: Returns the upper bound, if bounded */
  virtual char getUpperBound() { return upperBound; } ;
  
  /* Method binSend:     Send binary representation of data */
  virtual void binSend(int sfd) { 
    cerr << "Warning: DataType::binSend: unknown data type\n";
  } ;

  /* Method binReceive:  Receive binary representation of data */
  virtual void binReceive(int sfd) { 
    cerr << "Warning: DataType::binReceive: unknown data type\n";
  } ;

  /* Method print:    Return a string representation of DataType */
  virtual char* print() {
    cerr << "Warning: DataType::print: unknown data type\n";
    return NULL;
  } ;

  /* Method setValueFromDouble: Set the value of DataType from double */
  virtual void setValueFromDouble(double d) {
    cerr << "Warning: DataType::setValueFromDouble: unknown data type\n";
  } ;

  /* Method int: Return DataType as int */
  virtual operator int() { return 0; } ;

  /* Method char: Return DataType as char */
  virtual operator char() { return 0; } ;

  /* Method float: Return DataType as float */
  virtual operator float() { return 0; } ;


  
  /* Method double: Return DataType as double */
  virtual operator double() { return 0; } ;
  
  /* Method char*: Return DataType as character string */
  virtual operator char*() { return 0; } ;

  /* Method printOn: Stream output function */
  virtual void printOn(ostream &os = cout);

};

inline ostream &operator<<(ostream &os, DataType &obj)
{
	obj.printOn(os);
	return os;
}

#endif
