/*
 * This file is part of the Pablo Performance Analysis Environment
 *
 *                                           TM
 * The Pablo Performance Analysis Environment   software is *not* in
 * the public domain.  However, it is freely available without fee for
 * education, research, and non-profit purposes.  By obtaining copies
 * of this and other files that comprise the Pablo Performance Analysis
 * Environment, you, the Licensee, agree to abide by the following
 * conditions and understandings with respect to the copyrighted software:
 * 
 * 1.  The software is copyrighted in the name of the Board of Trustees
 *     of the University of Illinois (UI), and ownership of the software
 *     remains with the UI. 
 *
 * 2.  Permission to use, copy, and modify this software and its documentation
 *     for education, research, and non-profit purposes is hereby granted
 *     to Licensee, provided that the copyright notice, the original author's
 *     names and unit identification, and this permission notice appear on
 *     all such copies, and that no charge be made for such copies.  Any
 *     entity desiring permission to incorporate this software into commercial
 *     products should contact:
 *
 *          Professor Daniel A. Reed                 reed@cs.uiuc.edu
 *          University of Illinois
 *          Department of Computer Science
 *          2413 Digital Computer Laboratory
 *          1304 West Springfield Avenue
 *          Urbana, Illinois  61801
 *          USA
 *
 * 3.  Licensee may not use the name, logo, or any other symbol of the UI
 *     nor the names of any of its employees nor any adaptation thereof in
 *     advertizing or publicity pertaining to the software without specific
 *     prior written approval of the UI.
 *
 * 4.  THE UI MAKES NO REPRESENTATIONS ABOUT THE SUITABILITY OF THE
 *     SOFTWARE FOR ANY PURPOSE.  IT IS PROVIDED "AS IS" WITHOUT EXPRESS
 *     OR IMPLIED WARRANTY.
 *
 * 5.  The UI shall not be liable for any damages suffered by Licensee from
 *     the use of this software.
 *
 * 6.  The software was developed under agreements between the UI and the
 *     Federal Government which entitle the Government to certain rights.
 *
 **************************************************************************
 *
 * Developed by: The TAPESTRY Parallel Computing Laboratory
 *		 University of Illinois at Urbana-Champaign
 *		 Department of Computer Science
 *		 1304 W. Springfield Avenue
 *		 Urbana, IL	61801
 *
 * Copyright (c) 1987, 1988, 1989, 1990, 1991, 1992
 * The University of Illinois Board of Trustees.
 *	All Rights Reserved.
 *
 * Author: Tara Madhyastha (tara@cs.uiuc.edu)
 * Project Manager and Principal Investigator:
 *	Daniel A. Reed (reed@cs.uiuc.edu)
 *
 * Funded by: National Science Foundation grants NSF CCR86-57696,
 * NSF CCR87-06653 and NSF CDA87-22836 (Tapestry), NASA ICLASS Contract
 * No. NAG-1-613, DARPA Contract No. DABT63-91-K-0004, and by a grant
 * from the Digital Equipment Corporation External Research Program.
 *
 */

/* 
 * XSonicWidgetInterface.h: The base class for X interfaces to manipulate
 * sonic widgets.
 *
 */


#pragma once
#ifndef XSonicWidgetInterface_h
#define XSonicWidgetInterface_h

#include "SWMultiParams.h"
#include "FileReader.h"

#include <Xm/Xm.h>
#include <ctype.h>

Widget appShell;
XtAppContext app;
class XSonicWidgetInterface : public SoundObj {
/*
 *  XSonicWidgetInterface is the base class for X interfaces to manipulate
 *  sound control files. Primarily useful for callback registering routines.
 * There is some MAJOR hackery involved in doing callbacks in C++.
 * Beware!
 * 
 */


protected:


  char *appName, *appClass;
  BaseSonicWidget *SW;

  SWMultiParams *swp;

  char *widgetresfile;
  char *datafile;
  Bool_ running = False_;
  Bool_ childrenCreated = 0;


  FILE *dfp;

  FileReader *filereader;

  /* Method registerCallbacks: Register callback functions */
  void registerCallbacks();

public:

  /* Method XSonicWidgetInterface: The XSonicWidgetInterface constructor. */
  XSonicWidgetInterface(BaseSonicWidget *SW, FileReader *filereader, 
			int argc, char **argv);

  /* Method ~XSonicWidgetInterface: The XSonicWidgetInterface destructor. */
  ~XSonicWidgetInterface();

  /* Method create: Create the XSonicWidgetInterface */
  virtual void create();

  /* Method selectNewDataFileCallback: Choose a new data file */
  virtual void selectNewDataFileCallback(Widget w, void *, void *);

  /* Method writeWCFCallback: Write an SCF */
  virtual void writeWCFCallback(Widget w, void *, void *);

  /* Method quitCallback: Called when quitting */
  virtual void quitCallback(Widget w, void *, void *);

  /* Method runCallback: Called when running */
  virtual void runCallback(Widget w,  void *, void *);

  /* Method stopCallback: Called when stopping */
  virtual void stopCallback(Widget w,  void *, void *);

  /* Method reRunCallback: Called to rewind the filereader */
  virtual void reRunCallback(Widget w,  void *, void *);
  
  /* Method stepCallback: Called to step through one data value */
  virtual void stepCallback(Widget w,  void *, void *);

  /* Method configureCallback: Called to configure the Sonic Widget */
  virtual void configureCallback(Widget w,  void *, void *);

  /* Method registerMemberCallback: Register a member function as a callback */
  virtual void registerMemberCallback(char *name, void *proc, 
				     XSonicWidgetInterface *data);

  /* Method generalXSWIMemberCallback: General member callback */
  static void generalXSWIMemberCallback(Widget w, void *rec, void *callData);

  /* Method run: Run the interface */
  void run();

  /* Method printOn: Stream output function */
  virtual void printOn(ostream &os = cout);



};

inline ostream &operator<<(ostream &os, XSonicWidgetInterface &obj)
{
	obj.printOn(os);
	return os;
}

#endif
