/*
 * This file is part of the Pablo Performance Analysis Environment
 *
 *                                           TM
 * The Pablo Performance Analysis Environment   software is *not* in
 * the public domain.  However, it is freely available without fee for
 * education, research, and non-profit purposes.  By obtaining copies
 * of this and other files that comprise the Pablo Performance Analysis
 * Environment, you, the Licensee, agree to abide by the following
 * conditions and understandings with respect to the copyrighted software:
 * 
 * 1.  The software is copyrighted in the name of the Board of Trustees
 *     of the University of Illinois (UI), and ownership of the software
 *     remains with the UI. 
 *
 * 2.  Permission to use, copy, and modify this software and its documentation
 *     for education, research, and non-profit purposes is hereby granted
 *     to Licensee, provided that the copyright notice, the original author's
 *     names and unit identification, and this permission notice appear on
 *     all such copies, and that no charge be made for such copies.  Any
 *     entity desiring permission to incorporate this software into commercial
 *     products should contact:
 *
 *          Professor Daniel A. Reed                 reed@cs.uiuc.edu
 *          University of Illinois
 *          Department of Computer Science
 *          2413 Digital Computer Laboratory
 *          1304 West Springfield Avenue
 *          Urbana, Illinois  61801
 *          USA
 *
 * 3.  Licensee may not use the name, logo, or any other symbol of the UI
 *     nor the names of any of its employees nor any adaptation thereof in
 *     advertizing or publicity pertaining to the software without specific
 *     prior written approval of the UI.
 *
 * 4.  THE UI MAKES NO REPRESENTATIONS ABOUT THE SUITABILITY OF THE
 *     SOFTWARE FOR ANY PURPOSE.  IT IS PROVIDED "AS IS" WITHOUT EXPRESS
 *     OR IMPLIED WARRANTY.
 *
 * 5.  The UI shall not be liable for any damages suffered by Licensee from
 *     the use of this software.
 *
 * 6.  The software was developed under agreements between the UI and the
 *     Federal Government which entitle the Government to certain rights.
 *
 **************************************************************************
 *
 * Developed by: The TAPESTRY Parallel Computing Laboratory
 *		 University of Illinois at Urbana-Champaign
 *		 Department of Computer Science
 *		 1304 W. Springfield Avenue
 *		 Urbana, IL	61801
 *
 * Copyright (c) 1987, 1988, 1989, 1990, 1991, 1992
 * The University of Illinois Board of Trustees.
 *	All Rights Reserved.
 *
 * Author: Tara Madhyastha (tara@cs.uiuc.edu)
 * Project Manager and Principal Investigator:
 *	Daniel A. Reed (reed@cs.uiuc.edu)
 *
 * Funded by: National Science Foundation grants NSF CCR86-57696,
 * NSF CCR87-06653 and NSF CDA87-22836 (Tapestry), NASA ICLASS Contract
 * No. NAG-1-613, DARPA Contract No. DABT63-91-K-0004, and by a grant
 * from the Digital Equipment Corporation External Research Program.
 *
 */



#include "XSonicWidgetInterface.h"



typedef void (XSonicWidgetInterface::*XSonicWidgetInterfaceCallbackProc) (Widget, 
							      void *, void *);

struct XSonicWidgetInterfaceCBRec
{
  XSonicWidgetInterface *userData;
  XSonicWidgetInterfaceCallbackProc userProc;
};
  

XSonicWidgetInterface::XSonicWidgetInterface(BaseSonicWidget *SW,
					     FileReader *filereader,
					     int argc, char **argv) : SW(SW),
					     filereader(filereader)

{ 
  char *tmp, *appdir;
  
  if ((tmp = rindex(argv[0], '/')) == NULL) {
    appName = new char[strlen(argv[0]) + 1];
    strcpy(appName, argv[0]);
  } else {
    appName = new char[strlen(tmp) + 1];
    strcpy(appName, tmp);
  }
  
  char *appClass = new char[strlen(appName) + 1];
  
  strcpy(appClass, appName);
  
  if (islower(appClass[0]))
    appClass[0] = toupper(appClass[0]);
  else if (islower(appClass[1]))
    appClass[1] = toupper(appClass[1]);
  
   if ((appdir = getenv("XAPPLRESDIR")) == NULL) {
    cerr << form("Warning: XAPPLRESDIR is not set. Defaulting to\n%s\n",
		 DEFAULTXAPPLRESDIR);
    putenv((appdir = duplicateString(form("XAPPLRESDIR=%s",DEFAULTXAPPLRESDIR))));
  }
  
  appShell = XtInitialize(appName, appClass, NULL, 0, &argc, argv);
  Display *dpy = XtDisplay(appShell);
  WcAllowDuplicateRegistration(1);
  create();
}

void XSonicWidgetInterface::registerCallbacks()
{
  registerMemberCallback( "selectNewDataFileCB",
	 (XtCallbackProc) &XSonicWidgetInterface::selectNewDataFileCallback,
			 this);
  
  registerMemberCallback( "writeWCFCB",
	 (XtCallbackProc) &XSonicWidgetInterface::writeWCFCallback,
			 this);

  registerMemberCallback( "quitCB",
	 (XtCallbackProc) &XSonicWidgetInterface::quitCallback,
			 this);


  registerMemberCallback( "runCB",
	 (XtCallbackProc) &XSonicWidgetInterface::runCallback, this);
  registerMemberCallback( "stopCB",
	 (XtCallbackProc) &XSonicWidgetInterface::stopCallback, this);
  registerMemberCallback( "stepCB",
	 (XtCallbackProc) &XSonicWidgetInterface::stepCallback, this);
  registerMemberCallback( "reRunCB",
	 (XtCallbackProc) &XSonicWidgetInterface::reRunCallback, this);
  registerMemberCallback( "configureCB",
	 (XtCallbackProc) &XSonicWidgetInterface::configureCallback, this);
}

void XSonicWidgetInterface::create()
{
  registerCallbacks();

  app = XtWidgetToApplicationContext(appShell);

  MriRegisterMotif(app);
  WcWidgetCreation(appShell);
}

void XSonicWidgetInterface::run()
{
  Display *dpy = XtDisplay(appShell);
  XtRealizeWidget(appShell);
  XtMainLoop();
}


XSonicWidgetInterface::~XSonicWidgetInterface()
{
  delete appName; 
  delete appClass; 
  if (childrenCreated) {
    delete swp;
  }
}
  


void XSonicWidgetInterface::printOn(ostream &os)
{
	os << "XSonicWidgetInterface\n";
}

void XSonicWidgetInterface::configureCallback(Widget w, 
					      void *ignored,
					      void *unused)
{
  Widget w;
  Display *dpy = XtDisplay(appShell);

  if (childrenCreated == 0) {
    swp = new SWMultiParams(appShell, SW->getName(), appName, SW);
    childrenCreated = 1;
  }
  swp->run();
}


void XSonicWidgetInterface::selectNewDataFileCallback(Widget w,
						      void *ignored,
						      void *unused)
{
  XmString file;
  Arg arg[1];

  char *widgetclassname = (char *) (XtClass(w))->core_class.class_name;
  if (strcmp("XmFileSelectionBox", widgetclassname) != 0) {
    cerr << "Error: XSonicWidgetInterface::selectNewDatafileCallback: expected input from file selection box\n";
    return;
  }
  
  XtSetArg(arg[0], XmNdirSpec, (XtArgVal) &file);
  XtGetValues(w, arg, 1);
  XmStringGetLtoR(file, XmSTRING_DEFAULT_CHARSET, &datafile);
  filereader->newFile(datafile);
}



void XSonicWidgetInterface::writeWCFCallback(Widget w,
					     void *ignored,
					     void *unused)
{
  XmString file;
  Arg arg[1];
  filebuf fb;
  char *outputfile;

  char *widgetclassname = (char *) (XtClass(w))->core_class.class_name;
  if (strcmp("XmFileSelectionBox", widgetclassname) != 0) {
    cerr << "Error: XSonicWidgetInterface::writeWCFCallback: expected input from file selection box\n";
    return;
  }
  
  XtSetArg(arg[0], XmNdirSpec, (XtArgVal) &file);
  XtGetValues(w, arg, 1);
  XmStringGetLtoR(file, XmSTRING_DEFAULT_CHARSET, &outputfile);
  if(fb.open(outputfile,output) == 0) {
    cerr << "Error: XSonicWidgetInterface::writeWCFCallback: unable to open " << outputfile << NL;
    return;
  }
  ostream to(&fb);

  SW->writeWCF(to);
}

void XSonicWidgetInterface::quitCallback(Widget w, void *unused, void *ignored)
{
  if (childrenCreated) {
    delete swp;
  }
}

void XSonicWidgetInterface::stepCallback(Widget w, void *unused, void *ignored)
{
  double darray[25];
  int length;

  if(filereader->nextValue(darray, length, 25)) {
    SW->execute(darray, length);
  } else {
    cerr << "Warning: no more data\n";
  }
}
    
void XSonicWidgetInterface::runCallback(Widget w, void *unused, void *ignored)
{
  XEvent event;

  double darray[25];
  int length;
  running = True_;

  while(filereader->nextValue(darray, length, 25) && running) {
    SW->execute(darray, length);
    while(XtPending()) {
      XtNextEvent(&event);
      XtDispatchEvent(&event);
    }
  }
  cerr << "Warning: no more data\n";
  running = False_;
}

void XSonicWidgetInterface::stopCallback(Widget w, void *unused, void *ignored)
{
  running = False_;
}

void XSonicWidgetInterface::reRunCallback(Widget w, void *unused, 
					  void *ignored)
{
  double d;
  filereader->rewindFile();
}
 

void XSonicWidgetInterface::registerMemberCallback(char *name, void * proc,
                                       XSonicWidgetInterface *data)
{
  XSonicWidgetInterfaceCBRec *rec = new XSonicWidgetInterfaceCBRec;

  rec->userData = data;
  rec->userProc = (XSonicWidgetInterfaceCallbackProc) proc;

  WcRegisterCallback(app,
                     name,
                     (XtCallbackProc) generalXSWIMemberCallback,
                     rec);
}


static void XSonicWidgetInterface::generalXSWIMemberCallback(Widget w, 
							     void *rec, 
							     void *callData)
{
  struct XSonicWidgetInterfaceCBRec *foo = (XSonicWidgetInterfaceCBRec *) rec;
  XSonicWidgetInterface *foobar = foo->userData;
  XSonicWidgetInterfaceCallbackProc proc = foo->userProc;
  (foobar->*proc) (w, foo->userData, callData);
}
