/*
 * This file is part of the Pablo Performance Analysis Environment
 *
 *                                           TM
 * The Pablo Performance Analysis Environment   software is *not* in
 * the public domain.  However, it is freely available without fee for
 * education, research, and non-profit purposes.  By obtaining copies
 * of this and other files that comprise the Pablo Performance Analysis
 * Environment, you, the Licensee, agree to abide by the following
 * conditions and understandings with respect to the copyrighted software:
 * 
 * 1.  The software is copyrighted in the name of the Board of Trustees
 *     of the University of Illinois (UI), and ownership of the software
 *     remains with the UI. 
 *
 * 2.  Permission to use, copy, and modify this software and its documentation
 *     for education, research, and non-profit purposes is hereby granted
 *     to Licensee, provided that the copyright notice, the original author's
 *     names and unit identification, and this permission notice appear on
 *     all such copies, and that no charge be made for such copies.  Any
 *     entity desiring permission to incorporate this software into commercial
 *     products should contact:
 *
 *          Professor Daniel A. Reed                 reed@cs.uiuc.edu
 *          University of Illinois
 *          Department of Computer Science
 *          2413 Digital Computer Laboratory
 *          1304 West Springfield Avenue
 *          Urbana, Illinois  61801
 *          USA
 *
 * 3.  Licensee may not use the name, logo, or any other symbol of the UI
 *     nor the names of any of its employees nor any adaptation thereof in
 *     advertizing or publicity pertaining to the software without specific
 *     prior written approval of the UI.
 *
 * 4.  THE UI MAKES NO REPRESENTATIONS ABOUT THE SUITABILITY OF THE
 *     SOFTWARE FOR ANY PURPOSE.  IT IS PROVIDED "AS IS" WITHOUT EXPRESS
 *     OR IMPLIED WARRANTY.
 *
 * 5.  The UI shall not be liable for any damages suffered by Licensee from
 *     the use of this software.
 *
 * 6.  The software was developed under agreements between the UI and the
 *     Federal Government which entitle the Government to certain rights.
 *
 **************************************************************************
 *
 * Developed by: The TAPESTRY Parallel Computing Laboratory
 *		 University of Illinois at Urbana-Champaign
 *		 Department of Computer Science
 *		 1304 W. Springfield Avenue
 *		 Urbana, IL	61801
 *
 * Copyright (c) 1987, 1988, 1989, 1990, 1991, 1992
 * The University of Illinois Board of Trustees.
 *	All Rights Reserved.
 *
 * Author: Tara Madhyastha (tara@cs.uiuc.edu)
 * Project Manager and Principal Investigator:
 *	Daniel A. Reed (reed@cs.uiuc.edu)
 *
 * Funded by: National Science Foundation grants NSF CCR86-57696,
 * NSF CCR87-06653 and NSF CDA87-22836 (Tapestry), NASA ICLASS Contract
 * No. NAG-1-613, DARPA Contract No. DABT63-91-K-0004, and by a grant
 * from the Digital Equipment Corporation External Research Program.
 *
 */


#include "WclParams.h"

extern "C" {
//#include <Wc/WcCreate.h>
//#include <X11/StringDefs.h>
//void WcSetValueCB();
//void MriRegisterMotif(XtAppContext);
//char *XmTextGetString();
};

// probably don't need defaults
WclParams::WclParams(char *widgetName, ValList* Defaults, 
		     ValList* SystemParameters) : Defaults(Defaults), SystemParameters(SystemParameters)
{ 
  myWidgetName = duplicateString(widgetName);
}

WclParams::~WclParams()
{
delete myWidgetName;
delete LabelTable;
delete ParamTable;
}
  
// this is the big cheese
Bool_ WclParams::dumpWclResourceFile(ostream &os, 
				     MessageList& targetMessageList)
{
  int nargs;
  LabelTable = genName();
  ParamTable = genName();
  
  char *MainTable = genName();

// these two lines for prototyping
  os << "Mri.title:    FU Params!\n";
  os << "Mri.wcChildren:\t" << myWidgetName << NL;

  os << "*TransformFunctionMenu.wcResFile:     Sound/TransformFunctionMenu\n";

  dumpMessageList(os, targetMessageList);

  os << form("*%s.dismiss.wcConstructor:    XmCreatePushButton\n", MainTable);
  os << form("*%s.dismiss.labelString:      Dismiss\n", MainTable);
  os << form("*%s.dismiss.activateCallback:  DismissedCB\n", 
	     MainTable, myWidgetName);

  os << form("*%s.wcConstructor:      CreateTable\n", MainTable);
  os << form("*%s.wcChildren:\t%s, dismiss\n", MainTable, 
	     LabelTable);  

  os << form("*%s.layout:    %s 0 0; dismiss 0 1 2 1\n", MainTable, 
             LabelTable);
  

  
  os << form("*%s.wcConstructor:   XtCreateTransientShell\n", myWidgetName);
  os << form("*%s.wcChildren:      %s\n", myWidgetName, MainTable);
  os << form("*%s.title:       %s\n", myWidgetName, myWidgetName);

  os << form("*%sSW.wcConstructor:   XtCreateTopLevelShell\n", myWidgetName);
  os << form("*%sSW.wcChildren:      sw%s\n", myWidgetName, myWidgetName);
  os << form("*%sSW.title:       %s\n", myWidgetName, myWidgetName);

  os << form("*sw%s.wcConstructor:       XmCreateScrolledWindow\n", myWidgetName);
  os << form("*sw%s.scrollBarDisplayPolicy:   as_needed\n", myWidgetName);
  os << form("*sw%s.scrollingPolicy:       automatic\n", myWidgetName);
  os << form("*sw%s.wcChildren:         %s\n", myWidgetName, MainTable);



  delete MainTable;
  return(True_);
}

void WclParams::outputPtrList(ostream &os, PtrList &pl)
{
  int nargs = pl.numberArgs() - 1;

  for(int i=0; i < nargs; i++) {
    os << (char *)pl.getElement(i) << ", ";
  }
  if (nargs >= 0) {
    os << (char *)pl.getElement(i);
  } 
//  os << NL;
}

char *WclParams::doLabelWidget(ostream &os, char *text)
{
  char *labelname = genName();
  os << form("*%s.wcClassName:\tXmLabel\n", labelname);
  os << form("*%s.labelString:\t%s\n", labelname, text);
  return(labelname);
}

char *WclParams::doPushButtonWidget(ostream &os, char *label)
{
  char *pb = genName();
  os << form("*%s.wcClassName:\tXmPushButton\n", pb);
  os << form("*%s.labelString: %s\n", pb, label);
  os << form("*%s.height: 20\n", pb);
  return (pb);
}


// this returns the childname which represents the entire message structure
char* WclParams::doVariableVal(ostream &os, Val& v)
{
  char *bounds;
  Bool_ bounded = False_;
  int l, u;
  char *table = genName();
  char *label=doLabelWidget(os, form("Transform for \"%s\"", v.retname()));
  char *pushbutton = doPushButtonWidget(os, "Reconfigure");

  if (bounded = v.getbounds(l, u)) {
    if ((int)SystemParameters->getArg(l) < (int)SystemParameters->getArg(u)) {
      bounds=doLabelWidget(os, form("Min: %s -- Max: %s\n",
				    (SystemParameters->getArg(l)).printVal(),
				    (SystemParameters->getArg(u)).printVal()));
    } else {
      bounds=doLabelWidget(os, form("Enumeration: 0 - %d\n",
				    (int) SystemParameters->getArg(l)));
    }
  } else {
    bounds=doLabelWidget(os, "");
  }
    
  os << form("*%s.activateCallback:   PutLineResourceCB(*%s.callbackArgs: %d %d),\
configureTransformCB\n", pushbutton, myWidgetName, 
	     CurrentMessage, CurrentDefault);

//  os << form("*%s.wcConstructor:\tCreateTable\n", table);
//  os << form("*%s.wcConstructor:\tXmCreateRowColumn\n", table);
  

  os << form("*%s.wcConstructor:\tXmCreateForm\n", table);
  os << form("*%s.wcChildren:\t%s, %s, %s\n", 
	     table, label, bounds, pushbutton);

  os << form("*%s.fractionBase:\t3\n", table);

  os << form("*%s.topAttachment:\tattach_position\n", label);
  os << form("*%s.topPosition:\t0\n", label);
  os << form("*%s.leftAttachment:\tattach_position\n", label);
  os << form("*%s.leftPosition:\t0\n", label);
  os << form("*%s.rightAttachment:\tattach_position\n", label);
  os << form("*%s.rightPosition:\t3\n", label);
  os << form("*%s.bottomAttachment:\tattach_position\n", label);
  os << form("*%s.bottomPosition:\t1\n", label);


  os << form("*%s.topAttachment:\tattach_position\n", bounds);
  os << form("*%s.topPosition:\t1\n", bounds);
  os << form("*%s.leftAttachment:\tattach_position\n", bounds);
  os << form("*%s.leftPosition:\t0\n", bounds);
  os << form("*%s.rightAttachment:\tattach_position\n", bounds);
  os << form("*%s.rightPosition:\t3\n", bounds);
  os << form("*%s.bottomAttachment:\tattach_position\n", bounds);
  os << form("*%s.bottomPosition:\t2\n", bounds);

  os << form("*%s.topAttachment:\tattach_position\n", pushbutton);
  os << form("*%s.topPosition:\t2\n", pushbutton);
  os << form("*%s.leftAttachment:\tattach_position\n", pushbutton);
  os << form("*%s.leftPosition:\t0\n", pushbutton);
  os << form("*%s.rightAttachment:\tattach_position\n", pushbutton);
  os << form("*%s.rightPosition:\t3\n", pushbutton);
  os << form("*%s.bottomAttachment:\tattach_position\n", pushbutton);
  os << form("*%s.bottomPosition:\t3\n", pushbutton);


//    os << form("*%s.layout:     %s 0 0 lb; %s 0 1 lb; %s 0 2 lb\n", 
//	       table, bounds, pushbutton, label);

  delete bounds;
  delete label;
  delete pushbutton;

  return(table);
}

char* WclParams::dumpMessage(ostream &os, Message &msg)
{
  int j, index=0;
  PtrList msgChildren;
  Bool_ DisplayThisMessage = False_;

  char *messagename = genName();

  ValList &vl = msg.getValList();
  int nargs = vl.numberArgs();
  for(CurrentDefault=0; CurrentDefault < nargs; CurrentDefault++) {
    Val &v = vl.getArg(CurrentDefault);
    switch(v.kind()) {
    case FIXED:
      //do nothing
      break;
    case CONFIGURABLE:
      DisplayThisMessage = True_;
      msgChildren.addElement((char *)dumpVal(os, v));
      // do configurable param
      break;
    case VARIABLE:
      DisplayThisMessage = True_;
      msgChildren.addElement((char *)doVariableVal(os, v));
      // do variable, create popup for function params
      break;
    default:
      cerr << "Error: WclParams::dumpMessage: unrecognized type for val " << v << NL;
      break;
    }
  }

  if (DisplayThisMessage == True_) {
    os << form("*%s.wcConstructor:      CreateTable\n", messagename);
    os << form("*%s.wcChildren:\t", messagename);    
    outputPtrList(os, msgChildren); os << NL;
    // Layout
    os << form("*%s.layout:\t", messagename);
    for(int i=0; i < msgChildren.numberArgs(); i++) {
      os << form("%s %d 0 lb; ", (char *) msgChildren.getElement(i), i);
    }
    os << NL;

    return(messagename);
  } else {
    return NULL;
  }
}



void WclParams::dumpMessageList(ostream &os,
				MessageList& targetMessageList)
{
  int i, j, k, nmsgs, nargs;

  PtrList *paramChildNames = new PtrList;
  PtrList *labelChildNames = new PtrList;
  char *child;
  char *labelname;

  nmsgs = targetMessageList.numberArgs();
  for(CurrentMessage=0; CurrentMessage < nmsgs; CurrentMessage++) {
    Message &msg = targetMessageList.getArg(CurrentMessage);
    child = (char *) dumpMessage(os, msg);
    if (child != NULL) { // there is a label and param(s) for this message
      labelname = genName();
      os << form("*%s.wcClassName:\tXmLabel\n", labelname );
      os << form("*%s.labelString:\t%s\n", labelname, msg.getName());
      labelChildNames->addElement(labelname);
      paramChildNames->addElement(child);
    }
  }

  os << form("*%s.wcConstructor:     CreateTable\n", LabelTable);
  os << form("*%s.wcChildren:\t", LabelTable);
  outputPtrList(os, *labelChildNames); os << ", ";
  outputPtrList(os, *paramChildNames); os << NL;
  
  // layout for the whole thing
  os << form("*%s.layout:\t", LabelTable);
  // there had better be the same number of labels as parameter lists
  for(i=0; i < labelChildNames->numberArgs() - 1 ; i++) {
    os << form("%s 0 %d l; %s 1 %d l; ", 
	       (char *) labelChildNames->getElement(i), i,
	       (char *) paramChildNames->getElement(i), i);

  }
  os << form("%s 0 %d l; %s 1 %d l\n", 
	     (char *) labelChildNames->getElement(i), i, 
	     (char *) paramChildNames->getElement(i), i);

  for(i=0; i < labelChildNames->numberArgs(); i++) {
    delete labelChildNames->getElement(i);
    delete paramChildNames->getElement(i);
  }
  delete paramChildNames, labelChildNames;
}

// creates appropriate input for val, returns childname
char* WclParams::dumpVal(ostream &os, Val& v)
{
  char *childname;
  
  if (v.kind() == VARIABLE) {
    // handle variable Vals!!!
    return (NULL);
  } else {
    switch(v.type()) {
    case ENUMVAL:
    case REMOTEFILE:
      childname = doEnumList(os, v);
      break;
    case BOOLEAN:
      childname = doButton(os, v);
      break;
    case FLOAT:
    case DOUBLE:
    case ARRAY:
      childname = doText(os, v);
      break;
    case CHAR:
    case INTEGER:
     if (v.isbounded()) {
       childname = doSlider(os, v);
      } else {
	childname = doText(os, v);
      }
      break;
    default:
      break;
    }
  }
  return(childname);
}

char* WclParams::genName()
{
  return(duplicateString(form("%s%d", myWidgetName, LabelNumber++)));
}

// I gave up with option menus.
char* WclParams::doEnumList(ostream& os, Val& v)
{
  int i, l, u;
  char *name = genName();

  char *label = genName();
  char *list = genName();
  
  v.getbounds(l, u);

  Val& enumlist = SystemParameters->getArg(l);
  u = (int) enumlist;
    
  os << form("*%s.wcConstructor:\tXmCreateRowColumn\n", name);
  os << form("*%s.wcChildren:\t%s, %s\n", name, label, list);
  os << form("*%s.entryAlignment:\tALIGNMENT_CENTER\n", name);
    
  os << form("*%s.wcClassName:\tXmLabel\n", label);
  os << form("*%s.labelString:\t%s\n", label, v.retname());
  os << form("*%s.wcConstructor:\tXmCreateScrolledList\n", list);
  os << form("*%s.items:\t", list);
  
  os <<  form("%s", enumlist.EnumAsString(0));
  for (i=1; i < u; i++) {
    os <<  form(",\\\n%s", enumlist.EnumAsString(i));
  }
  os << form("\n*%s.itemCount:\t%d\n", list, u );
  os << form("*%s.visibleItemCount:\t%d\n", list, MAX_WINDOW_SIZE > u ? u : MAX_WINDOW_SIZE);
  os << form("*%s.selectionPolicy:\tSINGLE_SELECT\n", list);
  os << form("*%s.singleSelectionCallback:\t\
               PutLineResourceCB(*%s.callbackArgs:\t%d %d),\
               UpdateDefaultFromListCB\n", 
	       list, myWidgetName, CurrentMessage, CurrentDefault);
  os << form("*%s.selectedItemCount:\t1\n", list);
  os << form("*%s.selectedItems:\t%s\n", list, enumlist.EnumAsString((int) v));
  delete label;
  delete list;
  return(name);
}


char* WclParams::doEnumList(ostream& os, PtrList &enumlist, char *enumname, 
			    int selected)
{
  int i, l, u;
  char *name = genName();
  char *label = genName();
  char *list = genName();

  u = (int) enumlist.numberArgs();
    
  os << form("*%s.wcConstructor:\tXmCreateRowColumn\n", name);
  os << form("*%s.wcChildren:\t%s, %s\n", name, label, list);
  os << form("*%s.entryAlignment:\tALIGNMENT_CENTER\n", name);
  
  os << form("*%s.wcClassName:\tXmLabel\n", label);
  os << form("*%s.labelString:\t%s\n", label, enumname);
  os << form("*%s.wcConstructor:\tXmCreateScrolledList\n", list);
  os << form("*%s.items:\t", list);
  outputPtrList(os, enumlist);  os << NL;

  os << form("\n*%s.itemCount:\t%d\n", list, u );
  os << form("*%s.visibleItemCount:\t%d\n", list, MAX_WINDOW_SIZE > u ? u : MAX_WINDOW_SIZE);
  os << form("*%s.selectionPolicy:\tSINGLE_SELECT\n", list);
  os << form("*%s.singleSelectionCallback:\tPutLineResourceCB(*%s.callbackArgs:\t %d %d), UpdateDefaultFromListCB\n", list, \
	       myWidgetName, CurrentMessage, CurrentDefault);
  os << form("*%s.selectedItemCount:\t1\n", list);
  os << form("*%s.selectedItems:\t%s\n", list, (char *)enumlist.getElement(selected));
  
  delete label; delete list;
  return(name);
}


char* WclParams::doText(ostream& os, Val& v)
{
  char *name = genName();

//  os << form("*%s.wcClassName:\tXmRowColumn\n", name);
  os << form("*%s.wcConstructor:\tCreateTable\n", name);
  os << form("*%s.wcChildren:\tlabel, textinput\n", name);
  os << form("*%s.layout:\tlabel 0 0 lb ; textinput 0 1 lbH\n", name);
//  os << form("*%s.orientation:\tvertical\n", name);
  os << form("*%s.label.wcClassName:\tXmLabel\n", name);
  os << form("*%s.label.labelString:\t%s\n", name, v.retname());
  os << form("*%s.textinput.wcClassName:\tXmText\n", name);
  os << form("*%s.textinput.value:\t%s\n", name, v.printVal());
  os << form("*%s.textinput.losingFocusCallback:\t\
             PutLineResourceCB(*%s.callbackArgs:\t %d %d),\
             UpdateDefaultFromTextCB\n", 
	     name, myWidgetName, CurrentMessage, CurrentDefault );

  return name;
}


char* WclParams::doSlider(ostream& os, Val& v)
{
  int l, u;
  char *name = genName();

  v.getbounds(l, u);
  os << form("*%s.wcClassName:\tXmScale\n", name);
  os << form("*%s.showValue:\tTrue\n", name);
  os << form("*%s.maximum:\t%s\n",name,
	     (SystemParameters->getArg(u)).printVal());
  os << form("*%s.minimum:\t%s\n",name,
	     (SystemParameters->getArg(l)).printVal());
  os << form("*%s.value:\t%s\n", name, v.printVal());
  os << form("*%s.orientation:\thorizontal\n", name );
  os << form("*%s.titleString:\t%s\n", name, v.retname());
  os << form("*%s.valueChangedCallback:\tPutLineResourceCB(*%s.callbackArgs:\t%d %d), \
             UpdateDefaultFromSliderCB\n", 
	     name, myWidgetName, CurrentMessage, CurrentDefault);

  return name;

}

char* WclParams::doButton(ostream& os, Val& v)
{
  char *name = genName();

  os << form("*%s.wcClass:\tXmToggleButtonWidgetClass\n", name);
  os << form("*%s.labelString:\t%s\n", name, v.retname());
  os << form("*%s.valueChangedCallback:\tPutLineResourceCB(*%s.callbackArgs:\t %d %d), UpdateDefaultToggleCB\n", 
	     name,  myWidgetName, CurrentMessage, CurrentDefault);
  os << form("*%s.set:\t%s\n", name, ((int) v == 0) ? "False" : "True");

  return name;
}

void WclParams::printOn(ostream &os)
{
	os << "WclParams\n";
}


