/*
 * This file is part of the Pablo Performance Analysis Environment
 *
 *                                           TM
 * The Pablo Performance Analysis Environment   software is *not* in
 * the public domain.  However, it is freely available without fee for
 * education, research, and non-profit purposes.  By obtaining copies
 * of this and other files that comprise the Pablo Performance Analysis
 * Environment, you, the Licensee, agree to abide by the following
 * conditions and understandings with respect to the copyrighted software:
 * 
 * 1.  The software is copyrighted in the name of the Board of Trustees
 *     of the University of Illinois (UI), and ownership of the software
 *     remains with the UI. 
 *
 * 2.  Permission to use, copy, and modify this software and its documentation
 *     for education, research, and non-profit purposes is hereby granted
 *     to Licensee, provided that the copyright notice, the original author's
 *     names and unit identification, and this permission notice appear on
 *     all such copies, and that no charge be made for such copies.  Any
 *     entity desiring permission to incorporate this software into commercial
 *     products should contact:
 *
 *          Professor Daniel A. Reed                 reed@cs.uiuc.edu
 *          University of Illinois
 *          Department of Computer Science
 *          2413 Digital Computer Laboratory
 *          1304 West Springfield Avenue
 *          Urbana, Illinois  61801
 *          USA
 *
 * 3.  Licensee may not use the name, logo, or any other symbol of the UI
 *     nor the names of any of its employees nor any adaptation thereof in
 *     advertizing or publicity pertaining to the software without specific
 *     prior written approval of the UI.
 *
 * 4.  THE UI MAKES NO REPRESENTATIONS ABOUT THE SUITABILITY OF THE
 *     SOFTWARE FOR ANY PURPOSE.  IT IS PROVIDED "AS IS" WITHOUT EXPRESS
 *     OR IMPLIED WARRANTY.
 *
 * 5.  The UI shall not be liable for any damages suffered by Licensee from
 *     the use of this software.
 *
 * 6.  The software was developed under agreements between the UI and the
 *     Federal Government which entitle the Government to certain rights.
 *
 **************************************************************************
 *
 * Developed by: The TAPESTRY Parallel Computing Laboratory
 *		 University of Illinois at Urbana-Champaign
 *		 Department of Computer Science
 *		 1304 W. Springfield Avenue
 *		 Urbana, IL	61801
 *
 * Copyright (c) 1987, 1988, 1989, 1990, 1991, 1992
 * The University of Illinois Board of Trustees.
 *	All Rights Reserved.
 *
 * Author: Tara Madhyastha (tara@cs.uiuc.edu)
 * Project Manager and Principal Investigator:
 *	Daniel A. Reed (reed@cs.uiuc.edu)
 *
 * Funded by: National Science Foundation grants NSF CCR86-57696,
 * NSF CCR87-06653 and NSF CDA87-22836 (Tapestry), NASA ICLASS Contract
 * No. NAG-1-613, DARPA Contract No. DABT63-91-K-0004, and by a grant
 * from the Digital Equipment Corporation External Research Program.
 *
 */


#include "SoundDevice.h"

SoundDevice::SoundDevice(char *RemoteHost, char *PortName, Bool_ ack)
{
  openConnection(RemoteHost, PortName);
  synchronousMode = ack;

  if (synchronousMode == False_) {
    // do what you have to do
    ;
  }
}



SoundDevice::~SoundDevice()
{
  delete SDName;
  close(fd);
  close(ackfd);
}

void SoundDevice::executeMessage(char *stringMsg)
{
  char *tok;
  int msgnum, nargs, foobar;
  Val *v;
  tok = strtok(stringMsg, " \t");
  msgnum = atoi(tok);
  if (msgnum < 0 || msgnum >= Messages.numberArgs()) {
    cerr << form("Error: SoundDevice::SendMessage: message number %d out of range -- ignoring\n", tok);
    return;
  }
  Message myMsg;
  myMsg = Messages.getArg(msgnum);
  myMsg.setNumber(msgnum);
  
  IndexList& ilist = myMsg.getIndexList();
  nargs = ilist.numberArgs();
  for(int i=0; i < nargs; i++) {
    foobar = ilist.getArg(i);
    v = new Val;
//    *v = ilist.getArg(DefaultsTable, i);
    *v = DefaultsTable.getArg(foobar);
    if((tok = strtok(NULL, " \t")) == NULL) {
      cerr << form("Warning: SoundDevice::SendMessage: not enough parameters for message number = %d\n", msgnum);
    } else {
      v->SetValueFromString(tok);
    }
    myMsg.addArgToValList(*v);
  }
  executeMessage(myMsg);
}

void SoundDevice::executeMessage(MessageList &msglist)
{
  int numMsgs = msglist.numberArgs();
  char ack;

  // yes -- what we're doing now is : if this instance of SoundDevice is
  // set to run synchronously, get an "ack", or token, first. 

  if (synchronousMode) { 
    if (read(ackfd, &ack, 1) < 0) {
      cerr << form("SD: read acknowledgement: %s\n", sys_errlist[errno]);
    } else {
//      cout << "Read acknowledgement\n";
    }
  }
  // first, the number of messages
  send((char) numMsgs);

  // second, synchronous mode or not
  send((char) synchronousMode);

  // then all the messages
  for(int i=0; i < numMsgs; i++) {
    Message &m = msglist.getArg(i);
    send((char) m.getNumber());
    m.binSend(fd);
  }
}

void SoundDevice::executeMessage(Message &msg)
{
  char ack;

  if (synchronousMode) { 
    if (read(ackfd, &ack, 1) < 0) {
      cerr << form("SD: read acknowledgement: %s\n", sys_errlist[errno]);
    } else {
//      cout << "Read acknowledgement\n";
    }
  }
  // first, the number of messages
  send((char) 1); // one single message
  
  // second, are we in synch or not?
  ack = (char) synchronousMode;
  if (write(fd, &ack, 1) < 0) {
    cerr << form("SD: write: %s\n", sys_errlist[errno]);
  }

  // and last, the message itself.
  send((char)(msg.getNumber()));
  msg.binSend(fd);
}
   
  

Bool_ SoundDevice::openConnection(char *RemoteHost, char *PortName)
{
  char a;
  int i;
  char localHostName[128], *n;
  char remoteHostName[128];
  TCPSocket *localsock;
  if (Connected == True_) {
    cerr << form("Error: SoundDevice::openConnection(): already connected\n");
    return(False_);
  }

  if (gethostname(localHostName, 128) < 0) {
    cerr << form("Error: SoundDevice::openConnection(): gethostname: %s\n",
		 sys_errlist[errno]);
    return(False_);
  }

  struct hostent *hentry;
  char *h_name;

// localhost can be used in SCF's -- just substitute the real hostname as
// found by gethostname.

  if (strcmp(RemoteHost, "localhost") == 0) {
    strcpy(remoteHostName, localHostName);
  } else {
    if ((hentry = gethostbyname(RemoteHost)) == NULL) {
      cerr << form("Error: SoundDevice::openConnection(): gethostbyname(host = %s): %s\n", 
		   RemoteHost, sys_errlist[errno] );
      return(False_);
    }  else {
      strcpy(remoteHostName, hentry->h_name);
    }
  }

  SDName = new char[strlen(remoteHostName) + strlen(PortName) + 3];
  sprintf(SDName, "%sAT%s", PortName, remoteHostName);

  localsock = new TCPSocket;

  if (localsock->connectToService(localHostName, NAAD_PORT) < 0) {
    cerr << form("Error: SoundDevice::openConnection: Unable to connect to %s at %s\n",
		 localHostName, NAAD_PORT);
    cerr << "Check to make sure that the local sound server is running.\n";
    delete localsock;
    return(False_);
  }

//  cout << "Connected locally\n";
//  cout << "sock is " << *localsock << NL;

  
  localsock->send((char) INITIATE_CONNECTION);
  localsock->send(remoteHostName);
  localsock->send(PortName);
  n = localsock->recString();

//  cout << form("received name %s\n", n);
  if (strlen(n) == 0) {
    cerr << form("Error: SoundDevice(): Unable to open connection to %s at %s\n",
		 PortName, RemoteHost);
    delete localsock;
    return(False_);
  }
  localsock->receive(DefaultsTable);
  localsock->receive(SystemParameters);
  localsock->receive(Messages);

  if ((fd = open(n, O_RDWR)) < 0) {
    cerr << form("Error: SoundDevice(): open filename = %s: %s\n", n, sys_errlist[errno]);
    delete localsock;
    return(False_);
  } 

  if ((ackfd = open(form("%s.Ack", n), O_RDONLY)) < 0) {
    cerr << form("Error: SoundDevice(): open: %s\n", sys_errlist[errno]);
    delete localsock;
    return(False_);
  }

  delete localsock; delete n;
  return(Connected = True_);
}



void SoundDevice::printOn(ostream &os)
{
  os << form("SoundDevice is %sconnected\n", Connected ? "" : "un");
}



