/*
 * This file is part of the Pablo Performance Analysis Environment
 *
 *                                           TM
 * The Pablo Performance Analysis Environment   software is *not* in
 * the public domain.  However, it is freely available without fee for
 * education, research, and non-profit purposes.  By obtaining copies
 * of this and other files that comprise the Pablo Performance Analysis
 * Environment, you, the Licensee, agree to abide by the following
 * conditions and understandings with respect to the copyrighted software:
 * 
 * 1.  The software is copyrighted in the name of the Board of Trustees
 *     of the University of Illinois (UI), and ownership of the software
 *     remains with the UI. 
 *
 * 2.  Permission to use, copy, and modify this software and its documentation
 *     for education, research, and non-profit purposes is hereby granted
 *     to Licensee, provided that the copyright notice, the original author's
 *     names and unit identification, and this permission notice appear on
 *     all such copies, and that no charge be made for such copies.  Any
 *     entity desiring permission to incorporate this software into commercial
 *     products should contact:
 *
 *          Professor Daniel A. Reed                 reed@cs.uiuc.edu
 *          University of Illinois
 *          Department of Computer Science
 *          2413 Digital Computer Laboratory
 *          1304 West Springfield Avenue
 *          Urbana, Illinois  61801
 *          USA
 *
 * 3.  Licensee may not use the name, logo, or any other symbol of the UI
 *     nor the names of any of its employees nor any adaptation thereof in
 *     advertizing or publicity pertaining to the software without specific
 *     prior written approval of the UI.
 *
 * 4.  THE UI MAKES NO REPRESENTATIONS ABOUT THE SUITABILITY OF THE
 *     SOFTWARE FOR ANY PURPOSE.  IT IS PROVIDED "AS IS" WITHOUT EXPRESS
 *     OR IMPLIED WARRANTY.
 *
 * 5.  The UI shall not be liable for any damages suffered by Licensee from
 *     the use of this software.
 *
 * 6.  The software was developed under agreements between the UI and the
 *     Federal Government which entitle the Government to certain rights.
 *
 **************************************************************************
 *
 * Developed by: The TAPESTRY Parallel Computing Laboratory
 *		 University of Illinois at Urbana-Champaign
 *		 Department of Computer Science
 *		 1304 W. Springfield Avenue
 *		 Urbana, IL	61801
 *
 * Copyright (c) 1987, 1988, 1989, 1990, 1991, 1992
 * The University of Illinois Board of Trustees.
 *	All Rights Reserved.
 *
 * Author:Tara Madhyastha (tara@cs.uiuc.edu) 
 *
 * Project Manager and Principal Investigator:
 *	Daniel A. Reed (reed@cs.uiuc.edu)
 *
 * Funded by: National Science Foundation grants NSF CCR86-57696,
 * NSF CCR87-06653 and NSF CDA87-22836 (Tapestry), NASA ICLASS Contract
 * No. NAG-1-613, DARPA Contract No. DABT63-91-K-0004, and by a grant
 * from the Digital Equipment Corporation External Research Program.
 *
 */

#include "SonicWidgetCreator.h"



/* virtual */
Bool_ SonicWidgetCreator::looksValid(char *widgetControlFile)
{
  char *tmp = widgetControlFile;
  if (strcmp((tmp + (strlen(widgetControlFile) - 4)), ".wcf") != 0) {
    return(False_);
  } else {
    return(True_);
  }
}
  


/* virtual */
BaseSonicWidget *SonicWidgetCreator::createWidget(char *widgetControlFile, char *name)
{
  filebuf fb;
  char buf[MAXID];
  BaseSonicWidget *ret;
  
  if (looksValid(widgetControlFile) == False_ ){
    cerr << form("Error: %s::createWidget(): filename = %s,\
 doesn't end in .wcf\n", myClassName(), widgetControlFile);
    return(NULL);
  }
  
  if (fb.open(widgetControlFile, input) == 0) {
    cerr << form("Error: %s::createWidget(): filename = %s,\
 %s\n", myClassName(), widgetControlFile, sys_errlist[errno]);
    return(NULL);
  }
   
  istream is(&fb);
  if (getTok(is, buf) != FIXED) {
    cerr << form("Error: %s::createWidget(): expected sound widget classname\
 as first token in %s\n", myClassName(), widgetControlFile);
    return(NULL);
  }
  
  if (strcmp(buf, "SimpleSonicWidget") == 0) {
    ret = new SimpleSonicWidget(name);
    if (((SimpleSonicWidget *) ret)->initialize(is)) {
      return(ret); 
    } else {
      return(NULL);
    }
  }

  if (strcmp(buf, "BooleanSonicWidget") == 0) {
    ret = new BooleanSonicWidget(name);
    if  (((BooleanSonicWidget *) ret)->initialize(is)) {
      return(ret);
    } else {
      return(NULL);
    }
  }

  if (strcmp(buf, "MultiSonicWidget") == 0) {
    ret = new MultiSonicWidget(name);
    if (((MultiSonicWidget *) ret)->initialize(is)) {
      return(ret);
    } else {
      return(NULL);
    }
  }


  if (strcmp(buf, "LoopingSonicWidget") == 0) {
    ret = new LoopingSonicWidget(name);
    if (((LoopingSonicWidget *) ret)->initialize(is)) {
      return(ret);
    } else {
      return(NULL);
    }
  }

  if (strcmp(buf, "InitializingSonicWidget") == 0) {
    ret = new InitializingSonicWidget(name);
    if (((InitializingSonicWidget *) ret)->initialize(is)) {
      return(ret);
    } else {
      return(NULL);
    }
  }

  /* if we haven't returned by now, there is an unrecognized widget */

  cerr << form("Error: %s::createWidget(): unrecognized sound widget classname\
 %s\n", myClassName(), buf);
  return(NULL);
}



void SonicWidgetCreator::printOn(ostream &os)
{
	os << myClassName() << NL;
}

