/*
 * This file is part of the Pablo Performance Analysis Environment
 *
 *                                           TM
 * The Pablo Performance Analysis Environment   software is *not* in
 * the public domain.  However, it is freely available without fee for
 * education, research, and non-profit purposes.  By obtaining copies
 * of this and other files that comprise the Pablo Performance Analysis
 * Environment, you, the Licensee, agree to abide by the following
 * conditions and understandings with respect to the copyrighted software:
 * 
 * 1.  The software is copyrighted in the name of the Board of Trustees
 *     of the University of Illinois (UI), and ownership of the software
 *     remains with the UI. 
 *
 * 2.  Permission to use, copy, and modify this software and its documentation
 *     for education, research, and non-profit purposes is hereby granted
 *     to Licensee, provided that the copyright notice, the original author's
 *     names and unit identification, and this permission notice appear on
 *     all such copies, and that no charge be made for such copies.  Any
 *     entity desiring permission to incorporate this software into commercial
 *     products should contact:
 *
 *          Professor Daniel A. Reed                 reed@cs.uiuc.edu
 *          University of Illinois
 *          Department of Computer Science
 *          2413 Digital Computer Laboratory
 *          1304 West Springfield Avenue
 *          Urbana, Illinois  61801
 *          USA
 *
 * 3.  Licensee may not use the name, logo, or any other symbol of the UI
 *     nor the names of any of its employees nor any adaptation thereof in
 *     advertizing or publicity pertaining to the software without specific
 *     prior written approval of the UI.
 *
 * 4.  THE UI MAKES NO REPRESENTATIONS ABOUT THE SUITABILITY OF THE
 *     SOFTWARE FOR ANY PURPOSE.  IT IS PROVIDED "AS IS" WITHOUT EXPRESS
 *     OR IMPLIED WARRANTY.
 *
 * 5.  The UI shall not be liable for any damages suffered by Licensee from
 *     the use of this software.
 *
 * 6.  The software was developed under agreements between the UI and the
 *     Federal Government which entitle the Government to certain rights.
 *
 **************************************************************************
 *
 * Developed by: The TAPESTRY Parallel Computing Laboratory
 *		 University of Illinois at Urbana-Champaign
 *		 Department of Computer Science
 *		 1304 W. Springfield Avenue
 *		 Urbana, IL	61801
 *
 * Copyright (c) 1987, 1988, 1989, 1990, 1991, 1992
 * The University of Illinois Board of Trustees.
 *	All Rights Reserved.
 *
 * Author: Tara Madhyastha (tara@cs.uiuc.edu)
 * Project Manager and Principal Investigator:
 *	Daniel A. Reed (reed@cs.uiuc.edu)
 *
 * Funded by: National Science Foundation grants NSF CCR86-57696,
 * NSF CCR87-06653 and NSF CDA87-22836 (Tapestry), NASA ICLASS Contract
 * No. NAG-1-613, DARPA Contract No. DABT63-91-K-0004, and by a grant
 * from the Digital Equipment Corporation External Research Program.
 *
 */

#include "SWMultiParams.h"

static PtrList GlobalCBRecList;
static Boolean RegisteredCallbacks = 0;

typedef void (SWMultiParams::*SWParamsCallbackProc) (Widget, void *, void *);

struct SWParamsCBRec
{
  SWMultiParams *userData;
  SWParamsCallbackProc userProc;
};


SWMultiParams::SWMultiParams(Widget parent, const char *name, 
			     const char *AppName, 
			     BaseSonicWidget *SW) : 
			     SmallWCLWidget(parent, name, AppName), 
			     SW(SW)
{

  TF = new PassThrough;
  writeResourceFiles();

  create();

}

SWMultiParams::~SWMultiParams()
{
  int i,  n = ResFileList.numberArgs();

  for(i=0; i < n; i++) {
    PutLineResourceCB(parent, 
                      form("*%sSCF%d2.wcCallback:  \n", 
                           SW->getName(), i), (void *) NULL);
  }

  for(i=0; i < n; i++) {
    ::unlink((char *)ResFileList.getElement(i));
    delete (char *)ResFileList.getElement(i);
  }
  
  XtDestroyWidget(transformMenu);
  n = TFWidgetList.numberArgs();
  for(i=0; i < n; i++) {
    XtDestroyWidget((Widget)TFWidgetList.getElement(i));
  }

  n = WclWidgetList.numberArgs();
  for(i=0; i < n; i++) {
    XtDestroyWidget((Widget)WclWidgetList.getElement(i));
  }
}

void SWMultiParams::writeResourceFiles()
{
  Display *dpy = XtDisplay(parent);
  char *tf;

  for(int i=0; i < SW->numSCFs(); i++) {
    tf = SW->writeParamsResourceFile(P_tmpdir, i);
    XrmPutLineResource(&(dpy->db), form("*%sSCF%d.wcResFile: %s", 
					SW->getName(), i, tf));
    ResFileList.addElement((void *) tf);
  }
}
  
void SWMultiParams::registerCallbacks()
{
  WcRegisterCallback(app,
		     "PutLineResourceCB",
		     (XtCallbackProc) &PutLineResourceCB);

  registerMemberCallback("UpdateDefaultFromSliderCB",
      &SWMultiParams::updateDefaultFromSliderCallback, this);

  registerMemberCallback("UpdateDefaultFromTextCB",
      &SWMultiParams::updateDefaultFromTextCallback, this);

  registerMemberCallback("UpdateDefaultFromToggleCB",
      &SWMultiParams::updateDefaultFromToggleCallback, this);

  registerMemberCallback("UpdateDefaultFromListCB",
      &SWMultiParams::updateDefaultFromListCallback, this);

  registerMemberCallback("UpdateDefaultCB",
      &SWMultiParams::updateDefaultCallback, this);

  registerMemberCallback("SelectTransformFunctionCB",
      &SWMultiParams::selectTransformFunctionCallback, this);
	
  registerMemberCallback("UpdateTransformDefaultCB",
      &SWMultiParams::updateTransformDefaultCallback, this);

  registerMemberCallback("DoneRunningCB",
      &SWMultiParams::doneRunningCallback, this);

  registerMemberCallback("DismissedCB",
      &SWMultiParams::dismissedCallback, this);

  registerMemberCallback("CancelledCB",
      &SWMultiParams::cancelledCallback, this);

  registerMemberCallback("ConfigureTransformCB",
      &SWMultiParams::configureTransformCallback, this);

  registerMemberCallback("RevertTransformFunctionCB",
      &SWMultiParams::revertTransformFunctionCallback, this);
}

// the transform function menu is used in two ways: as a means to specify a 
// boolean condition or a multiplexing function ("standalone") or as a
// means to configure a variable parameter of an SCF. These panels
// written as resource files, consequently, although some callbacks should
// logically have different actions, they have the same names. That's
// why the standaloneMode flag exists, and why promptTranformFunctionMenu
// is here.


void SWMultiParams::promptTransformFunctionMenu() 
{
  XEvent event;

  if (SW->getTransformFunction() != NULL) {
    XtSetSensitive(transformMenu, 1);
    doneRunning = False_;

    oldTF = SW->getTransformFunction();
    updateRevertLabel(oldTF);

    centerWidget(parent, transformMenu);
    standaloneMode = True_;

    XtPopup(transformMenu, XtGrabNone);

    while(!doneRunning) {
      XtAppNextEvent(app, &event);
      XtDispatchEvent(&event);
    }
  }

}

void SWMultiParams::updateRevertLabel(DataTransform *transform)
{
  Arg arg[1];
  char name[128];
  Widget w, toggle;
  XmString xmstr;
  int id;

  ostream ost(128, name);
  ost << *transform << '\0';

// must give path relative to transformMenu here
  w = WcFullNameToWidget(transformMenu, ".bb*transformlabel");

  id = transform->idNumber();
  resetAllToggles();
  toggle = WcFullNameToWidget(transformMenu, form(".bb.tfmenu.func%d", id));
  if (id >= 0 ) {
    XmToggleButtonSetState(toggle, True, False);
  }
  XmTextSetString(w, name);
}

void SWMultiParams::resetAllToggles() 
{
  Widget toggle;
  int i, id;

  for(i=0; i < 5; i++) {
    toggle = WcFullNameToWidget(transformMenu, form(".bb.tfmenu.func%d",i));
    XmToggleButtonSetState(toggle, False, False);
  }
}

void SWMultiParams::centerWidget(Widget reference, Widget center)
{
  Arg arg[2];
  Position x, y;
  Dimension width, height;

  XtSetArg(arg[0], XtNwidth, &width); 
  XtSetArg(arg[1], XtNheight, &height); 
  XtGetValues(reference, arg, 2);


  XtTranslateCoords(reference, 
		    (Position) width/2, (Position) height/2, &x, &y);

  XtSetArg(arg[0], XtNx, x); 
  XtSetArg(arg[1], XtNy, y); 
  XtSetValues(center, arg, 2);

}

void SWMultiParams::fixupSize(Widget it, int i)
{
  Arg arg[3];
  Dimension width, height, sbwidth, sbheight;
  Widget sw, hsb,vsb, newwidget;

  Screen *screen = XtScreen(parent);
  Position screenheight = HeightOfScreen(screen);
  Position screenwidth = WidthOfScreen(screen);
  char name[128];
  XtSetArg(arg[0], XtNwidth, &width); 
  XtSetArg(arg[1], XtNheight, &height); 

  XtGetValues(it, arg, 2);


  XtDestroyWidget(it); // destroy the old one 
  // YES, this is a hack of the worst kind -- believe me, I tried every
  // other way first. It seemed impossible to get the correct size from the
  // row-column widget inside if it was realized within a scrolled window
  // to begin with.

  // create the scrolled window version
  PutLineResourceCB(parent, 
   form("*%sSCF%d2.wcCallback:   WcSetValueCB(*sw%sSCF%d.workWindow: this)\n", 
	SW->getName(), i, SW->getName(), i), (void *) NULL);
  newwidget =  WcCreateDatabasePopup(parent, 
			       form("%sSCF%dSW", SW->getName(), i));
  WclWidgetList.setElement(i, (void *) newwidget);
    
  if (!(sw = WcFullNameToWidget(newwidget, form("*sw%sSCF%d", SW->getName(), i)))) {
    cerr << "Warning: SWMultiParams::fixupSize: unable to get id of\
 scrolled window\n";
    return;
  }

  XtSetArg(arg[0], XmNverticalScrollBar, &hsb);
  XtGetValues(sw, arg, 1);
  XtSetArg(arg[0], XtNwidth, &sbwidth);
  XtGetValues(hsb, arg, 1);    


  height = (screenheight > height) ?  height + sbwidth : screenheight;
  width = (screenwidth > width) ? width + sbwidth: screenwidth;

  XtVaSetValues(sw,  
		XtNheight, height,
		XtNwidth, width,
		NULL);
}

void SWMultiParams::revertTransformFunctionCallback(Widget w, 
						    SWMultiParams *obj,
						    void *unused)
{
  usingOldTF = True_;
}
  


void SWMultiParams::configureTransformCallback(Widget w, SWMultiParams *obj, 
				void *unused)
{
  char arglist[128];

  centerWidget(w, transformMenu);

  XtSetSensitive((Widget)WclWidgetList.getElement(childID), 0);
  XtSetSensitive(transformMenu, 1);

  if (getCallbackArgs(arglist) == 0) {
    return;
  } else {
    sscanf(arglist, "%d %d", &currentMessage, &currentVal);
      
    oldTF = (SW->getSCF(childID))->getTransformFunction(currentMessage,
							  currentVal);
    updateRevertLabel(oldTF);

  }
  XtPopup(transformMenu, XtGrabNone);
}

void SWMultiParams::run() {

  XEvent event;

  promptTransformFunctionMenu();

  for(int i = 0; i < SW->numSCFs(); i++) {
    childID = i;
    dismissed = False_;
    centerWidget(parent, (Widget) WclWidgetList.getElement(i));
    XtPopup((Widget) WclWidgetList.getElement(i), XtGrabNone);
    while(!dismissed) {
      XtAppNextEvent(app, &event);
      XtDispatchEvent(&event);
    }
    XtPopdown((Widget) WclWidgetList.getElement(i));
  }
  SW->configure(); // called so that the SW can take any necessary
                   // actions to ensure correct operation
}

void SWMultiParams::create() {
// register some callbacks here
  int i;

  Widget it;
  if (!RegisteredCallbacks) {
    registerCallbacks();
    RegisteredCallbacks = True_;
  } else {
    for(i=0; i < GlobalCBRecList.numberArgs() ; i++) {
      ((SWParamsCBRec *) GlobalCBRecList.getElement(i))->userData = this;
    }
  }
  for(i = 0; i < SW->numSCFs(); i++) {
    it = WcCreateDatabasePopup(parent, form("%sSCF%d", SW->getName(), i));
    WclWidgetList.addElement((void *) it);
    // realizing it forces it to have a size.
    XtRealizeWidget(it);
    fixupSize(it, i);
  }
  transformMenu = WcCreateDatabasePopup(parent, "TransformFunctionMenu");
  TFWidgetList.addElement((void *) WcFullNameToWidget(transformMenu, ".PassThroughTransform"));
  TFWidgetList.addElement((void *) WcFullNameToWidget(transformMenu, ".LinearTransform"));
  TFWidgetList.addElement((void *) WcFullNameToWidget(transformMenu, ".DataRangeTransform"));
  TFWidgetList.addElement((void *) WcFullNameToWidget(transformMenu, ".StepTransform"));
  TFWidgetList.addElement((void *) WcFullNameToWidget(transformMenu, ".BooleanTransform"));
}
void SWMultiParams::doneRunningCallback(Widget w, SWMultiParams *obj,
				   void *unused)
{
  doneRunning = True_;
  if (standaloneMode == True_) {
    if (!usingOldTF) {
      SW->setTransformFunction(newTF);
    }
  } else {
    if (!usingOldTF) {
      (SW->getSCF(childID))->setTransformFunction(currentMessage,
						    currentVal, 
						    newTF);    
    }
    XtSetSensitive((Widget)WclWidgetList.getElement(childID), True_);
  }

  // screw WCL.
  XtPopdown(transformMenu);
  if (CurrentlyUp >= 0 && CurrentlyUp < (TFWidgetList.numberArgs())) {
    XtPopdown((Widget)TFWidgetList.getElement(CurrentlyUp));
    CurrentlyUp = -1;
  }

  usingOldTF = False_;
  standaloneMode = False_;
}

void SWMultiParams::dismissedCallback(Widget w, SWMultiParams *obj,
				   void *unused)
{
  dismissed= True_;
}

void SWMultiParams::cancelledCallback(Widget w, SWMultiParams *obj,
				      void *unused)
{
  if (CurrentlyUp >= 0 && CurrentlyUp < (TFWidgetList.numberArgs())) {
    XtPopdown((Widget)TFWidgetList.getElement(CurrentlyUp));
    CurrentlyUp = -1;
  }
  XtSetSensitive(transformMenu, 1);
  resetAllToggles();
}

Bool_ SWMultiParams::getCallbackArgs(char *arglist)
{
  Bool_ status;
  XrmValue value;
  char *type;


  Display *dpy = XtDisplay(parent);

  status = XrmGetResource(dpy->db, 
			  form("%s.%sSCF%d.callbackArgs", appName,
			       SW->getName(), childID),

			  form("%s.%sSCF%d.callbackArgs", appName,
			       SW->getName(), childID),
			  &type,
			  &value);
  if (status) {
    strcpy(arglist, value.addr);
  } else {
    cerr << form("Error: SWMultiParams::getCallbackArgs: Unable to get callback arguments for widget %s.%sSCF%d\n", appName, SW->getName(), childID);
  }
  return(status);
}


void SWMultiParams::selectTransformFunctionCallback(Widget w, 
				    SWMultiParams *obj,
				    XmToggleButtonCallbackStruct  *state)
{
  int func=0;
  if (!(state->set)) {
    return;
  }

  sscanf(XtName(w), "%*[^0-9]%d", &func);
  newTF = TFuncs.SelectFunction(func);
  if (func >= 0 && func < (TFWidgetList.numberArgs())) {
    centerWidget(w, TFWidgetList.getElement(func));
    XtSetSensitive(transformMenu, 0);
    XtPopup((Widget)TFWidgetList.getElement(func), XtGrabNone);
    CurrentlyUp = func;
  }
}

void SWMultiParams::updateTransformDefaultCallback(Widget w, 
						   SWMultiParams *obj, 
						   void *call_data)
{
  int mn, vn, v;
  
  XmString file;
  Arg arg[1];
  char *text;
  
  char *widgetclassname = (char *) (XtClass(w))->core_class.class_name;
  
  
  // use the widget name as the argument
  char *widgetname = XtName(w);
  
  if (strcmp("XmText",  widgetclassname) == 0) {
    newTF->setValue(widgetname, (char *) XmTextGetString(w));
    return;
  }
  
  if (strcmp("XmScale", widgetclassname) == 0) {
    v = ((XmScaleCallbackStruct *) call_data)->value;
    newTF->setValue(widgetname, (double) v);
    return;
  }
  
  if (strcmp("XmList", widgetclassname) == 0 ){
    v = ((XmListCallbackStruct *)call_data)->item_position - 1;      
    newTF->setValue(widgetname, (double) v);
    return;
  }
  
  
  if (strcmp("XmFileSelectionBox", widgetclassname) == 0) {
    XtSetArg(arg[0], XmNdirSpec, (XtArgVal) &file);
    XtGetValues(w, arg, 1);
    XmStringGetLtoR(file, XmSTRING_DEFAULT_CHARSET, &text);
    newTF->setValue(widgetname, text);
    return;
  }
  
  /* otherwise, */
  newTF->setValue(widgetname, "");
  
}

void SWMultiParams::updateDefaultFromSliderCallback(Widget w, SWMultiParams *obj,
					XtPointer call_data)
{
  int mn, vn;

  int v = ((XmScaleCallbackStruct *) call_data)->value;

  char arglist[128];

  if (getCallbackArgs(arglist) == 0) {
    return;
  } else {
    sscanf(arglist, "%d %d", &mn, &vn);
    (SW->getSCF(childID))->setDefault(mn, vn, (double) v);
  }
}

void SWMultiParams::updateDefaultFromListCallback(Widget w, SWMultiParams *obj,
                              XtPointer call_data)
{
  int value, mn, vn;
  char arglist[128];

  if (getCallbackArgs(arglist) == 0) {
    return;
  }
  sscanf(arglist, "%d %d", &mn, &vn);
  value = ((XmListCallbackStruct  *) call_data)->item_position - 1;

  (SW->getSCF(childID))->setDefault(mn, vn, (double) value);
}

void SWMultiParams::updateDefaultFromTextCallback(Widget w, SWMultiParams *obj,XtPointer unused)
{
  int mn, vn;
  char arglist[128];
  char *textstring = XmTextGetString(w);
  if (getCallbackArgs(arglist) == 0) {
    return;
  }
  sscanf(arglist, "%d %d", &mn, &vn);
  (SW->getSCF(childID))->setDefault(mn, vn, textstring);

}
void SWMultiParams::updateDefaultFromToggleCallback(Widget w, 
						    SWMultiParams *obj, 
						    XtPointer unused)
{
  char arglist[128];

  int mn, vn, value;

  if (getCallbackArgs(arglist) == 0) {
    return;
  }
  sscanf(arglist, "%d %d", &mn, &vn);
  value = !((int) (SW->getSCF(childID))->getDefault(mn, vn));
  (SW->getSCF(childID))->setDefault(mn, vn, (double) value);
}


void SWMultiParams::updateDefaultCallback(Widget w, SWMultiParams *obj, 
					  XtPointer unused)
{
  int mn, vn;
  char valuestring[128];

  char arglist[128];


  if (getCallbackArgs(arglist) == 0) {
    return;
  }
  sscanf(arglist, "%d %d %s", &mn, &vn, valuestring);
  (SW->getSCF(childID))->setDefault(mn, vn, valuestring);
}
  

void SWMultiParams::printOn(ostream &os)
{
	os << "SWMultiParams\n";
}

void SWMultiParams::registerMemberCallback(char *name, void * proc, 
				       SWMultiParams *data)
{
  SWParamsCBRec *rec = new SWParamsCBRec;

  GlobalCBRecList.addElement(rec);

  rec->userData = data;
  rec->userProc = (SWParamsCallbackProc) proc;

  WcRegisterCallback(app,
		     name,
		     (XtCallbackProc) &SWMultiParams::generalSWParamsCallback,
		     rec);
}

static void SWMultiParams::generalSWParamsCallback(Widget w, void *rec, 
						  void *callData)
{
  struct SWParamsCBRec *foo = (SWParamsCBRec *) rec;
  SWMultiParams *foobar = foo->userData;
  SWParamsCallbackProc proc = foo->userProc;
  (foobar->*proc) (w, foo->userData, callData);
}

static void SWMultiParams::PutLineResourceCB(Widget w, char *line, void *unused)
{

  Display *dpy = XtDisplay(w);
  XrmPutLineResource(&(dpy->db), line);
}
