/*
 * This file is part of the Pablo Performance Analysis Environment
 *
 *                                           TM
 * The Pablo Performance Analysis Environment   software is *not* in
 * the public domain.  However, it is freely available without fee for
 * education, research, and non-profit purposes.  By obtaining copies
 * of this and other files that comprise the Pablo Performance Analysis
 * Environment, you, the Licensee, agree to abide by the following
 * conditions and understandings with respect to the copyrighted software:
 * 
 * 1.  The software is copyrighted in the name of the Board of Trustees
 *     of the University of Illinois (UI), and ownership of the software
 *     remains with the UI. 
 *
 * 2.  Permission to use, copy, and modify this software and its documentation
 *     for education, research, and non-profit purposes is hereby granted
 *     to Licensee, provided that the copyright notice, the original author's
 *     names and unit identification, and this permission notice appear on
 *     all such copies, and that no charge be made for such copies.  Any
 *     entity desiring permission to incorporate this software into commercial
 *     products should contact:
 *
 *          Professor Daniel A. Reed                 reed@cs.uiuc.edu
 *          University of Illinois
 *          Department of Computer Science
 *          2413 Digital Computer Laboratory
 *          1304 West Springfield Avenue
 *          Urbana, Illinois  61801
 *          USA
 *
 * 3.  Licensee may not use the name, logo, or any other symbol of the UI
 *     nor the names of any of its employees nor any adaptation thereof in
 *     advertizing or publicity pertaining to the software without specific
 *     prior written approval of the UI.
 *
 * 4.  THE UI MAKES NO REPRESENTATIONS ABOUT THE SUITABILITY OF THE
 *     SOFTWARE FOR ANY PURPOSE.  IT IS PROVIDED "AS IS" WITHOUT EXPRESS
 *     OR IMPLIED WARRANTY.
 *
 * 5.  The UI shall not be liable for any damages suffered by Licensee from
 *     the use of this software.
 *
 * 6.  The software was developed under agreements between the UI and the
 *     Federal Government which entitle the Government to certain rights.
 *
 **************************************************************************
 *
 * Developed by: The TAPESTRY Parallel Computing Laboratory
 *		 University of Illinois at Urbana-Champaign
 *		 Department of Computer Science
 *		 1304 W. Springfield Avenue
 *		 Urbana, IL	61801
 *
 * Copyright (c) 1987-1994
 * The University of Illinois Board of Trustees.
 *	All Rights Reserved.
 *
 * Author: Daniel A. Reed (reed@cs.uiuc.edu)
 * Project Manager and Principal Investigator:
 *	Daniel A. Reed (reed@cs.uiuc.edu)
 *
 * Funded by: National Science Foundation grants NSF CCR86-57696,
 * NSF CCR87-06653 and NSF CDA87-22836 (Tapestry), NASA ICLASS Contract
 * No. NAG-1-613, DARPA Contract No. DABT63-91-K-0004, by a grant
 * from the Digital Equipment Corporation External Research Program,
 * and by a collaborative research agreement with the Intel Supercomputer
 * Systems Division.
 *
 */
/*
 *	$Header: /mnt/Pablo-guitar/Stable.2-94/Visual/Src/Widgets/polar/Demo/RCS/multipolar.c,v 1.7 1994/02/25 04:47:08 aydt Exp $
 */

#include <X11/Xatom.h>
#include <X11/Xlib.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>
#include <X11/Xaw/Cardinals.h>
#include <X11/Xaw/Form.h>

#include "Polar.h"

#define SetArg(r, v)	XtSetArg(arglist[argi], r, v); argi++;
#define MIN		1
#define MAX		50
#define MAXPOINTS	128
#define NUMKIVIATS	16

static void Select();
static XtCallbackRec selectcallback[] = {
  {Select,	(caddr_t) NULL	},
  {NULL,	(caddr_t) NULL	},
};

static XrmOptionDescRec options[] = {
  {"-circle",	"*polar.circleColor",		XrmoptionSepArg,	NULL},
  {"-pointcolor","*polar.pointColor",		XrmoptionSepArg,	NULL},
  {"-axis",	"*polar.axisColor",		XrmoptionSepArg,	NULL},
  {"-numaxes",	"*polar.numaxes",		XrmoptionSepArg,	NULL},
  {"-numcircles", "*polar.numCircles",		XrmoptionSepArg,	NULL},
  {"-marker","*polar.markerSize",        	XrmoptionSepArg, 	NULL},
};

Syntax(call)
	char *call;
{
  printf("Usage: %s\n", call);
  printf("\t-circle <color>\n");
  printf("\t-pointcolor <color>\n");
  printf("\t-axis <color>\n");
  printf("\t-numaxes <number>\n");
  printf("\t-numcircles <number>\n");
  printf("\t-marker <size>\n");
  exit(1);

} /* Syntax */

void main(argc, argv)
int argc;
char **argv;
{
  int		i, j, argi;
  int		xvalues[MAXPOINTS];
  int		yvalues[MAXPOINTS];
  Widget	w, toplevel, form, polar[NUMKIVIATS];
  Arg		arglist[10];
  XEvent	event;
  int		mag;

  toplevel = XtInitialize("main", "XPolar", options,
			  XtNumber(options), &argc, argv);
  form = XtCreateManagedWidget("form", formWidgetClass, toplevel,
			       NULL, 0);
  if (argc != 1) Syntax(argv[0]);

  mag = 1.4142136 * MAX;
  w = NULL;
  argi = 0;
  SetArg(XtNtitle, "Polar");
  SetArg(XtNmagnitude, mag);
  SetArg(XtNselect, selectcallback);

  for (i=0; i<NUMKIVIATS; i++) {
    argi = 5;
    if ((i%4) == 0) {
      SetArg(XtNfromVert, w);
      SetArg(XtNvertDistance, 10);
      SetArg(XtNfromHoriz, NULL);
      SetArg(XtNhorizDistance, 10);
      polar[i] = XtCreateManagedWidget("polar", polarWidgetClass, form,
					arglist, argi);
    }
    else {
      SetArg(XtNfromVert, w);
      SetArg(XtNvertDistance, 10);
      SetArg(XtNfromHoriz, polar[i-1]);
      SetArg(XtNhorizDistance, 10);
      polar[i] = XtCreateManagedWidget("polar", polarWidgetClass, form,
					arglist, argi);
      if (((i+1)%4) == 0)
	w = polar[i];
    }
  }

  XtRealizeWidget(toplevel);

  while(1) {
    while (XtPending()) {
      XtNextEvent(&event);
      XtDispatchEvent(&event);
    }

    sleep(1);

    for (i=0; i<NUMKIVIATS; i++) {
       for (j=0; j<MAXPOINTS; j++) {
         xvalues[j] = MIN + (MAX - MIN) * (getvalue() / 100.);

         if (getvalue() >= MAX)
            xvalues[j] = -xvalues[j];

         yvalues[j] = MIN + (MAX - MIN) * (getvalue() / 100.);

         if (getvalue() >= MAX)
            yvalues[j] = -yvalues[j];
       }

       PolarSetValues(polar[i], MAXPOINTS, xvalues, yvalues);
    }
  }

}

static void Select(w, client_data, call_data)
Widget	w;
caddr_t	client_data, call_data;
{
  int	value = (int) call_data;

  printf("Callback:  value = %d\n", value);

} /* Select */
