.TH "Matrix" "3-PerfW" "Jan. 1, 1990" "Version 1.0" "Performance Widgets"
.ad b
.ne 4
.SH NAME
Matrix \- A matrix widget.
.ne 4
.SH CLASS HIERARCHY
.br
Core
.ne 4
.SH NEW RESOURCES
.br
.TS
tab(:);
lB lB lB lB.
Name:Type:Default:Description
.T&
lB l l l.

XtNcolumns:int:10:number of columns
XtNgridColor:Pixel:"black":grid color
XtNmaxValue:int:100:maximum array value
XtNminValue:int:0:minimum array value
XtNrows:int:10:number of rows
XtNselect:XtCallbackList:NULL:callback for matrix selection
XtNshowGrid:Boolean:TRUE:show matrix grid
.TE
.ne 4
.SH TRANSLATIONS
.br
.TS
tab(:);
l l.
<Btn1Down>:select()
<Btn1Up>:notify()
.TE
.ne 4
.SH ACTIONS
.br
.TS
tab(:);
l l.
select:records row and column for selected cell
notify:invokes the matrix select callbacks
.TE
.ne 4
.SH PUBLIC FUNCTIONS
.br
.nf
.ta 3i
void \fBMatrixSetValues\fR(w, v)
MatrixWidget w;	/* matrix widget */
int *v;	/* two-dimensional array of values */
	/* minvalue <= v[][] <= maxvalue */
.fi
.sp
MatrixSetValues() copies the integers pointed to by 'v' into a values array
maintained within the Matrix instance.  
'v' is expected to point to rows*columns elements.  
If v contains entries that are less than minvalue, or greater
than maxvalue, a warning is printed and minvalue or 
maxvalue respectively, rather than *v, is stored in the Matrix values array. 
All cells in the matrix display are automatically updated.
.sp
.nf
void \fBMatrixSetValue\fR(w, r, c, v)
MatrixWidget w;	/* matrix widget */
int r;	/* row */
int c;	/* column */
int v;	/* minvalue <= v <= maxvalue */
.fi
.sp
MatrixSetValue() sets the value of the matrix element at row r and column c 
to v.
If r is greater than the current number of rows, or c is greater than the
current number of columns, a warning is displayed and MatrixSetValue()
returns without updating the widget's values array.
If v is less than minvalue, or greater than maxvalue, a warning is printer
and minvalue or maxvalue respectively, rather than v, is stored in the Matrix
values array.
The (r,c) cell in the matrix display is automatically updated.
.sp
.nf
void \fBMatrixSetColors\fR(w, n, c)
MatrixWidget w;	/* matrix widget */
int n;	/* number of colors */
Pixel *c;	/* array of colors */
.fi
.sp
MatrixSetColors() sets the number of fill colors
to n and the fill colors to the first n in c[].
A side-effect is that the number of pixmaps is set to 0 and any
pixmaps which may have been previously allocated are freed.
The matrix display is redrawn with the new colors.
.sp
.nf
void \fBMatrixSetPixmaps\fR(w, n, p)
MatrixWidget w;
int n;
Pixmap *p;
.fi
.sp
MatrixSetPixmaps() sets the number of fill pixmaps
to n and the fill pixmaps to the first n in p[].
A side-effect is that the number of colors is set to 0 and any
color pixels which may have been previously allocated are freed.
The matrix display is redrawn with the new pixmaps.
.sp
.nf
void \fBMatrixGetRowCol\fR(w, rowp, colp)
MatrixWidget w;
int *rowp, *colp;
.fi
.sp
MatrixGetRowCol() sets *rowp and *colp to the 
row (0 to rows-1) and column (0 to columns-1) values of
the last matrix element selected.
If the element is not within the boundaries of the matrix display, then
*rowp and/or *colp will be set to -1.
.ne 4
.SH DESCRIPTION
.br
The \fBMatrix\fR widget manages a rectangular matrix display
of the specified number of rows and columns; a maximum of 500 rows and
500 columns are possible.
The matrix display shows values from an array of values of the
same dimensions.
The user sets the minimum and maximum values the matrix will show.
Matrix values not in this range will be reset to minvalue or maxvalue, and
warning messages will be printed.
The array values are linearly mapped to a color (pixmap) table and the
corresponding matrix element is shown filled by with the mapped
color (pixmap).
A grid is drawn to separate the matrix elements, if enabled.
.PP
Matrix element selection is supported throught the XtNselect callback
resource.
Although the user-supplied callback routine is returned the
XButtonReleasedEvent as the call_data part,
usually the row and column values of the selected matrix element
will be desired.
The method MatrixGetRowCol() is provided for this purpose.
.ne 4
.SH FUTURE ENHANCEMENTS
.br
Additional callbacks may be provided in the future for region selection.
.ne 4
.SH AUTHOR
.br
.nf
Allen Malony, \fImalony@csrd.uicsrd.uiuc.edu\fR
Center for Supercomputing Research and Development,
University of Illinois
.SH CONTRIBUTING AUTHOR
.br
.nf
Ruth Aydt, \fIaydt@cs.uiuc.edu\fR
Department of Computer Science
University of Illinois at Urbana-Champaign
.fi
.ne 4
.SH COMMENTS
All comments and suggestions should be directed to the author.
