/*
 * This file is part of the Pablo Performance Analysis Environment
 *
 *                                           TM
 * The Pablo Performance Analysis Environment   software is *not* in
 * the public domain.  However, it is freely available without fee for
 * education, research, and non-profit purposes.  By obtaining copies
 * of this and other files that comprise the Pablo Performance Analysis
 * Environment, you, the Licensee, agree to abide by the following
 * conditions and understandings with respect to the copyrighted software:
 * 
 * 1.  The software is copyrighted in the name of the Board of Trustees
 *     of the University of Illinois (UI), and ownership of the software
 *     remains with the UI. 
 *
 * 2.  Permission to use, copy, and modify this software and its documentation
 *     for education, research, and non-profit purposes is hereby granted
 *     to Licensee, provided that the copyright notice, the original author's
 *     names and unit identification, and this permission notice appear on
 *     all such copies, and that no charge be made for such copies.  Any
 *     entity desiring permission to incorporate this software into commercial
 *     products should contact:
 *
 *          Professor Daniel A. Reed                 reed@cs.uiuc.edu
 *          University of Illinois
 *          Department of Computer Science
 *          2413 Digital Computer Laboratory
 *          1304 West Springfield Avenue
 *          Urbana, Illinois  61801
 *          USA
 *
 * 3.  Licensee may not use the name, logo, or any other symbol of the UI
 *     nor the names of any of its employees nor any adaptation thereof in
 *     advertizing or publicity pertaining to the software without specific
 *     prior written approval of the UI.
 *
 * 4.  THE UI MAKES NO REPRESENTATIONS ABOUT THE SUITABILITY OF THE
 *     SOFTWARE FOR ANY PURPOSE.  IT IS PROVIDED "AS IS" WITHOUT EXPRESS
 *     OR IMPLIED WARRANTY.
 *
 * 5.  The UI shall not be liable for any damages suffered by Licensee from
 *     the use of this software.
 *
 * 6.  The software was developed under agreements between the UI and the
 *     Federal Government which entitle the Government to certain rights.
 *
 **************************************************************************
 *
 * Developed by: The TAPESTRY Parallel Computing Laboratory
 *		 University of Illinois at Urbana-Champaign
 *		 Department of Computer Science
 *		 1304 W. Springfield Avenue
 *		 Urbana, IL	61801
 *
 * Copyright (c) 1987-1994
 * The University of Illinois Board of Trustees.
 *	All Rights Reserved.
 *
 * Author: Allen D. Malony (malony@uicsrd.csrd.uiuc.edu)
 * Project Manager and Principal Investigator:
 *	Daniel A. Reed (reed@cs.uiuc.edu)
 *
 * Funded by: National Science Foundation grants NSF CCR86-57696,
 * NSF CCR87-06653 and NSF CDA87-22836 (Tapestry), NASA ICLASS Contract
 * No. NAG-1-613, DARPA Contract No. DABT63-91-K-0004, by a grant
 * from the Digital Equipment Corporation External Research Program,
 * and by a collaborative research agreement with the Intel Supercomputer
 * Systems Division.
 *
 */
/*
 *	$Header: /mnt/Pablo-guitar/Stable.2-94/Visual/Src/Widgets/matrix/Demo/RCS/onematrixcolor.c,v 1.5 1994/02/25 04:46:57 aydt Exp $
 */

#include <X11/Xatom.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xos.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>
#include <X11/Xaw/Cardinals.h>
#include <X11/Xaw/Box.h>

#include "Matrix.h"

#define SetArg(r, v)	XtSetArg(arglist[argi], r, v); argi++;

#define MIN	50
#define MAX	500

#define COLORNUM	14
Pixmap	pixels[COLORNUM];

int	*values;

static void Select();
static XtCallbackRec selectcallback[] = {
  {Select,	(caddr_t) NULL	},
  {NULL,	(caddr_t) NULL	},
};

static XrmOptionDescRec options[] = {
  {"-rows",	"*matrix.rows",		XrmoptionSepArg,	NULL},
  {"-cols",	"*matrix.columns",	XrmoptionSepArg,	NULL},
  {"-grid",	"*matrix.gridColor",	XrmoptionSepArg, 	NULL},
  {"-showgrid",	"*matrix.showGrid",	XrmoptionNoArg,         "TRUE"},
};

Syntax(call)
char *call;
{
  printf("Usage: %s\n", call);
  printf("\t-rows <#rows (1-100)>\n");
  printf("\t-cols <#columns (1-100)>\n");
  printf("\t-grid <color>\n");
  printf("\t-showgrid\n");
  exit(1);

} /* Syntax */

void main(argc, argv)
int argc;
char **argv;
{
  int		i, j, rows, cols, argi;
  Widget	top, matrix;
  Arg		arglist[10];
  XEvent	event;

  top = XtInitialize("main", "XMatrix", options,
		     XtNumber(options), &argc, argv);
  if (argc != 1)
    Syntax(argv[0]);

  argi = 0;
  SetArg(XtNwidth, 500);
  SetArg(XtNheight, 500);
  SetArg(XtNminValue, MIN);
  SetArg(XtNmaxValue, MAX);
  SetArg(XtNselect, selectcallback);
  matrix = XtCreateManagedWidget("matrix", matrixWidgetClass,
				 top, arglist, argi);

  XtRealizeWidget(top);

  argi = 0;
  SetArg(XtNrows, 0);
  SetArg(XtNcolumns, 0);
  XtGetValues(matrix, arglist, argi);
  rows = (int) arglist[0].value;
  cols = (int) arglist[1].value;
  values = (int *) XtMalloc(rows*cols*sizeof(int));

  gencolor(XtDisplay(top), XtScreen(top), COLORNUM);
  MatrixSetColors(matrix, COLORNUM, pixels);
  for (i=0; i<rows; i++)
    for (j=0; j<cols; j++)
      values[i*cols+j] = MIN + (MAX-MIN)*(getvalue() / 100.);
    MatrixSetValues(matrix, values);

  while(1) {
    while (XtPending()) {
      XtNextEvent(&event);
      XtDispatchEvent(&event);
    }
    sleep(1);
    for (i=0; i<rows; i++)
      for (j=0; j<cols; j++)
	values[i*cols+j] = MIN + (MAX-MIN)*(getvalue() / 100.);
    MatrixSetValues(matrix, values);
  }

} /* main */

static void Select(w, client_data, call_data)
Widget	w;
caddr_t	client_data, call_data;
{
  int	row, col;

  MatrixGetRowCol(w, &row, &col);
  printf("Callback\n   Row:  %d\nColumn:  %d\n", row, col);

} /* Select */
