.TH "Led" "3-PerfW" "Jan. 1, 1990" "Version 1.0" "Performance Widgets"
.ad b
.ne 4
.SH NAME
Led \- A led widget.
.ne 4
.SH CLASS HIERARCHY
.br
Core
.ne 4
.SH NEW RESOURCES
.br
.TS
tab(:);
lB lB lB lB.
Name:Type:Default:Description
.T&
lB l l l.

XtNoutlineColor:Pixel:"black":outline color
XtNcolors:Pixel*:NULL:fill colors
XtNlevels:int:10:number of led levels
XtNmaxValue:int:100:maximum value
XtNminValue:int:0:minimum value
XtNnumColors:int:1:number of fill colors
XtNnumPixmaps:int:1:number of fill pixmaps
XtNorientation:XtOrientation:vertical:led orientation
XtNpixmaps:Pixmap*:NULL:fill pixmaps
XtNshowOutline:Boolean:TRUE:show led outline
XtNstickyHold:int:5:sticky level hold interval
XtNvalue:int:0:led value (minvalue - maxvalue)
XtNselect:XtCallbackList:NULL:callbacks for led selection
.TE
.sp
XtOrientation: vertical, horizontal
.ne 4
.SH TRANSLATIONS
.br
.TS
tab(:);
l l.
<Btn1Down>:select()
<Btn1Up>:notify()
.TE
.ne 4
.SH ACTIONS
.br
.TS
tab(:);
l l.
select:records samples current led value
notify:invokes the led select callbacks
.TE
.ne 4
.SH PUBLIC FUNCTIONS
.br
.nf
.ta 3i
void \fBLedSetValue\fR(w, v)
LedWidget w;	/* led widget */
int v;	/* minvalue <= v <= maxvalue */
.fi
.sp
LedSetValue() set the current value of the led to v.
The led display is automatically updated.
.sp
.nf
void \fBLedSetColors\fR(w, n, c)
LedWidget w;	/* led widget */
int n;	/* number of colors */
Pixel *c;	/* array of colors */
.fi
.sp
LedSetColor() sets the number of fill colors
to n and the fill colors to the first n in c[].
.sp
.nf
void \fBLedSetPixmap\fR(w, n, p)
LedWidget w;	/* led widget */
int n;	/* number of led pixmaps */
Pixmap *p;	/* array of pixmaps */
.fi
.sp
LedSetPixmap() sets the number of fill pixmaps
to n and the fill pixmaps to the first n in p[].
.ne 4
.SH DESCRIPTION
.br
The \fBLed\fR widget manages a rectangular led display
in a horizontal or vertical orientation.
The user sets the minimum and maximum values the led will show.
Led values must be in this range.
The current value of the led is mapped to the corresponding level in
the display and all level indicators up to and including this level
are fill in with a color or a pixmap.
The color (pixmap) used to fill in a led level indicator is chosen by
mapping values to the linear array of colors (pixmaps).
All levels not including the highest level will use the maximum value
corresponding to the levels to determine the color (pixmap).
The highest level will use the current led value.
.PP
The most recent highest value can be made to "stick" for a specified
period of updates given by the sticky hold resource.
The sticky value will be drawn in the sticky value color.
Notice that the sticky value and the current value (by definition, less
than or equal to the sticky value) might be mapped to the same level
indicator.
In this situation, the sticky color value takes precedence.
.PP
Clicking the left mouse button on an led invokes a callback function
with the current value of the led. 
.ne 4
.SH FUTURE ENHANCEMENTS
.br
Two additional callbacks may be supported in the future.
Clicking the middle mouse button will return the value in the led
range closest to the mouse position.
Clicking the right mouse button will set the led value to that
value closest to the mouse position and call any registered callbacks.
.ne 4
.SH AUTHOR
.br
.nf
Allen Malony, \fImalony@csrd.uicsrd.uiuc.edu\fR
Center for Supercomputing Research and Development,
University of Illinois
.fi
.ne 4
.SH COMMENTS
All comments and suggestions should be directed to the author.
