/*
 * This file is part of the Pablo Performance Analysis Environment
 *
 *                                           TM
 * The Pablo Performance Analysis Environment   software is *not* in
 * the public domain.  However, it is freely available without fee for
 * education, research, and non-profit purposes.  By obtaining copies
 * of this and other files that comprise the Pablo Performance Analysis
 * Environment, you, the Licensee, agree to abide by the following
 * conditions and understandings with respect to the copyrighted software:
 * 
 * 1.  The software is copyrighted in the name of the Board of Trustees
 *     of the University of Illinois (UI), and ownership of the software
 *     remains with the UI. 
 *
 * 2.  Permission to use, copy, and modify this software and its documentation
 *     for education, research, and non-profit purposes is hereby granted
 *     to Licensee, provided that the copyright notice, the original author's
 *     names and unit identification, and this permission notice appear on
 *     all such copies, and that no charge be made for such copies.  Any
 *     entity desiring permission to incorporate this software into commercial
 *     products should contact:
 *
 *          Professor Daniel A. Reed                 reed@cs.uiuc.edu
 *          University of Illinois
 *          Department of Computer Science
 *          2413 Digital Computer Laboratory
 *          1304 West Springfield Avenue
 *          Urbana, Illinois  61801
 *          USA
 *
 * 3.  Licensee may not use the name, logo, or any other symbol of the UI
 *     nor the names of any of its employees nor any adaptation thereof in
 *     advertizing or publicity pertaining to the software without specific
 *     prior written approval of the UI.
 *
 * 4.  THE UI MAKES NO REPRESENTATIONS ABOUT THE SUITABILITY OF THE
 *     SOFTWARE FOR ANY PURPOSE.  IT IS PROVIDED "AS IS" WITHOUT EXPRESS
 *     OR IMPLIED WARRANTY.
 *
 * 5.  The UI shall not be liable for any damages suffered by Licensee from
 *     the use of this software.
 *
 * 6.  The software was developed under agreements between the UI and the
 *     Federal Government which entitle the Government to certain rights.
 *
 **************************************************************************
 *
 * Developed by: The TAPESTRY Parallel Computing Laboratory
 *		 University of Illinois at Urbana-Champaign
 *		 Department of Computer Science
 *		 1304 W. Springfield Avenue
 *		 Urbana, IL	61801
 *
 * Copyright (c) 1987-1994
 * The University of Illinois Board of Trustees.
 *	All Rights Reserved.
 *
 * Author: Allen D. Malony (malony@uicsrd.csrd.uiuc.edu)
 * Project Manager and Principal Investigator:
 *	Daniel A. Reed (reed@cs.uiuc.edu)
 *
 * Funded by: National Science Foundation grants NSF CCR86-57696,
 * NSF CCR87-06653 and NSF CDA87-22836 (Tapestry), NASA ICLASS Contract
 * No. NAG-1-613, DARPA Contract No. DABT63-91-K-0004, by a grant
 * from the Digital Equipment Corporation External Research Program,
 * and by a collaborative research agreement with the Intel Supercomputer
 * Systems Division.
 *
 */
/*
 *	$Header: /mnt/Pablo-guitar/Stable.2-94/Visual/Src/Widgets/led/Demo/RCS/multiledpixmap.c,v 1.5 1994/02/25 04:46:47 aydt Exp $
 */

#include <X11/Xatom.h>
#include <X11/Xlib.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>
#include <X11/Xaw/Cardinals.h>
#include <X11/Xaw/Form.h>

#include "Led.h"

#define SetArg(r, v)	XtSetArg(arglist[argi], r, v); argi++;

#define MIN		50
#define MAX		500

#define BITMAPNUM	8
Pixmap	pixmaps[BITMAPNUM];
#define COLORNUM	8
Pixmap	pixels[COLORNUM];

static void Select();
static XtCallbackRec selectcallback[] = {
  {Select,	(caddr_t) NULL	},
  {NULL,	(caddr_t) NULL	},
};

static XrmOptionDescRec options[] = {
  {"-outline",	"*led.outlineColor",	XrmoptionSepArg,	NULL},
  {"-hold",	"*led.stickyHold",	XrmoptionSepArg,	NULL},
};

#define MAXLEDS		20
#define MAXLEVELS	20
#define LEDWIDTH	50
#define LEDHEIGHT	500
#define PADDING		2

Syntax(call)
char *call;
{
  printf("Usage: %s\n", call);
  printf("\t-outline <color>\n");
  printf("\t-hold <sticky hold>\n");
  printf("\t-leds <# leds>\n");
  printf("\t-levels <# levels>\n");
  exit(1);

} /* Syntax */

void main(argc, argv)
int	argc;
char	**argv;
{
  char		arg[50];
  int		i, value, argi, numleds = 20, numlevels = 20;
  Widget	top, form, led[MAXLEDS];
  Arg		arglist[15];
  Pixel		color;
  Pixmap	pixmap;
  XEvent	event;

  top = XtInitialize("main", "XLed", options,
			  XtNumber(options), &argc, argv);
  argi = 0;
  form = XtCreateManagedWidget("form", formWidgetClass, top,
			       arglist, argi);
  for (i=1; i<argc; i++) {
    sscanf(argv[i], "%s", arg);
    if (strcmp(arg, "-leds") == 0) {
      sscanf(argv[i+1], "%d", &numleds);
      i++;
    }
    else if (strcmp(arg, "-levels") == 0) {
      sscanf(argv[i+1], "%d", &numlevels);
      i++;
    }
    else
      Syntax(argv[0]);
  }

  argi = 0;
  SetArg(XtNwidth, LEDWIDTH);
  SetArg(XtNheight, LEDHEIGHT);
  SetArg(XtNorientation, XtorientVertical);
  SetArg(XtNborderWidth, 0);
  SetArg(XtNlevels, numlevels);
  SetArg(XtNminValue, MIN);
  SetArg(XtNmaxValue, MAX);
  SetArg(XtNselect, selectcallback);
  for (i=0; i<numleds; i++) {
    argi = 8;
    SetArg(XtNfromHoriz, NULL);
    if (i!=0)
      SetArg(XtNfromHoriz, led[i-1]);
    SetArg(XtNhorizDistance, 10);
    led[i] = XtCreateManagedWidget("led", ledWidgetClass,
				   form, arglist, argi);
  }

  XtRealizeWidget(top);

  genpix(XtDisplay(top), XtScreen(top));
  for (i=0; i<numleds; i++)
    LedSetPixmaps(led[i], BITMAPNUM, pixmaps);

  while(1) {
    while (XtPending()) {
      XtNextEvent(&event);
      XtDispatchEvent(&event);
    }
    sleep(1);
    for (i=0; i<numleds; i++) {
      value = MIN + (MAX-MIN)*(getvalue() / 100.);
      LedSetValue(led[i], value);
    }
  }

} /* main */

static void Select(w, client_data, call_data)
Widget	w;
caddr_t	client_data, call_data;
{
  int	value = (int) call_data;

  printf("Callback:  value = %d\n", value);

} /* Select */
