.TH "Graph" "3-PerfW" "Jan. 1, 1990" "Version 1.0" "Performance Widgets"
.ad b
.ne 4
.SH NAME
Graph \- A graphing widget.
.ne 4
.SH CLASS HIERARCHY
.br
Core
.ne 4
.SH NEW RESOURCES
.br
.TS
tab(:);
lB lB lB lB.
Name:Type:Default:Description
.T&
lB l l l.

XtNattachType:AttachType:AttachCenter:node attachment
XtNfillNodes:Boolean:TRUE:fill nodes?
XtNfont:XFontStruct*:"fixed":text font
XtNlinkColors:Pixel*:NULL:node link colors
XtNmaxLinkValue:int:100:maximum link value
XtNminLinkValue:int:0:minimum link value
XtNmaxNodeValue:int:100:maximum node value
XtNminNodeValue:int:0:minimum node value
XtNnodeBorderColor:Pixel:"black":node border color
XtNnodeColors:Pixel*:NULL:node fill colors
XtNnodePixmaps:Pixmap*:NULL:node fill pixmaps
XtNnodeShape:int:0:node shape (0-circle, 1-square)
XtNnumLinkColors:int:1:number of link colors
XtNnumNodeColors:int:1:number of fill colors
XtNnumNodePixmaps:int:1:number of fill pixmaps
XtNshowNodeName:Boolean:TRUE:show node names
XtNtextColor:Pixel:"black":text color
XtNselect:XtCallbackList:NULL:callbacks for graph node selection
.TE
.ne 4
.SH TRANSLATIONS
.br
.TS
tab(:);
l l.
<Btn1Down>:select()
<Btn1Up>:notify()
.TE
.ne 4
.SH ACTIONS
.br
.TS
tab(:);
l l.
select:records node selected
notify:invokes the graph select callbacks
.TE
.ne 4
.SH PUBLIC FUNCTIONS
.br
.nf
.ta 3i
void \fBGraphSetNodeValue\fR(w, id, v)
GraphWidget w;
NodeID id;
int v;	/* node value */
.fi
.sp
GraphSetNodeValue() sets the value of node id to v.
The graph display is automatically updated.
.sp
.nf
void \fBGraphSetLinkValue\fR(w, from, to, v)
GraphWidget w;
NodeID from, to;
int v;
.fi
.sp
GraphSetLinkValue() sets the value of the link
between node from and node to to v.
The graph display is automatically updated.
.sp
.nf
void \fBGraphSetNodeColors\fR(w, n, c)
GraphWidget w;
int n;
Pixel *c;
.fi
.sp
GraphSetNodeColors() sets the number of node fill colors
to n and the node fill colors to the first n in c[].
.sp
.nf
void \fBGraphSetNodePixmaps\fR(w, n, p)
GraphWidget w;
int n;
Pixmap *p;
.fi
.sp
GraphSetNodePixmaps() sets the number of node fill pixmaps
to n and the node fill pixmaps to the first n in p[].
.sp
.nf
void \fBGraphSetLinkColors\fR(w, n, p)
GraphWidget w;
int n;
Pixel *c;
.fi
.sp
GraphSetLinkColors() sets the number of link colors
to n and the link colors to the first n in c[].
.sp
.nf
void \fBGraphSetGraph\fR(w, igraph)
GraphWidget w;
I_GraphPtr igraph;
.fi
.sp
void \fBGraphSetGraph\fR() sets the graph to be that specified
by igraph; see Graph(5-PerfW).
.ne 4
.SH DESCRIPTION
.br
The \fBGraph\fR widget manages a display of a graph of nodes and links
as specified by the user.
An input graph can be supplied from which an internal graph structure
is created.
Each node can be assigned a value.
The user can then choose to fill nodes with colors or pixmaps that
are mapped to the node values.
The node values are linearly mapped to a color (pixmap) table.
Similarly, each link represented by a (from, to) node pair can be
assigned a value.
An array of link colors, separate from the node colors,
are used to draw the links based on their value.
.PP
Callbacks for node selection are supported.
If a mouse click occurs within the area defined by a node, the graph
callbacks are called with the node id as argument.
.ne 4
.SH FUTURE ENHANCEMENTS
.br
Link callbacks will be provided in the future.
.ne 4
.SH SEE ALSO
Graph (5-PerfW)
.ne 4
.SH AUTHOR
.br
.nf
Allen Malony, \fImalony@csrd.uicsrd.uiuc.edu\fR
Center for Supercomputing Research and Development,
University of Illinois
.fi
.ne 4
.SH COMMENTS
All comments and suggestions should be directed to the author.
