.TH "Contour" "3-PerfW" "April 15, 1989" "Version 1.0" "Performance Widgets"
.ad b
.ne 4
.SH NAME
Contour \- A contour widget
.ne 4
.SH CLASS HIERARCHY
.br
Core
.ne 4
.SH NEW RESOURCES
.br
.TS
tab(:);
lB lB lB lB.
Name:Type:Default:Description
.T&
lB l l l.
XtNcolumns:int:10:number of columns (min of 2)
XtNcontourCnt:int:10:number of contours
XtNfont:XFontStruct*:"fixed":text font
XtNgridColor:Pixel:"black":grid color
XtNrows:int:10:number of rows (min of 2)
XtNselect:XtCallbackList:NULL:callbacks for contour selection
XtNshowContours:Boolean:FALSE:show contour values
XtNshowGrid:Boolean:FALSE:show contour grid
XtNshowRange:Boolean:FALSE:show contour range
XtNtextColor:Pixel:"black":text color
.TE
.ne 4
.SH TRANSLATIONS
.br
.TS
tab(:);
l l.
<Btn1Down>:select()
<Btn1Up>:notify()
.TE
.ne 4
.SH ACTIONS
.br
.TS
tab(:);
l l.
select:records the current contour lines
notify:invokes the contour select callback
.TE
.ne 4
.SH PUBLIC FUNCTIONS
.br
.nf
void \fBContourSetValues\fP(w, v)
ContourWidget w;
float *v;   /* two-dimensional array of values */
.fi
.sp
ContourSetValues() copies the floats pointed to by 'v' into a values
array maintained within the Contour instance.
'v' is expected to point to a list with rows*columns float elements.
The contour display is automatically updated.
.sp
.nf
void \fBContourSetValue\fP(w, r, c, v)
ContourWidget w;
int   r;   /* row */
int   c;   /* column */
float v;   /* value */
.fi
.sp
ContourSetValue() sets the value of a the contour element at row r and
column c to v.
If r is greater than the current number or rows, or c is greater than
the current number of columns, a warning is displayed and ContourSetValue()
returns without updating the widget's value array.
The contour display is automatically updated.
.sp
.nf
void \fBContourSetColors\fR(w, n, c)
ContourWidget w; /* contour widget */
int n;  /* number of colors */
Pixel *c;       /* array of colors */
.fi
.sp
ContourSetColors() sets the number of contour line colors
to n and the colors to the first n in c[].
The contour display is redrawn with the new colors.
Note: If N, the number of color table entries, is less than C, the
number of contours specified,  the last C-N contour lines will be plotted
in color N.  If no colors are specified, the grid color will be used
to plot the contour lines.
.sp
.ne 4
.SH DESCRIPTION
.br
The \fBContour\fR widget manages a rectangular contour display
of the specified number of rows and columns. Rows are displayed
top to bottom on the display, and colums left to right.  That
is point (row=0, column=0) will be in the upper left of the display
window.
The contour display shows values from an array of values of the
same dimensions.
A grid may be displayed to delimit the (row,column) axes.
If 'showRange' is TRUE, the minimum and maximum values for the display
will be shown at the bottom of the contour plot area.
The contour lines will be labelled if 'showContour' is true.  Note that 
only the first contour line drawn for a given level will be labeled.
Note: when the window is small and/or many contours are drawn, labels often
overlap and are unreadable.
.PP
Clicking the left mouse button on the contour plot invokes a
callback function with the current values of the contour lines. 
.ne 4
.SH FUTURE ENHANCEMENTS
.br
An additional callback may be supported in the future.
Clicking the middle mouse button will return the value of the nearest
contour line.
.ne 4
.SH AUTHOR
.br
.nf
Daniel Reed, \fIreed@oboe.cs.uiuc.edu\fR
Department of Computer Science
University of Illinois
.SH CONTRIBUTING AUTHOR
.br
.nf
Ruth Aydt, \fIaydt@cs.uiuc.edu\fR
Department of Computer Science
University of Illinois at Urbana-Champaign
.fi
