/*
 * This file is part of the Pablo Performance Analysis Environment
 *
 *                                           TM
 * The Pablo Performance Analysis Environment   software is *not* in
 * the public domain.  However, it is freely available without fee for
 * education, research, and non-profit purposes.  By obtaining copies
 * of this and other files that comprise the Pablo Performance Analysis
 * Environment, you, the Licensee, agree to abide by the following
 * conditions and understandings with respect to the copyrighted software:
 * 
 * 1.  The software is copyrighted in the name of the Board of Trustees
 *     of the University of Illinois (UI), and ownership of the software
 *     remains with the UI. 
 *
 * 2.  Permission to use, copy, and modify this software and its documentation
 *     for education, research, and non-profit purposes is hereby granted
 *     to Licensee, provided that the copyright notice, the original author's
 *     names and unit identification, and this permission notice appear on
 *     all such copies, and that no charge be made for such copies.  Any
 *     entity desiring permission to incorporate this software into commercial
 *     products should contact:
 *
 *          Professor Daniel A. Reed                 reed@cs.uiuc.edu
 *          University of Illinois
 *          Department of Computer Science
 *          2413 Digital Computer Laboratory
 *          1304 West Springfield Avenue
 *          Urbana, Illinois  61801
 *          USA
 *
 * 3.  Licensee may not use the name, logo, or any other symbol of the UI
 *     nor the names of any of its employees nor any adaptation thereof in
 *     advertizing or publicity pertaining to the software without specific
 *     prior written approval of the UI.
 *
 * 4.  THE UI MAKES NO REPRESENTATIONS ABOUT THE SUITABILITY OF THE
 *     SOFTWARE FOR ANY PURPOSE.  IT IS PROVIDED "AS IS" WITHOUT EXPRESS
 *     OR IMPLIED WARRANTY.
 *
 * 5.  The UI shall not be liable for any damages suffered by Licensee from
 *     the use of this software.
 *
 * 6.  The software was developed under agreements between the UI and the
 *     Federal Government which entitle the Government to certain rights.
 *
 **************************************************************************
 *
 * Developed by: The TAPESTRY Parallel Computing Laboratory
 *		 University of Illinois at Urbana-Champaign
 *		 Department of Computer Science
 *		 1304 W. Springfield Avenue
 *		 Urbana, IL	61801
 *
 * Copyright (c) 1987-1994
 * The University of Illinois Board of Trustees.
 *	All Rights Reserved.
 *
 * Author: Daniel A. Reed (reed@cs.uiuc.edu)
 * Contributing Author:  Bradley W. Schwartz (schwartz@cs.uiuc.edu)
 *
 * Project Manager and Principal Investigator:
 *	Daniel A. Reed (reed@cs.uiuc.edu)
 *
 * Funded by: National Science Foundation grants NSF CCR86-57696,
 * NSF CCR87-06653 and NSF CDA87-22836 (Tapestry), NASA ICLASS Contract
 * No. NAG-1-613, DARPA Contract No. DABT63-91-K-0004, by a grant
 * from the Digital Equipment Corporation External Research Program,
 * and by a collaborative research agreement with the Intel Supercomputer
 * Systems Division.
 *
 */
/*
 * XYGraphWrapper.cc:  Class wrapper for the XYGraph performance widget  
 *
 *	$Header: /mnt/Pablo-guitar/Stable.2-94/Visual/Src/Widgets/Wrappers/RCS/XYGraphFormWrapper.C,v 1.10 1994/02/25 04:44:57 aydt Exp $
 */

#include "XYGraphFormWrapper.h"

extern "C" {
#include "XYGraph.h"
}

#include <Xm/Xm.h>
#include <Xm/Form.h>	// Form widget class name definition
#include <Xm/Label.h>   // For Matrix widget labelling

#include "XArgs.h"
#include "util.h"


XYGraphFormWrapper::XYGraphFormWrapper( WidgetBase *par,
                                 XYGraphFU *xygraphFUPtr,
				 const XArgs& args,
				 const CString& name ) : PerfWidget( par )
{
        Arg arglist[1];

        xygraphFUthisPtr = xygraphFUPtr;
    	_setType("XYGraphFormWrapper");

        // Create the Motif FORM
    	widget = XtCreateManagedWidget( name.getValue(),
				 xmFormWidgetClass, par->getWidget(),
				 args.getArgs(), args.getNArgs() );
        XtSetArg(arglist[0], XmNfractionBase, (XtArgVal)10000 );
        XtSetValues(widget, arglist, 1 );


        // Create a single XYGraph to be the initial child.  Also create our
	// Label widgets.
        xygraphChild = XtCreateManagedWidget( "xygraphChild", 
			         xygraphWidgetClass, widget,
			         NULL, 0 );
	setXYGraphLabel( L_LEFT_VERT, NULLCHARSTRING );
	setXYGraphLabel( L_BOTTOM_HORIZ, NULLCHARSTRING );

	addCallback(xygraphChild, XtNselect, &Callback::callback1, this, NULL);

}       


XYGraphFormWrapper::~XYGraphFormWrapper()
{
}


void 
XYGraphFormWrapper::callback1( Widget /* callbackWidget */, 
			       XtPointer /* ptr1 */, XtPointer /* ptr2 */ )
{
     int nearestXValue, nearestYValue;
     int index;

     XYGraphGetNearestPoint( (XYGraphWidget) xygraphChild, 
			     &nearestXValue, &nearestYValue, &index );
     if (index >= 0) {
        XYGraphDrawPointMarker( (XYGraphWidget) xygraphChild, index );
        xygraphFUthisPtr->fuCallback(nearestXValue, nearestYValue, index );
     }
}


// Generates the appropriate label for the current display instance
void 
XYGraphFormWrapper::setXYGraphLabel( int whichLabel, const char *stringLabel )
{
     Boolean_ layoutChange;
     if (whichLabel == L_LEFT_VERT) {
         layoutChange = 
         labels.setLabel( widget,"XYGraphLabelVert", whichLabel, stringLabel );
     } else if (whichLabel == L_BOTTOM_HORIZ) {
         layoutChange = 
         labels.setLabel( widget,"XYGraphLabelHoriz", whichLabel,stringLabel );
     }
     if (layoutChange) {
         int xygraphLayoutXOrg, xygraphLayoutYOrg,
             xygraphWidthProportion, xygraphHeightProportion;
         findXYGraphFormPosition(&xygraphLayoutXOrg, &xygraphLayoutYOrg,
			   &xygraphWidthProportion, &xygraphHeightProportion);
         setXYGraphFormPosition( xygraphLayoutXOrg, xygraphLayoutYOrg,
			     xygraphWidthProportion, xygraphHeightProportion);
     }
}



// Retrieves the text string for the given label
void 
XYGraphFormWrapper::getXYGraphLabel( int whichLabel, const char **aLabel ) const
{
     labels.getLabel(whichLabel, aLabel);
} 


// Retrieves an XYGraph (not XYGraphForm) attribute
void 
XYGraphFormWrapper::getXYGraphValue( String name, XtArgVal value )
{
     Arg arg[1];
 
     XtSetArg( arg[0], name, value );
     XtGetValues( xygraphChild, arg, 1 );
}

// SETS an XYGraph attribute for the Matrix within the Form 
void 
XYGraphFormWrapper::setXYGraphValue( String name, XtArgVal value )
{
   Arg arg[1];

   XtSetArg( arg[0], name, value );
   XtSetValues( xygraphChild, arg, 1 );
}


void 
XYGraphFormWrapper::getXYGraphFormValue( String name, XtArgVal value )
{
  Arg arglist[1];
  
  XtSetArg( arglist[0], name, value );
  XtGetValues( widget, arglist, 1 );
}


void 
XYGraphFormWrapper::setXYGraphFormValue( String name, XtArgVal value )
{
  Arg arglist[1];
  
  XtSetArg( arglist[0], name, value );
  XtSetValues( widget, arglist, 1 );
}


void 
XYGraphFormWrapper::findXYGraphFormPosition( int *xygraphLayoutXOrg, 
			int *xygraphLayoutYOrg, int *xygraphWidthProportion, 
			int *xygraphHeightProportion )
{
  int iFractionBase;
  getXYGraphFormValue( XmNfractionBase, (XtArgVal) &iFractionBase );
  *xygraphLayoutYOrg = 0;
 
  if (labels.isALabel(L_LEFT_VERT)) {
      *xygraphWidthProportion = (int)(iFractionBase -
                                  2*labels.getLabelHeight(L_LEFT_VERT));
      *xygraphLayoutXOrg = labels.getLabelHeight(L_LEFT_VERT);
  } else {
      *xygraphWidthProportion = iFractionBase;
      *xygraphLayoutXOrg = 0;
  }
  if (labels.isALabel(L_BOTTOM_HORIZ)) {
      *xygraphHeightProportion = (int)(iFractionBase -
                               labels.getLabelHeight(L_BOTTOM_HORIZ) );
  } else {
      *xygraphHeightProportion = iFractionBase;
  }
}



void 
XYGraphFormWrapper::setXYGraphFormPosition( int xygraphLayoutXOrg, 
			int xygraphLayoutYOrg,	int xygraphWidthProportion, 
			int xygraphHeightProportion )
{
     Arg arglist[4];
     int i = 0;

     XtSetArg( arglist[i], XmNleftPosition, (XtArgVal)xygraphLayoutXOrg); i++;
     XtSetArg( arglist[i], XmNrightPosition, 
                    (XtArgVal)(xygraphLayoutXOrg+xygraphWidthProportion)); i++;
     XtSetArg( arglist[i], XmNtopPosition, (XtArgVal)xygraphLayoutYOrg); i++;
     XtSetArg( arglist[i], XmNbottomPosition,
                   (XtArgVal)xygraphLayoutYOrg+xygraphHeightProportion); i++;
     XtSetValues( xygraphChild, arglist, i );
}


void 
XYGraphFormWrapper::setPerfWidgetValues( int *xValues, int *yValues,
					 int *pointCount, int lineCount )
{
     XYGraphSetValues( (XYGraphWidget) xygraphChild, xValues, yValues, 
			pointCount, lineCount );
}

void 
XYGraphFormWrapper::setPerfWidgetColors( )
{
     colorTable.gencolor( getDisplay(), getScreen() );
     XYGraphSetColors( (XYGraphWidget) xygraphChild, colorTable.getNumColors(),
                       colorTable.getColormapEntries() );
}
