/*
 * This file is part of the Pablo Performance Analysis Environment
 *
 *                                           TM
 * The Pablo Performance Analysis Environment   software is *not* in
 * the public domain.  However, it is freely available without fee for
 * education, research, and non-profit purposes.  By obtaining copies
 * of this and other files that comprise the Pablo Performance Analysis
 * Environment, you, the Licensee, agree to abide by the following
 * conditions and understandings with respect to the copyrighted software:
 * 
 * 1.  The software is copyrighted in the name of the Board of Trustees
 *     of the University of Illinois (UI), and ownership of the software
 *     remains with the UI. 
 *
 * 2.  Permission to use, copy, and modify this software and its documentation
 *     for education, research, and non-profit purposes is hereby granted
 *     to Licensee, provided that the copyright notice, the original author's
 *     names and unit identification, and this permission notice appear on
 *     all such copies, and that no charge be made for such copies.  Any
 *     entity desiring permission to incorporate this software into commercial
 *     products should contact:
 *
 *          Professor Daniel A. Reed                 reed@cs.uiuc.edu
 *          University of Illinois
 *          Department of Computer Science
 *          2413 Digital Computer Laboratory
 *          1304 West Springfield Avenue
 *          Urbana, Illinois  61801
 *          USA
 *
 * 3.  Licensee may not use the name, logo, or any other symbol of the UI
 *     nor the names of any of its employees nor any adaptation thereof in
 *     advertizing or publicity pertaining to the software without specific
 *     prior written approval of the UI.
 *
 * 4.  THE UI MAKES NO REPRESENTATIONS ABOUT THE SUITABILITY OF THE
 *     SOFTWARE FOR ANY PURPOSE.  IT IS PROVIDED "AS IS" WITHOUT EXPRESS
 *     OR IMPLIED WARRANTY.
 *
 * 5.  The UI shall not be liable for any damages suffered by Licensee from
 *     the use of this software.
 *
 * 6.  The software was developed under agreements between the UI and the
 *     Federal Government which entitle the Government to certain rights.
 *
 **************************************************************************
 *
 * Developed by: The TAPESTRY Parallel Computing Laboratory
 *		 University of Illinois at Urbana-Champaign
 *		 Department of Computer Science
 *		 1304 W. Springfield Avenue
 *		 Urbana, IL	61801
 *
 * Copyright (c) 1987-1994
 * The University of Illinois Board of Trustees.
 *	All Rights Reserved.
 *
 * Author: Bradley Schwartz (schwartz@cs.uiuc.edu)
 * Project Manager and Principal Investigator:
 *	Daniel A. Reed (reed@cs.uiuc.edu)
 *
 * Funded by: National Science Foundation grants NSF CCR86-57696,
 * NSF CCR87-06653 and NSF CDA87-22836 (Tapestry), NASA ICLASS Contract
 * No. NAG-1-613, DARPA Contract No. DABT63-91-K-0004, by a grant
 * from the Digital Equipment Corporation External Research Program,
 * and by a collaborative research agreement with the Intel Supercomputer
 * Systems Division.
 *
 */

#include "ScatterPlotMatrixFormWrapper.h"
#include "PabloMainInterface.h"
#ifdef __GNUG__
#include <builtin.h>
#endif

// For XYGraph
#define NormX(x) ( ( ((double) x) - 0 ) / (100) )
#define NormY(y) ( ( ((double) y) - 0 ) / (100) )
#define Round(x) ( x >= 0.0 ? (int)(x + .5) : (int)(x - .5) )
#define max(a,b) ( (a) > (b) ? (a):(b) )

#define BaseUnivarWidget    ( plotMatrixChildren->getElement(0) )
#define BaseXYGraphWidget   ( plotMatrixChildren->getElement(1) )
#define CurrentXYGraph(i,j) ( plotMatrixChildren->getElement(i*dim + j ) )
#define OurDisplay          ( XtDisplay(dataForm) )
#define OurScreen           ( XtScreen(dataForm) )
#define OurDataWindow       ( XtWindow(dataForm) )
#define OurDefaultDrawable  ( XtWindow(dataForm) )


ScatterPlotMatrixFormWrapper::ScatterPlotMatrixFormWrapper(
					Widget SPMparent,
				        ScatterPlotMatrixFU *SPmatrixFUPtr )
{
  	spmMainWindow = XtVaAppCreateShell( "ScatterPlotMatrix",
				            "SPM",
				            topLevelShellWidgetClass,
				            XtDisplay(SPMparent),
				            NULL );

	Widget spmMainContainer = XtVaCreateManagedWidget( "SPMContainer",
						           xmFormWidgetClass,
						           spmMainWindow,
						               NULL );

        dataForm = XtVaCreateManagedWidget( "SPMDataWidgetForm",
					    xmFormWidgetClass,
					    spmMainContainer,
					       NULL );
	xLabelForm = XtVaCreateManagedWidget( "SPMXLabelForm",
					      xmFormWidgetClass,
					      spmMainContainer,
					          NULL );
	yLabelForm = XtVaCreateManagedWidget( "SPMYLabelForm",
					      xmFormWidgetClass,
					      spmMainContainer,
					          NULL );
	statusForm = XtVaCreateManagedWidget( "SPMstatusForm",
					       xmFormWidgetClass,
					       spmMainContainer,
					           NULL );
	Widget interactionForm = XtVaCreateManagedWidget( "SPMInteractionForm",
						   xmFormWidgetClass,
						   spmMainContainer,
						      NULL );
	int statusFormHeight = _setupStatusArea( statusForm );
	_setupInteractionArea( interactionForm );
	
	XtVaSetValues( dataForm,
		       XmNtopWidget, statusForm,
		       XmNbottomWidget, xLabelForm,
		       XmNleftWidget, yLabelForm,
		       XmNrightWidget, interactionForm,
		          NULL );
	XtVaSetValues( xLabelForm,
		       XmNrightWidget, interactionForm,
		          NULL );
	XtVaSetValues( statusForm,
		       XmNrightWidget, interactionForm,
		          NULL );

	SPMFUthisPtr = SPmatrixFUPtr;
	plotMatrixChildren = new VoidPtrList( 1 );
	dim = 0;
	currentCallbackColor = 0;
	currentViewingPoint = NONEXISTENT_INDEX;
}


ScatterPlotMatrixFormWrapper::~ScatterPlotMatrixFormWrapper()
{
        delete plotMatrixChildren;
}




void ScatterPlotMatrixFormWrapper::_activatePointerTracking(
						   SPMEditMode *spmEditMode)
{
        int i,j;
	for (i=0; i<dim; i++) {
            for (j=0; j<dim; j++) { 
                if ( i != j ) { 
                   addEventHandler( (Widget)CurrentXYGraph(i,j),
				    PointerMotionMask, FALSE,
				    &EventHandler::eventHandler1, this,
				    (XtPointer)spmEditMode );
		}
	    }
	}
}
				    
				    
	      
Widget ScatterPlotMatrixFormWrapper::_addNewSPMWidget( int i, int j )
{
       	WidgetClass widgetClassUsed;
	char widgetName[STRING_MAX_LEN];

        if (i != j ) {
	   widgetClassUsed = _entryToClassName( spmWidgetEntry );
	   if ( spmWidgetEntry == XYGRAPH_ENTRY ) {
	      sprintf(widgetName, "SPMXYGraph%d:%d", i+1, j+1 );
           } else if ( spmWidgetEntry == MATRIX_ENTRY ) {
	      sprintf(widgetName, "SPMMatrix%d:%d", i+1, j+1 );
           }
	} else {
           widgetClassUsed = boxAndWhiskerWidgetClass;
	   sprintf(widgetName, "SPMboxAndWhisker%d", i+1 );
	}
        Widget newWidget = XtVaCreateManagedWidget( widgetName,
				        widgetClassUsed,
					dataForm,
					XmNtopAttachment, XmATTACH_POSITION,
					XmNtopPosition, i,
					XmNleftAttachment, XmATTACH_POSITION,
					XmNleftPosition, j,
					XmNrightAttachment, XmATTACH_POSITION,
					XmNrightPosition, j+1,
					XmNbottomAttachment, XmATTACH_POSITION,
					XmNbottomPosition, i+1,
					     NULL );
        addCallback( newWidget, XtNselect, &Callback::callback1, this );
        return(newWidget);
}

       


void ScatterPlotMatrixFormWrapper::_colorPointAcrossMatrix( int pointIndex )
{
	int i, j;	
	for (i=0; i<dim; i++) {
            for (j=0; j<dim; j++) {
                 if (i != j ) {
                    XYGraphSetPointColor( (XYGraphWidget)CurrentXYGraph(i,j),
					  pointIndex,
			                  currentCallbackColor );
		 }
	    }
	}
}


			     


Widget ScatterPlotMatrixFormWrapper::_create1DCallbackWindow( 
			             Callback1DTextWidgetSet& textWidgetSet )
{

	/* Get colors that will be used to match labels with B&W colors */
	Pixel quartileColor, rangeColor;
	XtVaGetValues( (Widget)BaseUnivarWidget,
		       XtNboxColor, &quartileColor,
		       XtNwhiskerColor, &rangeColor,
		          NULL );

	Widget callbackMainWindow = XtVaAppCreateShell(
					       "SPM1DcallbackMainWindow",
					       "SPMcallback",
					       applicationShellWidgetClass,
					       OurDisplay,
						   NULL );
	Widget callbackMainContainer = XtVaCreateManagedWidget( 
						  "SPM1DcallbackMainContainer",
						  xmFormWidgetClass,
						  callbackMainWindow,
						      NULL );
	Widget callbackDataContainer = XtVaCreateManagedWidget(
				    "SPM1DcallbackDataContainer",
				     xmFormWidgetClass,
				     callbackMainContainer,
					NULL );
	textWidgetSet.headerWidget = XtVaCreateManagedWidget( 
						  "SPM1DcallbackHeaderText",
						  xmLabelWidgetClass,
						  callbackDataContainer,
						      NULL );
        /* Set of labels */
	Widget callbackLabelContainer = XtVaCreateManagedWidget( 
				      "SPM1DcallbackLabelContainer",
				      xmFormWidgetClass,
				      callbackDataContainer,
				      XmNtopWidget, textWidgetSet.headerWidget,
				         NULL );
	Widget callbackMinimumLabel = XtVaCreateManagedWidget(
						"SPM1DcallbackMinimumLabel",
						xmLabelWidgetClass,
						callbackLabelContainer,
						    NULL );
	Widget callbackSmallestLabel =  XtVaCreateManagedWidget( 
					   "SPM1DcallbackSmallestLabel",
				           xmLabelWidgetClass,
				           callbackLabelContainer,
					   XmNtopWidget, callbackMinimumLabel,
					   XmNforeground, rangeColor,
						NULL );
	Widget callback25PercentileLabel =  XtVaCreateManagedWidget( 
					 "SPM1DcallbackPercentile25Label",
					  xmLabelWidgetClass,
				          callbackLabelContainer,
					  XmNtopWidget, callbackSmallestLabel,
					  XmNforeground, quartileColor,
					      NULL );
	Widget callback50PercentileLabel =  XtVaCreateManagedWidget( 
			      	  "SPM1DcallbackPercentile50Label",
				  xmLabelWidgetClass,
       			          callbackLabelContainer,
				  XmNtopWidget, callback25PercentileLabel,
				  XmNforeground, quartileColor,
		                      NULL );
        Widget callback75PercentileLabel =  XtVaCreateManagedWidget( 
				  "SPM1DcallbackPercentile75Label",
				  xmLabelWidgetClass,
				  callbackLabelContainer,
				  XmNtopWidget, callback50PercentileLabel,
				  XmNforeground, quartileColor,
				      NULL );
	Widget callbackLargestLabel =  XtVaCreateManagedWidget( 
				   "SPM1DcallbackLargestLabel",
			           xmLabelWidgetClass,
				   callbackLabelContainer,
				   XmNtopWidget, callback75PercentileLabel,
				   XmNforeground, rangeColor,
				       NULL );
	Widget callbackMaximumLabel = XtVaCreateManagedWidget(
					    "SPM1DcallbackMaximumLabel",
					    xmLabelWidgetClass,
					    callbackLabelContainer,
					    XmNtopWidget, callbackLargestLabel,
						NULL );
	/* Set of values */
	Widget callbackValueContainer = XtVaCreateManagedWidget( 
				       "SPM1DcallbackValueContainer",
				       xmFormWidgetClass,
				       callbackDataContainer,
				       XmNtopWidget,textWidgetSet.headerWidget,
				       XmNleftWidget, callbackLabelContainer,
					     NULL );
	textWidgetSet.minimumTextWidget = XtVaCreateManagedWidget(
						"SPM1DcallbackMinimumValue",
					        xmLabelWidgetClass,
					        callbackValueContainer,
						    NULL );
        textWidgetSet.smallestTextWidget =  XtVaCreateManagedWidget( 
			       "SPM1DcallbackSmallestValue",
			       xmLabelWidgetClass,
			       callbackValueContainer,
			       XmNtopWidget, textWidgetSet.minimumTextWidget,
			       XmNforeground, rangeColor,
                                    NULL );
	textWidgetSet.Q1valueTextWidget =  XtVaCreateManagedWidget( 
				"SPM1DcallbackPercentile25Value",
				xmLabelWidgetClass,
				callbackValueContainer,
			        XmNtopWidget, textWidgetSet.smallestTextWidget,
				XmNforeground, quartileColor,
				   NULL );
	textWidgetSet.medianTextWidget =  XtVaCreateManagedWidget( 
			      	"SPM1DcallbackPercentile50Value",
			        xmLabelWidgetClass,
       			        callbackValueContainer,
			        XmNtopWidget, textWidgetSet.Q1valueTextWidget,
		                XmNforeground, quartileColor,
				   NULL );
        textWidgetSet.Q3valueTextWidget =  XtVaCreateManagedWidget( 
				"SPM1DcallbackPercentile75Value",
			        xmLabelWidgetClass,
			        callbackValueContainer,
			        XmNtopWidget, textWidgetSet.medianTextWidget,
				XmNforeground, quartileColor,
				    NULL );
	textWidgetSet.largestTextWidget =  XtVaCreateManagedWidget( 
				"SPM1DcallbackLargestValue",
			        xmLabelWidgetClass,
				callbackValueContainer,
				XmNtopWidget, textWidgetSet.Q3valueTextWidget,
				XmNforeground, rangeColor,
				   NULL );
	textWidgetSet.maximumTextWidget = XtVaCreateManagedWidget(
			       "SPM1DcallbackMaximumValue",
			       xmLabelWidgetClass,
			       callbackValueContainer,
			       XmNtopWidget, textWidgetSet.largestTextWidget,
				   NULL );

	Widget callbackButtonContainer = XtVaCreateManagedWidget( 
				         "SPM1DcallbackButtonContainer",
				         xmFormWidgetClass,
				         callbackMainContainer,
					 XmNtopWidget, callbackDataContainer,
					       NULL );
	Widget dismissButton = XtVaCreateManagedWidget(
						 "SPMcallbackDismissButton",
						 xmPushButtonWidgetClass,
						 callbackButtonContainer,
						    NULL );
	addCallback( dismissButton, XmNactivateCallback, &Callback::callback3,
		        this );
	Dimension buttonHeight;
	XtVaGetValues( dismissButton,
		       XmNheight, &buttonHeight,
		           NULL );
	XtVaSetValues( callbackDataContainer,
		       XmNbottomWidget, callbackDataContainer,
		       XmNbottomOffset, (int)buttonHeight,
		          NULL );

	return(callbackMainWindow);
}	


Widget ScatterPlotMatrixFormWrapper::_create2DCallbackWindow()
{
        Widget callbackMainWindow = XtVaAppCreateShell(
						   "SPM2DcallbackMainWindow",
					           "SPMcallback",
						   applicationShellWidgetClass,
						   OurDisplay,
						      NULL );

	Widget callbackMainContainer = XtVaCreateManagedWidget( 
						  "SPM2DcallbackMainContainer",
						  xmFormWidgetClass,
						  callbackMainWindow,
						     NULL );
	Widget displayOptionLabel = XtVaCreateManagedWidget(
					  "SPMcallbackDisplayOptionLabel",
					  xmLabelWidgetClass,
					  callbackMainContainer,
					      NULL );
	Widget displayOptionContainer = XtVaCreateManagedWidget(
					  "SPMcallbackDisplayOptionContainer",
					  xmFormWidgetClass,
					  callbackMainContainer,
					  XmNtopWidget, displayOptionLabel,
					      NULL );
	Widget pointDisplayOptionRadioBox =  XmCreateRadioBox( 
						displayOptionContainer,
				                "SPManalysisOptionRadioBox",
					           NULL, 0 );
	_createPointDisplaySetup( pointDisplayOptionRadioBox );
	XtManageChild( pointDisplayOptionRadioBox );

	Widget separator1 =  XtVaCreateManagedWidget(
					  "SPMcallbackSeparator1",
					  xmSeparatorWidgetClass,
					  callbackMainContainer,
					  XmNtopWidget, displayOptionContainer,
					      NULL );
	Widget editOptionLabel = XtVaCreateManagedWidget(
					  "SPMcallbackEditOptionLabel",
					  xmLabelWidgetClass,
					  callbackMainContainer,
					  XmNtopWidget, separator1,
					      NULL );
        Widget editOptionContainer = XtVaCreateManagedWidget(
					  "SPMcallbackEditOptionContainer",
					  xmFormWidgetClass,
	                                  callbackMainContainer,
					  XmNtopWidget, editOptionLabel,
					      NULL );
	Widget modeOptionContainer = XtVaCreateManagedWidget(
				          "SPMcallbackModeOptionContainer",
				          xmFormWidgetClass,
					  editOptionContainer,
					      NULL );
        _createModeSetup( modeOptionContainer );
	
	Widget functionConfigContainer = XtVaCreateManagedWidget(
				          "SPMcallbackFunctionConfigContainer",
				          xmFormWidgetClass,
					  editOptionContainer,
					  XmNleftWidget, modeOptionContainer,
					      NULL );
	_createFunctionSetup( functionConfigContainer );
	
	Widget colorChoiceContainer =  XtVaCreateManagedWidget(
				         "SPMcolorChoiceContainer",
				         xmFormWidgetClass,
					 editOptionContainer,
					 XmNleftWidget,functionConfigContainer,
					     NULL );
	_createColorChooser( colorChoiceContainer );

	Widget buttonContainer = XtVaCreateManagedWidget(
				          "SPM2DcallbackButtonContainer",
				          xmFormWidgetClass,
					  callbackMainContainer,
					  XmNtopWidget, editOptionContainer,
					      NULL );
	Widget dismissButton = XtVaCreateManagedWidget(
						 "SPMcallbackDismissButton",
						 xmPushButtonWidgetClass,
						 buttonContainer,
						    NULL );
	addCallback( dismissButton, XmNactivateCallback, &Callback::callback3,
		        this );

	// Set initial default settings
	XmToggleButtonSetState( XtNameToWidget( modeOptionContainer,
		                   "SPMmodeOptionRadioBox.SPMmodeViewButton"),
			        True, True );
	XmToggleButtonSetState( XtNameToWidget( functionRadioBox,
					        "SPMfunctionByPointToggle"),
			        True, True );
	XmToggleButtonSetState( XtNameToWidget( colorChoiceRadioBox,
					        "colorChoice0" ),
			        True, True );
	return( callbackMainWindow );
}


Widget ScatterPlotMatrixFormWrapper::_createClusterSheet()
{
        static SPMInteractionOptions data;
	data.specificData = &clusteringOptions;
	data.tag = SPM_TAG_CLUSTERING;

        data.mainWindow = XtVaAppCreateShell(  "SPMClusterSheetMainWindow",
					       "SPMClusterSheet",
					       applicationShellWidgetClass,
					       OurDisplay,
						   NULL );
	Widget sheetMainContainer = XtVaCreateManagedWidget(
					     "ClusterSheetMainContainer",
					      xmFormWidgetClass,
					      data.mainWindow,
						 NULL );
	Widget sheetActionArea = XtVaCreateManagedWidget( 
					     "ClusterSheetActionArea",
					      xmFormWidgetClass,
					      sheetMainContainer,
					         NULL );
	Widget sheetTextField1Area = addTextFieldToDialog( sheetActionArea,
						           (Widget)NULL,
				 	        "ClusterSheetTextField1",
		           &(clusteringOptions.clusteringIntervalWidget) );
	Widget sheetRadioBox1Area = addRadioToggleListToDialog(
					      sheetActionArea,
					      sheetTextField1Area,
					      "ClusterSheetState",
					      2, 0,
			            &(clusteringOptions.clusteringRadioBox1) );
/*
	Widget sheetActivateButton = XtVaCreateManagedWidget(
	  				     "ClusterSheetActivateButton",
					     xmPushButtonWidgetClass,
					     sheetActionArea,
	   				     XmNtopWidget, sheetTextField1Area,
					         NULL );
	addCallback( sheetActivateButton, XmNactivateCallback,
		     &Callback::callback8, this, &data );
*/
	Widget sheetControlArea = XtVaCreateManagedWidget(
					     "ClusterSheetControlArea",
					     xmFormWidgetClass,
					     sheetMainContainer,
					     XmNtopWidget, sheetActionArea,
	                                   	 NULL );
	Widget okButton = XtVaCreateManagedWidget( 
					     "DialogOKButton",
					     xmPushButtonWidgetClass,
					     sheetControlArea,
					        NULL );
	addCallback( okButton, XmNactivateCallback,
		     &Callback::callback9, this, &data );
	return( data.mainWindow );
}


void ScatterPlotMatrixFormWrapper::_createColorChooser( Widget parentWidget )
{
        Widget colorChoiceLabel =XtVaCreateManagedWidget("SPMcolorChoiceLabel",
							 xmLabelWidgetClass,
							 parentWidget,
							    NULL );
	Arg arglist[1];
	XtSetArg( arglist[0], XmNtopWidget, colorChoiceLabel );
	colorChoiceRadioBox = XmCreateRadioBox( parentWidget,
				                "SPMcolorChoiceRadioBox",
					        arglist, 1 );
        XtManageChild(colorChoiceRadioBox);

	int i;
	Widget currentRadioChild;
	char currentWidgetName[24];
	XmString nullLabelString = XmStringCreateSimple("\0");

	for (i=0; i<brushColorTable.getNumColors(); i++) {
	    sprintf( currentWidgetName, "colorChoice%d", i );
            currentRadioChild =  XtVaCreateManagedWidget( 
					  currentWidgetName,
				          xmToggleButtonWidgetClass,
					  colorChoiceRadioBox,
		      XmNbackground, brushColorTable.getColormapEntry(i),
		      XmNlabelString, nullLabelString,			
					      NULL );
	    addCallback( currentRadioChild, XmNvalueChangedCallback,
			 &Callback::callback5, this );
       }
       XmStringFree( nullLabelString );
}

        		      
void ScatterPlotMatrixFormWrapper::_createFunctionSetup( Widget parentWidget )
{
        Widget functionOptionLabel = XtVaCreateManagedWidget(
					      "SPMfunctionOptionLabel",
					      xmLabelWidgetClass,
					      parentWidget,
						  NULL );

	Arg arglist[1];
	XtSetArg( arglist[0], XmNtopWidget, functionOptionLabel );
        functionRadioBox = XmCreateRadioBox( parentWidget,
					      "SPMfunctionRadioBox",
					      arglist, 1 );
	XtManageChild(functionRadioBox);
	
	Widget byPointToggle = XtVaCreateManagedWidget(
					      "SPMfunctionByPointToggle",
					      xmToggleButtonWidgetClass,
					      functionRadioBox,
						 NULL );
	Widget byRegionToggle = XtVaCreateManagedWidget(
				              "SPMfunctionByRegionToggle",
					      xmToggleButtonWidgetClass,
					      functionRadioBox,
				                 NULL );
	Widget byColorToggle = XtVaCreateManagedWidget(
				              "SPMfunctionByColorToggle",
					      xmToggleButtonWidgetClass,
					      functionRadioBox,
				                 NULL );
}



void ScatterPlotMatrixFormWrapper::_createModeSetup( Widget parentWidget )
{
	Widget modeOptionLabel = XtVaCreateManagedWidget( "SPMmodeOptionLabel",
					  xmLabelWidgetClass,
					  parentWidget,
					      NULL );
	Arg arglist[1];
	XtSetArg( arglist[0], XmNtopWidget, modeOptionLabel );
	Widget modeOptionRadioBox =  XmCreateRadioBox( parentWidget,
				          "SPMmodeOptionRadioBox",
					  arglist, 1 );
	XtManageChild( modeOptionRadioBox );

	Widget viewButton =  XtVaCreateManagedWidget("SPMmodeViewButton",
						     xmToggleButtonWidgetClass,
						     modeOptionRadioBox,
						        NULL );
	addCallback( viewButton, XmNvalueChangedCallback, &Callback::callback2,
		        this );

	Widget sprayButton = XtVaCreateManagedWidget("SPMmodeSprayButton",
						     xmToggleButtonWidgetClass,
						     modeOptionRadioBox,
						        NULL );
	addCallback( sprayButton,XmNvalueChangedCallback, &Callback::callback2,
		      this );

	Widget pruneButton = XtVaCreateManagedWidget("SPMmodePruneButton",
						     xmToggleButtonWidgetClass,
						     modeOptionRadioBox,
						        NULL );
	addCallback( pruneButton,XmNvalueChangedCallback, &Callback::callback2,
		        this );
}


void ScatterPlotMatrixFormWrapper::_createPointDisplaySetup(
							  Widget parentWidget)
{
	Widget pointDisplayOptionButton1 = XtVaCreateManagedWidget(
					   "SPMpointDisplayOptionButton1",
				            xmToggleButtonWidgetClass,
					    parentWidget,
						 NULL );
	addCallback( pointDisplayOptionButton1, XmNvalueChangedCallback,
		     &Callback::callback2, this );

	Widget pointDisplayOptionButton2 = XtVaCreateManagedWidget(
					   "SPMpointDisplayOptionButton2",
				            xmToggleButtonWidgetClass,
					    parentWidget,
						 NULL );
	addCallback( pointDisplayOptionButton2, XmNvalueChangedCallback,
		     &Callback::callback2, this );
}        



Widget ScatterPlotMatrixFormWrapper::_createPreferenceSheet()
{
        static SPMInteractionOptions data;
        static SPMPreferenceOptions specificData;
	data.specificData = &specificData;
	data.tag = SPM_TAG_PREFERENCES;

	specificData.numberOptions = 1;
	specificData.toggleOptions = 
	                 (Widget *)XtMalloc( specificData.numberOptions *
					     sizeof(Widget) );

        data.mainWindow = XtVaAppCreateShell(  "SPMPreferenceSheetMainWindow",
					       "PCPreferenceSheet",
					       applicationShellWidgetClass,
					       OurDisplay,
						   NULL );
	Widget sheetMainContainer = XtVaCreateManagedWidget(
					     "PreferenceSheetMainContainer",
					      xmFormWidgetClass,
					      data.mainWindow,
						 NULL );
	Widget sheetActionArea = XtVaCreateManagedWidget( 
					     "PreferenceSheetActionArea",
					      xmFormWidgetClass,
					      sheetMainContainer,
					         NULL );
	Widget autoscaleToggleArea = addToggleToDialog( sheetActionArea,
						        NULL,
				 	        "PreferenceSheetAutoscale",
					   &(specificData.toggleOptions[0]) );
	Widget sheetControlArea = XtVaCreateManagedWidget(
					     "PreferenceSheetControlArea",
					     xmFormWidgetClass,
					     sheetMainContainer,
					     XmNtopWidget, sheetActionArea,
						 NULL );
	Widget dismissButton = XtVaCreateManagedWidget( 
					     "DialogDismissButton",
					     xmPushButtonWidgetClass,
					     sheetControlArea,
						  NULL );
	addCallback( dismissButton, XmNactivateCallback,
		     &Callback::callback9, this, &data );

	return( data.mainWindow );
}



void ScatterPlotMatrixFormWrapper::_deactivatePointerTracking( 
						  SPMEditMode *spmEditMode )
{
        int i,j;
	for (i=0; i<dim; i++) {
            for (j=0; j<dim; j++) { 
                if ( i != j ) { 
                   removeEventHandler( (Widget)CurrentXYGraph(i,j),
				       PointerMotionMask, FALSE,
				       &EventHandler::eventHandler1, this,
				       (XtPointer)spmEditMode );
		}
	    }
	}
}

     

WidgetClass ScatterPlotMatrixFormWrapper::_entryToClassName(
				       SPMWidgetTypeEntry spmWidgetEntry)
{
        switch (spmWidgetEntry ) {
	     case XYGRAPH_ENTRY:
                 return( xygraphWidgetClass );

	     case MATRIX_ENTRY:
		 return( matrixWidgetClass );
        } 

	warning( "_entryToClassName: Invalid SPMWidgetTypeEntry %d",
		 (int) spmWidgetEntry );
	return NULL;
} 


void ScatterPlotMatrixFormWrapper::_prunePointAcrossMatrix( int pointIndex )
{
	int i, j;	
	for (i=0; i<dim; i++) {
            for (j=0; j<dim; j++) {
                 if (i != j ) {
                    XYGraphRemovePoint( (XYGraphWidget)CurrentXYGraph(i,j),
	                                pointIndex );
		 }
	    }
	}
}


Pixmap ScatterPlotMatrixFormWrapper::_rotateYLabel( XmString labelString,
						    XmFontList fontList )
{
       char *label;
       XmStringGetLtoR( labelString, XmSTRING_DEFAULT_CHARSET,
			              &label );
       XmFontContext fontContext;
	
       if ( XmFontListInitFontContext( &fontContext,fontList ) ) {
	    // Retrieve the font structure being used for this label
	    XFontStruct *labelFont;
	    XmStringCharSet charSet;
	    XmFontListGetNextFont( fontContext, &charSet, &labelFont );

	    Pixmap rotatedPixmap = labelUtilities.rotateVerticalLabel(
					  yLabelForm, labelFont, label );
	    XmFontListFreeFontContext( fontContext );
	    return( rotatedPixmap );
	}
        return( (Pixmap)NULL );
}		   
				   
				 
			 
			   
void ScatterPlotMatrixFormWrapper::_setSPMDataWidgets( int dimension )
{
	XtVaSetValues( dataForm,
		       XmNfractionBase, dimension,
		          NULL );
	
        Widget newWidget;
	VoidPtrList *newPlotMatrixChildren = new VoidPtrList(1);

        int i, j;
	// Create widgets 
	for ( i=0; i<dimension; i++) {
             for ( j=0; j<dimension; j++) {
		 // Add a display widget into the grid
	         if ( (i>=dim) || (j>=dim) ) {
                    newWidget = _addNewSPMWidget(i,j);
                 } else {
                    newWidget = (Widget)
	                  plotMatrixChildren->getElement(i*dimension + j);
		 }
		 newPlotMatrixChildren->addElement(newWidget);
             }
       }
       // Set resources 
       Widget dim1Widget, dim2Widget, dataWidget;
       int dim1Min, dim1Max, dim2Min, dim2Max;
       for ( i=0; i<dimension; i++) {
	   dim1Widget = (Widget)
	               newPlotMatrixChildren->getElement(i*dimension + i);
	   XtVaGetValues( dim1Widget,
			  XtNminValue, &dim1Min,
			  XtNmaxValue, &dim1Max,
			      NULL );

           for ( j=0; j<dimension; j++) {
               dim2Widget = (Widget)
	               newPlotMatrixChildren->getElement(j*dimension + j);
               if (i != j ) {
                  dataWidget = (Widget)
	                 newPlotMatrixChildren->getElement(i*dimension+j);
		  XtVaGetValues( dim2Widget,
				 XtNminValue, &dim2Min,
				 XtNmaxValue, &dim2Max,
				    NULL );
		  XtVaSetValues( dataWidget,
				 XtNminx, dim2Min,
				 XtNmaxx, dim2Max,
				 XtNminy, dim1Min,
				 XtNmaxy, dim1Max,
				    NULL );
	       }
	   }
       }
       delete plotMatrixChildren;
       plotMatrixChildren = newPlotMatrixChildren;
}


void ScatterPlotMatrixFormWrapper::_unsetSPMDataWidgets(int dimension)
{
        int i, j;
	// Destroy widgets 
	for ( i=0; i<dimension; i++) {
             for ( j=0; j<dimension; j++) {
		 if ( i != j ) {
                    XtDestroyWidget( (Widget)
			plotMatrixChildren->getElement(i*dimension+j) );
                 }
             }
       }
}


void ScatterPlotMatrixFormWrapper::_setSPMLabelWidgets( int dimension )
{
	XtVaSetValues( xLabelForm,
		       XmNfractionBase, dimension,
		          NULL );
	XtVaSetValues( yLabelForm,
		       XmNfractionBase, dimension,
		          NULL );

	Widget newXLabel, newYLabel;
        int i;
	for (i=0; i<dimension; i++) {
             if (i >= dim) {
                 newXLabel = XtVaCreateManagedWidget( "SPMXLabelWidget",
				       xmLabelWidgetClass,
				       xLabelForm,
				       XmNleftPosition, i,
				       XmNrightPosition, i+1,
					   NULL );
		 newYLabel = XtVaCreateManagedWidget( "SPMYLabelWidget",
				       xmLabelWidgetClass,
				       yLabelForm,
				       XmNtopPosition, i,
				       XmNbottomPosition, i+1,
				           NULL );

	     } else {
                 newXLabel = (Widget)plotMatrixXLabels.getElement(i);
		 newYLabel = (Widget)plotMatrixYLabels.getElement(i);
	     }	
	     plotMatrixXLabels.setElement( i, newXLabel );
	     plotMatrixYLabels.setElement( i, newYLabel );
	}
}


void ScatterPlotMatrixFormWrapper::_setupInteractionArea( Widget parentWidget )
{
        Widget preferencesButton = XtVaCreateManagedWidget( 
						    "SPMPreferencesButton",
						    xmPushButtonWidgetClass,
						    parentWidget,
							NULL );
	addCallback( preferencesButton, XmNactivateCallback,
		     &Callback::callback7, this, NULL );
	Widget clusteringButton = XtVaCreateManagedWidget(
				                    "SPMClusteringButton",
					            xmPushButtonWidgetClass,
						    parentWidget,
							NULL );
	addCallback( clusteringButton, XmNactivateCallback,
		     &Callback::callback7, this, NULL );
}


int ScatterPlotMatrixFormWrapper::_setupStatusArea( Widget parentWidget )
{
        Widget pointSetLabel = XtVaCreateManagedWidget( 
					      "SPMpointSetNameLabel",
					      xmLabelWidgetClass,
					      parentWidget,
						  NULL );
        statusInformation.pointSetName = XtVaCreateManagedWidget(
						"SPMpointSetNameText",
						xmLabelWidgetClass,
						parentWidget,
						XmNleftWidget, pointSetLabel,
						   NULL );

	Widget pointCountLabel =  XtVaCreateManagedWidget( 
			      "SPMpointCountLabel",
			       xmLabelWidgetClass,
		               parentWidget,
			       XmNleftWidget, statusInformation.pointSetName,
				   NULL );

        statusInformation. pointCount = XtVaCreateManagedWidget( 
				               "SPMpointCountText",
				               xmLabelWidgetClass,
				               parentWidget,
				               XmNleftWidget, pointCountLabel,
					          NULL );
	int height;
	XtVaGetValues( pointSetLabel,
		       XmNheight, &height,
		          NULL );
	return( height );
}


void ScatterPlotMatrixFormWrapper::_updateFormOffsets()
{
        static Dimension currentStatusAreaHeight = 0;
	
	Dimension statusAreaHeight;
	XtVaGetValues( statusInformation.pointSetName,
		       XmNheight, &statusAreaHeight,
		          NULL ); 

	if ( statusAreaHeight > currentStatusAreaHeight ) {
           XtVaSetValues( dataForm,
			  XmNtopOffset, (int)statusAreaHeight,
			     NULL );
	   XtVaSetValues( yLabelForm,
			  XmNtopOffset, (int)statusAreaHeight,
			     NULL );
	   currentStatusAreaHeight = statusAreaHeight;
	}
}



void ScatterPlotMatrixFormWrapper::_updateFormOffsets( XmFontList fontList,
						       XmString labelString )
{
        static Dimension currentXLabelFormHeight=0, currentYLabelFormWidth=0;

   	Dimension xLabelHeight = XmStringHeight( fontList, labelString );

	if ( xLabelHeight > currentXLabelFormHeight ) {
           XtVaSetValues( yLabelForm,
			  XmNbottomOffset, (int)xLabelHeight,
			     NULL );	
	   XtVaSetValues( dataForm,
			  XmNbottomOffset, (int)xLabelHeight,
			     NULL );
           currentXLabelFormHeight = xLabelHeight;
        }
	if ( xLabelHeight > currentYLabelFormWidth ) {
	   XtVaSetValues( xLabelForm, 
		          XmNleftOffset, (int)xLabelHeight,
		             NULL );
	   XtVaSetValues( dataForm,
			  XmNleftOffset, (int)xLabelHeight,
			     NULL );
	   XtVaSetValues( statusForm,
			  XmNleftOffset, (int)xLabelHeight,
			     NULL );
	   currentYLabelFormWidth = xLabelHeight;
	}
}


void ScatterPlotMatrixFormWrapper::_viewPointAcrossMatrix( int pointIndex )
{
	int i, j;	
	for (i=0; i<dim; i++) {
            for (j=0; j<dim; j++) {
                 if (i != j ) {
                    XYGraphSetPointColor( (XYGraphWidget)CurrentXYGraph(i,j),
					  pointIndex,
			                  currentCallbackColor );
		    currentViewingPoint = pointIndex;
		 }
	    }
	}
}



/* This callback deals with clicks on any of the matrix entries */
void ScatterPlotMatrixFormWrapper::callback1( Widget callbackWidget,
					      XtPointer ptr1, XtPointer ptr2 )
{
	ptr1 = ptr1;
	ptr2 = ptr2;
        static Boolean is1DCallbackWindowMade = False,
	               is2DCallbackWindowMade = False;
        static Callback1DTextWidgetSet textWidgetSet;

        if ( Pablo::MainInterface()->isCameraOn() ) {
           CString fuName = SPMFUthisPtr->getName();
	   Pablo::MainInterface()->takeSnapshot( callbackWidget, 
					         SPMFUthisPtr->getFUClass(),
					         fuName.getValue() );
	}
        else {
   	   if ( XtClass(callbackWidget) == boxAndWhiskerWidgetClass ) {
	      // Create callback window if necessary 
	      if ( !is1DCallbackWindowMade ) {
                 callbackMainWindow1D = _create1DCallbackWindow(textWidgetSet);
	         is1DCallbackWindowMade = True;
	      }
	      // Determine which dimension we"re dealing with
	      char *widgetName = XtName( callbackWidget );
	      int cbDim;
	      sscanf( widgetName, "SPMboxAndWhisker%d", &cbDim );
	      cbDim--;

	      // Set the header text to reflect the current dimension
	      XmString headerString;
	      XtVaGetValues( (Widget)plotMatrixXLabels.getElement(cbDim),
			     XmNlabelString, &headerString,
			        NULL );
	      XtVaSetValues( (Widget)textWidgetSet.headerWidget,
			     XmNlabelString, headerString,
			        NULL );

	      // Call the FU callback to show actual data values
	      SPMFUthisPtr->fuCallback1( callbackWidget,
				         callbackMainWindow1D,
				         textWidgetSet, cbDim );
	   
           } else {
              if ( ! is2DCallbackWindowMade ) {
                 callbackMainWindow2D = _create2DCallbackWindow();
	         is2DCallbackWindowMade = True;
              }
	      XtPopup( callbackMainWindow2D, XtGrabNone );
           }
     }
}         



/* This callback handles toggle button presses */
void ScatterPlotMatrixFormWrapper::callback2( Widget callbackWidget,
					      XtPointer ptr1, XtPointer ptr2 )
{
	ptr1 = ptr1;
	ptr2 = ptr2;
	static SPMEditMode previousEditMode = NULL_EDITMODE;
	static int previousDisplayMode = NULL_DISPMODE;

        XmToggleButtonCallbackStruct *xmCallbackStruct = 
	                                (XmToggleButtonCallbackStruct *) ptr2;

	SPMEditMode currentEditMode;
	SPMDisplayMode currentDisplayMode;
        const char *widgetName = XtName(callbackWidget);

        Widget currentWidget;
	int i,j;
	/* Toggle turned on */
	if (xmCallbackStruct->set) {
	   /* Check for display options */
	   if (strcmp(widgetName, "SPMpointDisplayOptionButton1") == 0) {
              currentDisplayMode = DISPLAY_DENSITY;
           }

	   /* Check for edit options */
           if (strcmp(widgetName, "SPMmodeViewButton") == 0) {
              currentEditMode = VIEW_MODE;
	      XtSetSensitive( XtNameToWidget( functionRadioBox,
					      "SPMfunctionByColorToggle" ),
	                      True );
           } else if (strcmp( widgetName, "SPMmodeSprayButton") == 0) {
              currentEditMode = SPRAY_MODE;
	      XtSetSensitive( XtNameToWidget( functionRadioBox,
					      "SPMfunctionByColorToggle" ),
	                      False );
	   } else if (strcmp( widgetName, "SPMmodePruneButton") == 0) {
	      currentEditMode = PRUNE_MODE;
	      XtSetSensitive( XtNameToWidget( functionRadioBox,
					      "SPMfunctionByColorToggle" ),
	                      True );
	   }

	   /* Process the selected option */
           for (i=0; i<dim; i++) {
               for (j=0; j<dim; j++) {
                   currentWidget = (Widget)CurrentXYGraph(i,j);
		   if ( i != j ) {
	   	      /* Process current edit option */
                      switch( currentEditMode ) {
			 case VIEW_MODE:
                             addCallback( currentWidget, XtNselect,
				          &Callback::callback4, this,
					  (XtPointer)&previousEditMode );
			     break;
                         case SPRAY_MODE:
		             addCallback( currentWidget, XtNselect,
		                &Callback::callback4, this, 
				(XtPointer)&previousEditMode );
		             break; 
			 case PRUNE_MODE:
			     addCallback( currentWidget, XtNselect,
				&Callback::callback4, this, 
			        (XtPointer)&previousEditMode );
			     break;
			 default:
                             break;
		      }
		      /* Un-process previous edit option */
                      switch ( previousEditMode ) {
                         case VIEW_MODE:
			     removeCallback( currentWidget, XtNselect,
			                     &Callback::callback4, this,
					     (XtPointer)&previousEditMode );
			     
			     break;
		         case SPRAY_MODE:
			     removeCallback( currentWidget, XtNselect,
				&Callback::callback4, this, 
				(XtPointer)&previousEditMode );
			     break;
			 case PRUNE_MODE:
			     removeCallback( currentWidget, XtNselect,
				&Callback::callback4, this,
				(XtPointer)&previousEditMode );
			     break;
			 default:
                             break;
		      }
	           }
	        }
	    }

            /* Process display option */
            if ( previousDisplayMode != currentDisplayMode ) {
               if ( currentDisplayMode == DISPLAY_DENSITY ) {
		   XtVaSetValues( (Widget)currentWidget,
				  XtNdensityPlot, True,
				    NULL );
                   XYGraphPlotValues( (XYGraphWidget)currentWidget );
     	       }
           }

        /* Toggle turned off */
        } else {
	   if (strcmp(widgetName, "SPMpointDisplayOptionButton1") == 0) {

	      /* Undisplay density plots */
              for (i=0; i<dim; i++) {
                  for (j=0; j<dim; j++) {
                      currentWidget = (Widget)CurrentXYGraph(i,j);
		      if ( i != j ) {
                         XtVaSetValues( currentWidget,
			                XtNdensityPlot, False,
				          NULL );
	                 XYGraphPlotValues( (XYGraphWidget)currentWidget );
		      }
		  }
	      }
              currentDisplayMode = NULL_DISPMODE;
	    }
        }
	previousEditMode = currentEditMode;
	previousDisplayMode = currentDisplayMode;
}



/* This widget handles closing of the matrix entry callback windows */
void ScatterPlotMatrixFormWrapper::callback3( Widget callbackWidget,
					      XtPointer ptr1, XtPointer ptr2 )
{
	callbackWidget = callbackWidget;
	ptr1 = ptr1;
	ptr2 = ptr2;
        Widget parentWidget = XtParent(callbackWidget);

	if ( strncmp( XtName(parentWidget), "SPM1D", 5 ) == 0 ) {
           XtPopdown( callbackMainWindow1D );
        } else if ( strncmp( XtName(parentWidget), "SPM2D", 5 ) == 0 ) {
           XtPopdown( callbackMainWindow2D );
	}
}


/* This callback handles the activation of spray and prune modes */
void ScatterPlotMatrixFormWrapper::callback4( Widget callbackWidget,
					      XtPointer ptr1, XtPointer ptr2 )
{
	callbackWidget = callbackWidget;
	ptr1 = ptr2;
        static SPMEditMode previousSPMEditMode = NULL_EDITMODE;
	SPMEditMode *spmEditMode = (SPMEditMode *)ptr1;

	switch ( *spmEditMode ) {
	      case VIEW_MODE:
	           if ( previousSPMEditMode & VIEW_MODE ) {
		      _activatePointerTracking( spmEditMode );
		   } else {
                      _deactivatePointerTracking( spmEditMode );
		   }
		   previousSPMEditMode = (SPMEditMode)(
	                             (int)(previousSPMEditMode)^VIEW_MODE);
		   break;

	      case SPRAY_MODE:
	           if ( previousSPMEditMode & SPRAY_MODE ) {
                      XUndefineCursor( OurDisplay, OurDataWindow );
	              _deactivatePointerTracking( spmEditMode );
                   } else {
                      XDefineCursor( OurDisplay, OurDataWindow,
		                XCreateFontCursor( OurDisplay, XC_spraycan ) );
	              _activatePointerTracking( spmEditMode );
                   }
      	           previousSPMEditMode = (SPMEditMode)(
	                             (int)(previousSPMEditMode)^SPRAY_MODE);
		   break;
              case PRUNE_MODE:
                   if ( previousSPMEditMode & PRUNE_MODE ) {
                      XUndefineCursor( OurDisplay, OurDataWindow );
		      _deactivatePointerTracking( spmEditMode );
		   } else {
                      XDefineCursor( OurDisplay, OurDataWindow,
			    XCreateFontCursor( OurDisplay, XC_cross_reverse ));
		      _activatePointerTracking( spmEditMode );
		   }
		   previousSPMEditMode = (SPMEditMode)(
	                             (int)(previousSPMEditMode)^PRUNE_MODE);
	           break;
	      default:
                   break;
	}
	previousSPMEditMode = *spmEditMode;
}


/* This callback handles changes in the currently active callback color */
void ScatterPlotMatrixFormWrapper::callback5( Widget callbackWidget,
					      XtPointer ptr1, XtPointer ptr2 )
{
	ptr1 = ptr1;
	ptr2 = ptr2;
        int selectedColor;
	sscanf( XtName(callbackWidget), "%d", &selectedColor );
	currentCallbackColor = selectedColor;
}
        


void ScatterPlotMatrixFormWrapper::callback6( Widget callbackWidget,
					      XtPointer ptr1, XtPointer ptr2 )
{ 
     ptr1 = ptr1;
     ptr2 = ptr2;
     int nearestXValue, nearestYValue;
     int index;

     XYGraphGetNearestPoint( (XYGraphWidget)callbackWidget, 
	                     &nearestXValue, &nearestYValue,
			     &index );
     if (index >= 0) {
        XYGraphDrawPointMarker( (XYGraphWidget)callbackWidget, index );
//        xygraphFUthisPtr->fuCallback(nearestXValue, nearestYValue);
     }
}


// This callback handles interactive push button selection
void ScatterPlotMatrixFormWrapper::callback7( Widget callbackWidget,
					      XtPointer ptr1, XtPointer ptr2 )
{ 
     ptr1 = ptr1;
     ptr2 = ptr2;
     static Boolean preferenceSheetIsCreated = False,
	            clusterSheetIsCreated = False;
     static Widget preferenceSheetMainWindow, clusterSheetMainWindow;

     if (  strcmp( XtName(callbackWidget), "SPMPreferencesButton" ) == 0 ) {
        if ( ! preferenceSheetIsCreated ) {
           preferenceSheetMainWindow = _createPreferenceSheet();
	   preferenceSheetIsCreated = True;
        }
        XtPopup( preferenceSheetMainWindow, XtGrabNone );
     } else if (strcmp( XtName(callbackWidget),"SPMClusteringButton")==0) {
	if ( ! clusterSheetIsCreated ) {
	   clusterSheetMainWindow = _createClusterSheet();
	   clusterSheetIsCreated = True;
        }
	XtPopup( clusterSheetMainWindow, XtGrabNone );
     }
}



void ScatterPlotMatrixFormWrapper::callback8( Widget, XtPointer, XtPointer)
{
}


// This callback handles dialog window updates and close
void ScatterPlotMatrixFormWrapper::callback9( Widget callbackWidget,
					      XtPointer ptr1, XtPointer ptr2 )
{
	callbackWidget = callbackWidget;
	ptr2 = ptr2;
        SPMInteractionOptions *data = (SPMInteractionOptions *)ptr1;

	switch (data->tag ) {
 	     case SPM_TAG_PREFERENCES:
                 XtPopdown( data->mainWindow );
		 break;
	     case SPM_TAG_CLUSTERING:
	         XtPopdown( data->mainWindow );
		 SPMClusteringOptions *specificData;
                 specificData = (SPMClusteringOptions*)data->specificData;

                 // Determine enabled state
                 int possibleStates;
                 WidgetList childList;
                 XtVaGetValues( specificData->clusteringRadioBox1,
		                XmNchildren, &childList,
	 	                XmNnumChildren, &possibleStates,
		                   NULL );
                 int i;
                 for (i=0; i<possibleStates; i++) {
	             if ( XmToggleButtonGetState( childList[i] ) ) {
	                specificData->clusteringEnabled = (Boolean)i;
	                break;
                     } 
                 }
                 // Determine clustering interval	
                 char *clusteringIntervalString;  
	         clusteringIntervalString = XmTextFieldGetString(
	                          specificData->clusteringIntervalWidget);
                 sscanf(clusteringIntervalString, "%d",
				       &specificData->clusteringInterval);
		 break;        	         	         
	     default:
		 break;
	}
}


/* This event handler takes care of point spraying */
void ScatterPlotMatrixFormWrapper::eventHandler1( Widget childWidget,
						  XtPointer clientData,
						  XEvent *event,
						  Boolean *continueToDispatch )
{
	continueToDispatch = continueToDispatch;
        int x_pos, y_pos;
        if (event->type == MotionNotify ) {
            x_pos = event->xmotion.x;
	    y_pos = event->xmotion.y;

	    int graphCount;
	    XtVaGetValues( childWidget,
			   XtNxygraphCnt, &graphCount,
			      NULL );

	    int *valueCount, *xvalues, *yvalues;
	    XtVaGetValues( childWidget,
			   XtNvalueCnt, &valueCount,
			   XtNxvalues, &xvalues,
			   XtNyvalues, &yvalues,
			      NULL );
	    int i, j;
	    int totalValues = 0;
	    SPMEditMode *spmEditMode = (SPMEditMode *)clientData;

	    for (i=0; i<graphCount; i++) {
                for (j=0; j<valueCount[i]; j++) {
		    if ( ( abs(x_pos - xvalues[totalValues+j]) <= 3 ) &&
		         ( abs(y_pos - yvalues[totalValues+j]) <= 3 ) ) {
			 switch (*spmEditMode) {
			    case NULL_EDITMODE:
	                       break;
	                    case VIEW_MODE:
                               _viewPointAcrossMatrix( totalValues+j );
			    case SPRAY_MODE:
			       _colorPointAcrossMatrix( totalValues+j );
			       break;
			    case PRUNE_MODE:
                               _prunePointAcrossMatrix( totalValues+j );
			       break;
	                    default:
	                       break;
			}
		    }
		}
		totalValues += valueCount[i];
	    }
      }
}



char * ScatterPlotMatrixFormWrapper::getCategoryLabel( int theDimension )
{
        char *categoryText;
	
	if ( theDimension >= dim ) return( (char *)NULL );

	XmString categoryString;
	XtVaGetValues( (Widget)plotMatrixXLabels.getElement(theDimension), 
		       XmNlabelString, &categoryString,
		          NULL );
	XmStringGetLtoR( categoryString, XmSTRING_DEFAULT_CHARSET,
			 &categoryText );
	return( categoryText );
}				 


int
ScatterPlotMatrixFormWrapper::getClusteringInterval()
{
	return( clusteringOptions.clusteringInterval );
}


void ScatterPlotMatrixFormWrapper::getPerfWidgetPosition( int& x, int& y,
					        int& width, int& height )
{
        Position widgetX, widgetY;
	Dimension widgetWidth, widgetHeight;

	XtVaGetValues( spmMainWindow,
		       XmNx, &widgetX,
		       XmNy, &widgetY,
		       XmNwidth, &widgetWidth,
		       XmNheight, &widgetHeight,
		          NULL );
	x = (int)widgetX;
	y = (int)widgetY;
	width = (int)widgetWidth;
	height = (int)widgetHeight;
}



char * ScatterPlotMatrixFormWrapper::getPointSetName()
{
        XmString pointSetString;
	XtVaGetValues( (Widget)statusInformation.pointSetName,
		       XmNlabelString, &pointSetString,
		           NULL );
	char *pointSetLabel;
	XmStringGetLtoR( pointSetString,
			 XmSTRING_DEFAULT_CHARSET, &pointSetLabel );
	return( pointSetLabel );
}



void ScatterPlotMatrixFormWrapper::getSPMAttr( int dimension,
					       String name, XtArgVal value )
{
        XtVaGetValues( (Widget)plotMatrixChildren->getElement(
	                                           dimension*dim+dimension),
		       name, value,
		          NULL );
}



void ScatterPlotMatrixFormWrapper::getWidgetConnectOption( int& connectOption )
{
        Boolean connectOptionInWidget;
	
	XtVaGetValues( (Widget)BaseXYGraphWidget,
		       XtNconnect, &connectOptionInWidget,
		          NULL );
	if (connectOptionInWidget) {
           connectOption = 1;
	} else {
           connectOption = 0;
	}
}


void ScatterPlotMatrixFormWrapper::getWidgetMinMaxInfo(int& wMinX, int& wMaxX,
						       int& wMinY, int& wMaxY )
{
        int wMinXIn, wMaxXIn, wMinYIn, wMaxYIn;

	XtVaGetValues( (Widget)BaseXYGraphWidget,
		       XtNminx, &wMinXIn,
		       XtNmaxx, &wMaxXIn,
		       XtNminy, &wMinYIn,
		       XtNmaxy, &wMaxYIn,
		          NULL );
	wMinX = wMinXIn;
	wMaxX = wMaxXIn;
	wMinY = wMinYIn;
	wMaxY = wMaxYIn;
}



void ScatterPlotMatrixFormWrapper::getWidgetTicks( int& xticks, int& yticks )
{ 
        int xticksIn, yticksIn;

        XtVaGetValues( (Widget)BaseXYGraphWidget,
		       XtNxticks, &xticksIn,
		       XtNyticks, &yticksIn,
		          NULL );
	xticks = xticksIn;
	yticks = yticksIn;
}


Boolean ScatterPlotMatrixFormWrapper::isClusteringEnabled()
{
       return( clusteringOptions.clusteringEnabled );
}


void ScatterPlotMatrixFormWrapper::realize()
{
	XtRealizeWidget( spmMainWindow );

	// Adjust the initial size and position of the snapshot dialog
/*
	Dimension mainWidth, mainHeight, snapshotWidth, snapshotHeight;
	Position mainX, mainY, snapshotX, snapshotY;
	XtVaGetValues( spmMainWindow,
		       XmNwidth, &mainWidth,
		       XmNheight, &mainHeight,
		       XmNx, &mainX,
		       XmNy, &mainY,
		          NULL );
	snapshotWidth = mainWidth;
	snapshotX = mainX;
	snapshotY = mainY + mainHeight;

	XtVaSetValues( snapshotDialog,
		       XmNwidth, snapshotWidth,
		       XmNx, snapshotX,
		       XmNy, snapshotY,
		          NULL );

	XtRealizeWidget( snapshotDialog ); 
*/
}


void ScatterPlotMatrixFormWrapper::setCategoryLabel( 
					   XmString categoryLabelString,
					   int theDimension )
{
	// X Label
	Widget newXLabel = (Widget)plotMatrixXLabels.getElement(theDimension);
	XtVaSetValues( newXLabel,
		       XmNlabelString, categoryLabelString,
		          NULL );
	// Y Label
	XmFontList fontList;
	XtVaGetValues( newXLabel,
		       XmNfontList, &fontList,
		          NULL );
	Widget newYLabel = (Widget)plotMatrixYLabels.getElement(theDimension);

	Pixmap categoryLabelPixmap =
                            _rotateYLabel( categoryLabelString, fontList );
	/* is this a memory leak? */
	XtVaSetValues( newYLabel,
		       XmNlabelType, XmPIXMAP,
		       XmNlabelPixmap, categoryLabelPixmap,
	                  NULL );

	// Update the position offsets for the label forms
	_updateFormOffsets( fontList, categoryLabelString );
}


void ScatterPlotMatrixFormWrapper::setCategoryLabel( const char *categoryLabel,
						     int theDimension )
{
        if ( strlen(categoryLabel) > 0 ) {
           XmString categoryLabelString = XmStringCreateSimple(
						     (char *)categoryLabel );
	   setCategoryLabel( categoryLabelString, theDimension );
	   XmStringFree( categoryLabelString );
	}
}				 



void ScatterPlotMatrixFormWrapper::setConnectOption( Boolean connectOption )
{
        int i, j;
        for (i=0; i<dim; i++) {
            for (j=0; j<dim; j++) {
                 if (i != j ) {
                    XtVaSetValues( (Widget)CurrentXYGraph(i,j),
				   XtNconnect, connectOption,
				      NULL );
		 }
	     }
	}
}



void ScatterPlotMatrixFormWrapper::setDimension( int dimension )
{
       if ( dimension != dim ) {
          _setSPMLabelWidgets( dimension );
          _setSPMDataWidgets( dimension );
          dim = dimension;
       }
}

  
void ScatterPlotMatrixFormWrapper::setPerfWidgetColors()
{ 
        static char *lineColors[] = {
		"#000000",
		"#ff0000",
		"#00ff00",
		"#0000ff",
		"#ff00ff",
		"#ffff00",
		"#00ffff"
	};
	int numLineColors = 7;
	static char *densityColors[] = {
                "#404040",
		"#b0b0b0"
	};
	int numDensityColors = 2;
	static char *brushColors[] = {
	        "#ff0000",
		"#00ff00",
		"#0000ff",
		"#ff00ff",
		"#ffff00",
		"#00ffff"
	};
	int numBrushColors = 6;

	lineColorTable.loadNewColormap( lineColors, numLineColors);
        lineColorTable.gencolor( OurDisplay, OurScreen );
	densityColorTable.loadNewColormap( densityColors, numDensityColors );
	densityColorTable.gencolor( OurDisplay, OurScreen );
	brushColorTable.loadNewColormap( brushColors, numBrushColors );
	brushColorTable.gencolor( OurDisplay, OurScreen );

	Widget currentChild;
	int i, j;
	for (i=0; i<dim; i++) {
             for (j=0; j<dim; j++) {

                if (i != j ) {
                   currentChild = (Widget)CurrentXYGraph(i,j);
                   switch (spmWidgetEntry) {
                       case XYGRAPH_ENTRY:
		           XYGraphSetColors( 
	                               (XYGraphWidget)currentChild,
				       lineColorTable.getNumColors(),
				       lineColorTable.getColormapEntries() );
			   XYGraphSetDensityColors(
	                              (XYGraphWidget)currentChild,
				      densityColorTable.getNumColors(),
				      densityColorTable.getColormapEntries() );
			   XYGraphSetBrushColors(
	                              (XYGraphWidget)currentChild,
				      brushColorTable.getNumColors(),
				      brushColorTable.getColormapEntries() );
 		           break;

		       case MATRIX_ENTRY:
//			  MatrixSetColors( ... );
			  break;
		   }
	       }
           }
	}
}


void ScatterPlotMatrixFormWrapper::setPointCount( int numPoints )
{
        static char pointCountText[STRING_MAX_LEN];
	static XmString pointCountString;

	sprintf( pointCountText, "%d", numPoints );
        pointCountString = XmStringCreateSimple( pointCountText ); 
        XtVaSetValues( statusInformation.pointCount,
		       XmNlabelString, pointCountString,
		          NULL );
}


void ScatterPlotMatrixFormWrapper::setPointSetName( char *pointSetName )
{
        XmString pointSetString = XmStringCreateSimple( pointSetName );
	XtVaSetValues( statusInformation.pointSetName,
		       XmNlabelString, pointSetString,
		           NULL );
	_updateFormOffsets();
}
      

void ScatterPlotMatrixFormWrapper::setSPMValues( int *nDimDataPoints,
						 int *lineIndices,
						 int lineCount,
						 int pointCount )

{
        // First, recast the n-dimensional data points to be in the
        // multiple line-form XYGraph wants (each cluster will be
        // represented by XYGraph as a single line).

	int currentLoadedPoint = 0;
	int *nDimLinedDataPoints = new int[pointCount*dim];
	int *pointsPerLine = new int[lineCount];
        int i, j, k;

        if ( lineCount > 1 ) {
   	   for (i=0; i < lineCount ; i++) {
	       pointsPerLine[i] = 0;
               for (j=0; j < pointCount; j++) {
                   if ( lineIndices[j] == i ) {
                      for (k=0; k<dim; k++) {
                          nDimLinedDataPoints[ currentLoadedPoint*dim + k ] =
			                       nDimDataPoints[ j*dim + k ];
		      }
		      pointsPerLine[i]++;
		      currentLoadedPoint++;
		   }
	       }
	   }
	}
        // Now just draw the data
        setSPMValues( nDimLinedDataPoints, lineCount, pointCount,
		      pointsPerLine );
	delete pointsPerLine;
}


               
void ScatterPlotMatrixFormWrapper::setSPMValues( int *nDimDataPoints,
						 int lineCount,
						 int pointCount,
						 int *pointsPerLine )
{
        int *dim1Values = new int [pointCount];
	int *dim2Values = new int [pointCount];
	int *TwoDimEmbeddedValues = new int [dim * pointCount];

        int i, j, k;
	int dim1In, dim2In;
	for (i=0; i<dim; i++) {
            for (j=0; j<dim; j++) {

                 if (i != j) { 
                    switch (spmWidgetEntry) {
                         case XYGRAPH_ENTRY:
                            for (k=0; k<pointCount; k++) {
	                        dim1In = nDimDataPoints[k*dim+i];
			        dim2In = nDimDataPoints[k*dim+j];
                                dim1Values[k] = Round((NormX(dim1In)* 100));
                                dim2Values[k] = Round((NormY(dim2In)* 100));
			    }
                            XYGraphSetValues((XYGraphWidget)CurrentXYGraph(i,j),
			                      dim2Values, dim1Values,
			                      pointsPerLine, lineCount );
			    break;

			 case MATRIX_ENTRY:
			     for (k=0; k<pointCount; k++) {
                                 TwoDimEmbeddedValues[k*dim] = 
                                        nDimDataPoints[k*dim+i];
				 TwoDimEmbeddedValues[k*dim+1] =
                                        nDimDataPoints[k*dim+j];
			     }
			     MatrixSetValues( 
				  (MatrixWidget)CurrentXYGraph(i,j),
				  TwoDimEmbeddedValues );
                             break;
		    }
		 } else {
		      for (k=0; k<pointCount; k++) {
                          dim1Values[k] = nDimDataPoints[k*dim+i];
		      }
		      BoxAndWhiskerSetValues(
	                (BoxAndWhiskerWidget)CurrentXYGraph(i,j),
			dim1Values, pointCount );
                 } 
	    }
	}
	delete dim1Values;
	delete dim2Values;
	delete TwoDimEmbeddedValues;

	if ( pointCount % 10 == 0 ) {
	   setPointCount( pointCount );
        } 
}


void ScatterPlotMatrixFormWrapper::setSPMValues( int *dataPoint )
{
        static int pointCount = 0;

        int i, j;
	for (i=0; i<dim; i++) {
            for (j=0; j<dim; j++) {
                 if (i != j) { 
                    switch (spmWidgetEntry) {
                         case XYGRAPH_ENTRY:
                            XYGraphSetValue((XYGraphWidget)CurrentXYGraph(i,j),
			                    dataPoint[j], dataPoint[i] ); 
			    break;

			 case MATRIX_ENTRY:
                             break;
		    }
		 } else {
		      BoxAndWhiskerSetValue(
	                (BoxAndWhiskerWidget)CurrentXYGraph(i,j),
					     dataPoint[i] );

                 } 
	    }
	}
	pointCount++;
	if ( pointCount % 10 == 0 ) {
	   setPointCount( pointCount );
	}
}    


void ScatterPlotMatrixFormWrapper::setSPM2DAttr( String name, XtArgVal value )
{
        int i,j;
	for (i=0; i<dim; i++) {
            for (j=0; j<dim; j++) {
                if (i != j ) {
		    XtVaSetValues( (Widget)CurrentXYGraph(i,j),
				   name, value,
				      NULL );
		}
	    }
	}
}
      
void ScatterPlotMatrixFormWrapper::setSPMAttr( int x, int y,
					       int width, int height )
{
        static char geometry[STRING_MAX_LEN];

	sprintf( geometry, "%dx%d+%d+%d", width, height, x, y );
        XtVaSetValues( spmMainWindow,
		       XtNgeometry, geometry,
		          NULL );
}


void ScatterPlotMatrixFormWrapper::setType( int widgetEntry )
{
	if ( (SPMWidgetTypeEntry)widgetEntry != spmWidgetEntry ) {
            spmWidgetEntry = (SPMWidgetTypeEntry)widgetEntry;
        }
}     







