/*
 * This file is part of the Pablo Performance Analysis Environment
 *
 *                                           TM
 * The Pablo Performance Analysis Environment   software is *not* in
 * the public domain.  However, it is freely available without fee for
 * education, research, and non-profit purposes.  By obtaining copies
 * of this and other files that comprise the Pablo Performance Analysis
 * Environment, you, the Licensee, agree to abide by the following
 * conditions and understandings with respect to the copyrighted software:
 * 
 * 1.  The software is copyrighted in the name of the Board of Trustees
 *     of the University of Illinois (UI), and ownership of the software
 *     remains with the UI. 
 *
 * 2.  Permission to use, copy, and modify this software and its documentation
 *     for education, research, and non-profit purposes is hereby granted
 *     to Licensee, provided that the copyright notice, the original author's
 *     names and unit identification, and this permission notice appear on
 *     all such copies, and that no charge be made for such copies.  Any
 *     entity desiring permission to incorporate this software into commercial
 *     products should contact:
 *
 *          Professor Daniel A. Reed                 reed@cs.uiuc.edu
 *          University of Illinois
 *          Department of Computer Science
 *          2413 Digital Computer Laboratory
 *          1304 West Springfield Avenue
 *          Urbana, Illinois  61801
 *          USA
 *
 * 3.  Licensee may not use the name, logo, or any other symbol of the UI
 *     nor the names of any of its employees nor any adaptation thereof in
 *     advertizing or publicity pertaining to the software without specific
 *     prior written approval of the UI.
 *
 * 4.  THE UI MAKES NO REPRESENTATIONS ABOUT THE SUITABILITY OF THE
 *     SOFTWARE FOR ANY PURPOSE.  IT IS PROVIDED "AS IS" WITHOUT EXPRESS
 *     OR IMPLIED WARRANTY.
 *
 * 5.  The UI shall not be liable for any damages suffered by Licensee from
 *     the use of this software.
 *
 * 6.  The software was developed under agreements between the UI and the
 *     Federal Government which entitle the Government to certain rights.
 *
 **************************************************************************
 *
 * Developed by: The TAPESTRY Parallel Computing Laboratory
 *		 University of Illinois at Urbana-Champaign
 *		 Department of Computer Science
 *		 1304 W. Springfield Avenue
 *		 Urbana, IL	61801
 *
 * Copyright (c) 1987-1994
 * The University of Illinois Board of Trustees.
 *	All Rights Reserved.
 *
 * Author: Daniel A. Reed (reed@cs.uiuc.edu)
 * Contributing Author:  Bradley W. Schwartz (schwartz@cs.uiuc.edu)
 *
 * Project Manager and Principal Investigator:
 *	Daniel A. Reed (reed@cs.uiuc.edu)
 *
 * Funded by: National Science Foundation grants NSF CCR86-57696,
 * NSF CCR87-06653 and NSF CDA87-22836 (Tapestry), NASA ICLASS Contract
 * No. NAG-1-613, DARPA Contract No. DABT63-91-K-0004, by a grant
 * from the Digital Equipment Corporation External Research Program,
 * and by a collaborative research agreement with the Intel Supercomputer
 * Systems Division.
 *
 */
/*
 * PiechartWrapper.C:  Class wrapper for the pie chart performance widget  
 *
 *	$Header: /mnt/Pablo-guitar/Stable.2-94/Visual/Src/Widgets/Wrappers/RCS/PiechartFormWrapper.C,v 1.10 1994/02/25 04:44:58 aydt Exp $
 */

#include "PiechartFormWrapper.h"

extern "C" {
#include "Piechart.h"
}

#include <Xm/Form.h>       // Form widget class name definition
#include "XArgs.h"

PiechartFormWrapper::PiechartFormWrapper( WidgetBase *par,
					  PiechartFU *piechartFUPtr,
				 	  const XArgs& args,
				 	  const CString& name ) 
		    : PerfWidget( par )
{
	_setClassName( MY_CLASS );
        piechartFUthisPtr = piechartFUPtr;
    	_setType( "PiechartFormWrapper" );
	colorsSet = FALSE_;

	// Create the Motif Form widget
    	widget = XtCreateManagedWidget( name.getValue(), xmFormWidgetClass, 
					par->getWidget(), args.getArgs(), 
					args.getNArgs() );
	setPiechartFormAttr( XmNfractionBase, (XtArgVal)10000 );

        // Create a single Piechart widget to be the initial child of the Form
	Arg arg;
        piechartChild = XtCreateManagedWidget( "PiechartChild",
					       piechartWidgetClass, 
					       widget, &arg, 0 );
	// Create the min/max label
        labels.createMinMaxLabel( widget, "PiechartMinMaxLabel" );
        setPiechartLabel( L_LEFT_VERT, NULLCHARSTRING );
        setPiechartLabel( L_BOTTOM_HORIZ, NULLCHARSTRING );

        addCallback( piechartChild, XtNselect, &Callback::callback1, this, 
								     NULL );
}	


PiechartFormWrapper::~PiechartFormWrapper()
{
	XtDestroyWidget( widget );
}

void 
PiechartFormWrapper::_findPiechartFormPosition( int *piechartLayoutXOrg, 
						int *piechartLayoutYOrg,
	      					int *piechartWidthProportion, 
						int *piechartHeightProportion )
{
  	int iFractionBase, widthP, heightP, lBottom, lTop, lLeft;

  	getPiechartFormAttr( XmNfractionBase, (XtArgVal) &iFractionBase );
	
  	if ( labels.isALabel( L_LEFT_VERT ) ) {
	    lLeft = labels.getLabelHeight( L_LEFT_VERT );
      	    widthP = (int)( ( iFractionBase - (2 * lLeft) ) );
  	} else {
	    lLeft = 0;
      	    widthP = iFractionBase;
  	}

	*piechartLayoutXOrg = lLeft;
	*piechartWidthProportion = widthP;

	if ( labels.isALabel( L_BOTTOM_HORIZ ) ) {
	    lBottom = labels.getLabelHeight( L_BOTTOM_HORIZ );
	    lTop = labels.getLabelHeight( L_TOP_HORIZ );
	    heightP = (int)( iFractionBase - lBottom - lTop );
	} else {
	    lTop = labels.getLabelHeight( L_TOP_HORIZ );
	    heightP = (int)( iFractionBase - lTop );
	}
	*piechartLayoutYOrg = lTop;
      	*piechartHeightProportion = heightP;
}

void 
PiechartFormWrapper::_setPiechartFormPosition( int piechartLayoutXOrg, 
					       int piechartLayoutYOrg,	
                    		               int piechartWidthProportion, 
					       int piechartHeightProportion )
{
     	Arg arglist[4];

     	XtSetArg( arglist[0], XmNleftPosition, (XtArgVal)piechartLayoutXOrg );
     	XtSetArg( arglist[1], XmNrightPosition, 
                   (XtArgVal)( piechartLayoutXOrg+piechartWidthProportion ) );
     	XtSetArg( arglist[2], XmNtopPosition, (XtArgVal)piechartLayoutYOrg ); 
     	XtSetArg( arglist[3], XmNbottomPosition,
                   (XtArgVal)( piechartLayoutYOrg+piechartHeightProportion ) );
     	XtSetValues( piechartChild, arglist, 4 );
}

void 
PiechartFormWrapper::callback1( Widget /* callbackWidget */, 
			        XtPointer /* ptr1 */, XtPointer /* ptr2 */ )
{
	int pieSelected;
	float piePercentage;
	PiechartGetSelectedPie( (PiechartWidget)piechartChild, &pieSelected, 
							       &piePercentage );
        piechartFUthisPtr->fuCallback( piechartChild,
	                               pieSelected, piePercentage);
}

void 
PiechartFormWrapper::getPiechartAttr( String name, XtArgVal value ) const
{
     	Arg arg;
 
     	XtSetArg( arg, name, value );
     	XtGetValues( piechartChild, &arg, 1 );
}

void 
PiechartFormWrapper::getPiechartFormAttr( String name, XtArgVal value ) const
{
  	Arg arg;
  
  	XtSetArg( arg, name, value );
  	XtGetValues( widget, &arg, 1 );
}

void 
PiechartFormWrapper::getPiechartLabel( int whichLabel, 
				       const char **aLabel ) const
{
     	labels.getLabel( whichLabel, aLabel );
} 

void 
PiechartFormWrapper::setDisplayValues( int valueCount, int *values )
{
	PiechartSetValues( (PiechartWidget)piechartChild, valueCount, values );
}

void 
PiechartFormWrapper::setPiechartLabel( double fuMin, double fuMax )
{
     	labels.setLabel( fuMin, fuMax );
}

void 
PiechartFormWrapper::setPiechartAttr( String name, XtArgVal value )
{
   	Arg arg;

   	XtSetArg( arg, name, value );
   	XtSetValues( piechartChild, &arg, 1 );
}

void 
PiechartFormWrapper::setPiechartFormAttr( String name, XtArgVal value )
{
  	Arg arg;
  
  	XtSetArg( arg, name, value );
  	XtSetValues( widget, &arg, 1 );
}

void 
PiechartFormWrapper::setPiechartLabel( int whichLabel, const char *stringLabel )
{
     	Boolean_ layoutChange;

     	if ( whichLabel == L_LEFT_VERT ) {
            layoutChange = labels.setLabel( widget, "PiechartLabelVert",
					 whichLabel, stringLabel );
     	} else if (whichLabel == L_BOTTOM_HORIZ) {
            layoutChange = labels.setLabel( widget, "PiechartLabelHoriz",
					 whichLabel, stringLabel );
     	}

	if ( layoutChange ) {
            int piechartLayoutXOrg, piechartLayoutYOrg;
            int piechartWidthProportion, piechartHeightProportion;
            _findPiechartFormPosition( &piechartLayoutXOrg, &piechartLayoutYOrg,
			 	       &piechartWidthProportion, 
				       &piechartHeightProportion );
            _setPiechartFormPosition( piechartLayoutXOrg, piechartLayoutYOrg,
			              piechartWidthProportion, 
				      piechartHeightProportion );
     	}
}

void 
PiechartFormWrapper::setPerfWidgetColors()
{
  	static char *newcolors [] = { 
	  	"#ff0000",
		"#00ff00",
	  	"#0000ff",
	  	"#00ffff",
	  	"#ff00ff",
	  	"#ffff00",	
	  	"#b03060",
	  	"#458b00",
	  	"#ff0000",
	  	"#00ff00",
	  	"#0000ff",
	  	"#00ffff",
	  	"#ff00ff",
	  	"#ffff00",
	  	"#b03060",
	  	"#458b00",
	  	"#ff0000",
	  	"#00ff00",
	  	"#00ffff",
	  	"#ff00ff",
	  	"#ffff00",
	  	"#b03060",
	  	"#458b00",
	  	"#ff0000",
	  	"#00ff00",
	  	"#0000ff",
	  	"#00ffff",
	  	"#0000ff"
   	};
   	const int numNewColors = 28;

	if ( ! colorsSet ) {
   	     colorTable.loadNewColormap( newcolors, numNewColors );
   	     colorTable.gencolor( getDisplay(), getScreen() );
   	     PiechartSetColors( (PiechartWidget) piechartChild,
		      	         colorTable.getNumColors(),
	                         colorTable.getColormapEntries() );
	     colorsSet = TRUE_;
	}
}

/*
 *      Initialize the static data.   Only executed once.
 */
const char *const PiechartFormWrapper::MY_CLASS = "PiechartFormWrapper";

