/*
 * This file is part of the Pablo Performance Analysis Environment
 *
 *                                           TM
 * The Pablo Performance Analysis Environment   software is *not* in
 * the public domain.  However, it is freely available without fee for
 * education, research, and non-profit purposes.  By obtaining copies
 * of this and other files that comprise the Pablo Performance Analysis
 * Environment, you, the Licensee, agree to abide by the following
 * conditions and understandings with respect to the copyrighted software:
 * 
 * 1.  The software is copyrighted in the name of the Board of Trustees
 *     of the University of Illinois (UI), and ownership of the software
 *     remains with the UI. 
 *
 * 2.  Permission to use, copy, and modify this software and its documentation
 *     for education, research, and non-profit purposes is hereby granted
 *     to Licensee, provided that the copyright notice, the original author's
 *     names and unit identification, and this permission notice appear on
 *     all such copies, and that no charge be made for such copies.  Any
 *     entity desiring permission to incorporate this software into commercial
 *     products should contact:
 *
 *          Professor Daniel A. Reed                 reed@cs.uiuc.edu
 *          University of Illinois
 *          Department of Computer Science
 *          2413 Digital Computer Laboratory
 *          1304 West Springfield Avenue
 *          Urbana, Illinois  61801
 *          USA
 *
 * 3.  Licensee may not use the name, logo, or any other symbol of the UI
 *     nor the names of any of its employees nor any adaptation thereof in
 *     advertizing or publicity pertaining to the software without specific
 *     prior written approval of the UI.
 *
 * 4.  THE UI MAKES NO REPRESENTATIONS ABOUT THE SUITABILITY OF THE
 *     SOFTWARE FOR ANY PURPOSE.  IT IS PROVIDED "AS IS" WITHOUT EXPRESS
 *     OR IMPLIED WARRANTY.
 *
 * 5.  The UI shall not be liable for any damages suffered by Licensee from
 *     the use of this software.
 *
 * 6.  The software was developed under agreements between the UI and the
 *     Federal Government which entitle the Government to certain rights.
 *
 **************************************************************************
 *
 * Developed by: The TAPESTRY Parallel Computing Laboratory
 *		 University of Illinois at Urbana-Champaign
 *		 Department of Computer Science
 *		 1304 W. Springfield Avenue
 *		 Urbana, IL	61801
 *
 * Copyright (c) 1987-1994
 * The University of Illinois Board of Trustees.
 *	All Rights Reserved.
 *
 * Author: Robert Olson (olson@cs.uiuc.edu)
 * Contributing Author: Ruth A. Aydt (aydt@cs.uiuc.edu)
 * Project Manager and Principal Investigator:
 *	Daniel A. Reed (reed@cs.uiuc.edu)
 *
 * Funded by: National Science Foundation grants NSF CCR86-57696,
 * NSF CCR87-06653 and NSF CDA87-22836 (Tapestry), NASA ICLASS Contract
 * No. NAG-1-613, DARPA Contract No. DABT63-91-K-0004, by a grant
 * from the Digital Equipment Corporation External Research Program,
 * and by a collaborative research agreement with the Intel Supercomputer
 * Systems Division.
 *
 */
/*
 * PerfWidget.cc:  Class wrapper for the performance widgets  
 *
 *	$Header: /mnt/Pablo-guitar/Stable.2-94/Visual/Src/Widgets/Wrappers/RCS/PerfWidget.C,v 1.9 1994/02/25 04:44:32 aydt Exp $
 */

#include "PerfWidget.h"
#include "XArgs.h"

PerfWidget::PerfWidget(WidgetBase *par) : WidgetBase(par)
{
}

PerfWidget::~PerfWidget()
{
}

#ifndef XtNselect
#define XtNselect	"select"
#endif

void PerfWidget::addSelectionCallback(XtCallbackProc proc, void *value)
{
	XArgs xargs;
	XtCallbackList list;
	XtCallbackRec *r;
	int nRecs, i;

	xargs.addArg(XtNselect, (XtArgVal) &list);
	getArgs(xargs);

	cout << form("addSelectionCallback proc=0x%x value=0x%x\n",
	       proc, value);


	nRecs = 0;
	for (r = list; r->callback != NULL; r++)
	{
		cout << form("r=%x r->proc=%x r->data=%x\n", r, r->callback,
		       r->closure);
		if (r->callback == proc && r->closure == value)
		{
			cout << form("Warning: callback already present\n");
		}
		nRecs++;
	}

	XtCallbackRec *newList = new XtCallbackRec[nRecs + 2];

	for (i = 0; i < nRecs; i++)
		newList[i] = list[i];
	newList[i].callback = proc;
	newList[i].closure = value;
	i++;
	newList[i].callback = NULL;
	newList[i].closure = NULL;

	xargs.reset();
	xargs.addArg(XtNselect, (XtArgVal) newList);
	setArgs(xargs);
}

void PerfWidget::deleteSelectionCallback(XtCallbackProc proc, void *value)
{
	XArgs xargs;
	XtCallbackList list;
	XtCallbackRec *r;
	int nRecs, i, j;
	int procIndex = -1;

	xargs.addArg(XtNselect, (XtArgVal) &list);
	getArgs(xargs);

	cout << form("DeleteSelectionCallback proc=0x%x value=0x%x\n",
	       proc, value);

	displaySelectionCallbacks(cout);

	nRecs = 0;
	for (r = list; r->callback != NULL; r++)
	{
		cout << form("r=%x r->proc=%x r->data=%x\n", r, r->callback,
		       r->closure);
		if (r->callback == proc && r->closure == value)
		{
			procIndex = r - list;
		}
		nRecs++;
	}
	if (procIndex == -1)
	{
		cout << "Warning: proc not found in deleteSelectionCallback\n";
		return;
	}

	cout << form("got procIndex=%d\n", procIndex);
	XtCallbackRec *newList = new XtCallbackRec[nRecs + 1];

	j = 0;
	for (i = 0; i < nRecs; i++)
	{
		if (i != procIndex)
		{
			cout << form("assigning new %d = old %d\n", j, i);
			newList[j] = list[i];
			j++;
		}
	}
	newList[j].callback = NULL;
	newList[j].closure = NULL;

	cout << "new list:\n";
	for (r = newList; r->callback != NULL; r++)
	{
		cout << form("r=%x r->proc=%x r->data=%x\n", r, r->callback,
			     r->closure);
	}

	xargs.reset();
	xargs.addArg(XtNselect, (XtArgVal) newList);
	setArgs(xargs);

	cout <<  "new callbacks:\n";
	displaySelectionCallbacks(cout);
}

void PerfWidget::displaySelectionCallbacks(ostream &os)
{
	XArgs xargs;
	XtCallbackList list;
	XtCallbackRec *r;

	xargs.addArg(XtNselect, (XtArgVal) &list);
	getArgs(xargs);

	os << "displaySelectionCallbacks:\n";

	for (r = list; r->callback != NULL; r++)
	{
		os << form("    r=%x r->proc=%x r->data=%x\n",
			   r, r->callback, r->closure);
	}
}

void 
PerfWidget::getPerfWidgetPosition( int *x, int *y, int *width, int *height )
{
	
	/* 
	 * First, we get the information on our parent in the the WidgetBase
	 * hierarchy.  This should be a FormDialog instance.  
	 * Remember, this FormDialog has children LabelWidget and PerfWidget.
	 */
	XArgs 		xargs;
	Position 	px, py;
	Dimension	pwidth, pheight;

	xargs.addArg( XmNx, (XtArgVal) &px );
	xargs.addArg( XmNy, (XtArgVal) &py );
	xargs.addArg( XtNwidth, (XtArgVal) &pwidth );
	xargs.addArg( XtNheight, (XtArgVal) &pheight );

	WidgetBase *parent = getParent();
	parent->getArgs( xargs );

	/* 
	 * Now, we jump "outside" the WidgetBase tree, and get the parent
	 * widget of the FormDialog Widget. This will have the offsets 
	 * accounting for the decoration of any window managers.  
	 * It seems MWM has zero offsets.  Twm has non-zero offsets.
	 */

	XWindowAttributes gpattrs;
	Widget   gpwidget = XtParent( parent->getWidget() );
	Display *gpdisplay = XtDisplay( gpwidget );
	Window   gpwindow = XtWindow( gpwidget );
	XGetWindowAttributes( gpdisplay, gpwindow, &gpattrs );

	*x = (int) px - gpattrs.x;
	*y = (int) py - gpattrs.y;
	*width = (int) pwidth;
	*height = (int) pheight;
}

void 
PerfWidget::setPerfWidgetPosition( int x, int y, int width, int height )
{
	
	XArgs 		xargs;

	Position	wx, wy;
	Dimension	wwidth, wheight;

	wx = (Position) x;
	wy = (Position) y;
	wwidth = (Position) width;
	wheight = (Position) height;

	xargs.addArg( XmNx, (XtArgVal) wx );
	xargs.addArg( XmNy, (XtArgVal) wy );
	xargs.addArg( XmNwidth, (XtArgVal) wwidth );
	xargs.addArg( XmNheight, (XtArgVal) wheight );

	WidgetBase *parent = getParent();
	parent->setArgs( xargs );
}
