/*
 * This file is part of the Pablo Performance Analysis Environment
 *
 *                                           TM
 * The Pablo Performance Analysis Environment   software is *not* in
 * the public domain.  However, it is freely available without fee for
 * education, research, and non-profit purposes.  By obtaining copies
 * of this and other files that comprise the Pablo Performance Analysis
 * Environment, you, the Licensee, agree to abide by the following
 * conditions and understandings with respect to the copyrighted software:
 * 
 * 1.  The software is copyrighted in the name of the Board of Trustees
 *     of the University of Illinois (UI), and ownership of the software
 *     remains with the UI. 
 *
 * 2.  Permission to use, copy, and modify this software and its documentation
 *     for education, research, and non-profit purposes is hereby granted
 *     to Licensee, provided that the copyright notice, the original author's
 *     names and unit identification, and this permission notice appear on
 *     all such copies, and that no charge be made for such copies.  Any
 *     entity desiring permission to incorporate this software into commercial
 *     products should contact:
 *
 *          Professor Daniel A. Reed                 reed@cs.uiuc.edu
 *          University of Illinois
 *          Department of Computer Science
 *          2413 Digital Computer Laboratory
 *          1304 West Springfield Avenue
 *          Urbana, Illinois  61801
 *          USA
 *
 * 3.  Licensee may not use the name, logo, or any other symbol of the UI
 *     nor the names of any of its employees nor any adaptation thereof in
 *     advertizing or publicity pertaining to the software without specific
 *     prior written approval of the UI.
 *
 * 4.  THE UI MAKES NO REPRESENTATIONS ABOUT THE SUITABILITY OF THE
 *     SOFTWARE FOR ANY PURPOSE.  IT IS PROVIDED "AS IS" WITHOUT EXPRESS
 *     OR IMPLIED WARRANTY.
 *
 * 5.  The UI shall not be liable for any damages suffered by Licensee from
 *     the use of this software.
 *
 * 6.  The software was developed under agreements between the UI and the
 *     Federal Government which entitle the Government to certain rights.
 *
 **************************************************************************
 *
 * Developed by: The TAPESTRY Parallel Computing Laboratory
 *		 University of Illinois at Urbana-Champaign
 *		 Department of Computer Science
 *		 1304 W. Springfield Avenue
 *		 Urbana, IL	61801
 *
 * Copyright (c) 1987-1994
 * The University of Illinois Board of Trustees.
 *	All Rights Reserved.
 *
 * Author: Bradley Schwartz (schwartz@cs.uiuc.edu)
 * Project Manager and Principal Investigator:
 *	Daniel A. Reed (reed@cs.uiuc.edu)
 *
 * Funded by: National Science Foundation grants NSF CCR86-57696,
 * NSF CCR87-06653 and NSF CDA87-22836 (Tapestry), NASA ICLASS Contract
 * No. NAG-1-613, DARPA Contract No. DABT63-91-K-0004, by a grant
 * from the Digital Equipment Corporation External Research Program,
 * and by a collaborative research agreement with the Intel Supercomputer
 * Systems Division.
 *
 */

#include "ParallelCoordsFormWrapper.h"
#define OurDisplay          ( XtDisplay(dataForm) )


ParallelCoordsFormWrapper::ParallelCoordsFormWrapper( Widget PCparent,
					    ParallelCoordsFU *PCFUPtr )
{
        pcMainWindow = XtVaAppCreateShell( "ParallelCoordinates",
					   "PC",
					   topLevelShellWidgetClass,
					   XtDisplay(PCparent),
					      NULL );
	Widget pcMainContainer = XtVaCreateManagedWidget( "PCContainer",
							  xmFormWidgetClass,
							  pcMainWindow,
							     NULL );
	dataForm = XtVaCreateManagedWidget( "PCDataWidgetForm",
					    xmFormWidgetClass,
					    pcMainContainer,
					       NULL );
	statusForm = XtVaCreateManagedWidget( "PCstatusForm",
					      xmFormWidgetClass,
					      pcMainContainer,
					          NULL );
	int statusFormHeight = _setupStatusArea( statusForm );

	interactionForm = XtVaCreateManagedWidget( "PCInteractionForm",
						    xmFormWidgetClass,
						    pcMainContainer,
						       NULL );
         _setupInteractionArea( interactionForm );
	XtVaSetValues( dataForm,
		       XmNtopWidget, statusForm,
		       XmNbottomWidget, interactionForm,
		           NULL );
	PCFUthisPtr = PCFUPtr;
	pcWidget = NULL;
	dim = 0;
}


ParallelCoordsFormWrapper::~ParallelCoordsFormWrapper()
{
}


/*
Widget
ParallelCoordsFormWrapper::_createClusteringWindow()
{
        static PCInteractionOptions data;
	static PCClusteringOptions specificData;
	data.specificData = &specificData;
	specificData.numberOfClusters = 1;
	specificData.writeClusterReps = False;

	data.tag = PC_TAG_CLUSTERING;
	data.mainWindow = XtVaAppCreateShell( "PCClusteringMainWindow",
					        "PCclustering",
					         applicationShellWidgetClass,
					         OurDisplay,
					            NULL );
	Widget clusteringMainContainer = XtVaCreateManagedWidget(
					        "ClusteringMainContainer",
						xmFormWidgetClass,
						data.mainWindow,
						   NULL );
	Widget clusteringActionArea = XtVaCreateManagedWidget( 
					     "ClusteringActionArea",
					      xmFormWidgetClass,
					      clusteringMainContainer,
					         NULL );
	Widget clusterNumberArea = addTextFieldToDialog( clusteringActionArea,
							 NULL,
							 "ClusterNumber",
			       &(clusteringOptions.numberOfClustersWidget ) );

	char defaultNumberOfClusters[STRING_MAX_LEN];
	sprintf( defaultNumberOfClusters, "%d",specificData.numberOfClusters );
	XtVaSetValues( clusteringOptions.numberOfClustersWidget,
		       XmNvalue, defaultNumberOfClusters,
		          NULL );

	Widget clusterWriteRepsArea = addToggleToDialog( clusteringActionArea,
							 clusterNumberArea,
							   "ClusterWriteReps",
			       &(clusteringOptions.numberOfClustersWidget ) );

	Widget clusteringControlArea = XtVaCreateManagedWidget(
					  "ClusteringControlArea",
					  xmFormWidgetClass,	
					  clusteringMainContainer,
					  XmNtopWidget, clusteringActionArea,
						   NULL );
	Widget dismissButton = XtVaCreateManagedWidget( "DialogDismissButton",
					              xmPushButtonWidgetClass,
					              clusteringControlArea,
						          NULL );
	addCallback( dismissButton, XmNactivateCallback,
		     &Callback::callback2, this, &data );
        return(data.mainWindow);
}
*/

Widget
ParallelCoordsFormWrapper::_createPreferenceSheet()
{
        static PCInteractionOptions data;
        static PCPreferenceOptions specificData;
	data.specificData = &specificData;
	data.tag = PC_TAG_PREFERENCES;

	specificData.numberOptions = 1;
	specificData.toggleOptions = 
	                 (Widget *)XtMalloc( specificData.numberOptions *
					     sizeof(Widget) );

        data.mainWindow = XtVaAppCreateShell(  "PCPreferenceSheetMainWindow",
					       "PCPreferenceSheet",
					       applicationShellWidgetClass,
					       OurDisplay,
					          NULL );
	Widget sheetMainContainer = XtVaCreateManagedWidget(
					     "PreferenceSheetMainContainer",
					      xmFormWidgetClass,
					      data.mainWindow,
						 NULL );
	Widget sheetActionArea = XtVaCreateManagedWidget( 
					     "PreferenceSheetActionArea",
					      xmFormWidgetClass,
					      sheetMainContainer,
					         NULL );
	Widget autoscaleToggleArea = addToggleToDialog( sheetActionArea,
						        NULL,
				 	        "PreferenceSheetAutoscale",
					   &(specificData.toggleOptions[0]) );
	Widget sheetControlArea = XtVaCreateManagedWidget(
					     "PreferenceSheetControlArea",
					     xmFormWidgetClass,
					     sheetMainContainer,
					     XmNtopWidget, sheetActionArea,
						 NULL );
	Widget dismissButton = XtVaCreateManagedWidget( 
					     "DialogDismissButton",
					     xmPushButtonWidgetClass,
					     sheetControlArea,
						  NULL );
	addCallback( dismissButton, XmNactivateCallback,
		     &Callback::callback2, this, &data );

	return( data.mainWindow );
}


/*
Widget
ParallelCoordsFormWrapper::_createPreprocessWindow()
{
        static PCInteractionOptions data;
	static PCPreprocessOptions specificData;
	
	data.tag = PC_TAG_PREPROCESSING;
	data.specificData = &specificData;

	specificData.numberOptions = 3;
	specificData.toggleOptions = (Widget *)XtMalloc(
 		          specificData.numberOptions * sizeof(Widget) );
	data.mainWindow = XtVaAppCreateShell( "PCPreprocessingMainWindow",
					      "PCpreprocessing",
					      applicationShellWidgetClass,
					      OurDisplay,
					         NULL );
	Widget preprocessMainContainer = XtVaCreateManagedWidget(
					     "PreprocessMainContainer",
					      xmFormWidgetClass,
					      data.mainWindow,
						 NULL );
	Widget preprocessActionArea = XtVaCreateManagedWidget( 
					     "PreprocessActionArea",
					      xmFormWidgetClass,
					      preprocessMainContainer,
					         NULL ); 
	Widget preprocessExtractArea = addToggleListToDialog(
					     preprocessActionArea,
			                     "PreprocessExtract",
			                     2,
					     &(specificData.toggleOptions[0]),
			                     &(specificData.toggleOptions[1]));
	Widget preprocessTransformArea = addToggleToDialog(
					     preprocessActionArea,
					     preprocessExtractArea,	   
					     "PreprocessTransform",
					     &(specificData.toggleOptions[2]));

	Widget preprocessControlArea = XtVaCreateManagedWidget(
					  "PreprocessControlArea",
					  xmFormWidgetClass,
					  preprocessMainContainer,
					  XmNtopWidget, preprocessActionArea,
					      NULL );
	Widget dismissButton = XtVaCreateManagedWidget( 
					     "DialogDismissButton",
					     xmPushButtonWidgetClass,
					     preprocessControlArea,
						  NULL );
	addCallback( dismissButton, XmNactivateCallback,
		     &Callback::callback2, this, &data );
	return( data.mainWindow );
}
	
*/

void
ParallelCoordsFormWrapper::_setPCDataWidgets( int dimension )
{
        pcWidget =  XtVaCreateManagedWidget( "PCdataWidget",
				              parallelCoordsWidgetClass,
			                      dataForm,
				              XtNnumAxes, dimension,
					         NULL );
}


void
ParallelCoordsFormWrapper::_setPCLabelWidgets( int dimension )
{
        Widget newLabel;
        int i;
	for (i=0; i<dimension; i++) {
            newLabel = XtVaCreateWidget( "PCLabelWidget",
					  xmLabelWidgetClass,
					  dataForm,
					     NULL );
	    pcLabels.setElement(i, newLabel );
	}
}


void
ParallelCoordsFormWrapper::_setupInteractionArea( Widget parentWidget )
{
	Widget preferencesButton = XtVaCreateManagedWidget(
					      "PCPreferencesButton",
					      xmPushButtonWidgetClass,
					      parentWidget,
						  NULL );
	addCallback( preferencesButton, XmNactivateCallback,
		     &Callback::callback1, this, NULL );
}



int
ParallelCoordsFormWrapper::_setupStatusArea( Widget parentWidget )
{
        Widget pointSetLabel = XtVaCreateManagedWidget("PCpointSetNameLabel",
						        xmLabelWidgetClass,
						       parentWidget,
						            NULL );
	statusInformation.pointSetName = XtVaCreateManagedWidget(
					         "PCpointSetNameText",
					         xmLabelWidgetClass,
					         parentWidget,
					         XmNleftWidget, pointSetLabel,
						     NULL );
	Widget pointCountLabel = XtVaCreateManagedWidget( "PCpointCountLabel",
			        xmLabelWidgetClass,
			        parentWidget,
			        XmNleftWidget, statusInformation.pointSetName,
				    NULL );
	statusInformation.pointCount = XtVaCreateManagedWidget(
					       "PCpointCountText",
					       xmLabelWidgetClass,
					       parentWidget,
			     	               XmNleftWidget, pointCountLabel,
						   NULL );
	Dimension height;
	XtVaGetValues( pointSetLabel,
		       XmNheight, &height,
		          NULL );
	return( (int)height );
}


void
ParallelCoordsFormWrapper::_updateFormOffsets()
{
        static Dimension currentStatusAreaHeight = 0;

	Dimension statusAreaHeight;
	XtVaGetValues( statusInformation.pointSetName,
		       XmNheight, &statusAreaHeight,
		           NULL );
	if ( statusAreaHeight > currentStatusAreaHeight ) {
	   XtVaSetValues( dataForm,
		          XmNtopOffset, (int)statusAreaHeight,
			     NULL );
	   currentStatusAreaHeight = statusAreaHeight;
	}
}


void
ParallelCoordsFormWrapper::callback1( Widget callbackWidget,
				      XtPointer ptr1,XtPointer ptr2 )
{
	ptr1 = ptr1;
	ptr2 = ptr2;
	callbackWidget = callbackWidget;
        static Boolean preferenceSheetIsCreated = False;
        static Widget preferenceSheetMainWindow;

	if ( strcmp( XtName(callbackWidget),"PCPreferencesButton" ) == 0 ) {
           if ( ! preferenceSheetIsCreated ) {
              preferenceSheetMainWindow = _createPreferenceSheet();
	      preferenceSheetIsCreated = True;
	   }
	   XtPopup( preferenceSheetMainWindow, XtGrabNone );
        }
}


// This callback handles dialog window close
void
ParallelCoordsFormWrapper::callback2( Widget callbackWidget,
				      XtPointer ptr1, XtPointer ptr2 )
{
	callbackWidget = callbackWidget;
	ptr2 = ptr2;
        PCInteractionOptions *data = (PCInteractionOptions *)ptr1;
	XtPopdown( data->mainWindow );

	void *specificData = data->specificData;
	switch( data->tag ) {
  	   case PC_TAG_PREPROCESSING:
	       PCFUthisPtr->fuCallback2( (PCPreprocessOptions *)specificData);
               break;
	   case PC_TAG_CLUSTERING:
	       break;
	   case PC_TAG_PREFERENCES:
	       break;
	   default:
	       break;
	}
}

	
char *
ParallelCoordsFormWrapper::getCategoryLabel( int theDimension )
{
        char *categoryText;

	if ( theDimension >= dim ) return( (char *)NULL );

	XmString categoryString;
	XtVaGetValues( (Widget)pcLabels.getElement(theDimension),
		       XmNlabelString, &categoryString,
		          NULL );
	XmStringGetLtoR( categoryString, XmSTRING_DEFAULT_CHARSET,
			 &categoryText );
	return( categoryText );
}


void
ParallelCoordsFormWrapper::getPCAttr( String name, XtArgVal value )
{
        XtVaGetValues( pcWidget,
		       name, value,
		          NULL );
}


void
ParallelCoordsFormWrapper::getPerfWidgetPosition( int& x, int& y,
						  int& width, int& height )
{
        Position widgetX, widgetY;
	Dimension widgetWidth, widgetHeight;

	XtVaGetValues( pcMainWindow,
		       XmNx, &widgetX,
		       XmNy, &widgetY,
		       XmNwidth, &widgetWidth,
		       XmNheight, &widgetHeight,
		          NULL );
	x = (int)widgetX;
	y = (int)widgetY;
	width = (int)widgetWidth;
	height = (int)widgetHeight;
}


char *
ParallelCoordsFormWrapper::getPointSetName()
{
        XmString pointSetString;
	XtVaGetValues( statusInformation.pointSetName,
		       XmNlabelString, &pointSetString,
		          NULL );
	char *pointSetLabel;
	XmStringGetLtoR( pointSetString,
			 XmSTRING_DEFAULT_CHARSET, &pointSetLabel );
	return( pointSetLabel );
}


void 
ParallelCoordsFormWrapper::realize()
{
        XtRealizeWidget( pcMainWindow );

	/* update the offset for the interaction area */
	Dimension height;
	XtVaGetValues( interactionForm,
		       XmNheight, &height,
		          NULL );
        XtVaSetValues( dataForm,
		       XmNbottomOffset, (int)height,
		          NULL );
}


void
ParallelCoordsFormWrapper::setCategoryLabel( const char *categoryLabel,
					     int theDimension )
{
	categoryLabel = categoryLabel;
	theDimension = theDimension;
}


void
ParallelCoordsFormWrapper::setDimension( int dimension )
{
       _setPCDataWidgets( dimension );
       _setPCLabelWidgets( dimension );
       dim = dimension;
}


void
ParallelCoordsFormWrapper::setPCAttr( int x, int y,
				      int width, int height )
{
        static char geometry[STRING_MAX_LEN];

	sprintf( geometry, "%dx%d+%d+%d", width, height, x, y );
	XtVaSetValues( pcMainWindow,
		       XtNgeometry, geometry,
		          NULL );
}

void
ParallelCoordsFormWrapper::setPCValues( int *nDimDataPoints,
				        int pointCount )
{
        ParallelCoordsSetValues(  (ParallelCoordsWidget)pcWidget,
	                          nDimDataPoints, pointCount );
	if ( pointCount % 10 == 0 ) {
           setPointCount( pointCount );
	}
}
				 

void
ParallelCoordsFormWrapper::setPCValues( int *dataPoint )
{
        static int pointCount = 0;

	ParallelCoordsSetValue( (ParallelCoordsWidget)pcWidget, dataPoint );
	pointCount++;
	if ( pointCount % 10 == 0 ) {
           setPointCount( pointCount );
	}
}
	
	
void
ParallelCoordsFormWrapper::setPerfWidgetColors()
{
}


void
ParallelCoordsFormWrapper::setPointCount( int numPoints )
{
        static char pointCountText[STRING_MAX_LEN];
	static XmString pointCountString;

	sprintf( pointCountText, "%d", numPoints );
	pointCountString = XmStringCreateSimple( pointCountText );
	XtVaSetValues( statusInformation.pointCount,
		       XmNlabelString, pointCountString,
		          NULL );
}


void
ParallelCoordsFormWrapper::setPointSetName( char *pointSetName )
{
        XmString pointSetString = XmStringCreateSimple( pointSetName );
	XtVaSetValues( statusInformation.pointSetName,
		       XmNlabelString, pointSetString,
		          NULL );
        _updateFormOffsets();
}



