/*
 * This file is part of the Pablo Performance Analysis Environment
 *
 *                                           TM
 * The Pablo Performance Analysis Environment   software is *not* in
 * the public domain.  However, it is freely available without fee for
 * education, research, and non-profit purposes.  By obtaining copies
 * of this and other files that comprise the Pablo Performance Analysis
 * Environment, you, the Licensee, agree to abide by the following
 * conditions and understandings with respect to the copyrighted software:
 * 
 * 1.  The software is copyrighted in the name of the Board of Trustees
 *     of the University of Illinois (UI), and ownership of the software
 *     remains with the UI. 
 *
 * 2.  Permission to use, copy, and modify this software and its documentation
 *     for education, research, and non-profit purposes is hereby granted
 *     to Licensee, provided that the copyright notice, the original author's
 *     names and unit identification, and this permission notice appear on
 *     all such copies, and that no charge be made for such copies.  Any
 *     entity desiring permission to incorporate this software into commercial
 *     products should contact:
 *
 *          Professor Daniel A. Reed                 reed@cs.uiuc.edu
 *          University of Illinois
 *          Department of Computer Science
 *          2413 Digital Computer Laboratory
 *          1304 West Springfield Avenue
 *          Urbana, Illinois  61801
 *          USA
 *
 * 3.  Licensee may not use the name, logo, or any other symbol of the UI
 *     nor the names of any of its employees nor any adaptation thereof in
 *     advertizing or publicity pertaining to the software without specific
 *     prior written approval of the UI.
 *
 * 4.  THE UI MAKES NO REPRESENTATIONS ABOUT THE SUITABILITY OF THE
 *     SOFTWARE FOR ANY PURPOSE.  IT IS PROVIDED "AS IS" WITHOUT EXPRESS
 *     OR IMPLIED WARRANTY.
 *
 * 5.  The UI shall not be liable for any damages suffered by Licensee from
 *     the use of this software.
 *
 * 6.  The software was developed under agreements between the UI and the
 *     Federal Government which entitle the Government to certain rights.
 *
 **************************************************************************
 *
 * Developed by: The TAPESTRY Parallel Computing Laboratory
 *		 University of Illinois at Urbana-Champaign
 *		 Department of Computer Science
 *		 1304 W. Springfield Avenue
 *		 Urbana, IL	61801
 *
 * Copyright (c) 1987-1994
 * The University of Illinois Board of Trustees.
 *	All Rights Reserved.
 *
 * Author: Daniel A. Reed (reed@cs.uiuc.edu)
 * Contributing Author:  Bradley W. Schwartz (schwartz@cs.uiuc.edu)
 *			 Ruth A. Aydt (aydt@cs.uiuc.edu)
 *
 * Project Manager and Principal Investigator:
 *	Daniel A. Reed (reed@cs.uiuc.edu)
 *
 * Funded by: National Science Foundation grants NSF CCR86-57696,
 * NSF CCR87-06653 and NSF CDA87-22836 (Tapestry), NASA ICLASS Contract
 * No. NAG-1-613, DARPA Contract No. DABT63-91-K-0004, by a grant
 * from the Digital Equipment Corporation External Research Program,
 * and by a collaborative research agreement with the Intel Supercomputer
 * Systems Division.
 *
 */
/*
 * KiviatFormWrapper.h: A class wrapper for the Kiviat performance widget
 *
 *	$Header: /mnt/Pablo-guitar/Stable.2-94/Visual/Src/Widgets/Wrappers/RCS/KiviatFormWrapper.h,v 1.10 1994/02/25 04:44:48 aydt Exp $
 */
#ifndef KiviatFormWrapper_h
#define KiviatFormWrapper_h

#include "KiviatFU.h"
#include "DisplayLabels.h"
#include "PerfWidget.h"

class KiviatFormWrapper : public PerfWidget {
/*
* A KiviatFormWrapper is the C++ wrapper for the Kiviat display widget.
*/

private:
	static const char *const MY_CLASS;

	DisplayLabels 	labels;
	Widget 		kiviatChild;
	KiviatFU 	*kiviatFUthisPtr;

	/* Method _findKiviatFormPosition:   Layout elements within the form  */
	void _findKiviatFormPosition( int *kiviatLayoutXOrg, 
	 			      int *kiviatLayoutYOrg,
	              		      int *kiviatWidthProportion, 
				      int *kiviatHeightProportion );

	/* Method _setKiviatFormPosition:    Sets the layout attributes for
	*			             the kiviat within the form       */
	void _setKiviatFormPosition( int kiviatLayoutXOrg,
				     int kiviatLayoutYOrg,
	              		     int kiviatWidthProportion, 
				     int kiviatHeightProportion ); 
public:
	/* Method KiviatFormWrapper: 	     The KiviatWrapper Constructor    */
	KiviatFormWrapper( WidgetBase *par, KiviatFU *kiviatFUPtr,
			   const XArgs& args, const CString& name );

	/* Method ~KiviatFormWrapper: 	     The destructor                   */
	~KiviatFormWrapper();

	/* Method callback1:		     Overloads Callback::callback1 to
	*				     handle callback in the display   */
	virtual void callback1( Widget, XtPointer, XtPointer );

	/* Method getKiviatAttr:	     Get attribute of individual Kiviat
	*				     widget.                          */
        void getKiviatAttr( String name, XtArgVal value ) const;

	/* Method getKiviatFormAttr:	     Get attribute of the Form widget */
        void getKiviatFormAttr( String name, XtArgVal value ) const;

	/* Method getKiviatLabel:	     Set aLabel to point to text string
	*				     for label specified.  If label is
	*				     not set, then aLabel points to a
	*				     null string.                     */
	void getKiviatLabel( int whichLabel, const char **aLabel ) const;

	/* Method setDisplayValues:	     Sets the kiviat values for vector.
	*				     if numAxes has changed since last
	*				     call, adjustment is made.        */
	void setDisplayValues( int numAxes, int *values );

	/* Method setKiviatAttr:	     Set attribute of individual Kiviat
	*				     widget.                          */
        void setKiviatAttr( String name, XtArgVal value );

	/* Method setKiviatFormAttr:	     Set attribute of the Form widget */
        void setKiviatFormAttr( String name, XtArgVal value );

	/* Method setKiviatLabel:	     Set the min and max labels on the
	*				     Form                             */
        void setKiviatLabel( double fuMin, double fuMax );

	/* Method setKiviatLabel:	     Set the Horizontal or Vertical
	*				     Label.                           */
        void setKiviatLabel( int whichLabel, const char *stringLabel );

};

#endif
