/*
 * This file is part of the Pablo Performance Analysis Environment
 *
 *                                           TM
 * The Pablo Performance Analysis Environment   software is *not* in
 * the public domain.  However, it is freely available without fee for
 * education, research, and non-profit purposes.  By obtaining copies
 * of this and other files that comprise the Pablo Performance Analysis
 * Environment, you, the Licensee, agree to abide by the following
 * conditions and understandings with respect to the copyrighted software:
 * 
 * 1.  The software is copyrighted in the name of the Board of Trustees
 *     of the University of Illinois (UI), and ownership of the software
 *     remains with the UI. 
 *
 * 2.  Permission to use, copy, and modify this software and its documentation
 *     for education, research, and non-profit purposes is hereby granted
 *     to Licensee, provided that the copyright notice, the original author's
 *     names and unit identification, and this permission notice appear on
 *     all such copies, and that no charge be made for such copies.  Any
 *     entity desiring permission to incorporate this software into commercial
 *     products should contact:
 *
 *          Professor Daniel A. Reed                 reed@cs.uiuc.edu
 *          University of Illinois
 *          Department of Computer Science
 *          2413 Digital Computer Laboratory
 *          1304 West Springfield Avenue
 *          Urbana, Illinois  61801
 *          USA
 *
 * 3.  Licensee may not use the name, logo, or any other symbol of the UI
 *     nor the names of any of its employees nor any adaptation thereof in
 *     advertizing or publicity pertaining to the software without specific
 *     prior written approval of the UI.
 *
 * 4.  THE UI MAKES NO REPRESENTATIONS ABOUT THE SUITABILITY OF THE
 *     SOFTWARE FOR ANY PURPOSE.  IT IS PROVIDED "AS IS" WITHOUT EXPRESS
 *     OR IMPLIED WARRANTY.
 *
 * 5.  The UI shall not be liable for any damages suffered by Licensee from
 *     the use of this software.
 *
 * 6.  The software was developed under agreements between the UI and the
 *     Federal Government which entitle the Government to certain rights.
 *
 **************************************************************************
 *
 * Developed by: The TAPESTRY Parallel Computing Laboratory
 *		 University of Illinois at Urbana-Champaign
 *		 Department of Computer Science
 *		 1304 W. Springfield Avenue
 *		 Urbana, IL	61801
 *
 * Copyright (c) 1987-1994
 * The University of Illinois Board of Trustees.
 *	All Rights Reserved.
 *
 * Author: Daniel A. Reed (reed@cs.uiuc.edu)
 * Contributing Author: Bradley W. Schwartz (schwartz@cs.uiuc.edu)
 *
 * Project Manager and Principal Investigator:
 *	Daniel A. Reed (reed@cs.uiuc.edu)
 *
 * Funded by: National Science Foundation grants NSF CCR86-57696,
 * NSF CCR87-06653 and NSF CDA87-22836 (Tapestry), NASA ICLASS Contract
 * No. NAG-1-613, DARPA Contract No. DABT63-91-K-0004, by a grant
 * from the Digital Equipment Corporation External Research Program,
 * and by a collaborative research agreement with the Intel Supercomputer
 * Systems Division.
 *
 */
/*
 * BubbleFormWrapper.h: A class wrapper for the bubble performance widget
 *
 *	$Header: /mnt/Pablo-guitar/Stable.2-94/Visual/Src/Widgets/Wrappers/RCS/BubbleFormWrapper.h,v 1.10 1994/02/25 04:44:59 aydt Exp $
 */


#ifndef BubbleFormWrapper_h
#define BubbleFormWrapper_h

#include "PerfWidget.h"
#include "DisplayColorTables.h"  /* Maintains widget color table information */
#include "DisplayLabels.h"       /* Handles all widget labelling functions */

#include "BubbleFU.h"



class BubbleFormWrapper : public PerfWidget {
/*
*
* A BubbleFormWrapper is the C++ wrapper for the bubble display widget.
*
*/
private:
        DisplayLabels labels;
	DisplayColorTables colorTable;
        Widget bubbleChild;
	BubbleFU *bubbleFUthisPtr;

protected:
        void findBubbleFormPosition(int*bubbleLayoutXOrg,int *bubbleLayoutYOrg,
		     int *bubbleWidthProportion, int *bubbleHeightProportion );
        void setBubbleFormPosition(int bubbleLayoutXOrg,int bubbleLayoutYOrg,
		     int bubbleWidthProportion, int bubbleHeightProportion ); 
public:

	/* Method BubbleFormWrapper: 	the BubbleFormWrapper constructor  */
	BubbleFormWrapper( WidgetBase *par, BubbleFU *bubbleFUPtr,
			   const XArgs& args, const CString& name );

	/* Method ~BubbleFormWrapper: 	the BubbleFormWrapper destructor  */
	~BubbleFormWrapper();

	virtual void callback1( Widget, XtPointer, XtPointer );
        
        /* Method set/getBubbleLabels:  sets and retrieves configure-time
            specified labels, respectively, within the BubbleForm */
        void getBubbleLabel( int whichLabel, const char **aLabel ) const;
        void setBubbleLabel( int whichLabel, const char *stringLabel );
        void setBubbleLabel( double fuMin, double fuMax );

        /* Set and retrieve X attributes from both the BubbleForm and Bubble */
        void getBubbleAttr( String name, XtArgVal value );
        void setBubbleAttr( String name, XtArgVal value );
        void getBubbleFormAttr( String name, XtArgVal value );
	void setBubbleFormAttr( String name, XtArgVal value );

        /* Method setDisplayValue:	sets the current value of
	*				the bubble display widget	*/
	void setDisplayValue( int row, int column, int value );

	/* Method setDisplayValues:	sets all values of the bubble
	*				display widget			*/
	void setDisplayValues( int rows, int columns, int *values );

	/* Method setPerfWidgetColors:	sets the colors for the
	*				bubble widget			*/
	void setPerfWidgetColors();

	/* Method setPerfWidgetPixmaps:	sets the pixmaps for the
	*				bubble widget			*/
	void setPerfWidgetPixmaps( int colorCount, Pixmap* pixmaps );

};

#endif
