/*
 * This file is part of the Pablo Performance Analysis Environment
 *
 *                                           TM
 * The Pablo Performance Analysis Environment   software is *not* in
 * the public domain.  However, it is freely available without fee for
 * education, research, and non-profit purposes.  By obtaining copies
 * of this and other files that comprise the Pablo Performance Analysis
 * Environment, you, the Licensee, agree to abide by the following
 * conditions and understandings with respect to the copyrighted software:
 * 
 * 1.  The software is copyrighted in the name of the Board of Trustees
 *     of the University of Illinois (UI), and ownership of the software
 *     remains with the UI. 
 *
 * 2.  Permission to use, copy, and modify this software and its documentation
 *     for education, research, and non-profit purposes is hereby granted
 *     to Licensee, provided that the copyright notice, the original author's
 *     names and unit identification, and this permission notice appear on
 *     all such copies, and that no charge be made for such copies.  Any
 *     entity desiring permission to incorporate this software into commercial
 *     products should contact:
 *
 *          Professor Daniel A. Reed                 reed@cs.uiuc.edu
 *          University of Illinois
 *          Department of Computer Science
 *          2413 Digital Computer Laboratory
 *          1304 West Springfield Avenue
 *          Urbana, Illinois  61801
 *          USA
 *
 * 3.  Licensee may not use the name, logo, or any other symbol of the UI
 *     nor the names of any of its employees nor any adaptation thereof in
 *     advertizing or publicity pertaining to the software without specific
 *     prior written approval of the UI.
 *
 * 4.  THE UI MAKES NO REPRESENTATIONS ABOUT THE SUITABILITY OF THE
 *     SOFTWARE FOR ANY PURPOSE.  IT IS PROVIDED "AS IS" WITHOUT EXPRESS
 *     OR IMPLIED WARRANTY.
 *
 * 5.  The UI shall not be liable for any damages suffered by Licensee from
 *     the use of this software.
 *
 * 6.  The software was developed under agreements between the UI and the
 *     Federal Government which entitle the Government to certain rights.
 *
 **************************************************************************
 *
 * Developed by: The TAPESTRY Parallel Computing Laboratory
 *		 University of Illinois at Urbana-Champaign
 *		 Department of Computer Science
 *		 1304 W. Springfield Avenue
 *		 Urbana, IL	61801
 *
 * Copyright (c) 1987-1994
 * The University of Illinois Board of Trustees.
 *	All Rights Reserved.
 *
 * Author: Bradley W. Schwartz (schwartz@cs.uiuc.edu)
 * Author: Ruth A. Aydt (aydt@cs.uiuc.edu)
 *
 * Project Manager and Principal Investigator:
 *	Daniel A. Reed (reed@cs.uiuc.edu)
 *
 * Funded by: National Science Foundation grants NSF CCR86-57696,
 * NSF CCR87-06653 and NSF CDA87-22836 (Tapestry), NASA ICLASS Contract
 * No. NAG-1-613, DARPA Contract No. DABT63-91-K-0004, by a grant
 * from the Digital Equipment Corporation External Research Program,
 * and by a collaborative research agreement with the Intel Supercomputer
 * Systems Division.
 *
 */
/*
 * BargraphFormWrapper.h: A class wrapper for the Bargraph performance widget
 *
 * $Header: /mnt/Pablo-guitar/Stable.2-94/Visual/Src/Widgets/Wrappers/RCS/BargraphFormWrapper.h,v 1.17 1994/02/25 04:44:52 aydt Exp $
 */

#ifndef BargraphFormWrapper_h
#define BargraphFormWrapper_h

#include "BarGraphFU.h"
#include "DisplayLabels.h"     
#include "PerfWidget.h"

class BargraphFormWrapper : public PerfWidget {
/*
*  A BargraphFormWrapper is the C++ wrapper for the Motif Form widget used
*  in conjunction with Bargraph display
*/

private:
 	static const char *const MY_CLASS;      // My class name

        DisplayLabels 	labels;
        WidgetList 	childList;
        BarGraphFU 	*barGraphFUthisPtr;
        int 		formCols, formRows;    

	/* Method _adjustLayout:	Called if the number of rows or cols
	*				has changed.  Adjusts the set of 
	*				bar displays (sizes and positions) 
	*				accordingly.  This is called 
	*				automatically by setDisplayValues() 
	*				when needed.  Also see the public
	*				method updateDisplayLayout().         */
	void _adjustLayout( int nCols, int nRows );

	/* Method _createChild:		Creates a new bargraph widget for the
	*				given row and column in the form.     */
        Widget _createChild( char *newWidgetName, int iCol, int iRow,
                             int barLayoutXOrg, int barLayoutYOrg, 
			     int barWidthProportion, int barHeightProportion );

        /* Method _findBarsFormPosition:  Layout elements within the Form     */
        void _findBarsFormPosition( int nColElements, int nRowElements,
			int *barLayoutXOrg, int *barLayoutYOrg,
		        int *barWidthProportion, int *barHeightProportion );

        /* Method _genChildLayout:  	Maintains the Bargraph widget layout on
	*			    	data dimension changes during runtime */
        void _genChildLayout( int nNewCols, int nNewRows );

	/* Method _setABarFormPosition:	Sets the Layout attributes for a 
	*				particular bar in the display.        */
        void _setABarFormPosition( int iCol, int iRow,
		     int barLayoutXOrg, int barLayoutYOrg,
                     int barWidthProportion, int barHeightProportion );

public:
	/* Method BargraphFormWrapper:	Constructor. If barGraphFUPtr is not
	*				NULL, then callback1 is registered.
	*				Otherwise, callback2 is registered.   */
	BargraphFormWrapper( WidgetBase *par, BarGraphFU *barGraphFUPtr,
			     const XArgs &args, const CString &name );

	/* Method ~BargraphFormWrapper: Destructor.			      */
	~BargraphFormWrapper();

        /* Method callback1:		Overloads Callback::callback1 to handle
	*				callback in the display if the ctor
	*				contained a valid BargraphFU pointer. */
        virtual void callback1( Widget, XtPointer, XtPointer );

        /* Method callback2:		Overloads Callback::callback2 to handle
	*				callback in the display if the ctor
	*				contained a NULL BargraphFU pointer.
	*				Dialog with information is created 
	*				locally.                              */
        virtual void callback2( Widget, XtPointer, XtPointer );

	/* Method getBargraphLabel:	Set aLabel to point to text string for
	*				label specified.  If label is not set,
	*				then aLable points to a null string.  */
	void getBargraphLabel( int whichLabel, const char **aLabel ) const;

	/* Method getBargraphAttr:	Get attribute of individual Bargraph
	*				widget.                               */
        void getBargraphAttr( String name, XtArgVal value ) const;

	/* Method getBargraphFormAttr:	Get attribute of the Form widget      */
	void getBargraphFormAttr( String name, XtArgVal value ) const ; 

	/* Method setBargraphAttr:	Set attributes for bargraphs in form  */
	void setBargraphAttr( String name, XtArgVal value );

	/* Method setBargraphFormAttr:	Set attribute in the Form widget      */
        void setBargraphFormAttr( String name, XtArgVal value );

	/* Method setBargraphLabel:	Set the min and max labels on Form.   */
        void setBargraphLabel( double fuMin, double fuMax );

	/* Method setBargraphLabel:	Set the Horizontal or Vertical label
	*				on Form.                              */
        void setBargraphLabel( int whichLabel, const char *stringLabel );

	/* Method setDisplayValues:	Sets bargraph value for scalar amount */
        void setDisplayValues( int value );

	/* Method setDisplayValues:	Sets bargraph values for vector. If
	*				nCols has changed since last call,
	*				_adjustLayout is called 
	*				automatically.   		      */
        void setDisplayValues( int nCols, int *values );

	/* Method setDisplayValues:	Sets bargraph values for 2-d array. 
	*				If nCols or nRows has changed since
	*				last call, _adjustLayout is called
	*				automatically. values is in Row-major
	*				order.                               */ 
        void setDisplayValues( int nCols, int nRows, int *values );

	/* Method setSingleValue:	Sets a single bargraph value.
	*				If iCol or iRow is out of range, a
	*				warning is printed & no update made.
	*				Use updateDisplayLayout() to resize
	*				display as needed before calling this */
	void setSingleValue( int iCol, int iRow, int value );

	/* Method updateDisplayLayout: 	Checks for changes in the number of
	*				columns and rows in the data and 
	*				calls _adjustLayout to redo display
	*				if needed.                            */
        void updateDisplayLayout( int nCols, int nRows );
};

#endif
