/*
 * This file is part of the Pablo Performance Analysis Environment
 *
 *                                           TM
 * The Pablo Performance Analysis Environment   software is *not* in
 * the public domain.  However, it is freely available without fee for
 * education, research, and non-profit purposes.  By obtaining copies
 * of this and other files that comprise the Pablo Performance Analysis
 * Environment, you, the Licensee, agree to abide by the following
 * conditions and understandings with respect to the copyrighted software:
 * 
 * 1.  The software is copyrighted in the name of the Board of Trustees
 *     of the University of Illinois (UI), and ownership of the software
 *     remains with the UI. 
 *
 * 2.  Permission to use, copy, and modify this software and its documentation
 *     for education, research, and non-profit purposes is hereby granted
 *     to Licensee, provided that the copyright notice, the original author's
 *     names and unit identification, and this permission notice appear on
 *     all such copies, and that no charge be made for such copies.  Any
 *     entity desiring permission to incorporate this software into commercial
 *     products should contact:
 *
 *          Professor Daniel A. Reed                 reed@cs.uiuc.edu
 *          University of Illinois
 *          Department of Computer Science
 *          2413 Digital Computer Laboratory
 *          1304 West Springfield Avenue
 *          Urbana, Illinois  61801
 *          USA
 *
 * 3.  Licensee may not use the name, logo, or any other symbol of the UI
 *     nor the names of any of its employees nor any adaptation thereof in
 *     advertizing or publicity pertaining to the software without specific
 *     prior written approval of the UI.
 *
 * 4.  THE UI MAKES NO REPRESENTATIONS ABOUT THE SUITABILITY OF THE
 *     SOFTWARE FOR ANY PURPOSE.  IT IS PROVIDED "AS IS" WITHOUT EXPRESS
 *     OR IMPLIED WARRANTY.
 *
 * 5.  The UI shall not be liable for any damages suffered by Licensee from
 *     the use of this software.
 *
 * 6.  The software was developed under agreements between the UI and the
 *     Federal Government which entitle the Government to certain rights.
 *
 **************************************************************************
 *
 * Developed by: The TAPESTRY Parallel Computing Laboratory
 *		 University of Illinois at Urbana-Champaign
 *		 Department of Computer Science
 *		 1304 W. Springfield Avenue
 *		 Urbana, IL	61801
 *
 * Copyright (c) 1987-1994
 * The University of Illinois Board of Trustees.
 *	All Rights Reserved.
 *
 * Author: Daniel A. Reed (reed@cs.uiuc.edu)
 * Contributing Author:  Bradley Schwartz (schwartz@cs.uiuc.edu)
 * Project Manager and Principal Investigator:
 *	Daniel A. Reed (reed@cs.uiuc.edu)
 *
 * Funded by: National Science Foundation grants NSF CCR86-57696,
 * NSF CCR87-06653 and NSF CDA87-22836 (Tapestry), NASA ICLASS Contract
 * No. NAG-1-613, DARPA Contract No. DABT63-91-K-0004, by a grant
 * from the Digital Equipment Corporation External Research Program,
 * and by a collaborative research agreement with the Intel Supercomputer
 * Systems Division.
 *
 */

#ifndef _XtXYGraphP_h
#define _XtXYGraphP_h

#include "XYGraph.h"
#include <X11/CoreP.h>

#define MINSIZE		300
#define MAXROWS		500
#define MAXCOLUMNS	500
#define	MAXCOLORS	32
#define	XTICK		4
#define	YTICK		4
#define PADDING		4
#define FONTPAD	   	2
#define TITLESPACE	4
#define MARKERRADIUS	3
#define FULLARC		360*64


typedef struct {
  /* public */
  Boolean	connect;		/* connect points		*/
  Boolean	show_range;		/* show xygraph range		*/
  Boolean	show_ticks;		/* show grid ticks		*/
  Boolean	logx;			/* log x axis			*/
  Boolean	logy;			/* log y axis			*/
  Boolean	autoscale;		/* autoscale graph?		*/
  Boolean       densityPlot;            /* density plot data points     */
  char		*title;			/* xygraph title		*/
  int		xygraph_cnt;		/* number of xygraphs		*/
  int		numcolors;              /* number of value colors       */
  int		markersize;		/* size of data markers		*/
  int           numDensityColors;       /* number of density colors     */
  int           numBrushColors;         /* number of brush colors       */
  int		xticks, yticks;		/* number of x and y ticks	*/
  int           *minValues;             /* min range values             */
  int           *maxValues;             /* max range values             */
  int		minx, miny;		/* min range values		*/
  int		maxx, maxy;		/* max range values		*/
  int		*xvalues;		/* x values			*/
  int		*yvalues;		/* y values			*/
  int           *xpixels;               /* x pixel values               */
  int           *ypixels;               /* y pixel values               */
  int           **data;                 /* linked list data pointer     */
  int           datasize;               /* number of points allocated   */
  int           pointCount;             /* total number of data values  */
  int		*valuecnt;		/* number of values/line	*/
  int           *point_coloring;        /* coloring info about ea value */
  Pixel		grid_color;		/* xygraph grid color		*/
  Pixel		*colors;		/* value colors			*/
  Pixel         *baseColors;            /* generic base color set       */
  Pixel         *dataColors;            /* generic data color set       */
  Pixel         *densityColors;         /* colors for data density      */
  Pixel         *brushColors;           /* colors for point brushing    */
  Pixel		text_color;		/* color for text		*/
  XFontStruct	*font;			/* font for text		*/
  XtCallbackList select;		/* callback for select		*/
  /* private */
  CoordinateLoc	location;		/* x-y location of mouse click	*/
  int		xmove;			/* last x location		*/
  int		ymove;			/* last y location		*/
  int		xloc;			/* current x location		*/
  int		yloc;			/* current y location		*/
  int		xmin;			/* extrema over all data points */
  int		ymin;
  int		xmax;
  int		ymax;
  int		offsetx;		/* xygraph x offset		*/
  int		offsety1;		/* xygraph y offset (above)	*/
  int		offsety2;		/* xygraph y offset (below)	*/
  int		sizex;			/* plot area x dimension	*/
  int		sizey;			/* plot area y dimension	*/
  int		backing_store;		/* backing store type		*/
  GC		textGC;			/* text GC			*/
  GC		gridGC;			/* xygraph grid GC		*/
  GC	        colorGCs[MAXCOLORS];	/* color GCs			*/
  GC            brushColorGCs[MAXCOLORS]; /* GCs for point brushing     */
  GC            pixmapGC;               /* pixmap GC                    */
  Pixmap        drawPixmap;             /* drawing pixmap               */
  XImage        *drawImage;             /* drawing image                */
} XYGraphPart;

typedef struct _XYGraphRec {
   CorePart core;
   XYGraphPart xygraph;
   } XYGraphRec;

typedef struct {int dummy;} XYGraphClassPart;

typedef struct _XYGraphClassRec {
   CoreClassPart core_class;
   XYGraphClassPart xygraph_class;
   } XYGraphClassRec;

extern XYGraphClassRec xygraphClassRec;

#endif _XtXYGraphP_h

