/*
 * This file is part of the Pablo Performance Analysis Environment
 *
 *                                           TM
 * The Pablo Performance Analysis Environment   software is *not* in
 * the public domain.  However, it is freely available without fee for
 * education, research, and non-profit purposes.  By obtaining copies
 * of this and other files that comprise the Pablo Performance Analysis
 * Environment, you, the Licensee, agree to abide by the following
 * conditions and understandings with respect to the copyrighted software:
 * 
 * 1.  The software is copyrighted in the name of the Board of Trustees
 *     of the University of Illinois (UI), and ownership of the software
 *     remains with the UI. 
 *
 * 2.  Permission to use, copy, and modify this software and its documentation
 *     for education, research, and non-profit purposes is hereby granted
 *     to Licensee, provided that the copyright notice, the original author's
 *     names and unit identification, and this permission notice appear on
 *     all such copies, and that no charge be made for such copies.  Any
 *     entity desiring permission to incorporate this software into commercial
 *     products should contact:
 *
 *          Professor Daniel A. Reed                 reed@cs.uiuc.edu
 *          University of Illinois
 *          Department of Computer Science
 *          2413 Digital Computer Laboratory
 *          1304 West Springfield Avenue
 *          Urbana, Illinois  61801
 *          USA
 *
 * 3.  Licensee may not use the name, logo, or any other symbol of the UI
 *     nor the names of any of its employees nor any adaptation thereof in
 *     advertizing or publicity pertaining to the software without specific
 *     prior written approval of the UI.
 *
 * 4.  THE UI MAKES NO REPRESENTATIONS ABOUT THE SUITABILITY OF THE
 *     SOFTWARE FOR ANY PURPOSE.  IT IS PROVIDED "AS IS" WITHOUT EXPRESS
 *     OR IMPLIED WARRANTY.
 *
 * 5.  The UI shall not be liable for any damages suffered by Licensee from
 *     the use of this software.
 *
 * 6.  The software was developed under agreements between the UI and the
 *     Federal Government which entitle the Government to certain rights.
 *
 **************************************************************************
 *
 * Developed by: The TAPESTRY Parallel Computing Laboratory
 *		 University of Illinois at Urbana-Champaign
 *		 Department of Computer Science
 *		 1304 W. Springfield Avenue
 *		 Urbana, IL	61801
 *
 * Copyright (c) 1987-1994
 * The University of Illinois Board of Trustees.
 *	All Rights Reserved.
 *
 * Author: Daniel A. Reed (reed@cs.uiuc.edu)
 * Project Manager and Principal Investigator:
 *	Daniel A. Reed (reed@cs.uiuc.edu)
 *
 * Funded by: National Science Foundation grants NSF CCR86-57696,
 * NSF CCR87-06653 and NSF CDA87-22836 (Tapestry), NASA ICLASS Contract
 * No. NAG-1-613, DARPA Contract No. DABT63-91-K-0004, by a grant
 * from the Digital Equipment Corporation External Research Program,
 * and by a collaborative research agreement with the Intel Supercomputer
 * Systems Division.
 *
 */
/*
 *	$Header: /mnt/Pablo-guitar/Stable.2-94/Visual/Src/Widgets/Includes/RCS/Polar.h,v 1.10 1994/02/25 04:47:29 aydt Exp $
 */

#ifndef _XtPolar_h
#define _XtPolar_h

#include <X11/Xmu/Xmu.h>

/************************************************************************/
/* polar resources							*/
/************************************************************************/
/* XtNaxisColor			Pixel		axis color		*/
/* XtNcircleColor 		Pixel		circle color		*/
/* XtNpointColor		Pixel		point color		*/
/* XtNmagnitude 		int		value range		*/
/* XtNnumaxes			int		number of axes		*/
/* XtNnumCircles		int		number of circles	*/
/* XtNpointCount		int		number of data points	*/
/* XtNmarkerSize		int		data point marker size	*/
/* XtNselect			XtCallbackList	callback pointer	*/
/************************************************************************/

#define XtNcircleColor		"circleColor"
#define XtNpointColor		"pointColor"
#define XtNaxisColor		"axisColor"
#define XtNnumaxes		"numaxes"
#define XtNnumCircles		"numCircles"
#define XtNmagnitude		"magnitude"
#define XtNmaxValue		"maxValue"
#define XtNpointCount		"pointCount"
#define XtNmarkerSize		"markerSize"
#define XtNselect		"select"

#define XtCFill			"Fill"
#define XtCCircleColor		"CircleColor"
#define XtCPointColor		"PointColor"
#define XtCAxisColor		"AxisColor"
#define XtCNumaxes		"Numaxes"
#define XtCNumCircles		"NumCircles"
#define XtCMagnitude		"Magnitude"
#define XtCPointCount		"PointCount"
#define XtCMarkerSize		"MarkerSize"

typedef struct _PolarRec *PolarWidget;
typedef struct _PolarClassRec *PolarWidgetClass;

extern WidgetClass polarWidgetClass;

/******************/
/* polar methods */
/******************/

#if __STDC__ || defined(__cplusplus)

extern void PolarGetNearestPoint( PolarWidget w, int *xNearest, int *yNearest,
				  int *index );
extern void PolarSetValues( PolarWidget w, int ptcnt, int *Xvalues, 
			    int *Yvalues ); 

#else

extern void PolarGetNearestPoint();
extern void PolarSetValues();

#endif  /* __STDC__ || defined(__cplusplus) */


typedef struct  Coordinate {		/* callback information		*/
	int	x;
	int	y;
} CoordinateLoc;

#endif _XtPolar_h
