/*
 * This file is part of the Pablo Performance Analysis Environment
 *
 *                                           TM
 * The Pablo Performance Analysis Environment   software is *not* in
 * the public domain.  However, it is freely available without fee for
 * education, research, and non-profit purposes.  By obtaining copies
 * of this and other files that comprise the Pablo Performance Analysis
 * Environment, you, the Licensee, agree to abide by the following
 * conditions and understandings with respect to the copyrighted software:
 * 
 * 1.  The software is copyrighted in the name of the Board of Trustees
 *     of the University of Illinois (UI), and ownership of the software
 *     remains with the UI. 
 *
 * 2.  Permission to use, copy, and modify this software and its documentation
 *     for education, research, and non-profit purposes is hereby granted
 *     to Licensee, provided that the copyright notice, the original author's
 *     names and unit identification, and this permission notice appear on
 *     all such copies, and that no charge be made for such copies.  Any
 *     entity desiring permission to incorporate this software into commercial
 *     products should contact:
 *
 *          Professor Daniel A. Reed                 reed@cs.uiuc.edu
 *          University of Illinois
 *          Department of Computer Science
 *          2413 Digital Computer Laboratory
 *          1304 West Springfield Avenue
 *          Urbana, Illinois  61801
 *          USA
 *
 * 3.  Licensee may not use the name, logo, or any other symbol of the UI
 *     nor the names of any of its employees nor any adaptation thereof in
 *     advertizing or publicity pertaining to the software without specific
 *     prior written approval of the UI.
 *
 * 4.  THE UI MAKES NO REPRESENTATIONS ABOUT THE SUITABILITY OF THE
 *     SOFTWARE FOR ANY PURPOSE.  IT IS PROVIDED "AS IS" WITHOUT EXPRESS
 *     OR IMPLIED WARRANTY.
 *
 * 5.  The UI shall not be liable for any damages suffered by Licensee from
 *     the use of this software.
 *
 * 6.  The software was developed under agreements between the UI and the
 *     Federal Government which entitle the Government to certain rights.
 *
 **************************************************************************
 *
 * Developed by: The TAPESTRY Parallel Computing Laboratory
 *		 University of Illinois at Urbana-Champaign
 *		 Department of Computer Science
 *		 1304 W. Springfield Avenue
 *		 Urbana, IL	61801
 *
 * Copyright (c) 1987-1994
 * The University of Illinois Board of Trustees.
 *	All Rights Reserved.
 *
 * Author: Allen D. Malony (malony@uicsrd.csrd.uiuc.edu)
 * Contributing Author: Ruth A. Aydt (aydt@cs.uiuc.edu)
 *
 * Project Manager and Principal Investigator:
 *	Daniel A. Reed (reed@cs.uiuc.edu)
 *
 * Funded by: National Science Foundation grants NSF CCR86-57696,
 * NSF CCR87-06653 and NSF CDA87-22836 (Tapestry), NASA ICLASS Contract
 * No. NAG-1-613, DARPA Contract No. DABT63-91-K-0004, by a grant
 * from the Digital Equipment Corporation External Research Program,
 * and by a collaborative research agreement with the Intel Supercomputer
 * Systems Division.
 *
 */
/*
 * Matrix.h: This file contains the public definitions for the Matrix widget.
 *
 * $Header: /mnt/Pablo-guitar/Stable.2-94/Visual/Src/Widgets/Includes/RCS/Matrix.h,v 1.9 1994/02/25 04:47:53 aydt Exp $
 */

#ifndef _XtMatrix_h
#define _XtMatrix_h

#include <X11/Xmu/Xmu.h>

/*============================================================================*
 *	Resources for the Matrix widget.		                      
 *============================================================================*
 * XtNcolumns		int		matrix columns			      *
 * XtNgridColor		Pixel		grid color			      *
 * XtNmaxValue		int		maximum value			      *
 * XtNminValue		int		minimum value			      *
 * XtNrows		int		matrix rows			      *
 * XtNselect		XtCallbackList	callback pointer		      *
 * XtNshowGrid		Boolean		show matrix grid		      *
 *============================================================================*/

/*============================================================================*
 * 	Resource name definitions for the Matrix widget
 *============================================================================*/
#define XtNcolumns		"columns"
#define XtNgridColor		"gridColor"
#define XtNminValue		"minValue"
#define XtNmaxValue		"maxValue"
#define XtNrows			"rows"
#define XtNselect		"select"
#define XtNshowGrid		"showGrid"

/*============================================================================*
 * 	Resource class definitions for the Matrix Widget
 *============================================================================*/
#define XtCColumns		"Columns"
#define XtCGridColor		"GridColor"
#define XtCMinValue		"MinValue"
#define XtCMaxValue		"MaxValue"
#define XtCRows			"Rows"
#define XtCShowGrid		"ShowGrid"
#define XtCValues		"Values"

/*============================================================================*
 * 	External declaration of the class record pointer for the widget.
 * 	This is used by applications in calls to XtCreateWidget.
 *============================================================================*/
extern WidgetClass matrixWidgetClass;

/*============================================================================*
 * 	Identifer definitions for pointers to class records and instance 
 * 	records of the Matrix Widget.
 *============================================================================*/
typedef struct _MatrixClassRec *MatrixWidgetClass;
typedef struct _MatrixRec      *MatrixWidget;

/*============================================================================*
 * 	Public functions of the Matrix Widget
 *============================================================================*/
 
#if __STDC__ || defined(__cplusplus)

extern void MatrixGetRowCol( MatrixWidget w, int *row, int *col );
extern void MatrixSetColors( MatrixWidget w, int numcolors, Pixel *colors );
extern void MatrixSetPixmaps( MatrixWidget w, int numpixmaps, Pixmap *pixmaps );
extern void MatrixSetValue( MatrixWidget w, int row, int col, int value );
extern void MatrixSetValues( MatrixWidget w, int *values );

#else

extern void MatrixGetRowCol();
extern void MatrixSetColors();
extern void MatrixSetPixmaps();
extern void MatrixSetValue();
extern void MatrixSetValues();

#endif  /* __STDC__ || defined(__cplusplus) */

#endif _XtMatrix_h
