/*
 * This file is part of the Pablo Performance Analysis Environment
 *
 *                                           TM
 * The Pablo Performance Analysis Environment   software is *not* in
 * the public domain.  However, it is freely available without fee for
 * education, research, and non-profit purposes.  By obtaining copies
 * of this and other files that comprise the Pablo Performance Analysis
 * Environment, you, the Licensee, agree to abide by the following
 * conditions and understandings with respect to the copyrighted software:
 * 
 * 1.  The software is copyrighted in the name of the Board of Trustees
 *     of the University of Illinois (UI), and ownership of the software
 *     remains with the UI. 
 *
 * 2.  Permission to use, copy, and modify this software and its documentation
 *     for education, research, and non-profit purposes is hereby granted
 *     to Licensee, provided that the copyright notice, the original author's
 *     names and unit identification, and this permission notice appear on
 *     all such copies, and that no charge be made for such copies.  Any
 *     entity desiring permission to incorporate this software into commercial
 *     products should contact:
 *
 *          Professor Daniel A. Reed                 reed@cs.uiuc.edu
 *          University of Illinois
 *          Department of Computer Science
 *          2413 Digital Computer Laboratory
 *          1304 West Springfield Avenue
 *          Urbana, Illinois  61801
 *          USA
 *
 * 3.  Licensee may not use the name, logo, or any other symbol of the UI
 *     nor the names of any of its employees nor any adaptation thereof in
 *     advertizing or publicity pertaining to the software without specific
 *     prior written approval of the UI.
 *
 * 4.  THE UI MAKES NO REPRESENTATIONS ABOUT THE SUITABILITY OF THE
 *     SOFTWARE FOR ANY PURPOSE.  IT IS PROVIDED "AS IS" WITHOUT EXPRESS
 *     OR IMPLIED WARRANTY.
 *
 * 5.  The UI shall not be liable for any damages suffered by Licensee from
 *     the use of this software.
 *
 * 6.  The software was developed under agreements between the UI and the
 *     Federal Government which entitle the Government to certain rights.
 *
 **************************************************************************
 *
 * Developed by: The TAPESTRY Parallel Computing Laboratory
 *		 University of Illinois at Urbana-Champaign
 *		 Department of Computer Science
 *		 1304 W. Springfield Avenue
 *		 Urbana, IL	61801
 *
 * Copyright (c) 1987-1994
 * The University of Illinois Board of Trustees.
 *	All Rights Reserved.
 *
 * Author: Allen D. Malony (malony@uicsrd.csrd.uiuc.edu)
 * Project Manager and Principal Investigator:
 *	Daniel A. Reed (reed@cs.uiuc.edu)
 *
 * Funded by: National Science Foundation grants NSF CCR86-57696,
 * NSF CCR87-06653 and NSF CDA87-22836 (Tapestry), NASA ICLASS Contract
 * No. NAG-1-613, DARPA Contract No. DABT63-91-K-0004, by a grant
 * from the Digital Equipment Corporation External Research Program,
 * and by a collaborative research agreement with the Intel Supercomputer
 * Systems Division.
 *
 */
/*
 *	$Header: /mnt/Pablo-guitar/Stable.2-94/Visual/Src/Widgets/Includes/RCS/Led.h,v 1.8 1994/02/25 04:47:48 aydt Exp $
 */

#ifndef _Led_h
#define _Led_h

#include <X11/Xmu/Xmu.h>

/************************************************************************/
/* led resources							*/
/************************************************************************/
/* XtNoutlineColor	Pixel		led outline color		*/
/* XtNcolors		*Pixel		colors				*/
/* XtNlevels		int		led levels			*/
/* XtNmaxValue		int		maximum value			*/
/* XtNminValue		int		minimum value			*/
/* XtNnumColors		int		number of colors		*/
/* XtNnumPixmaps	int		number of pixmaps		*/
/* XtNorientation	XtOrientation	horizontal or veritcal		*/
/* XtNpixmaps		*Pixmap		pixmaps				*/
/* XtNshowOutline	Boolean		show led outline		*/
/* XtNstickyHold	int		sticky hold (0 none)		*/
/* XtNvalue		int		led value			*/
/* XtNselect		XtCallbackList	callback pointer		*/
/************************************************************************/

#define XtNoutlineColor	"outlineColor"
#define XtNstickyHold	"stickyHold"
#define XtNcolors	"colors"
#define XtNlevels	"levels"
#define XtNnumColors	"numColors"
#define XtNnumPixmaps	"numPixmaps"
#define XtNpixmaps	"pixmaps"
#define XtNshowOutline	"showOutline"
#define XtNminValue	"minValue"
#define XtNmaxValue	"maxValue"
#define XtNselect	"select"

#define XtCOutlineColor	"OutlineColor"
#define XtCStickyHold	"StickyHold"
#define XtCColors	"Colors"
#define XtCLevels	"Levels"
#define XtCNumColors	"NumColors"
#define XtCNumPixmaps	"NumPixmaps"
#define XtCPixmaps	"Pixmaps"
#define XtCShowOutline	"ShowOutline"
#define XtCMinValue	"MinValue"
#define XtCMaxValue	"MaxValue"

/*typedef enum {XtorientHorizontal, XtorientVertical} XtOrientation;*/

typedef struct _LedRec		*LedWidget;
typedef struct _LedClassRec	*LedWidgetClass;

extern WidgetClass	ledWidgetClass;

/***************/
/* led Methods */
/***************/

#if __STDC__ || defined(__cplusplus)

extern void LedSetColors( LedWidget w, int numcolors, Pixel *colors );
extern void LedSetPixmaps( LedWidget w, int numpixmaps, Pixmap *pixmaps );
extern void LedSetValue( LedWidget w, int value );

#else

extern void LedSetColors();
extern void LedSetPixmaps();
extern void LedSetValue();

#endif  /* __STDC__ || defined(__cplusplus) */

#endif _Led_h
