/*
 * This file is part of the Pablo Performance Analysis Environment
 *
 *                                           TM
 * The Pablo Performance Analysis Environment   software is *not* in
 * the public domain.  However, it is freely available without fee for
 * education, research, and non-profit purposes.  By obtaining copies
 * of this and other files that comprise the Pablo Performance Analysis
 * Environment, you, the Licensee, agree to abide by the following
 * conditions and understandings with respect to the copyrighted software:
 * 
 * 1.  The software is copyrighted in the name of the Board of Trustees
 *     of the University of Illinois (UI), and ownership of the software
 *     remains with the UI. 
 *
 * 2.  Permission to use, copy, and modify this software and its documentation
 *     for education, research, and non-profit purposes is hereby granted
 *     to Licensee, provided that the copyright notice, the original author's
 *     names and unit identification, and this permission notice appear on
 *     all such copies, and that no charge be made for such copies.  Any
 *     entity desiring permission to incorporate this software into commercial
 *     products should contact:
 *
 *          Professor Daniel A. Reed                 reed@cs.uiuc.edu
 *          University of Illinois
 *          Department of Computer Science
 *          2413 Digital Computer Laboratory
 *          1304 West Springfield Avenue
 *          Urbana, Illinois  61801
 *          USA
 *
 * 3.  Licensee may not use the name, logo, or any other symbol of the UI
 *     nor the names of any of its employees nor any adaptation thereof in
 *     advertizing or publicity pertaining to the software without specific
 *     prior written approval of the UI.
 *
 * 4.  THE UI MAKES NO REPRESENTATIONS ABOUT THE SUITABILITY OF THE
 *     SOFTWARE FOR ANY PURPOSE.  IT IS PROVIDED "AS IS" WITHOUT EXPRESS
 *     OR IMPLIED WARRANTY.
 *
 * 5.  The UI shall not be liable for any damages suffered by Licensee from
 *     the use of this software.
 *
 * 6.  The software was developed under agreements between the UI and the
 *     Federal Government which entitle the Government to certain rights.
 *
 **************************************************************************
 *
 * Developed by: The TAPESTRY Parallel Computing Laboratory
 *		 University of Illinois at Urbana-Champaign
 *		 Department of Computer Science
 *		 1304 W. Springfield Avenue
 *		 Urbana, IL	61801
 *
 * Copyright (c) 1987-1994
 * The University of Illinois Board of Trustees.
 *	All Rights Reserved.
 *
 * Author: Allen D. Malony (malony@uicsrd.csrd.uiuc.edu)
 * Project Manager and Principal Investigator:
 *	Daniel A. Reed (reed@cs.uiuc.edu)
 *
 * Funded by: National Science Foundation grants NSF CCR86-57696,
 * NSF CCR87-06653 and NSF CDA87-22836 (Tapestry), NASA ICLASS Contract
 * No. NAG-1-613, DARPA Contract No. DABT63-91-K-0004, by a grant
 * from the Digital Equipment Corporation External Research Program,
 * and by a collaborative research agreement with the Intel Supercomputer
 * Systems Division.
 *
 */
/*
 *	$Header: /mnt/Pablo-guitar/Stable.2-94/Visual/Src/Widgets/Includes/RCS/HistoryDialP.h,v 1.8 1994/02/25 04:48:00 aydt Exp $
 */

#ifndef _XtHistoryDialP_h
#define _XtHistoryDialP_h

#include "HistoryDial.h"
#include <X11/CoreP.h>

#define PADDING			2
#define MAXHISTORY		64
#define PI			3.14159265358979
#define PIHALF			(3.14159265358979 / 2)
#define TWOPI			(2. * PI)
#define NEEDLE_FRACTION		0.75
#define NEEDLE_HEAD_FRACTION	0.15
#define NEEDLE_WIDTH		6
#define NEEDLE_POINTS		6
#define MAXTICKS		100
#define MAJOR_TICK		5
#define MIN_SIZE		150

typedef struct {
  /* public */
  Boolean	show_value;		/* show digital value		*/
  int		begin_degree;		/* beginning degree (0-360)	*/
  int		end_degree;		/* ending degree (0-360)	*/
  int		history;		/* history depth		*/
  int		num_history_colors;	/* number of history colors	*/
  int	 	min_value, max_value;	/* minimum and maximum value	*/
  int		value;			/* dial value			*/
  Pixel		face_border_color;	/* color for dial border	*/
  Pixel		face_color;		/* color for dial face		*/
  Pixel		needle_color;		/* color for needle		*/
  Pixel		tick_color;		/* color for tick marks		*/
  Pixel		*history_colors;	/* color for tick marks		*/
  XtCallbackList select;		/* callback for select		*/
  /* private */
  int		value_select;		/* selected value		*/
  int		backing_store;		/* backing store type		*/
  int		dial_offsetY;		/* y offset for dial		*/
  int		value_offsetY;		/* y offset for digital value	*/
  Dimension	radius;			/* radius factor		*/
  Dimension	needle_length;		/* needle length		*/
  Dimension	needle_head_length;	/* needle head length		*/
  GC		face_borderGC;		/* face border GC		*/
  GC		faceGC;			/* face GC			*/
  GC		eraseGC;		/* erase GC			*/
  GC		needleGC;		/* needle GC			*/
  GC		tickGC;			/* tick GC			*/
  GC		historyGCs[MAXHISTORY]; /* history GCs			*/
  Position	centerX;		/* x position of dial center	*/
  Position	centerY;		/* y position of dial center	*/
  XPoint	needle[NEEDLE_POINTS];	/* needle points		*/
  XPoint	needle_history[MAXHISTORY][NEEDLE_POINTS];
  XSegment	ticks[MAXTICKS];	/* tick segments		*/
} HistoryDialPart;

typedef struct _HistoryDialRec {
  CorePart		core;
  HistoryDialPart	dial;
} HistoryDialRec;

typedef struct {
  int	dummy;
} HistoryDialClassPart;

typedef struct _HistoryDialClassRec {
  CoreClassPart		core_class;
  HistoryDialClassPart	historydial_class;
} HistoryDialClassRec;

extern HistoryDialClassRec	historydialClassRec;

#endif _XtHistoryDialP_h
