/*
 * This file is part of the Pablo Performance Analysis Environment
 *
 *                                           TM
 * The Pablo Performance Analysis Environment   software is *not* in
 * the public domain.  However, it is freely available without fee for
 * education, research, and non-profit purposes.  By obtaining copies
 * of this and other files that comprise the Pablo Performance Analysis
 * Environment, you, the Licensee, agree to abide by the following
 * conditions and understandings with respect to the copyrighted software:
 * 
 * 1.  The software is copyrighted in the name of the Board of Trustees
 *     of the University of Illinois (UI), and ownership of the software
 *     remains with the UI. 
 *
 * 2.  Permission to use, copy, and modify this software and its documentation
 *     for education, research, and non-profit purposes is hereby granted
 *     to Licensee, provided that the copyright notice, the original author's
 *     names and unit identification, and this permission notice appear on
 *     all such copies, and that no charge be made for such copies.  Any
 *     entity desiring permission to incorporate this software into commercial
 *     products should contact:
 *
 *          Professor Daniel A. Reed                 reed@cs.uiuc.edu
 *          University of Illinois
 *          Department of Computer Science
 *          2413 Digital Computer Laboratory
 *          1304 West Springfield Avenue
 *          Urbana, Illinois  61801
 *          USA
 *
 * 3.  Licensee may not use the name, logo, or any other symbol of the UI
 *     nor the names of any of its employees nor any adaptation thereof in
 *     advertizing or publicity pertaining to the software without specific
 *     prior written approval of the UI.
 *
 * 4.  THE UI MAKES NO REPRESENTATIONS ABOUT THE SUITABILITY OF THE
 *     SOFTWARE FOR ANY PURPOSE.  IT IS PROVIDED "AS IS" WITHOUT EXPRESS
 *     OR IMPLIED WARRANTY.
 *
 * 5.  The UI shall not be liable for any damages suffered by Licensee from
 *     the use of this software.
 *
 * 6.  The software was developed under agreements between the UI and the
 *     Federal Government which entitle the Government to certain rights.
 *
 **************************************************************************
 *
 * Developed by: The TAPESTRY Parallel Computing Laboratory
 *		 University of Illinois at Urbana-Champaign
 *		 Department of Computer Science
 *		 1304 W. Springfield Avenue
 *		 Urbana, IL	61801
 *
 * Copyright (c) 1987-1994
 * The University of Illinois Board of Trustees.
 *	All Rights Reserved.
 *
 * Author: Allen D. Malony (malony@uicsrd.csrd.uiuc.edu)
 * Project Manager and Principal Investigator:
 *	Daniel A. Reed (reed@cs.uiuc.edu)
 *
 * Funded by: National Science Foundation grants NSF CCR86-57696,
 * NSF CCR87-06653 and NSF CDA87-22836 (Tapestry), NASA ICLASS Contract
 * No. NAG-1-613, DARPA Contract No. DABT63-91-K-0004, by a grant
 * from the Digital Equipment Corporation External Research Program,
 * and by a collaborative research agreement with the Intel Supercomputer
 * Systems Division.
 *
 */
/*
 *	$Header: /mnt/Pablo-guitar/Stable.2-94/Visual/Src/Widgets/Includes/RCS/Gantt.h,v 1.8 1994/02/25 04:47:39 aydt Exp $
 */

#ifndef _XtGantt_h
#define _XtGantt_h

#include <X11/Xmu/Xmu.h>

/************************************************************************/
/* gantt resources							*/
/************************************************************************/
/* XtNxmin		int		minimum x value			*/
/* XtNxmax		int		maximum x value			*/
/* XtNymin		int		minimum y value			*/
/* XtNymax		int		maximum y value			*/
/* XtNxticks		int		number of x axis tick marks	*/
/* XtNyticks		int		number of y axis tick marks	*/
/* XtNtickColor		Pixel		tick color			*/
/* XtNcolors		Pixel*		line colors			*/
/* XtNnumColors		int		number of line colors		*/
/* XtNorientation	XtOrientation	horizontal or veritcal		*/
/* XtNselect		XtCallbackList	callback pointer		*/
/************************************************************************/

#define XtNxmin			"xmin"
#define XtNxmax			"xmax"
#define XtNymin			"ymin"
#define XtNymax			"ymax"
#define XtNxticks		"xticks"
#define XtNyticks		"yticks"
#define XtNtickColor		"tickColor"
#define XtNcolors		"colors"
#define XtNnumColors		"numColors"
#define XtNselect		"select"

#define XtCXmin			"Xmin"
#define XtCXmax			"Xmin"
#define XtCYmin			"Ymin"
#define XtCYmax			"Ymax"
#define XtCXticks		"Xticks"
#define XtCYticks		"Yticks"
#define XtCTickColor		"TickColor"
#define XtCColors		"Colors"
#define XtCNumColors		"NumColors"

typedef struct _GanttRec *GanttWidget;
typedef struct _GanttClassRec *GanttWidgetClass;

#ifndef _XtOrientation_e
#define _XtOrientation_e

/*typedef enum {XtorientHorizontal, XtorientVertical} XtOrientation;*/

#endif _XtOrientation_e

extern WidgetClass ganttWidgetClass;

/*****************/
/* gantt methods */
/*****************/


 
#if __STDC__ || defined(__cplusplus)

extern void GanttAddLine( GanttWidget w, int lineId, int nPoints, 
			  int color, int *x, int *y );
extern void GanttDeleteLine( GanttWidget w, int lineId );
extern void GanttMapLine( GanttWidget w, int lineId );
extern void GanttSetColorMap( GanttWidget w, int numcolors, Pixel *colors );
extern void GanttShowGantt( GanttWidget w );
extern void GanttUnMapLine( GanttWidget w, int lineId );

#else

extern void GanttAddLine();
extern void GanttDeleteLine();
extern void GanttMapLine();
extern void GanttSetColorMap();
extern void GanttShowGantt();
extern void GanttUnMapLine();

#endif  /* __STDC__ || defined(__cplusplus) */


typedef struct Coordinate {		/* callback information		*/
	int	x;
	int	y;
	int	lid;
} CoordinateLoc;

#endif _XtGantt_h
