/*
 * This file is part of the Pablo Performance Analysis Environment
 *
 *                                           TM
 * The Pablo Performance Analysis Environment   software is *not* in
 * the public domain.  However, it is freely available without fee for
 * education, research, and non-profit purposes.  By obtaining copies
 * of this and other files that comprise the Pablo Performance Analysis
 * Environment, you, the Licensee, agree to abide by the following
 * conditions and understandings with respect to the copyrighted software:
 * 
 * 1.  The software is copyrighted in the name of the Board of Trustees
 *     of the University of Illinois (UI), and ownership of the software
 *     remains with the UI. 
 *
 * 2.  Permission to use, copy, and modify this software and its documentation
 *     for education, research, and non-profit purposes is hereby granted
 *     to Licensee, provided that the copyright notice, the original author's
 *     names and unit identification, and this permission notice appear on
 *     all such copies, and that no charge be made for such copies.  Any
 *     entity desiring permission to incorporate this software into commercial
 *     products should contact:
 *
 *          Professor Daniel A. Reed                 reed@cs.uiuc.edu
 *          University of Illinois
 *          Department of Computer Science
 *          2413 Digital Computer Laboratory
 *          1304 West Springfield Avenue
 *          Urbana, Illinois  61801
 *          USA
 *
 * 3.  Licensee may not use the name, logo, or any other symbol of the UI
 *     nor the names of any of its employees nor any adaptation thereof in
 *     advertizing or publicity pertaining to the software without specific
 *     prior written approval of the UI.
 *
 * 4.  THE UI MAKES NO REPRESENTATIONS ABOUT THE SUITABILITY OF THE
 *     SOFTWARE FOR ANY PURPOSE.  IT IS PROVIDED "AS IS" WITHOUT EXPRESS
 *     OR IMPLIED WARRANTY.
 *
 * 5.  The UI shall not be liable for any damages suffered by Licensee from
 *     the use of this software.
 *
 * 6.  The software was developed under agreements between the UI and the
 *     Federal Government which entitle the Government to certain rights.
 *
 **************************************************************************
 *
 * Developed by: The TAPESTRY Parallel Computing Laboratory
 *		 University of Illinois at Urbana-Champaign
 *		 Department of Computer Science
 *		 1304 W. Springfield Avenue
 *		 Urbana, IL	61801
 *
 * Copyright (c) 1987-1994
 * The University of Illinois Board of Trustees.
 *	All Rights Reserved.
 *
 * Author: Daniel A. Reed (reed@cs.uiuc.edu)
 * Contributing Authors: Ruth A. Aydt (aydt@cs.uiuc.edu)
 *                       Bradley W. Schwartz (schwartz@cs.uiuc.edu)
 *
 * Project Manager and Principal Investigator:
 *	Daniel A. Reed (reed@cs.uiuc.edu)
 *
 * Funded by: National Science Foundation grants NSF CCR86-57696,
 * NSF CCR87-06653 and NSF CDA87-22836 (Tapestry), NASA ICLASS Contract
 * No. NAG-1-613, DARPA Contract No. DABT63-91-K-0004, by a grant
 * from the Digital Equipment Corporation External Research Program,
 * and by a collaborative research agreement with the Intel Supercomputer
 * Systems Division.
 *
 */
/*
 * Contour.h: This file contains the public definitions for the Contour widget.
 *
 * $Header: /mnt/Pablo-guitar/Stable.2-94/Visual/Src/Widgets/Includes/RCS/Contour.h,v 1.11 1994/02/25 04:47:55 aydt Exp $
 */

#ifndef _XtContour_h
#define _XtContour_h

#include <X11/Xmu/Xmu.h>

/*============================================================================*
 *	Resources for the Contour widget.		                      
 *============================================================================*
 * XtNcolumns		int		contour columns			      *
 * XtNcontourCnt	int		number of contours		      *
 * XtNfont		XFontStruct*	font				      *
 * XtNgridColor		Pixel		grid color			      *
 * XtNrows		int		contour rows			      *
 * XtNselect		XtCallbackList	callback pointer		      *
 * XtNshowContours	Boolean		show contours			      *
 * XtNshowGrid		Boolean		show contour grid		      *
 * XtNshowRange		Boolean		show contour range		      *
 * XtNshowRangeAbove    Boolean         display range ABOVE contour           *
 * XtNtextColor		Pixel		text color			      *
 *============================================================================*/

/*============================================================================*
 * 	Resource name definitions for the Contour widget
 *============================================================================*/
#define XtNcolumns		"columns"
#define XtNcontourCnt		"contourCnt"
#define XtNgridColor		"gridColor"
#define XtNrows			"rows"
#define XtNselect		"select"
#define	XtNshowContours		"showContours"
#define XtNshowGrid		"showGrid"
#define XtNshowRange		"showRange"
#define XtNshowRangeAbove       "showRangeAbove"
#define XtNtextColor		"textColor"

/*============================================================================*
 * 	Resource class definitions for the Contour Widget
 *============================================================================*/
#define XtCColumns		"Columns"
#define XtCContourCnt		"ContourCnt"
#define XtCGridColor		"GridColor"
#define XtCRows			"Rows"
#define XtCSelect		"Select"
#define	XtCShowContours		"ShowContours"
#define XtCShowGrid		"ShowGrid"
#define XtCShowRange		"ShowRange"
#define XtCShowRangeAbove       "ShowRangeAbove"
#define XtCTextColor		"TextColor"


/*============================================================================*
 * 	External declaration of the class record pointer for the widget.
 * 	This is used by applications in calls to XtCreateWidget.
 *============================================================================*/
extern WidgetClass contourWidgetClass;

/*============================================================================*
 * 	Identifer definitions for pointers to class records and instance 
 * 	records of the Contour Widget.
 *============================================================================*/
typedef struct _ContourClassRec *ContourWidgetClass;
typedef struct _ContourRec      *ContourWidget;

/*============================================================================*
 * 	Public functions of the Contour Widget
 *============================================================================*/

#if __STDC__ || defined(__cplusplus)

extern void ContourGetRowCol( ContourWidget w, int *row, int *col );
extern void ContourGetValue( ContourWidget w, int row, int col, float *value );
extern void ContourSetColors( ContourWidget w, int numcolors, Pixel *colors );
extern void ContourSetValues( ContourWidget w, float *values );
extern void ContourSetValue( ContourWidget w, int row, int col, float val );

#else

extern void ContourGetRowCol();
extern void ContourGetValue();
extern void ContourSetColors();
extern void ContourSetValues();
extern void ContourSetValue();

#endif  /* __STDC__ || defined(__cplusplus) */


/*============================================================================*
 * 	This public structure is used as call_data to the callback.
 *============================================================================*/
#define MAXCON		256		/* max number of contours	 */

typedef struct {			/* callback information		*/
	int	cnt;
	float	contours[MAXCON];
} contourCallbackInfo;


#endif _XtContour_h
