/*
 * This file is part of the Pablo Performance Analysis Environment
 *
 *                                           TM
 * The Pablo Performance Analysis Environment   software is *not* in
 * the public domain.  However, it is freely available without fee for
 * education, research, and non-profit purposes.  By obtaining copies
 * of this and other files that comprise the Pablo Performance Analysis
 * Environment, you, the Licensee, agree to abide by the following
 * conditions and understandings with respect to the copyrighted software:
 * 
 * 1.  The software is copyrighted in the name of the Board of Trustees
 *     of the University of Illinois (UI), and ownership of the software
 *     remains with the UI. 
 *
 * 2.  Permission to use, copy, and modify this software and its documentation
 *     for education, research, and non-profit purposes is hereby granted
 *     to Licensee, provided that the copyright notice, the original author's
 *     names and unit identification, and this permission notice appear on
 *     all such copies, and that no charge be made for such copies.  Any
 *     entity desiring permission to incorporate this software into commercial
 *     products should contact:
 *
 *          Professor Daniel A. Reed                 reed@cs.uiuc.edu
 *          University of Illinois
 *          Department of Computer Science
 *          2413 Digital Computer Laboratory
 *          1304 West Springfield Avenue
 *          Urbana, Illinois  61801
 *          USA
 *
 * 3.  Licensee may not use the name, logo, or any other symbol of the UI
 *     nor the names of any of its employees nor any adaptation thereof in
 *     advertizing or publicity pertaining to the software without specific
 *     prior written approval of the UI.
 *
 * 4.  THE UI MAKES NO REPRESENTATIONS ABOUT THE SUITABILITY OF THE
 *     SOFTWARE FOR ANY PURPOSE.  IT IS PROVIDED "AS IS" WITHOUT EXPRESS
 *     OR IMPLIED WARRANTY.
 *
 * 5.  The UI shall not be liable for any damages suffered by Licensee from
 *     the use of this software.
 *
 * 6.  The software was developed under agreements between the UI and the
 *     Federal Government which entitle the Government to certain rights.
 *
 **************************************************************************
 *
 * Developed by: The TAPESTRY Parallel Computing Laboratory
 *		 University of Illinois at Urbana-Champaign
 *		 Department of Computer Science
 *		 1304 W. Springfield Avenue
 *		 Urbana, IL	61801
 *
 * Copyright (c) 1987-1994
 * The University of Illinois Board of Trustees.
 *	All Rights Reserved.
 *
 * Author: Brian K. Totty (totty@cs.uiuc.edu)
 * Project Manager and Principal Investigator:
 *	Daniel A. Reed (reed@cs.uiuc.edu)
 *
 * Funded by: National Science Foundation grants NSF CCR86-57696,
 * NSF CCR87-06653 and NSF CDA87-22836 (Tapestry), NASA ICLASS Contract
 * No. NAG-1-613, DARPA Contract No. DABT63-91-K-0004, by a grant
 * from the Digital Equipment Corporation External Research Program,
 * and by a collaborative research agreement with the Intel Supercomputer
 * Systems Division.
 *
 */
/*
 *	$Header: /mnt/Pablo-guitar/Stable.2-94/Visual/Src/Widgets/Includes/RCS/ChartP.h,v 1.7 1994/02/25 04:47:58 aydt Exp $
 */

#ifndef _XtChartP_h
#define _XtChartP_h

#include "Chart.h"
#include <X11/CoreP.h>

/* New fields for the chart widget instance record */
typedef struct
{
	XFontStruct *font;	/* font for text */
	GC textGC;
	GC markGC;
	GC dataGC;
	GC eraserGC;

	char *text;		/* text of chart */
	XtIntervalId interval_id;
	int backing_store;	/* backing store type */
	int update;		/* update frequency */

	int info_y;		/* Y position of info area */
	int mark_y;		/* Y position of marker line */
	int data_y;		/* Y position of data lines */
	int data_h;		/* Height of data region */
	int title_y;		/* Y position of title area */
  	XtCallbackList select;	/* callback for select		*/

  	int value_select;	/* selected value		*/
	Pixel text_pixel;	/* Color index for text */
	Pixel mark_pixel;	/* Color index for marker */
	Pixel data_pixel;	/* Color index for data */
	int marker;		/* Current position of marker line */
	int last_filled;	/* Current index of last value filled */
	int max_value;		/* Highest value in value array */
	int array_size;		/* Allocated size of value array */
	int *value_array;	/* Pointer to value array */
	char *chart_title;	/* Title of chart */
	Boolean autoscale;	/* Do we autoscale? */
	Boolean infoline;	/* Do we show info line? */
	Boolean passive;	/* Is chart passively driven? */
	unsigned int scale;	/* Current scale of chart */
} ChartPart;

	/* Full instance record declaration */

typedef struct _ChartRec
{
	CorePart core;
	ChartPart chart;
} ChartRec;

	/* New fields for the Chart widget class record */

typedef struct
{
	int dummy;
} ChartClassPart;

	/* Full class record declaration */

typedef struct _ChartClassRec
{
	CoreClassPart core_class;
	ChartClassPart chart_class;
} ChartClassRec;

	/* Class pointer */

extern ChartClassRec chartClassRec;

#endif _XtChartP_h
