/*
 * This file is part of the Pablo Performance Analysis Environment
 *
 *                                           TM
 * The Pablo Performance Analysis Environment   software is *not* in
 * the public domain.  However, it is freely available without fee for
 * education, research, and non-profit purposes.  By obtaining copies
 * of this and other files that comprise the Pablo Performance Analysis
 * Environment, you, the Licensee, agree to abide by the following
 * conditions and understandings with respect to the copyrighted software:
 * 
 * 1.  The software is copyrighted in the name of the Board of Trustees
 *     of the University of Illinois (UI), and ownership of the software
 *     remains with the UI. 
 *
 * 2.  Permission to use, copy, and modify this software and its documentation
 *     for education, research, and non-profit purposes is hereby granted
 *     to Licensee, provided that the copyright notice, the original author's
 *     names and unit identification, and this permission notice appear on
 *     all such copies, and that no charge be made for such copies.  Any
 *     entity desiring permission to incorporate this software into commercial
 *     products should contact:
 *
 *          Professor Daniel A. Reed                 reed@cs.uiuc.edu
 *          University of Illinois
 *          Department of Computer Science
 *          2413 Digital Computer Laboratory
 *          1304 West Springfield Avenue
 *          Urbana, Illinois  61801
 *          USA
 *
 * 3.  Licensee may not use the name, logo, or any other symbol of the UI
 *     nor the names of any of its employees nor any adaptation thereof in
 *     advertizing or publicity pertaining to the software without specific
 *     prior written approval of the UI.
 *
 * 4.  THE UI MAKES NO REPRESENTATIONS ABOUT THE SUITABILITY OF THE
 *     SOFTWARE FOR ANY PURPOSE.  IT IS PROVIDED "AS IS" WITHOUT EXPRESS
 *     OR IMPLIED WARRANTY.
 *
 * 5.  The UI shall not be liable for any damages suffered by Licensee from
 *     the use of this software.
 *
 * 6.  The software was developed under agreements between the UI and the
 *     Federal Government which entitle the Government to certain rights.
 *
 **************************************************************************
 *
 * Developed by: The TAPESTRY Parallel Computing Laboratory
 *		 University of Illinois at Urbana-Champaign
 *		 Department of Computer Science
 *		 1304 W. Springfield Avenue
 *		 Urbana, IL	61801
 *
 * Copyright (c) 1987-1994
 * The University of Illinois Board of Trustees.
 *	All Rights Reserved.
 *
 * Author: Robert Olson (olson@cs.uiuc.edu)
 * Project Manager and Principal Investigator:
 *	Daniel A. Reed (reed@cs.uiuc.edu)
 *
 * Funded by: National Science Foundation grants NSF CCR86-57696,
 * NSF CCR87-06653 and NSF CDA87-22836 (Tapestry), NASA ICLASS Contract
 * No. NAG-1-613, DARPA Contract No. DABT63-91-K-0004, by a grant
 * from the Digital Equipment Corporation External Research Program,
 * and by a collaborative research agreement with the Intel Supercomputer
 * Systems Division.
 *
 */
/*
 * CStringObjList.cc:
 *
 *	$Header: /mnt/Pablo-guitar/Stable.2-94/Visual/Src/System/UsefulClasses/RCS/CStringObjList.C,v 1.10 1994/02/25 04:34:33 aydt Exp $
 */


#include "CStringObjList.h"

static CString NullObj;

CStringObjList::CStringObjList(int initialSize)
{
	if ( initialSize != 0 )  {
	    list = new CString[initialSize];
	} else {
	    list = NULL;
	}

	nItems = 0;
	nItemsAllocated = initialSize;
	
}

CStringObjList::~CStringObjList()
{
	if ( list != NULL ) {
	    delete[] list;
	}
}

CStringObjList::CStringObjList( const CStringObjList& objlist )
{
	int i;
	
	if ( objlist.nItemsAllocated != 0 ) {
	    list = new CString [objlist.nItemsAllocated];
	} else {
	    list = NULL;
	    Assert( objlist.nItems == 0 );
	}
	nItems = objlist.nItems;
	nItemsAllocated = objlist.nItemsAllocated;

	for ( i = 0; i < nItems; i++ ) {
	    list[i] = objlist.list[i];
	}
}

CStringObjList& 
CStringObjList::operator=( const CStringObjList& objlist )
{
	int i;
	
	if ( list != NULL ) {
	    delete[] list;
	}

	if ( objlist.nItemsAllocated != 0 ) {
	    list = new CString [objlist.nItemsAllocated];
	} else {
	    list = NULL;
	    Assert( objlist.nItems == 0 );
	}
	nItems = objlist.nItems;
	nItemsAllocated = objlist.nItemsAllocated;

	for ( i = 0; i < nItems; i++ ) {
	    list[i] = objlist.list[i];
	}

	return *this;
}

int CStringObjList::addElement(CString &elt)
{
	int idx;
	
	if (nItems == nItemsAllocated)
	{
		growList(nItems);
	}

	idx = nItems++;

	list[idx] = elt;

	return idx;
}

int CStringObjList::addElement( const char *elt )
{
	int idx;
	
	if (nItems == nItemsAllocated)
	{
		growList(nItems);
	}

	idx = nItems++;

	list[idx] = elt;

	return idx;
}

void CStringObjList::reset()
{
	if ( list != NULL ) {
	    delete[] list;
	    list = new CString [nItemsAllocated];
	} else {
	    Assert( nItemsAllocated == 0 );
	    list = NULL;
	}

	nItems = 0;
}

int CStringObjList::computeNewSize(int requestedIndex)
{
	if (requestedIndex < nItemsAllocated)
		return nItemsAllocated * 2;
	else
		return requestedIndex * 2;
}

void CStringObjList::growList(int n)
{
	resizeListTo(computeNewSize(n));
}

Boolean_ CStringObjList::resizeListTo(int n)
{
	CString *oldList;
	
	if (nItemsAllocated > n)
		return TRUE_;

	oldList = list;
	list = new CString [n];

	for (int i = 0; i < nItemsAllocated; i++)
		list[i] = oldList[i];
	
	nItemsAllocated = n;
	return TRUE_;
}

int CStringObjList::setElement(int n, CString &elt)
{
	if (n < 0)
	{
		cerr << "Ack! index " << n;
		cerr << " out of bounds in CStringObjList::setElement(int)\n";
		return n;
	}

	if (n >= nItemsAllocated)
		growList(n);

	if (n >= nItems)
		nItems = n + 1;
	
	list[n] = elt;
	return n;
}

const CString &CStringObjList::getElement(int n) const
{
	if (n < 0 || n > nItems)
	{
		cerr << "Ack! index " << n;
		cerr << " out of bounds in CStringObjList::getElement(int)\n";
		return NullObj;
	}

	return list[n];
}

CString &CStringObjList::operator[](int n) 
{
	if (n < 0)
	{
		cerr << "Ack! index " << n;
		cerr << " out of bounds in CStringObjList::[](int)\n";
		return NullObj;
	}

	if (n >= nItemsAllocated)
		growList(n);
	if (n >= nItems)
		nItems = n + 1;

	return list[n];
}

int 
CStringObjList::lookup( const CString& elt ) const
{
	int i;

	for  (i = 0; i < nItems; i++ ) {
	    if ( list[i] == elt ) {
		return i;
	    }
	}
	return -1;
}

int CStringObjList::insertElementAt(int n, CString &elt)
{
	int i;

	if (n >= nItemsAllocated)
		growList(n);
	if (nItems == nItemsAllocated)
		growList(nItems);

	if (n >=  nItems)
		nItems = n;

	for (i = nItems; i > n; i--)
		list[i] = list[i - 1];
	list[n] = elt;
	nItems++;
	return n;
}


void CStringObjList::deleteElementAt(int n)
{
	int i;

	if (n >= nItemsAllocated)
		growList(n);

	if (n >=  nItems)
		nItems = n + 1;

	for (i = n; i < nItems - 1; i++)
		list[i] = list[i + 1];
	nItems--;
	list[nItems] = NullObj;
}

int CStringObjList::count() const
{
	return nItems;
}

int CStringObjList::allocatedSize() const
{
	return nItemsAllocated;
}

int CStringObjList::isEmpty() const
{
	return nItems == 0;
}

void CStringObjList::printOn(ostream & os) const
{
	os << "CStringObjList: " << count() << " items\n";
}
