/*
 * This file is part of the Pablo Performance Analysis Environment
 *
 *                                           TM
 * The Pablo Performance Analysis Environment   software is *not* in
 * the public domain.  However, it is freely available without fee for
 * education, research, and non-profit purposes.  By obtaining copies
 * of this and other files that comprise the Pablo Performance Analysis
 * Environment, you, the Licensee, agree to abide by the following
 * conditions and understandings with respect to the copyrighted software:
 * 
 * 1.  The software is copyrighted in the name of the Board of Trustees
 *     of the University of Illinois (UI), and ownership of the software
 *     remains with the UI. 
 *
 * 2.  Permission to use, copy, and modify this software and its documentation
 *     for education, research, and non-profit purposes is hereby granted
 *     to Licensee, provided that the copyright notice, the original author's
 *     names and unit identification, and this permission notice appear on
 *     all such copies, and that no charge be made for such copies.  Any
 *     entity desiring permission to incorporate this software into commercial
 *     products should contact:
 *
 *          Professor Daniel A. Reed                 reed@cs.uiuc.edu
 *          University of Illinois
 *          Department of Computer Science
 *          2413 Digital Computer Laboratory
 *          1304 West Springfield Avenue
 *          Urbana, Illinois  61801
 *          USA
 *
 * 3.  Licensee may not use the name, logo, or any other symbol of the UI
 *     nor the names of any of its employees nor any adaptation thereof in
 *     advertizing or publicity pertaining to the software without specific
 *     prior written approval of the UI.
 *
 * 4.  THE UI MAKES NO REPRESENTATIONS ABOUT THE SUITABILITY OF THE
 *     SOFTWARE FOR ANY PURPOSE.  IT IS PROVIDED "AS IS" WITHOUT EXPRESS
 *     OR IMPLIED WARRANTY.
 *
 * 5.  The UI shall not be liable for any damages suffered by Licensee from
 *     the use of this software.
 *
 * 6.  The software was developed under agreements between the UI and the
 *     Federal Government which entitle the Government to certain rights.
 *
 **************************************************************************
 *
 * Developed by: The TAPESTRY Parallel Computing Laboratory
 *		 University of Illinois at Urbana-Champaign
 *		 Department of Computer Science
 *		 1304 W. Springfield Avenue
 *		 Urbana, IL	61801
 *
 * Copyright (c) 1987-1994
 * The University of Illinois Board of Trustees.
 *	All Rights Reserved.
 *
 * Author: Bradley W. Schwartz (schwartz@cs.uiuc.edu)
 *
 * Project Manager and Principal Investigator:
 *	Daniel A. Reed (reed@cs.uiuc.edu)
 *
 * Funded by: National Science Foundation grants NSF CCR86-57696,
 * NSF CCR87-06653 and NSF CDA87-22836 (Tapestry), NASA ICLASS Contract
 * No. NAG-1-613, DARPA Contract No. DABT63-91-K-0004, by a grant
 * from the Digital Equipment Corporation External Research Program,
 * and by a collaborative research agreement with the Intel Supercomputer
 * Systems Division.
 *
 */

#include <stdio.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>

#include "SnapshotDialog.h"
#include "Pablo.h"
#include "WidgetBase.h"

#define XtNdata          "data"
#define XtNdataCnt       "dataCnt"
#define XtNbaseColors    "baseColors"
#define XtNdataColors    "dataColors"
#define XtNnumDataColors "numDataColors"
#define XtNminValues     "minValues"
#define XtNmaxValues     "maxValues"


SnapshotDialog::SnapshotDialog()
{
       callbackData.myObject = this;

       snapshotDialog = XtVaCreatePopupShell( "SnapshotDialog",
	                    topLevelShellWidgetClass,
			    Pablo::TopLevel()->getWidget(),
                                 NULL );
       Widget dialogPane = XtVaCreateManagedWidget( "SnapshotDialogPane",
				    xmPanedWindowWidgetClass, snapshotDialog,
				    XmNsashWidth, 1, 
				    XmNsashHeight, 1,
					NULL );
       Widget modeArea =  XtVaCreateManagedWidget( "SnapshotModeArea",
					      xmFormWidgetClass, dialogPane,
					         NULL );
       Widget modeLabel = XtVaCreateManagedWidget( "SnapshotModeAreaLabel",
					      xmLabelWidgetClass, modeArea,
					         NULL );

       snapshotModeTextWidget =  XtVaCreateManagedWidget(
					    "SnapshotModeAreaText",
					    xmLabelWidgetClass, modeArea,
					    XmNleftWidget, modeLabel,
					       NULL );

       Widget actionArea = XtVaCreateManagedWidget( "SnapshotActionArea",
					      xmFormWidgetClass, dialogPane,
					         NULL );
       Widget actionScrolledWindow = XtVaCreateManagedWidget(
						   "SnapshotScrolledWindow",
				                   xmScrolledWindowWidgetClass,
						   actionArea,
						       NULL );
       actionWorkWindow = XtVaCreateManagedWidget( "SnapshotWorkWindow",
						  xmRowColumnWidgetClass,
						  actionScrolledWindow,
						  XmNorientation, XmHORIZONTAL,
						      NULL );
       Widget controlArea = XtVaCreateManagedWidget( "DialogControlArea",
					      xmFormWidgetClass, dialogPane,
					      XmNfractionBase, 5,
					         NULL );
       Widget addButton = XtVaCreateManagedWidget( "DialogAddButton",
	    xmPushButtonWidgetClass,
	    controlArea, 
	    XmNleftAttachment, XmATTACH_POSITION, XmNleftPosition, 0,
	    XmNrightAttachment, XmATTACH_POSITION, XmNrightPosition, 1,
	       NULL );
       XtAddCallback( addButton, XmNactivateCallback, 
		      (XtCallbackProc)SnapshotDialog::_staticAddCallback, 
		      &callbackData );
 
       Widget deleteButton = XtVaCreateManagedWidget( "DialogDeleteButton",
		    xmPushButtonWidgetClass,
		    controlArea, 
		    XmNleftAttachment, XmATTACH_POSITION, XmNleftPosition, 1,
		    XmNrightAttachment, XmATTACH_POSITION, XmNrightPosition, 2,
 			NULL );
       XtAddCallback( deleteButton, XmNactivateCallback, 
		     (XtCallbackProc)SnapshotDialog::_staticDeleteCallback, 
		      &callbackData );
       superButton = XtVaCreateManagedWidget( "DialogSuperButton",
		    xmPushButtonWidgetClass,
		    controlArea, 
		    XmNsensitive, False,
		    XmNleftAttachment, XmATTACH_POSITION, XmNleftPosition, 2,
		    XmNrightAttachment, XmATTACH_POSITION, XmNrightPosition, 3,
		         NULL );
       XtAddCallback( superButton, XmNactivateCallback, 
		     (XtCallbackProc)SnapshotDialog::_staticSuperCallback, 
		     &callbackData );

       Widget optionsButton = XtVaCreateManagedWidget( "DialogOptionsButton",
		    xmPushButtonWidgetClass,
		    controlArea, 
		    XmNleftAttachment, XmATTACH_POSITION, XmNleftPosition, 3,
		    XmNrightAttachment, XmATTACH_POSITION, XmNrightPosition, 4,
		       NULL );
       XtAddCallback( optionsButton, XmNactivateCallback, 
		     (XtCallbackProc)SnapshotDialog::_staticOptionsCallback,
		      &callbackData );

       Widget dismissButton = XtVaCreateManagedWidget( 
		   "DialogDismissButton",
		   xmPushButtonWidgetClass, controlArea,
	           XmNleftAttachment, XmATTACH_POSITION, XmNleftPosition, 4,
		   XmNrightAttachment, XmATTACH_POSITION, XmNrightPosition, 5,
			NULL );
       XtAddCallback( dismissButton, XmNactivateCallback, 
		     (XtCallbackProc)SnapshotDialog::_staticDismissCallback,
		      &callbackData );

       // Fix the size of the control area
       Dimension height;
       XtVaGetValues( dismissButton,
		      XmNheight, &height,
		         NULL );
       XtVaSetValues( controlArea,
		      XmNpaneMaximum, height,
		      XmNpaneMinimum, height,
		         NULL );

       // Create the voidPtrLists
       snapshotDataList = new VoidPtrList(1);
       snapshotIconList = new VoidPtrList(1);
       snapshotIconLabelList = new VoidPtrList(1);
       snapshotViewWindowList = new VoidPtrList(1);
       snapshotViewDismissList = new VoidPtrList(1);

       optionWindow = NULL;
       snapshotMode = SS_OFF;
       snapshotSelectOption = SEL_WHOLE;
}


SnapshotDialog::~SnapshotDialog()
{
       delete snapshotDataList;
       delete snapshotIconList;
       delete snapshotIconLabelList;
       delete snapshotViewWindowList;
       delete snapshotViewDismissList;
}



void
SnapshotDialog::_activatePictureCallback( int snapshotIndex )
{
	static int *data;

        SnapshotWidgetInfo *curWidgetInfo = (SnapshotWidgetInfo *)
                           snapshotDataList->getElement(snapshotIndex);
	Widget subjectWidget = curWidgetInfo->widgetID;
        WidgetClass picturedClass = XtClass( subjectWidget );

        // Determine widget class and get widget data; then create it
	Widget viewWindow, viewWidget, viewLabel;
        Widget viewActionArea, iconContainer;

	switch (snapshotMode) {
	   case SS_ADD:
	   case SS_SUPER:
	      if ( (snapshotMode == SS_ADD) ) {
                 viewWindow = XtVaCreatePopupShell(
					      "SnapshotViewDialog",
 					      topLevelShellWidgetClass,
					      Pablo::TopLevel()->getWidget(),
					          NULL );
		 snapshotViewWindowList->addElement( viewWindow );

                 Widget viewContainer = XtVaCreateManagedWidget( 
					       "SnapshotViewContainer",
					        xmFormWidgetClass,
						viewWindow,
						  NULL );
		 viewActionArea = XtVaCreateManagedWidget(
					       "SnapshotViewActionArea",
						xmFormWidgetClass,
						viewContainer,
						   NULL );

		 XmString labelString = XmStringCreateSimple( (char *)
		          snapshotIconLabelList->getElement(snapshotIndex) );
		 viewLabel = XtVaCreateWidget( "SnapshotViewLabel",
			             		xmLabelWidgetClass,
					        viewActionArea,
					        XmNlabelString, labelString,
					            NULL );
		 XmStringFree( labelString );

                 viewWidget = XtVaCreateWidget(  "SnapshotViewWidget",
			       	 	         picturedClass,
					         viewActionArea,
					         XmNtopWidget, viewLabel,
					              NULL );
	         // Create control area for view window
	         Widget viewControlArea = XtVaCreateManagedWidget(
			                       "SnapshotViewControlArea",
			                       xmFormWidgetClass,
			                       viewContainer,
				                   NULL );
		 XtVaSetValues( viewActionArea,
     			        XmNbottomWidget, viewControlArea,
			           NULL );

		 Widget dismissButton = XtVaCreateManagedWidget(
					"DialogDismissButton",
					xmPushButtonWidgetClass,
					viewControlArea,
					   NULL );
		 snapshotViewDismissList->addElement( dismissButton );
		 XtAddCallback( dismissButton, XmNactivateCallback, 
   	          (XtCallbackProc)SnapshotDialog::_staticViewDismissCallback, 
		                  &callbackData );

 	         Dimension height;
	         XtVaGetValues( dismissButton,
			        XmNheight, &height,
			           NULL );
  	         XtVaSetValues( viewActionArea,
			        XmNbottomWidget, viewControlArea,
			        XmNbottomOffset, (int)height,
			           NULL );


	      } else if ( snapshotMode == SS_SUPER ) {
/*
   	         SnapshotWidgetInfo *superWidgetInfo;
		 SnapshotWidgetInfo *oldWidgetInfo =
                          snapshotDataList->getElement( 
                                snapshotList->lookup(XtParent(viewWidget)) );
		 superWidgetInfo = (SnapshotWidgetInfo *)
	                               XtMalloc( sizeof(SnapshotWidgetInfo));
		 superWidgetInfo->dataDimension = oldWidgetInfo->dataDimension;
		 superWidgetInfo->dataCount = oldWidgetInfo->dataCount + 
					      curWidgetInfo->dataCount;

		 int oldDimSize = oldWidgetInfo->dataCount * sizeof(int);
		 int curDimSize = curWidgetInfo->dataCount * sizeof(int);
		 int superDimSize = oldDimSize + curDimSize;
		 superWidgetInfo->data = (int **)XtMalloc(
   		      (oldWidgetInfo->dataDimension+1) * sizeof(int *) );
		 superWidgetInfo->data[ oldWidgetInfo->dataDimension ] = NULL;

		 int i;
		 for (i=0; i<superWidgetInfo->dataDimension; i++) {
		      superWidgetInfo->data[i] = (int *)XtMalloc(
	                      superWidgetInfo->dataCount * sizeof(int) );
		     (void)memcpy( superWidgetInfo->data[i],
				   oldWidgetInfo->data[i], oldDimSize );
		     (void)memcpy( superWidgetInfo->data[i] + oldDimSize,
				   curWidgetInfo->data[i], curDimSize );
		 }
*/
              }

	      if ( snapshotMode == SS_SUPER ) {
/*
                 XtVaSetValues( viewWidget,
			        XtNdata, superWidgetInfo->data,
			        XtNdataCnt, superWidgetInfo->dataCount,
			            NULL );
*/
	      } else {
		 if ( curWidgetInfo->next == NULL ) {
	            XtVaSetValues( viewWidget,
			        XtNdata, curWidgetInfo->data,
			        XtNdataCnt, curWidgetInfo->dataCount,
			        XtNbaseColors,   curWidgetInfo->baseColors,
			        XtNdataColors, curWidgetInfo->dataColors,
			        XtNnumDataColors,curWidgetInfo->numDataColors,
			        XmNwidth, curWidgetInfo->width,
			        XmNheight, curWidgetInfo->height,
			        XtNminValues, curWidgetInfo->minValue,
			        XtNmaxValues, curWidgetInfo->maxValue,
			            NULL );
		 } else { 
                    XtVaSetValues( viewWidget,
				XmNfractionBase, curWidgetInfo->fractionBase,
				   NULL );
	            SnapshotWidgetInfo *childInfo = 
                                  (SnapshotWidgetInfo *) curWidgetInfo->next;
		    while ( childInfo != NULL ) {
                          Widget viewWidgetChild = XtVaCreateManagedWidget(
				  "SnapshotViewWidgetChild",
 			          XtClass(childInfo->widgetID),
			      	  viewWidget,
                                      NULL );
			  XtVaSetValues( viewWidgetChild,	
	  		          XtNdata, childInfo->data,
			          XtNdataCnt, childInfo->dataCount,
			          XtNbaseColors, childInfo->baseColors,
			          XtNdataColors, childInfo->dataColors,
			          XtNnumDataColors, childInfo->numDataColors,
			          XmNwidth, childInfo->width,
			          XmNheight, childInfo->height,
			          XtNminValues, childInfo->minValue,
			          XtNmaxValues, childInfo->maxValue,
                                  XmNtopPosition, childInfo->topPosition,
                                  XmNbottomPosition,childInfo->bottomPosition,
                                  XmNleftPosition, childInfo->leftPosition,
                                  XmNrightPosition, childInfo->rightPosition,
				     NULL );	
			  childInfo = (SnapshotWidgetInfo *)childInfo->next;
                   }			  
	        }
             }	      
	     XtManageChild(viewLabel);
	     XtManageChild(viewWidget);
             XtPopup( viewWindow, XtGrabNone );
	     break;

        case SS_DELETE:
	    // Clean up data structures and destroy the widget
	    //    "pictured" widget ID

	    SnapshotWidgetInfo *nextWidgetInfo; 
	    curWidgetInfo = (SnapshotWidgetInfo *)
                                 snapshotDataList->getElement(snapshotIndex);
	    int i;
	    while( curWidgetInfo != NULL ) {
               if ( curWidgetInfo->data != (int **)NULL ) { 
  	          for (i=0; i<curWidgetInfo->dataDimension; i++) {
                      XtFree( (char *)curWidgetInfo->data[i] );
		  }
	          XtFree( (char *)curWidgetInfo->data );
	          XtFree( (char *)curWidgetInfo->baseColors );
	          XtFree( (char *)curWidgetInfo->dataColors );
	          XtFree( (char *)curWidgetInfo->minValue );
	          XtFree( (char *)curWidgetInfo->maxValue ); 
	       }
	       nextWidgetInfo = (SnapshotWidgetInfo *)curWidgetInfo->next;
	       XtFree( (char *)curWidgetInfo );
	       curWidgetInfo = nextWidgetInfo;
	    }
	    snapshotDataList->deleteElementAt( snapshotIndex );
	    iconContainer =(Widget)snapshotIconList->getElement(snapshotIndex);
	    XtDestroyWidget( iconContainer );
	    snapshotIconList->deleteElementAt( snapshotIndex );
	    XtFree( (char *)snapshotIconLabelList->getElement(snapshotIndex) );
	    snapshotIconLabelList->deleteElementAt( snapshotIndex );

	    if ( snapshotIconList->count() < 2 ) {
	       XtVaSetValues( superButton, 
                              XtNsensitive, False,
			        NULL );
	    }
	    break;
	
        case SS_OFF:
        default: 
            break;
    }
}


void
SnapshotDialog::_addCallback()
{
        _setSnapshotMode( "Add" );
	_setCursor( XC_top_left_arrow );
}


void
SnapshotDialog::_deleteCallback()
{
        _setSnapshotMode( "Delete" );
        _setCursor( XC_crosshair );
}


void
SnapshotDialog::_dismissCallback()
{
         XtPopdown( snapshotDialog );
} 


void
SnapshotDialog::_optionDismissCallback()
{
         XtPopdown( optionWindow );
}


void
SnapshotDialog::_optionCallback( SnapshotOptionInfo *optionInfo )
{
	 /* Extract the selection option */
	 if ( XmToggleButtonGetState(optionInfo->wholeSelectOption) ) {
	    snapshotSelectOption = SEL_WHOLE;
	 } else if ( XmToggleButtonGetState(optionInfo->pieceSelectOption) ) {
            snapshotSelectOption = SEL_PIECE;
	 }
}            


void
SnapshotDialog::_optionsCallback()
{
         static SnapshotOptionInfo optionInfo;
	 callbackData.data = (void *) &optionInfo;

	 if ( optionWindow == NULL ) {
            optionWindow = XtVaCreatePopupShell( "SnapshotOptionDialog",
 					         topLevelShellWidgetClass,
						 snapshotDialog,
					            NULL );
            Widget optionContainer = XtVaCreateManagedWidget(
						     "SnapshotOptionContainer",
 					             xmFormWidgetClass,
						     optionWindow,
						        NULL );
            Widget optionActionArea = XtVaCreateManagedWidget(
					            "SnapshotOptionActionArea",
 					            xmFormWidgetClass,
						    optionContainer,
						        NULL );
	    Widget optionAreaLabel = XtVaCreateManagedWidget(
						    "SnapshotOptionAreaLabel",
						    xmLabelWidgetClass,
						    optionActionArea,
						        NULL );
	    Arg arglist[1];
	    XtSetArg( arglist[0], XmNtopWidget, optionAreaLabel );
            Widget optionRadioBox = XmCreateRadioBox( optionActionArea,
						      "SnapshotOptionRadioBox",
						      arglist, 1 );
	    optionInfo.wholeSelectOption = XtVaCreateManagedWidget(
					         "SnapshotOptionRadioOption1",
 					         xmToggleButtonWidgetClass,
						 optionRadioBox,
						 XmNset, True,
						     NULL );
	    XtAddCallback( optionInfo.wholeSelectOption,
			   XmNvalueChangedCallback, 
                 (XtCallbackProc)SnapshotDialog::_staticOptionCallback, 
		                &callbackData );

	    optionInfo.pieceSelectOption = XtVaCreateManagedWidget(
					         "SnapshotOptionRadioOption2",
 					         xmToggleButtonWidgetClass,
						 optionRadioBox,
						      NULL );
	    XtAddCallback( optionInfo.pieceSelectOption,
			   XmNvalueChangedCallback, 
                 (XtCallbackProc)SnapshotDialog::_staticOptionCallback, 
		                &callbackData );
	    XtManageChild( optionRadioBox );

            // Create control area for option window
	    Widget optionControlArea = XtVaCreateManagedWidget(
	  	                              "SnapshotOptionControlArea",
			                       xmFormWidgetClass,
			                       optionContainer,
				                   NULL );
	    Widget dismissButton = XtVaCreateManagedWidget(
					"DialogDismissButton",
					xmPushButtonWidgetClass,
					optionControlArea,
					   NULL );
	    XtAddCallback( dismissButton, XmNactivateCallback, 
                 (XtCallbackProc)SnapshotDialog::_staticOptionDismissCallback, 
		                &callbackData );

	    Dimension height;
	    XtVaGetValues( dismissButton,
			   XmNheight, &height,
			      NULL );
	    XtVaSetValues( optionActionArea,
			   XmNbottomWidget, optionControlArea,
			   XmNbottomOffset, (int)height,
			      NULL );
         }
	 XtPopup( optionWindow, XtGrabNone );
}


void
SnapshotDialog::_superCallback()
{
        _setSnapshotMode( "Superimpose" );
        _setCursor( XC_crosshair );
}


void
SnapshotDialog::_viewDismissCallback(int whichView )
{

        XtDestroyWidget((Widget)snapshotViewWindowList->getElement(whichView));
	snapshotViewWindowList->deleteElementAt( whichView );
	snapshotViewDismissList->deleteElementAt( whichView );
}
 

Widget
SnapshotDialog::_generatePicture( const char *fuClass, const char *fuName )
{
        static int totalPictureCount = 0;

        Widget pictureIconContainer = XtVaCreateManagedWidget(
		           		      "SnapshotPictureIconContainer",
					      xmFormWidgetClass,
					      actionWorkWindow,
					         NULL );
	Display *display = XtDisplay(pictureIconContainer);
	unsigned int defaultScreen = DefaultScreen( display );

	int iconWidth, iconHeight;
	char *iconBits = getFUIconInfo(  fuClass, &iconWidth, &iconHeight );
	Pixmap picturePixmap = XCreatePixmapFromBitmapData( display,
				    RootWindow( display, defaultScreen ),
				    iconBits, iconWidth, iconHeight,
				    BlackPixel( display, defaultScreen ),
				    WhitePixel( display, defaultScreen ),
				    DefaultDepth( display, defaultScreen ) );

	Widget pictureIconGraphic = XtVaCreateManagedWidget(
					      "SnapshotIconGraphic",
					      xmPushButtonWidgetClass,
					      pictureIconContainer,
					      XmNlabelPixmap, picturePixmap,
					         NULL );

	XtAddCallback( pictureIconGraphic, XmNactivateCallback, 
		      (XtCallbackProc)SnapshotDialog::_staticActivateCallback, 
		      &callbackData );

	SnapshotWidgetInfo *widgetInfo = (SnapshotWidgetInfo *)
                   snapshotDataList->getElement( snapshotDataList->count()-1 );
	char *label = (char *)XtMalloc( STRING_MAX_LEN * sizeof(char) );
	sprintf(label, "%s : %d", (char *)fuName, ++totalPictureCount );
	snapshotIconLabelList->addElement( label );

	XmString labelString = XmStringCreateSimple( label );
	Widget pictureIconLabel = XtVaCreateManagedWidget(
					     "SnapshotIconLabel",
					     xmLabelWidgetClass,
					     pictureIconContainer,
					     XmNlabelString, labelString,
					     XmNtopWidget, pictureIconGraphic,
						  NULL );
	XmStringFree(labelString);

	return( pictureIconContainer );
}
	      


SnapshotWidgetInfo *
SnapshotDialog::_packageWidget( Widget subjectWidget, Widget headWidget )
{
         SnapshotWidgetInfo *widgetInfo = (SnapshotWidgetInfo *)
	                                 XtMalloc( sizeof(SnapshotWidgetInfo));
         int **data;
         int dataCount;
         Pixel *baseColors, *dataColors;
         int numDataColors = 0;
         Dimension width, height;
         int *minValue, *maxValue;
         int topPosition, bottomPosition, leftPosition, rightPosition;

         XtVaGetValues( subjectWidget,
	                XtNdata, &data,
		        XtNdataCnt, &dataCount,
		        XtNbaseColors, &baseColors,
		        XtNdataColors, &dataColors,
		        XtNnumDataColors, &numDataColors,
		        XmNwidth, &width,
		        XmNheight, &height,
		        XtNminValues, &minValue,
		        XtNmaxValues, &maxValue,
		           NULL );

	 if ( XtClass(headWidget) == xmFormWidgetClass ) {
	    XtVaGetValues( subjectWidget,
			   XmNtopPosition, &topPosition,
		           XmNbottomPosition, &bottomPosition,
		           XmNleftPosition, &leftPosition,
		           XmNrightPosition, &rightPosition,
		              NULL );
	 }

	 int i;
         if ( dataCount > 0 ) {
             i = 0;
 	     while ( data[i++] != NULL ) {}
             widgetInfo->data = (int **) XtMalloc( i * sizeof(int) );
	     widgetInfo->dataDimension = i-1;
             widgetInfo->dataCount = dataCount;

             for (i=0; i<widgetInfo->dataDimension; i++) {
                widgetInfo->data[i] = (int *)XtMalloc(
				   widgetInfo->dataCount * sizeof(int));
	     }
             widgetInfo->minValue = (int *) XtMalloc( i * sizeof(int) );
             widgetInfo->maxValue = (int *) XtMalloc( i * sizeof(int) );

             for (i=0; i<widgetInfo->dataDimension; i++) {
	         (void)memcpy( widgetInfo->data[i], data[i],
		 	       widgetInfo->dataCount * sizeof(int) );
	         widgetInfo->minValue[i] = minValue[i];
	         widgetInfo->maxValue[i] = maxValue[i];
             }
         }
         i = 0;
         while ( (int)(baseColors[i++]) >= 0) {}
         widgetInfo->numBaseColors = i;
         widgetInfo->baseColors = (Pixel *)XtMalloc(widgetInfo->numBaseColors*
						     sizeof(Pixel) );
         (void)memcpy( widgetInfo->baseColors, baseColors,
		        widgetInfo->numBaseColors * sizeof(Pixel) );
	 widgetInfo->numDataColors = numDataColors;
         widgetInfo->dataColors = (Pixel *)
                            XtMalloc(widgetInfo->numDataColors*sizeof(Pixel));

         (void)memcpy( widgetInfo->dataColors, dataColors, 
		       widgetInfo->numDataColors );
         widgetInfo->width = width;
         widgetInfo->height = height;

	 widgetInfo->topPosition = topPosition;
	 widgetInfo->bottomPosition = bottomPosition;
	 widgetInfo->leftPosition = leftPosition;
	 widgetInfo->rightPosition = rightPosition;

	 return( widgetInfo );
}


void
SnapshotDialog::_setCursor( int cursor )
{
        static Cursor ourCursor = (Cursor)NULL; 
        Display *display = XtDisplay(snapshotDialog);
        
        if ( ourCursor != (Cursor)NULL ) {
           XFreeCursor( display, ourCursor );
        }
	ourCursor = XCreateFontCursor( display, cursor );
        XDefineCursor( display,
		       XtWindow( XtParent(actionWorkWindow) ),
		       ourCursor );
}

void
SnapshotDialog::_setSnapshotMode( char *modeString )
{
        XmString modeXMstring = XmStringCreateSimple( modeString );
        XtVaSetValues( snapshotModeTextWidget,
		       XmNlabelString, modeXMstring,
		          NULL );
	XmStringFree( modeXMstring );
}


void
SnapshotDialog::_staticActivateCallback( Widget w, 
					 XtPointer ptr1, XtPointer )
{
        // The lookup() method in VoidPtrList will probably change
        // after Ruth is done with the compiler stuff (BWS 1/12/93)
        int i;
	for (i=0; i<snapshotIconList->count(); i++) {
            if ( XtParent(w) == snapshotIconList->getElement(i) ) {
	       break;
	    }
	}
        SnapshotDialog *obj = (SnapshotDialog *)ptr1;
        obj->_activatePictureCallback(i);
}

void
SnapshotDialog::_staticAddCallback( Widget, XtPointer ptr1, XtPointer )
{
        SnapshotDialog *obj = (SnapshotDialog *)ptr1;
	snapshotMode = SS_ADD;
	obj->_addCallback();
}

void
SnapshotDialog::_staticDeleteCallback( Widget, XtPointer ptr1, XtPointer )
{
        SnapshotDialog *obj = (SnapshotDialog *)ptr1;
	snapshotMode = SS_DELETE;
	obj->_deleteCallback();
}

void
SnapshotDialog::_staticSuperCallback( Widget, XtPointer ptr1, XtPointer )
{
        SnapshotDialog *obj = (SnapshotDialog *)ptr1;
	snapshotMode = SS_SUPER;
	obj->_superCallback();
}


void
SnapshotDialog::_staticOptionCallback(Widget, XtPointer ptr1, XtPointer)
{
        SnapshotDialog *obj = (SnapshotDialog *)ptr1;
	SnapshotOptionInfo *optionInfo = (SnapshotOptionInfo *)
                                       ((SnapshotDialogCBInfo *)(ptr1))->data;
        obj->_optionCallback( optionInfo );
}

void
SnapshotDialog::_staticOptionsCallback(Widget, XtPointer ptr1, XtPointer)
{
        SnapshotDialog *obj = (SnapshotDialog *)ptr1;
	obj->_optionsCallback();
}


void
SnapshotDialog::_staticDismissCallback(Widget, XtPointer ptr1, XtPointer )
{
        SnapshotDialog *obj = (SnapshotDialog *)ptr1;
	obj->_dismissCallback();
}


void
SnapshotDialog::_staticOptionDismissCallback( Widget,
					      XtPointer ptr1, XtPointer )
{
        SnapshotDialog *obj = (SnapshotDialog *)ptr1;
        obj->_optionDismissCallback();
}


void 
SnapshotDialog::_staticViewDismissCallback( Widget w,
					    XtPointer ptr1, XtPointer )
{
        SnapshotDialog *obj = (SnapshotDialog *)ptr1;
	
	int whichView;
	int i;
	for (i=0; i<snapshotViewDismissList->count(); i++) {
            if ( w == snapshotViewDismissList->getElement(i) ) {
               whichView = i;
	       break;
	    }
	}
        obj->_viewDismissCallback( whichView );
}


Boolean_
SnapshotDialog::isCameraOn()
{
        if ( snapshotMode == SS_ADD || snapshotMode == SS_SUPER ) {
           return( TRUE_ );
        }
	else {
	   return( FALSE_ );
        }
}


void
SnapshotDialog::realize()
{
        XtPopup( snapshotDialog, XtGrabNone );
        if ( snapshotMode == SS_OFF ) {
           _setCursor( XC_top_left_arrow );
	}
}


void
SnapshotDialog::takeSnapshot( Widget subjectWidget, const char *fuClass,
			      const char *fuName )
{
       // Save Widget ID and data
       SnapshotWidgetInfo *infoHead, *infoCurrent;

       if ( snapshotSelectOption == SEL_PIECE ) {
            SnapshotWidgetInfo *widgetInfo = _packageWidget( subjectWidget, 
						             subjectWidget );
	    infoHead = widgetInfo;
            widgetInfo->widgetID = subjectWidget;
	    widgetInfo->next = NULL;

 
      } else if ( snapshotSelectOption == SEL_WHOLE ) {
	  WidgetList widgetList;
	  int numWidgets;
	  int fractionBase;

	  XtVaGetValues( XtParent( subjectWidget ),
			 XmNchildren, &widgetList,
			 XmNnumChildren, &numWidgets,
			 XmNfractionBase, &fractionBase,
			    NULL );

          SnapshotWidgetInfo *widgetInfo = (SnapshotWidgetInfo *)
	                                XtMalloc( sizeof(SnapshotWidgetInfo));
	  widgetInfo->widgetID = XtParent(subjectWidget);
	  widgetInfo->fractionBase = fractionBase;
	  widgetInfo->data = NULL;
	  infoHead = widgetInfo;
	  infoCurrent = widgetInfo;

	  SnapshotWidgetInfo *childWidgetInfo;
          int i;
	  for (i=0; i<numWidgets; i++) {
	      childWidgetInfo = _packageWidget( widgetList[i],
					        infoHead->widgetID );
	      childWidgetInfo->widgetID = widgetList[i];
	      infoCurrent->next = childWidgetInfo;
	      infoCurrent = (SnapshotWidgetInfo *)infoCurrent->next;
	      infoCurrent->next = NULL;
          }	      
          infoHead->dataCount = childWidgetInfo->dataCount;
      }  
      snapshotDataList->addElement( infoHead );

      // Generate a new icon for this picture
      Widget pictureIconGraphic = _generatePicture( fuClass, fuName );
      snapshotIconList->addElement( pictureIconGraphic );

      if ( snapshotIconList->count() >= 2 ) {
         XtVaSetValues( superButton,
			XtNsensitive, False,
			    NULL );
      }
}


Widget SnapshotDialog::snapshotDialog;
Widget SnapshotDialog::snapshotModeTextWidget;
Widget SnapshotDialog::actionWorkWindow;
Widget SnapshotDialog::superButton;
Widget SnapshotDialog::optionWindow;
SnapshotMode SnapshotDialog::snapshotMode;
SnapshotSelectOption SnapshotDialog::snapshotSelectOption;
VoidPtrList * SnapshotDialog::snapshotDataList;
VoidPtrList * SnapshotDialog::snapshotIconList;
VoidPtrList * SnapshotDialog::snapshotIconLabelList;
VoidPtrList * SnapshotDialog::snapshotViewWindowList;
VoidPtrList * SnapshotDialog::snapshotViewDismissList;

	
                              
