/*
 * This file is part of the Pablo Performance Analysis Environment
 *
 *                                           TM
 * The Pablo Performance Analysis Environment   software is *not* in
 * the public domain.  However, it is freely available without fee for
 * education, research, and non-profit purposes.  By obtaining copies
 * of this and other files that comprise the Pablo Performance Analysis
 * Environment, you, the Licensee, agree to abide by the following
 * conditions and understandings with respect to the copyrighted software:
 * 
 * 1.  The software is copyrighted in the name of the Board of Trustees
 *     of the University of Illinois (UI), and ownership of the software
 *     remains with the UI. 
 *
 * 2.  Permission to use, copy, and modify this software and its documentation
 *     for education, research, and non-profit purposes is hereby granted
 *     to Licensee, provided that the copyright notice, the original author's
 *     names and unit identification, and this permission notice appear on
 *     all such copies, and that no charge be made for such copies.  Any
 *     entity desiring permission to incorporate this software into commercial
 *     products should contact:
 *
 *          Professor Daniel A. Reed                 reed@cs.uiuc.edu
 *          University of Illinois
 *          Department of Computer Science
 *          2413 Digital Computer Laboratory
 *          1304 West Springfield Avenue
 *          Urbana, Illinois  61801
 *          USA
 *
 * 3.  Licensee may not use the name, logo, or any other symbol of the UI
 *     nor the names of any of its employees nor any adaptation thereof in
 *     advertizing or publicity pertaining to the software without specific
 *     prior written approval of the UI.
 *
 * 4.  THE UI MAKES NO REPRESENTATIONS ABOUT THE SUITABILITY OF THE
 *     SOFTWARE FOR ANY PURPOSE.  IT IS PROVIDED "AS IS" WITHOUT EXPRESS
 *     OR IMPLIED WARRANTY.
 *
 * 5.  The UI shall not be liable for any damages suffered by Licensee from
 *     the use of this software.
 *
 * 6.  The software was developed under agreements between the UI and the
 *     Federal Government which entitle the Government to certain rights.
 *
 **************************************************************************
 *
 * Developed by: The TAPESTRY Parallel Computing Laboratory
 *		 University of Illinois at Urbana-Champaign
 *		 Department of Computer Science
 *		 1304 W. Springfield Avenue
 *		 Urbana, IL	61801
 *
 * Copyright (c) 1987-1994
 * The University of Illinois Board of Trustees.
 *	All Rights Reserved.
 *
 * Author: Ruth Aydt (aydt@cs.uiuc.edu)
 *
 * Project Manager and Principal Investigator:
 *	Daniel A. Reed (reed@cs.uiuc.edu)
 *
 * Funded by: National Science Foundation grants NSF CCR86-57696,
 * NSF CCR87-06653 and NSF CDA87-22836 (Tapestry), NASA ICLASS Contract
 * No. NAG-1-613, DARPA Contract No. DABT63-91-K-0004, by a grant
 * from the Digital Equipment Corporation External Research Program,
 * and by a collaborative research agreement with the Intel Supercomputer
 * Systems Division.
 *
 */
/*
 * FileSelectionDialog.cc: Implements a File Selection Dialog
 *	$Header: /mnt/Pablo-guitar/Stable.2-94/Visual/Src/System/Interface/RCS/FileSelectionDialog.C,v 1.13 1994/03/17 16:05:54 aydt Exp $
 *	
 */

#include <stdio.h>
#include <Xm/Xm.h>
#include <Xm/FileSB.h>

#include "FileSelectionDialog.h"

#include "Pablo.h"
#include "PabloHelpSystem.h"
#include "WidgetBase.h"

FileSelectionDialog::FileSelectionDialog() 
{
	_setClassName( MY_CLASS );
	cbinfo.dp = this;

        char buf[40];
        sprintf( buf, "FileSelectionDialog(%d)", dialog_num );
        dialog_name = new char[ strlen(buf) + 1 ];
        strcpy( dialog_name, buf );
	dialog_num++;

	dialog = XmCreateFileSelectionDialog( Pablo::TopLevel()->getWidget(),
					         dialog_name, NULL, 0 );
        setXmStringResource( XmNdialogTitle, "Pablo File Selection Dialog" );

        XtAddCallback( dialog, XmNokCallback, 
		      (XtCallbackProc)FileSelectionDialog::static_cb, &cbinfo );
        XtAddCallback( dialog, XmNcancelCallback, 
		      (XtCallbackProc)FileSelectionDialog::static_cb, &cbinfo );
        XtAddCallback( dialog, XmNhelpCallback, 
		      (XtCallbackProc)FileSelectionDialog::static_cb, &cbinfo );
}

FileSelectionDialog::~FileSelectionDialog()
{
	XtDestroyWidget( XtParent( dialog ) );
	delete dialog_name;
}

void
FileSelectionDialog::static_cb( Widget widget, fsd_cbInfo *cbi, 
			                XmFileSelectionBoxCallbackStruct *cbs )
{
        cbi->dp->callback( widget, cbi, cbs );
        return;
}

void 
FileSelectionDialog::callback( Widget /* widget */, fsd_cbInfo *cbi, 
			       		XmFileSelectionBoxCallbackStruct *cbs )
{
        switch ( cbs->reason ) {

          case XmCR_OK:
	        char *text;
	        if ( XmStringGetLtoR( cbs->value, XmSTRING_DEFAULT_CHARSET, 
						  &text ) ) {
		    if ( !*text ) {    /* nothing typed */
			error( "Blank selection invalid - please reenter." );
			XtFree( text );
		    } else {
	                fileName = text;
		        XtFree( text );
		        XtUnmanageChild( dialog );
                        cbi->button = 1;
		    }
		} else {
		    error( "Invalid entry in FileSelectionDialog" );
		}
                break;

	  case XmCR_CANCEL:
		cbi->button = 2;
		XtUnmanageChild( dialog );
		break;

	  case XmCR_HELP:
		Pablo::HelpSystem()->giveHelpOn("FileSelection");
		break;

          default:
                cbi->button = -1;
		XtUnmanageChild( dialog );
                break;
        }

        return;		
}

Boolean_
FileSelectionDialog::run()
{
        XtManageChild( dialog );

	cbinfo.button = 0;
        while ( cbinfo.button == 0 ) {
            XEvent event;
	    XtAppNextEvent( XtWidgetToApplicationContext( dialog ), &event );
            XtDispatchEvent( &event );
        }

	return ( CnvToBoolean_(cbinfo.button == 1) ); // Success if Okay button
}

void
FileSelectionDialog::setButtonSensitive( unsigned char button, 
				         Boolean_ isSensitive ) 
{
	if ( isSensitive ) {
	    XtSetSensitive( 
		XmFileSelectionBoxGetChild( dialog, button ), True );
	} else {
	    XtSetSensitive( 
		XmFileSelectionBoxGetChild( dialog, button ), False );
	}
}

void
FileSelectionDialog::setXmStringResource( String resource, char *value )
{
        XmString xmstr = XmStringCreate( value, XmSTRING_DEFAULT_CHARSET );
	Arg arg;
	XtSetArg( arg, resource, (XtArgVal) xmstr );
        XtSetValues( dialog, &arg, 1 );
	XmStringFree( xmstr );
}

void
FileSelectionDialog::setResource( String resource, XtArgVal value )
{
	Arg arg;
	XtSetArg( arg, resource, value );
	XtSetValues( dialog, &arg, 1 );
}

/*
 * Initialize the static data
 */
const char *const FileSelectionDialog::MY_CLASS = "FileSelectionDialog";
int FileSelectionDialog::dialog_num = 0;

