/*
 * This file is part of the Pablo Performance Analysis Environment
 *
 *                                           TM
 * The Pablo Performance Analysis Environment   software is *not* in
 * the public domain.  However, it is freely available without fee for
 * education, research, and non-profit purposes.  By obtaining copies
 * of this and other files that comprise the Pablo Performance Analysis
 * Environment, you, the Licensee, agree to abide by the following
 * conditions and understandings with respect to the copyrighted software:
 * 
 * 1.  The software is copyrighted in the name of the Board of Trustees
 *     of the University of Illinois (UI), and ownership of the software
 *     remains with the UI. 
 *
 * 2.  Permission to use, copy, and modify this software and its documentation
 *     for education, research, and non-profit purposes is hereby granted
 *     to Licensee, provided that the copyright notice, the original author's
 *     names and unit identification, and this permission notice appear on
 *     all such copies, and that no charge be made for such copies.  Any
 *     entity desiring permission to incorporate this software into commercial
 *     products should contact:
 *
 *          Professor Daniel A. Reed                 reed@cs.uiuc.edu
 *          University of Illinois
 *          Department of Computer Science
 *          2413 Digital Computer Laboratory
 *          1304 West Springfield Avenue
 *          Urbana, Illinois  61801
 *          USA
 *
 * 3.  Licensee may not use the name, logo, or any other symbol of the UI
 *     nor the names of any of its employees nor any adaptation thereof in
 *     advertizing or publicity pertaining to the software without specific
 *     prior written approval of the UI.
 *
 * 4.  THE UI MAKES NO REPRESENTATIONS ABOUT THE SUITABILITY OF THE
 *     SOFTWARE FOR ANY PURPOSE.  IT IS PROVIDED "AS IS" WITHOUT EXPRESS
 *     OR IMPLIED WARRANTY.
 *
 * 5.  The UI shall not be liable for any damages suffered by Licensee from
 *     the use of this software.
 *
 * 6.  The software was developed under agreements between the UI and the
 *     Federal Government which entitle the Government to certain rights.
 *
 **************************************************************************
 *
 * Developed by: The TAPESTRY Parallel Computing Laboratory
 *               University of Illinois at Urbana-Champaign
 *               Department of Computer Science
 *               1304 W. Springfield Avenue
 *               Urbana, IL     61801
 *
 * Copyright (c) 1987-1994
 * The University of Illinois Board of Trustees.
 *      All Rights Reserved.
 *
 * Author: Keith A. Shields (shields@cs.uiuc.edu)
 * 
 * Project Manager and Principal Investigator:
 *      Daniel A. Reed (reed@cs.uiuc.edu)
 *
 * Funded by: National Science Foundation grants NSF CCR86-57696,
 * NSF CCR87-06653 and NSF CDA87-22836 (Tapestry), NASA ICLASS Contract
 * No. NAG-1-613, DARPA Contract No. DABT63-91-K-0004, by a grant
 * from the Digital Equipment Corporation External Research Program,
 * and by a collaborative research agreement with the Intel Supercomputer
 * Systems Division.
 *
 */
/*
 * ExecutionModeDialog.cc : This module implements a custom dialog for
 *                          specifying the execution mode of a dialog
 * 
 *
 */

#include <Xm/Label.h>

#include "ExecutionModeDialog.h"

#include "PabloHelpSystem.h"

ExecutionModeDialog::ExecutionModeDialog(Widget parentApp, 
					 InterfaceClass *pabloInterface,
					 ConfigBoard *statusBoard)
{

  _setClassName(MY_CLASS);
  PabloInterface = pabloInterface;
  StatusBoard = statusBoard;

  DialogShell = XtCreatePopupShell("ExecutionModeDialog", 
				   topLevelShellWidgetClass, parentApp, NULL, 
				   0);
				   
  Widget panedWindow  = XtVaCreateWidget("dialogPane", 
					 xmPanedWindowWidgetClass, 
					 DialogShell, 
					 XmNsashWidth, 1, 
					 XmNsashHeight, 1,
					 NULL );

  _setDialogTitle();
  _buildControlArea(panedWindow);
  _buildActionArea(panedWindow);

  XtManageChild(panedWindow);
}



ExecutionModeDialog::~ExecutionModeDialog()
{
  XtDestroyWidget(DialogShell);
}



void ExecutionModeDialog::_buildActionArea(Widget panedWindow)
{
  Widget actionArea = XtCreateWidget("actionArea", xmFormWidgetClass, 
				     panedWindow, NULL, 0);

  Widget cont  = XtCreateManagedWidget("continue", 
				       xmPushButtonWidgetClass,
				       actionArea, NULL, 0); 

  Widget reset = XtCreateManagedWidget("reset", 
				       xmPushButtonWidgetClass,
				       actionArea, NULL, 0);

  Widget help = XtCreateManagedWidget("help", 
				      xmPushButtonWidgetClass,
				      actionArea, NULL, 0);

  addCallback(cont, XmNactivateCallback, &Callback::callback1, 
	      this, NULL);

  addCallback(reset, XmNactivateCallback, &Callback::callback2, this, NULL);

  addCallback(help, XmNactivateCallback, &Callback::helpCallback, this, NULL);

  /* fix height of action area */
  Dimension h; 
  XtVaGetValues(reset, XmNheight, &h, NULL);
  XtVaSetValues(actionArea, 
		XmNpaneMaximum, h, 
		XmNpaneMinimum, h,
		NULL);

  XtManageChild( actionArea );
}



void ExecutionModeDialog::_buildControlArea(Widget panedWindow)
{
  Widget controlArea = XtCreateWidget("controlArea", xmFormWidgetClass, 
                                      panedWindow, NULL, 0 );

  _makeExecutionModeArea(controlArea);

  XtManageChild(controlArea);
}



void ExecutionModeDialog::_initializeExecutionToggles()
{
  if (PabloInterface->getModuleExecutionMode() == SYNCHRONOUS_) { 
    XtVaSetValues(SynchToggle, XmNset, True, NULL);
    XtVaSetValues(AsynchToggle, XmNset, False, NULL);
  } else {
      XtVaSetValues(AsynchToggle, XmNset, True, NULL);
      XtVaSetValues(SynchToggle, XmNset, False, NULL);
    }
}



void ExecutionModeDialog::_makeExecutionModeArea(Widget controlArea)

{
  char *moduleName = (char *) PabloInterface->getModuleName();
  XmString moduleNameX = XmStringCreateSimple(moduleName);
  Widget moduleNameLabel = XtVaCreateManagedWidget("moduleNameLabel", 
						   xmLabelWidgetClass, 
						   controlArea,
						   XmNlabelString, moduleNameX,
						   NULL);
  XmStringFree(moduleNameX);

  Widget executionRadioBox = XmCreateRadioBox(controlArea, 
					      "executionRadioBox", NULL, 0);

  XtVaSetValues(executionRadioBox, XmNtopWidget, moduleNameLabel, NULL);

  SynchToggle = XtCreateManagedWidget("synchToggle", xmToggleButtonWidgetClass,
				      executionRadioBox, NULL, 0);

  AsynchToggle = XtCreateManagedWidget("asynchToggle", 
				       xmToggleButtonWidgetClass, 
				       executionRadioBox, NULL, 0);


  _initializeExecutionToggles();

  XtManageChild(executionRadioBox);
}



void ExecutionModeDialog::_setDialogTitle()
{
  char buf[1024];
  
  sprintf(buf, "Specify Module Execution Mode");

  XtVaSetValues(DialogShell,
		XmNtitle, buf, 
		NULL);
}



void ExecutionModeDialog::callback1(Widget, XtPointer /* ptr1 */,
				      	    XtPointer /* ptr2 */)
{
  /* callback called when continue is selected */
  DoneRunning = True;
}



void ExecutionModeDialog::callback2(Widget, XtPointer /* ptr1 */,
				      	    XtPointer /* ptr2 */)
{
  /* callback called when reset is selected */
  _initializeExecutionToggles();
}



void ExecutionModeDialog::helpCallback(Widget, XtPointer /* ptr1 */,
				      	       XtPointer /* ptr2 */)
{
  /* callback called when help is selected */
  Pablo::HelpSystem()->giveHelpOn( "ExecutionModeDialog" );
}



void ExecutionModeDialog::run()
{
  DoneRunning = False;

  XtManageChild(DialogShell);

  while (!DoneRunning) {
    XEvent event;
    XtAppNextEvent(
                   XtWidgetToApplicationContext(DialogShell), &event );
    XtDispatchEvent( &event );
  }
  
  XtUnmanageChild(DialogShell);

  Boolean synchToggleSet;
  
  XtVaGetValues(SynchToggle, XmNset, &synchToggleSet, NULL);

  if (synchToggleSet) {
    PabloInterface->setModuleExecutionMode(SYNCHRONOUS_);
  } else {
      PabloInterface->setModuleExecutionMode(ASYNCHRONOUS_);
    }
}



/*
 * Initialize the static data
 */
const char *const ExecutionModeDialog::MY_CLASS = "ExecutionModeDialog";







