/*
 * This file is part of the Pablo Performance Analysis Environment
 *
 *                                           TM
 * The Pablo Performance Analysis Environment   software is *not* in
 * the public domain.  However, it is freely available without fee for
 * education, research, and non-profit purposes.  By obtaining copies
 * of this and other files that comprise the Pablo Performance Analysis
 * Environment, you, the Licensee, agree to abide by the following
 * conditions and understandings with respect to the copyrighted software:
 * 
 * 1.  The software is copyrighted in the name of the Board of Trustees
 *     of the University of Illinois (UI), and ownership of the software
 *     remains with the UI. 
 *
 * 2.  Permission to use, copy, and modify this software and its documentation
 *     for education, research, and non-profit purposes is hereby granted
 *     to Licensee, provided that the copyright notice, the original author's
 *     names and unit identification, and this permission notice appear on
 *     all such copies, and that no charge be made for such copies.  Any
 *     entity desiring permission to incorporate this software into commercial
 *     products should contact:
 *
 *          Professor Daniel A. Reed                 reed@cs.uiuc.edu
 *          University of Illinois
 *          Department of Computer Science
 *          2413 Digital Computer Laboratory
 *          1304 West Springfield Avenue
 *          Urbana, Illinois  61801
 *          USA
 *
 * 3.  Licensee may not use the name, logo, or any other symbol of the UI
 *     nor the names of any of its employees nor any adaptation thereof in
 *     advertizing or publicity pertaining to the software without specific
 *     prior written approval of the UI.
 *
 * 4.  THE UI MAKES NO REPRESENTATIONS ABOUT THE SUITABILITY OF THE
 *     SOFTWARE FOR ANY PURPOSE.  IT IS PROVIDED "AS IS" WITHOUT EXPRESS
 *     OR IMPLIED WARRANTY.
 *
 * 5.  The UI shall not be liable for any damages suffered by Licensee from
 *     the use of this software.
 *
 * 6.  The software was developed under agreements between the UI and the
 *     Federal Government which entitle the Government to certain rights.
 *
 **************************************************************************
 *
 * Developed by: The TAPESTRY Parallel Computing Laboratory
 *		 University of Illinois at Urbana-Champaign
 *		 Department of Computer Science
 *		 1304 W. Springfield Avenue
 *		 Urbana, IL	61801
 *
 * Copyright (c) 1987-1994
 * The University of Illinois Board of Trustees.
 *	All Rights Reserved.
 *
 * Author: Bradley W. Schwartz (schwartz@cs.uiuc.edu)
 * Author: Ruth A. Aydt (aydt@cs.uiuc.edu)
 * Project Manager and Principal Investigator:
 *	Daniel A. Reed (reed@cs.uiuc.edu)
 *
 * Funded by: National Science Foundation grants NSF CCR86-57696,
 * NSF CCR87-06653 and NSF CDA87-22836 (Tapestry), NASA ICLASS Contract
 * No. NAG-1-613, DARPA Contract No. DABT63-91-K-0004, by a grant
 * from the Digital Equipment Corporation External Research Program,
 * and by a collaborative research agreement with the Intel Supercomputer
 * Systems Division.
 *
 */
/*
 * VoidPtrList.h: Maintains a list of void pointers.
 *
 * $Header: /mnt/Pablo-guitar/Stable.2-94/Visual/Src/System/Includes/RCS/VoidPtrList.h,v 1.11 1994/02/25 04:28:54 aydt Exp $
 */

#ifndef VoidPtrList_h
#define VoidPtrList_h

#include "Obj.h"

class VoidPtrList : public Obj {
/*
 *	A VoidPtrList is a simple array-like list of pointers, each pointing
 *      to an object of generic type 'void'.   
 */
protected:
	void* *list;			// The list.
	int nItems;			// Index of highest active slot.
	int nItemsAllocated;		// Number of slots in list.

        /* Method _growList:		Grow the list to have at least 
	*				n+1 elements.                        */
	void _growList( int n );

public:
	/* Method VoidPtrList: 	       The VoidPtrList constructor. Default 
	*			       is to have 10 entries in initial list */
	VoidPtrList( int initialSize = 10 );

	/* Method VoidPtrList:		Constructor with copy initialization */
	VoidPtrList( const VoidPtrList& vpl );

	/* Method ~VoidPtrList: 	The VoidPtrList destructor 	     */
	~VoidPtrList();

	/* Method addElement: 		Add an element to the end of the list.
	*				Return the index where it was placed. */
	int addElement( void *element );

	/* Method allocatedSize: 	Returns the number of elements 
	*				allocated for the list array         */
	int allocatedSize() const;

	/* Method count:                Return the number of elements present
	*		 		(defined as one more than the index of 
	*				the highest element in the set)       */
	int count() const;

	/* Method getElement: 		Get the n'th element from the list. 
	*				If n out of range, warning printed and
	*				0 returned.	                      */

	/* Method deleteElementAt:  Delete element 'n', shifting all entries
	                            to its right toward the left */
	void deleteElementAt( int n );

	void *const getElement( int n ) const;

	/* Method lookup:		Determine which entry in the list
	*			        matches the query and return the index.
	*				Returns -1 if no match.               */
	int lookup( void *elt ) const;

	/* Method setElement: 		Set list entry n to element, expanding 
	*				the list if needed		      */
	void setElement( int n, void *element );

	/* Method operator=:		VoidPtrList to VoidPtrList assignment */
	VoidPtrList& operator=( const VoidPtrList& vpl );

	/* Method operator[]:		Access element using array syntax. If
	*				index is out of range, 0 is returned. */
 	void *const operator[]( int index ) const; 

        /* Method printOn:         	Helper function for output	      */
	virtual void printOn( ostream& strm = cout ) const;
};

inline int 
VoidPtrList::count() const
{ 
	return nItems;
}

inline int 
VoidPtrList::allocatedSize() const
{ 
	return nItemsAllocated;
}


inline ostream& operator<<( ostream& os, VoidPtrList& vpl )
{
	vpl.printOn( os );
	return os;
}

#endif
