/*
 * This file is part of the Pablo Performance Analysis Environment
 *
 *                                           TM
 * The Pablo Performance Analysis Environment   software is *not* in
 * the public domain.  However, it is freely available without fee for
 * education, research, and non-profit purposes.  By obtaining copies
 * of this and other files that comprise the Pablo Performance Analysis
 * Environment, you, the Licensee, agree to abide by the following
 * conditions and understandings with respect to the copyrighted software:
 * 
 * 1.  The software is copyrighted in the name of the Board of Trustees
 *     of the University of Illinois (UI), and ownership of the software
 *     remains with the UI. 
 *
 * 2.  Permission to use, copy, and modify this software and its documentation
 *     for education, research, and non-profit purposes is hereby granted
 *     to Licensee, provided that the copyright notice, the original author's
 *     names and unit identification, and this permission notice appear on
 *     all such copies, and that no charge be made for such copies.  Any
 *     entity desiring permission to incorporate this software into commercial
 *     products should contact:
 *
 *          Professor Daniel A. Reed                 reed@cs.uiuc.edu
 *          University of Illinois
 *          Department of Computer Science
 *          2413 Digital Computer Laboratory
 *          1304 West Springfield Avenue
 *          Urbana, Illinois  61801
 *          USA
 *
 * 3.  Licensee may not use the name, logo, or any other symbol of the UI
 *     nor the names of any of its employees nor any adaptation thereof in
 *     advertizing or publicity pertaining to the software without specific
 *     prior written approval of the UI.
 *
 * 4.  THE UI MAKES NO REPRESENTATIONS ABOUT THE SUITABILITY OF THE
 *     SOFTWARE FOR ANY PURPOSE.  IT IS PROVIDED "AS IS" WITHOUT EXPRESS
 *     OR IMPLIED WARRANTY.
 *
 * 5.  The UI shall not be liable for any damages suffered by Licensee from
 *     the use of this software.
 *
 * 6.  The software was developed under agreements between the UI and the
 *     Federal Government which entitle the Government to certain rights.
 *
 **************************************************************************
 *
 * Developed by: The TAPESTRY Parallel Computing Laboratory
 *		 University of Illinois at Urbana-Champaign
 *		 Department of Computer Science
 *		 1304 W. Springfield Avenue
 *		 Urbana, IL	61801
 *
 * Copyright (c) 1987-1994
 * The University of Illinois Board of Trustees.
 *	All Rights Reserved.
 *
 * Author: Philip C. Roth (proth@cs.uiuc.edu)
 *
 * Project Manager and Principal Investigator:
 *	Daniel A. Reed (reed@cs.uiuc.edu)
 *
 * Funded by: National Science Foundation grants NSF CCR86-57696,
 * NSF CCR87-06653 and NSF CDA87-22836 (Tapestry), NASA ICLASS Contract
 * No. NAG-1-613, DARPA Contract No. DABT63-91-K-0004, by a grant
 * from the Digital Equipment Corporation External Research Program,
 * and by a collaborative research agreement with the Intel Supercomputer
 * Systems Division.
 *
 */
/*
 * UtilDisplayManager.h: Manager class for UtilDisplay objects
 *
 *	$Header: /mnt/Pablo-guitar/Stable.2-94/Visual/Src/System/Includes/RCS/UtilDisplayManager.h,v 1.8 1994/02/25 04:31:47 aydt Exp $
 */

#ifndef UtilDisplayManager_h
#define	UtilDisplayManager_h

#include <X11/Intrinsic.h>
#include <fstream.h>
#include <stdio.h>
#include "Defines.h"
#include "UtilDisplay.h"

class UtilFU;

class UtilDisplayManager {
/*
* UtilDisplayManager manages the creation and deletion of UtilDisplay
* objects for the UtilFU class.  This is the only class that "knows"
* about the different subclasses of available UtilDisplay objects.
*/

private:
	// data dealing with the known subclasses of the UtilDisplay class
	static const int numTypes;	// number of subclasses known
	static const int numAggrTypes;	// number of subclasses known which are
					// suitable for displaying aggregate
					// statistics

	// This is a list of the known display types, used in creating the
	// Motif List dialog showing the types.	  In order to correctly
	// handle aggregate-suitable displays, place the aggregate-suitable
	// displays FIRST in the list 
	static const char * typeList[];

	static const int buf_len;  // length of temporary character buffers 
	Widget parent;		   // parent of all created PU displays
	UtilFU *fuParent;	   // Utilization FU which owns this manager


public:

	// display type name constants
	// These should be in one to one  correspondance with the
	// typeList list, above except for the "unknown" type

	enum DisplayTypeConstant { bargraph,
                           	   chart,
                              	   strip,
                                   kiviat,
                                   unknown };

	/* Method UtilDisplayManager:	The class constructor.
	 *				The par argument specifies the
	 *				parent X widget to use for all
	 *				UtilDisplay"s which are created,
	 *				while the ufu argument specifies the
	 *				parent Utilization functional unit.  */
	UtilDisplayManager( Widget par, UtilFU* ufu );


	/* Method getAggregateTypeList:	Returns the list of known display
	 *				types that are suitable for
	 *				displaying aggregate statistics
	 *				Its argument is set to the number
	 *				of character strings returned.	     */
	const char ** getAggregateTypeList( int& num );


	/* Method getTypeList:		Returns the list of known display
	 *				types.  Its argument is set to
	 *				the number of character strings
	 *				returned.			     */
	const char ** getTypeList( int& num );


	/* Method makeNewDisplay:	Creates a new display with the
	 *				name and type as specified in 
	 *				the arguments.			     */
	UtilDisplay * makeNewDisplay( char *name, DisplayTypeConstant type,
					UtilsDisplayedType utype );


	/* Method nameToType:		Given a name of a type, converts
	 *				returns the constant used to
	 *				indicate the type.		     */
	DisplayTypeConstant nameToType( char *name );



	/* Method typeToName:		Given a type constant, returns 
	 *				a character string representing 
	 *				that type.			     */
	const char * const typeToName( DisplayTypeConstant type ); 

	/* Method readDisplayListFromFile:	Scans the representation
	 *					of a list of UtilDisplays
	 *					from the given stream,
	 *					creates the display objects,
	 *					and returns that list.
	 *					The numDisplays argument
	 *					specifies the number of
	 *					UtilDisplays to scan in.     */
	UtilDisplay * readDisplayListFromFile( FILE *fp, int numDisplays );


	/* Method saveDisplayListToFile:	Saves a representation 
	 *					of the given list of
	 *					UtilDisplays to the given
	 *					stream.			     */
	void saveDisplayListToFile( ofstream& ofs, UtilDisplay *list ) const;

};


#endif
