/*
 * This file is part of the Pablo Performance Analysis Environment
 *
 *                                           TM
 * The Pablo Performance Analysis Environment   software is *not* in
 * the public domain.  However, it is freely available without fee for
 * education, research, and non-profit purposes.  By obtaining copies
 * of this and other files that comprise the Pablo Performance Analysis
 * Environment, you, the Licensee, agree to abide by the following
 * conditions and understandings with respect to the copyrighted software:
 * 
 * 1.  The software is copyrighted in the name of the Board of Trustees
 *     of the University of Illinois (UI), and ownership of the software
 *     remains with the UI. 
 *
 * 2.  Permission to use, copy, and modify this software and its documentation
 *     for education, research, and non-profit purposes is hereby granted
 *     to Licensee, provided that the copyright notice, the original author's
 *     names and unit identification, and this permission notice appear on
 *     all such copies, and that no charge be made for such copies.  Any
 *     entity desiring permission to incorporate this software into commercial
 *     products should contact:
 *
 *          Professor Daniel A. Reed                 reed@cs.uiuc.edu
 *          University of Illinois
 *          Department of Computer Science
 *          2413 Digital Computer Laboratory
 *          1304 West Springfield Avenue
 *          Urbana, Illinois  61801
 *          USA
 *
 * 3.  Licensee may not use the name, logo, or any other symbol of the UI
 *     nor the names of any of its employees nor any adaptation thereof in
 *     advertizing or publicity pertaining to the software without specific
 *     prior written approval of the UI.
 *
 * 4.  THE UI MAKES NO REPRESENTATIONS ABOUT THE SUITABILITY OF THE
 *     SOFTWARE FOR ANY PURPOSE.  IT IS PROVIDED "AS IS" WITHOUT EXPRESS
 *     OR IMPLIED WARRANTY.
 *
 * 5.  The UI shall not be liable for any damages suffered by Licensee from
 *     the use of this software.
 *
 * 6.  The software was developed under agreements between the UI and the
 *     Federal Government which entitle the Government to certain rights.
 *
 **************************************************************************
 *
 * Developed by: The TAPESTRY Parallel Computing Laboratory
 *		 University of Illinois at Urbana-Champaign
 *		 Department of Computer Science
 *		 1304 W. Springfield Avenue
 *		 Urbana, IL	61801
 *
 * Copyright (c) 1987-1994
 * The University of Illinois Board of Trustees.
 *	All Rights Reserved.
 *
 * Author: Ruth A. Aydt (aydt.cs.uiuc.edu)
 *
 * Project Manager and Principal Investigator:
 *	Daniel A. Reed (reed@cs.uiuc.edu)
 *
 * Funded by: National Science Foundation grants NSF CCR86-57696,
 * NSF CCR87-06653 and NSF CDA87-22836 (Tapestry), NASA ICLASS Contract
 * No. NAG-1-613, DARPA Contract No. DABT63-91-K-0004, by a grant
 * from the Digital Equipment Corporation External Research Program,
 * and by a collaborative research agreement with the Intel Supercomputer
 * Systems Division.
 *
 */
/*
 * StructureDescriptorResolver.h: Class to provide a mechanism for resolving
 *			  potential conflicts between tags from different
 *		          sources.  It interfaces to the TagMappingDictionary
 *			  and to the StructureDictionary.  Currently only
 *			  basic levels of matching are supported but more
 *			  elaborate schemes can be supported within this 
 *			  framework.
 *
 *	$Header: /mnt/Pablo-guitar/Stable.2-94/Visual/Src/System/Includes/RCS/StructureDescriptorResolver.h,v 1.13 1994/02/25 04:30:19 aydt Exp $
 */

#ifndef StructureDescriptorResolver_h
#define StructureDescriptorResolver_h

#include "Defines.h"
#include "Obj.h"
#include "TagMappingDictionaryInquirer.h"
#include "StructureDictionaryInquirer.h"

enum ResolverQuery {
	QuestionUser,
	RespondSame,
	RespondDifferent,
};

class StructureDescriptorResolver : public Obj {
/*
*
* A StructureDescriptorResolver provides an iterface between modules trying
* to obtain a unique system Tag for a given StructureDescriptor, and the
* Dictionaries that keep track of what Structures are currently recognized
* by the Pablo system.
*
*/
private:
	static const char *const 	MY_CLASS;	// My class name
	TagMappingDictionaryInquirer	*tagMappingDictInquirer;
	StructureDictionaryInquirer	*structureDictInquirer;

	/* Method _sameSource:			Determines if this systemTag
	*					is associated with this srcId
	*					in the TagMappingDictionary   */
	Boolean_ _sameSource( const int theTag, const int srcId );

	/* Method _treatSameAs:			Shows user the srcId/srcTag
	*					pairs associated with the tag
	*					and asks if the current 
	*					StructureDescriptor should be
	*					treated the same as those.    */
	Boolean_ _treatSameAs( const int theTag );

public:
	/* Method StructureDescriptorResolver:	The constructor.              */
	StructureDescriptorResolver();

	/* Method ~StructureDescriptorResolver:	The destructor   	      */
	 ~StructureDescriptorResolver();

	/* Method determineTag:			 Return a system tag for this
	*					 Descriptor, or FAILURE_ if an
	*					 error was detected.  Similiar
	*					 to resolve() method, but here
	*					 we do not allow duplicate names
	*					 in the StructureDictionary -
	*					 even from different sources. */
	int determineTag( const int srcId, const int srcTag,
			  StructureDescriptor& structDescr );

	/* Method resolve:		         Return a system tag for this 
	*					 Descriptor, or FAILURE_ if an
	*					 error was detected. Depending
	*					 on the value of queryUser,
	*					 the user may be asked if
	*					 exact matches with different
	*					 sources should be treated the
	*				         same, assumed the same, or
	*					 assumed different.           */
	int resolve( const int srcId, const int srcTag, 
		     StructureDescriptor& structDescr, 
	             ResolverQuery queryUser = RespondDifferent );

};

#endif StructureDescriptorResolver_h
